/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.geoevent;

public enum FieldType {
    String,
    Date,
    Double,
    Float,
    Geometry,
    Integer,
    Long,
    Short,
    Boolean,
    Group;


    public static String toEsriFieldType(FieldType fieldType) {
        switch (fieldType) {
            case String: {
                return "esriFieldTypeString";
            }
            case Date: {
                return "esriFieldTypeDate";
            }
            case Double: {
                return "esriFieldTypeDouble";
            }
            case Float: {
                return "esriFieldTypeSingle";
            }
            case Geometry: {
                return "esriFieldTypeGeometry";
            }
            case Integer: {
                return "esriFieldTypeInteger";
            }
            case Long: {
                return "esriFieldTypeInteger";
            }
            case Short: {
                return "esriFieldTypeSmallInteger";
            }
            case Boolean: {
                return "esriFieldTypeString";
            }
            case Group: {
                return "esriFieldTypeGroup";
            }
        }
        return null;
    }

    public static FieldType fromEsriFieldType(String esriFieldType) {
        if (esriFieldType == null) {
            return null;
        }
        if (esriFieldType.equalsIgnoreCase("esriFieldTypeString") || esriFieldType.equalsIgnoreCase("esriFieldTypeXML")) {
            return String;
        }
        if (esriFieldType.equalsIgnoreCase("esriFieldTypeDate")) {
            return Date;
        }
        if (esriFieldType.equalsIgnoreCase("esriFieldTypeDouble")) {
            return Double;
        }
        if (esriFieldType.equalsIgnoreCase("esriFieldTypeSingle")) {
            return Float;
        }
        if (esriFieldType.equalsIgnoreCase("esriFieldTypeGeometry")) {
            return Geometry;
        }
        if (esriFieldType.equalsIgnoreCase("esriFieldTypeInteger") || esriFieldType.equalsIgnoreCase("esriFieldTypeOID")) {
            return Integer;
        }
        if (esriFieldType.equalsIgnoreCase("esriFieldTypeLong")) {
            return Long;
        }
        if (esriFieldType.equalsIgnoreCase("esriFieldTypeSmallInteger")) {
            return Short;
        }
        if (esriFieldType.equalsIgnoreCase("esriFieldTypeBoolean")) {
            return Boolean;
        }
        if (esriFieldType.equalsIgnoreCase("esriFieldTypeGroup")) {
            return Group;
        }
        return null;
    }
}

