/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.component;

import com.esri.ges.core.Uri;
import com.esri.ges.core.component.ComponentDefinition;
import com.esri.ges.core.property.PropertyDefinition;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Validator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;

public abstract class ComponentDefinitionBase
implements ComponentDefinition {
    private static BundleLogger LOGGER = BundleLoggerFactory.getLogger(ComponentDefinitionBase.class);
    protected Map<String, PropertyDefinition> propertyDefinitions = new LinkedHashMap<String, PropertyDefinition>();
    private BundleContext bundleContext;

    @Override
    public String getName() {
        return this.getHeader("Bundle-Name");
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return this.getHeader("Bundle-Description");
    }

    @Override
    public String getLastModified() {
        return this.getHeader("Bnd-LastModified");
    }

    @Override
    public String getContactInfo() {
        return this.getHeader("Bundle-ContactAddress");
    }

    @Override
    public String getDomain() {
        return this.getHeader("AGES-Domain");
    }

    @Override
    public String getVersion() {
        return this.getHeader("Bundle-Version");
    }

    private String getHeader(String headerName) {
        if (this.bundleContext == null) {
            LOGGER.error("NULL_BUNDLE_CONTEXT");
            return null;
        }
        return Validator.compactSpaces((String)this.bundleContext.getBundle().getHeaders().get(headerName));
    }

    @Override
    public Uri getUri() {
        return new Uri(this.getDomain(), this.getName(), this.getVersion());
    }

    @Override
    public Map<String, PropertyDefinition> getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    @Override
    public boolean hasPropertyDefinition(String name) {
        return this.propertyDefinitions.containsKey(name);
    }

    @Override
    public PropertyDefinition getPropertyDefinition(String name) {
        return this.hasPropertyDefinition(name) ? this.propertyDefinitions.get(name) : null;
    }

    @Override
    public boolean propertyMatches(String propertyName, String propertyValue, boolean exactMatch) {
        if (!exactMatch) {
            return this.propertyLike(propertyName, propertyValue);
        }
        if (propertyName != null) {
            if (propertyName.equalsIgnoreCase("name")) {
                return this.getName().equals(propertyValue);
            }
            if (propertyName.equalsIgnoreCase("contact")) {
                return this.getContactInfo().equals(propertyValue);
            }
            if (propertyName.equalsIgnoreCase("description")) {
                return this.getDescription().equals(propertyValue);
            }
            if (propertyName.equalsIgnoreCase("version")) {
                return this.getVersion().equals(propertyValue);
            }
            if (propertyName.equalsIgnoreCase("domain")) {
                return this.getDomain().equals(propertyValue);
            }
            if (propertyName.equalsIgnoreCase("lastModified")) {
                return this.getLastModified().equals(propertyValue);
            }
        }
        return true;
    }

    private boolean propertyLike(String propertyName, String propertyValue) {
        if (propertyName != null) {
            String regex = Validator.compactWhiteSpaces(propertyValue);
            regex = this.decorateRegex(regex);
            if (propertyName.equalsIgnoreCase("q")) {
                return this.getName().matches(regex) || this.getContactInfo().matches(regex) || this.getDescription().matches(regex) || this.getVersion().matches(regex) || this.getDomain().matches(regex) || this.getLastModified().matches(regex);
            }
            if (propertyName.equalsIgnoreCase("name")) {
                return this.getName().matches(regex);
            }
            if (propertyName.equalsIgnoreCase("contact")) {
                return this.getContactInfo().matches(regex);
            }
            if (propertyName.equalsIgnoreCase("description")) {
                return this.getDescription().matches(regex);
            }
            if (propertyName.equalsIgnoreCase("version")) {
                return this.getVersion().matches(regex);
            }
            if (propertyName.equalsIgnoreCase("domain")) {
                return this.getDomain().matches(regex);
            }
            if (propertyName.equalsIgnoreCase("lastModified")) {
                return this.getLastModified().matches(regex);
            }
        }
        return true;
    }

    private String decorateRegex(String regex) {
        if (regex.isEmpty()) {
            regex = ".*";
        } else {
            int caseOffset = -32;
            regex = regex.toLowerCase();
            StringBuffer buffer = new StringBuffer(regex);
            for (int i = 0; i < buffer.length(); ++i) {
                char c = buffer.charAt(i);
                if (c < 'a' || c > 'z') continue;
                char C = (char)(c + caseOffset);
                buffer.replace(i, i + 1, "[" + c + "," + C + "]");
                i += 4;
            }
            regex = buffer.toString();
            regex.replaceAll("\\*", ".*");
            if (!regex.startsWith(".*")) {
                regex = ".*" + regex;
            }
            if (!regex.endsWith(".*")) {
                regex = regex + ".*";
            }
        }
        return regex;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof ComponentDefinition && this.getName().equals(((ComponentDefinition)obj).getName()) && this.getDomain().equals(((ComponentDefinition)obj).getDomain()) && this.getVersion().equals(((ComponentDefinition)obj).getVersion());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" (" + this.getName() + ", " + this.getVersion() + ")\n");
        if (this.propertyDefinitions != null && !this.propertyDefinitions.isEmpty()) {
            sb.append("Property Definitions:\n ");
            for (PropertyDefinition pd : this.propertyDefinitions.values()) {
                sb.append(" " + pd.toString());
            }
        }
        return sb.toString();
    }
}

