/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core.component;

import com.esri.ges.core.component.Component;
import com.esri.ges.core.component.ComponentDefinition;
import com.esri.ges.core.component.ComponentException;
import com.esri.ges.core.component.GeoEventDefinitionEnabledComponentDefinition;
import com.esri.ges.core.property.Property;
import com.esri.ges.core.property.PropertyCollectionBase;
import com.esri.ges.core.property.PropertyDefinition;
import com.esri.ges.core.property.PropertyException;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Validator;

public abstract class ComponentBase
extends PropertyCollectionBase
implements Component {
    private String id;
    private String label;
    protected ComponentDefinition definition = null;
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(ComponentBase.class);

    public ComponentBase(ComponentDefinition definition) throws ComponentException {
        if (definition == null) {
            throw new ComponentException(LOGGER.translate("COMPONENT_INIT_ERROR", this.getClass().getName()));
        }
        this.definition = definition;
        this.label = "";
        this.id = "";
        this.clearProperties();
    }

    @Override
    public String getLabel() {
        return this.label.isEmpty() ? this.getId() : this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = Validator.compactWhiteSpaces(label);
    }

    @Override
    public String getId() {
        return this.id.isEmpty() ? this.definition.getUri().toString() : this.id;
    }

    @Override
    public void setId(String id) {
        this.id = Validator.compactWhiteSpaces(id);
    }

    @Override
    public void setProperty(String name, String value) throws PropertyException {
        PropertyDefinition def = this.definition.getPropertyDefinition(name);
        if (def == null) {
            throw new PropertyException(LOGGER.translate("FAILED_TO_SET_PROP_DOESNT_EXIST", this.getClass().getName(), name));
        }
        this.setProperty(new Property(def, value));
    }

    @Override
    public void clearProperties() {
        super.clearProperties();
        for (PropertyDefinition def : this.definition.getPropertyDefinitions().values()) {
            this.properties.put(def.getPropertyName(), def.getDefaultProperty());
        }
    }

    @Override
    public void shutdown() {
        super.clearProperties();
        this.definition = null;
    }

    public boolean equals(Object obj) {
        if (this.definition != null && obj != null && obj instanceof ComponentBase && this.definition.equals(((ComponentBase)obj).definition) && this.properties.size() == ((ComponentBase)obj).properties.size()) {
            for (Property objProp : ((ComponentBase)obj).properties.values()) {
                if (this.properties.containsKey(objProp.getName()) && ((Property)this.properties.get(objProp.getName())).equals(objProp)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" (" + this.definition.getName() + ", " + this.definition.getVersion() + ")\n");
        if (this.definition instanceof GeoEventDefinitionEnabledComponentDefinition) {
            sb.append("<geoEventDefinitions>");
            for (String mdName : ((GeoEventDefinitionEnabledComponentDefinition)this.definition).getGeoEventDefinitions().keySet()) {
                sb.append(mdName).append(" ");
            }
            sb.append("</geoEventDefinitions>\n");
        }
        sb.append("<properties>\n");
        for (Property prop : this.getProperties()) {
            sb.append("\t").append(prop.toString()).append("\n");
        }
        sb.append("</properties>\n");
        return sb.toString();
    }
}

