/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.core;

import com.esri.ges.core.validation.Validatable;
import com.esri.ges.core.validation.ValidationException;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class Uri
implements Validatable,
Serializable {
    private static final long serialVersionUID = 5245360707516543205L;
    private String domain;
    private String name;
    private String version;
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(Uri.class);

    public Uri() {
        this.domain = "";
        this.name = "";
        this.version = "";
    }

    public Uri(String domain, String name, String version) {
        this.setDomain(domain);
        this.setName(name);
        this.setVersion(version);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = Validator.compactWhiteSpaces(domain);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Validator.compactWhiteSpaces(name);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = Validator.compactWhiteSpaces(version);
    }

    public boolean isValid() {
        return !this.domain.isEmpty() && !this.name.isEmpty() && !this.version.isEmpty();
    }

    public static Uri parse(String s) {
        String[] tokens = Validator.compactSpaces(s).split("/");
        if (tokens.length == 3) {
            try {
                Uri uri = new Uri(tokens[0], tokens[1], tokens[2]);
                uri.validate();
                return uri;
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
        return new Uri();
    }

    public String toString() {
        return this.domain + "/" + this.name + "/" + this.version;
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("domain", this.domain);
        map.put("name", this.name);
        map.put("version", this.version);
        return map;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Uri && this.domain.equals(((Uri)o).getDomain()) && this.name.equals(((Uri)o).getName()) && this.version.equals(((Uri)o).getVersion());
    }

    @Override
    public void validate() throws ValidationException {
        if (this.domain.length() == 0) {
            throw new ValidationException(LOGGER.translate("URI_INVALID_DOMAIN"));
        }
        if (this.name.length() == 0) {
            throw new ValidationException(LOGGER.translate("URI_INVALID_NAME"));
        }
        if (this.version.length() == 0) {
            throw new ValidationException(LOGGER.translate("URI_INVALID_VERSION"));
        }
    }
}

