/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.adapter.util;

import com.esri.core.geometry.SpatialReference;
import com.esri.ges.core.geoevent.FieldException;
import com.esri.ges.core.geoevent.FieldGroup;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.util.Converter;
import org.apache.commons.lang3.StringUtils;

public class AdapterDefaultSpatialReferenceUtil {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(AdapterDefaultSpatialReferenceUtil.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpatialReference getSpatialReference(FieldGroup event, SpatialReference defaultSpatialReference, String spatialReferenceField) throws FieldException {
        SpatialReference thisSpatialReference = null;
        if (defaultSpatialReference != null) return defaultSpatialReference;
        try {
            if (spatialReferenceField.isEmpty()) {
                return SpatialReference.create(4326);
            }
            Object srObject = event.getField(spatialReferenceField);
            if (srObject == null) throw new Exception(LOGGER.translate("INBOUND_ERROR_SPATIAL_REFERENCE_FILED_EMPTY"));
            if (srObject instanceof Integer) {
                return SpatialReference.create(Converter.convertToInteger(srObject));
            }
            if (!(srObject instanceof String)) return thisSpatialReference;
            String srString = Converter.convertToString(srObject);
            if (!StringUtils.isNumeric((CharSequence)srString)) return SpatialReference.create(srString);
            return SpatialReference.create(Integer.parseInt(srString));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new FieldException(LOGGER.translate("INBOUND_ERROR_CREATING_SPATIAL_REFERENCE_FROM_FIELD", spatialReferenceField));
        }
    }
}

