/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ges.adapter;

import com.esri.ges.adapter.AdapterBase;
import com.esri.ges.adapter.AdapterDefinition;
import com.esri.ges.adapter.AdapterType;
import com.esri.ges.adapter.InboundAdapter;
import com.esri.ges.core.component.ComponentException;
import com.esri.ges.core.geoevent.GeoEvent;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.messaging.GeoEventCreator;
import com.esri.ges.messaging.GeoEventListener;
import java.nio.ByteBuffer;

public abstract class InboundAdapterBase
extends AdapterBase
implements InboundAdapter {
    protected GeoEventCreator geoEventCreator;
    protected GeoEventListener geoEventListener;
    private static final String BUNDLE_NAME = "com.esri.ges.framework.adapter.adapter-api";
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(InboundAdapterBase.class.getName(), "com.esri.ges.framework.adapter.adapter-api");

    public InboundAdapterBase(AdapterDefinition definition) throws ComponentException {
        super(definition);
        if (definition.getAdapterType() == null || !definition.getAdapterType().equals((Object)AdapterType.INBOUND)) {
            throw new ComponentException(LOGGER.translate(BUNDLE_NAME, "ADAPTER_INIT_ERROR", this.getClass().getName()));
        }
    }

    protected abstract GeoEvent adapt(ByteBuffer var1, String var2);

    @Override
    public void receive(ByteBuffer buffer, String channelId) {
        GeoEvent result = null;
        while ((result = this.adapt(buffer, channelId)) != null) {
            this.geoEventListener.receive(result);
        }
    }

    @Override
    public void setGeoEventCreator(GeoEventCreator geoEventCreator) {
        this.geoEventCreator = geoEventCreator;
    }

    @Override
    public void setGeoEventListener(GeoEventListener geoEventListener) {
        this.geoEventListener = geoEventListener;
    }
}

