/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionHash;
import java.util.Arrays;

final class VertexDescriptionDesignerImpl {
    VertexDescriptionDesignerImpl() {
    }

    static VertexDescription getVertexDescription(int descriptionBitMask) {
        return VertexDescriptionHash.INSTANCE.FindOrAdd(descriptionBitMask);
    }

    static VertexDescription getVertexDescription(boolean bZs, boolean bMs, boolean bIDs) {
        int mask = 1;
        if (bZs) {
            mask |= 2;
        }
        if (bMs) {
            mask |= 4;
        }
        if (bIDs) {
            mask |= 8;
        }
        return VertexDescriptionHash.INSTANCE.FindOrAdd(mask);
    }

    static VertexDescription getMergedVertexDescription(VertexDescription descr1, VertexDescription descr2) {
        int mask = descr1.getSemanticsBitArray() | descr2.getSemanticsBitArray();
        if ((mask & descr1.getSemanticsBitArray()) == mask) {
            return descr1;
        }
        if ((mask & descr2.getSemanticsBitArray()) == mask) {
            return descr2;
        }
        return VertexDescriptionDesignerImpl.getVertexDescription(mask);
    }

    static VertexDescription getMergedVertexDescription(VertexDescription descr, int semantics) {
        int mask = descr.getSemanticsBitArray() | 1 << semantics;
        if ((mask & descr.getSemanticsBitArray()) == mask) {
            return descr;
        }
        return VertexDescriptionDesignerImpl.getVertexDescription(mask);
    }

    static VertexDescription removeSemanticsFromVertexDescription(VertexDescription descr, int semanticsToRemove) {
        int mask = (descr.getSemanticsBitArray() | 1 << semanticsToRemove) - (1 << semanticsToRemove);
        if (mask == descr.getSemanticsBitArray()) {
            return descr;
        }
        return VertexDescriptionDesignerImpl.getVertexDescription(mask);
    }

    static VertexDescription getDefaultDescriptor2D() {
        return VertexDescriptionHash.VD2D;
    }

    static VertexDescription getDefaultDescriptor3D() {
        return VertexDescriptionHash.VD3D;
    }

    static int[] mapAttributes(VertexDescription src, VertexDescription dest) {
        int[] srcToDst = new int[src.getAttributeCount()];
        Arrays.fill(srcToDst, -1);
        int nsrc = src.getAttributeCount();
        for (int i = 0; i < nsrc; ++i) {
            srcToDst[i] = dest.getAttributeIndex(src.getSemantics(i));
        }
        return srcToDst;
    }
}

