/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AngularUnitImpl;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.LinearUnit;
import com.esri.core.geometry.LinearUnitImpl;
import com.esri.core.geometry.Unit;
import com.esri.sde.sdk.pe.engine.PeAngunit;
import com.esri.sde.sdk.pe.engine.PeCoordsys;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeLinunit;
import com.esri.sde.sdk.pe.engine.PeObject;
import com.esri.sde.sdk.pe.engine.PeProjcs;
import com.esri.sde.sdk.pe.engine.PeUnit;
import com.esri.sde.sdk.pe.engine.PeVertcs;
import com.esri.sde.sdk.pe.factory.PeFactory;

@HadoopSDKExcluded
class UnitFactoryImpl {
    UnitFactoryImpl() {
    }

    static Unit create(PeUnit peUnit) {
        if (PeFactory.getType((PeObject)peUnit) == 256) {
            return new LinearUnitImpl((PeLinunit)peUnit);
        }
        if (PeFactory.getType((PeObject)peUnit) == 512) {
            return new AngularUnitImpl((PeAngunit)peUnit);
        }
        throw new GeometryException("illegal argument");
    }

    static Unit create(PeCoordsys peCoordSys) {
        Object peUnit = peCoordSys.getType() == 2 ? ((PeProjcs)peCoordSys).getUnit() : ((PeGeogcs)peCoordSys).getUnit();
        return UnitFactoryImpl.create((PeUnit)peUnit);
    }

    static LinearUnit create(PeVertcs peVertcs) {
        PeUnit peUnit = (PeUnit)peVertcs.getUnit().clone();
        return (LinearUnit)UnitFactoryImpl.create(peUnit);
    }
}

