/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.NthElement;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.ProgressTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@HadoopSDKExcluded
public class SpatialTree2D {
    private Node m_root;
    private long m_elementCount;
    private int leafSize_ = 20;
    private int nodeSize_ = 16;

    @HadoopSDKPublic
    public int leafSize() {
        return this.leafSize_;
    }

    @HadoopSDKPublic
    public int nodeSize() {
        return this.nodeSize_;
    }

    @HadoopSDKPublic
    public Node getRoot() {
        return this.m_root;
    }

    @HadoopSDKPublic
    public SpatialTree2D(int leaf_size, int node_size) {
        this.leafSize_ = leaf_size;
        this.nodeSize_ = node_size;
        this.m_elementCount = 0L;
        this.m_root = new Node();
    }

    @HadoopSDKPublic
    public SpatialTree2D() {
        this(20, 16);
    }

    @HadoopSDKPublic
    public void clear() {
        this.nullReferences(this.m_root);
        this.m_elementCount = 0L;
        this.m_root = new Node();
    }

    @HadoopSDKPublic
    public static void bulkLoad(SpatialTree2D tree, List<ElementDescriptor> elements, ProgressTracker progressTracker) {
        if (elements.size() == 0) {
            return;
        }
        tree.nullReferences(tree.m_root);
        tree.m_root = null;
        tree.m_elementCount = 0L;
        List<BaseNode> leafs = tree.generateTreeLeafs_(elements, progressTracker);
        List<BaseNode> nodes = tree.generateTreeNodes_(leafs, progressTracker);
        while (nodes.size() > 1) {
            nodes = tree.generateTreeNodes_(nodes, progressTracker);
        }
        tree.m_root = (Node)nodes.get(0);
        tree.m_elementCount = elements.size();
        tree.setDepthInfoToNodes();
    }

    @HadoopSDKPublic
    public long elementCount() {
        return this.m_elementCount;
    }

    @HadoopSDKPublic
    public void setElementCount(long count) {
        this.m_elementCount = count;
    }

    @HadoopSDKPublic
    public void setDepthInfoToNodes() {
        this.setDepthInfoToNodes_();
    }

    @HadoopSDKPublic
    public int calculateTotalNodeCount() {
        int sz = 0;
        if (this.m_root != null) {
            sz += 1 + this.calculateTotalNodeCount_(this.m_root);
        }
        return sz;
    }

    @HadoopSDKPublic
    public boolean isIntersectingAnyLeaves(Envelope2D extent, ArrayList<Node> helper_) {
        ArrayList<Node> helper = helper_ == null ? new ArrayList<Node>() : helper_;
        helper.clear();
        if (this.m_root == null) {
            return false;
        }
        if (this.m_root.isIntersecting(extent)) {
            helper.add(this.m_root);
        }
        while (helper.size() != 0) {
            Node current = (Node)helper.get(helper.size() - 1);
            helper.remove(helper.size() - 1);
            for (BaseNode n : current.children) {
                if (!n.isIntersecting(extent)) continue;
                if (n.isLeaf()) {
                    return true;
                }
                helper.add((Node)n);
            }
        }
        return false;
    }

    @HadoopSDKPublic
    public void visitLeaves(Envelope2D extent, ArrayList<Node> helper_, Visitor visitor) {
        ArrayList<Node> helper = helper_ == null ? new ArrayList<Node>() : helper_;
        helper.clear();
        if (this.m_root == null || this.m_elementCount == 0L) {
            return;
        }
        if (this.m_root.isIntersecting(extent)) {
            helper.add(this.m_root);
        }
        while (helper.size() != 0) {
            Node current = (Node)helper.get(helper.size() - 1);
            helper.remove(helper.size() - 1);
            for (BaseNode n : current.children) {
                if (!n.isIntersecting(extent)) continue;
                if (n.isLeaf()) {
                    if (visitor.visit((LeafNode)n)) continue;
                    return;
                }
                helper.add((Node)n);
            }
        }
    }

    @HadoopSDKPublic
    public void visitLeavesNearest(Envelope2D extent, double search_radius, ArrayList<Node> helper_, NNVisitor visitor) {
        ArrayList<Node> helper = helper_ == null ? new ArrayList<Node>() : helper_;
        helper.clear();
        if (this.m_root == null || this.m_elementCount == 0L) {
            return;
        }
        double sqr_radius = search_radius * search_radius;
        Envelope2D dummyEnv = new Envelope2D();
        double min_dist = this.m_root.queryExtent(dummyEnv).sqrDistance(extent);
        if (sqr_radius < min_dist) {
            return;
        }
        double max_dist = this.m_root.queryExtent(dummyEnv).sqrMaxDistance(extent);
        if (!(sqr_radius < max_dist)) {
            sqr_radius = max_dist;
        }
        ArrayList<DistPair> sort_stack = new ArrayList<DistPair>();
        helper.add(this.m_root);
        while (helper.size() != 0) {
            sort_stack.clear();
            Node current = (Node)helper.get(helper.size() - 1);
            helper.remove(helper.size() - 1);
            for (BaseNode n : current.children) {
                Envelope2D ne = n.queryExtent(dummyEnv);
                double min_dist2 = ne.sqrDistance(extent);
                if (min_dist2 > sqr_radius) continue;
                if (n.isLeaf()) {
                    double dist = visitor.visit((LeafNode)n, sqr_radius);
                    if (dist < 0.0) {
                        return;
                    }
                    if (!(dist < sqr_radius)) continue;
                    sqr_radius = dist;
                    continue;
                }
                double max_dist2 = ne.sqrMaxDistance(extent);
                assert (max_dist2 >= min_dist2);
                if (sqr_radius > max_dist2) {
                    sqr_radius = max_dist2;
                }
                DistPair p = new DistPair();
                p.dist = min_dist2;
                p.node = (Node)n;
                sort_stack.add(p);
            }
            Collections.sort(sort_stack, new NNCompareDistPair());
            for (DistPair p : sort_stack) {
                if (p.dist <= sqr_radius) {
                    helper.add(p.node);
                }
                p.node = null;
            }
        }
        sort_stack.clear();
    }

    private static <E> int determineStrDirection_(boolean is_element_descriptor, List<E> elements, int from, int to, ProgressTracker progressTracker) {
        double mean_x = 0.0;
        double mean_y = 0.0;
        double std_dev_x = 0.0;
        double std_dev_y = 0.0;
        int count = 0;
        Point2D center = new Point2D();
        for (int i = from; i < to; ++i) {
            if (is_element_descriptor) {
                ElementDescriptor elm = (ElementDescriptor)elements.get(i);
                elm.queryCenter(center);
            } else {
                BaseNode n = (BaseNode)elements.get(i);
                n.queryCenter(center);
            }
            std_dev_x += center.x * center.x;
            std_dev_y += center.y * center.y;
            mean_x += center.x;
            mean_y += center.y;
            if ((++count & 0xFFFF) != 0) continue;
            ProgressTracker.checkAndThrow(progressTracker);
        }
        return (std_dev_x = std_dev_x / (double)count - (mean_x /= (double)count) * mean_x) < (std_dev_y = std_dev_y / (double)count - (mean_y /= (double)count) * mean_y) ? 1 : 0;
    }

    private List<BaseNode> generateTreeLeafs_(List<ElementDescriptor> elements, ProgressTracker progressTracker) {
        ArrayList<BaseNode> leafs = new ArrayList<BaseNode>();
        int load_factor = this.leafSize_;
        if (elements.size() < this.nodeSize_ * this.leafSize_ && (load_factor = (elements.size() + this.nodeSize_ - 1) / this.nodeSize_) == 0) {
            load_factor = 1;
        }
        leafs.ensureCapacity(elements.size() / load_factor + 1);
        ArrayList<RangePair> stack = new ArrayList<RangePair>();
        RangePair p = new RangePair();
        p.from = 0;
        p.to = elements.size();
        stack.add(p);
        Envelope2D dummyExtent = new Envelope2D();
        while (stack.size() > 0) {
            RangePair pair;
            int k;
            Partition lambda;
            RangePair current = (RangePair)stack.get(stack.size() - 1);
            stack.remove(stack.size() - 1);
            if (current.length() <= load_factor) {
                LeafNode leaf = new LeafNode();
                ArrayList<ElementDescriptor> leafElements = new ArrayList<ElementDescriptor>(current.to - current.from);
                Envelope2D leafEnvelope = new Envelope2D();
                for (int i = current.from; i < current.to; ++i) {
                    ElementDescriptor e = elements.get(i);
                    leafElements.add(e);
                    e.queryExtent(dummyExtent);
                    leafEnvelope.merge(dummyExtent);
                }
                leaf.setExtent(leafEnvelope);
                leaf.data = ((ElementDescriptor)leafElements.get(0)).generateLeafNodeData(leafElements);
                leafs.add(leaf);
                continue;
            }
            int dir = SpatialTree2D.determineStrDirection_(true, elements, current.from, current.to, progressTracker);
            int middle = current.from + current.length() / load_factor / 2 * load_factor;
            if (current.length() <= load_factor * 2) {
                middle = current.from + current.length() / 2;
            }
            if (current.to - (middle = NthElement.partitionApproximate(elements, current.from, middle, current.to, lambda = new Partition(progressTracker, k = 0, dir), (int)Math.max((double)(load_factor * 100), 10000.0))) > 0) {
                pair = new RangePair();
                pair.from = middle;
                pair.to = current.to;
                stack.add(pair);
            }
            if (middle - current.from > 0) {
                pair = new RangePair();
                pair.from = current.from;
                pair.to = middle;
                stack.add(pair);
            }
            ProgressTracker.checkAndThrow(progressTracker);
        }
        return leafs;
    }

    private List<BaseNode> generateTreeNodes_(List<BaseNode> nodes, ProgressTracker progressTracker) {
        int load_factor = this.nodeSize_;
        ArrayList<BaseNode> res = new ArrayList<BaseNode>();
        res.ensureCapacity(nodes.size() / load_factor + 1);
        ArrayList<RangePair> stack = new ArrayList<RangePair>();
        RangePair p = new RangePair();
        p.from = 0;
        p.to = nodes.size();
        stack.add(p);
        Envelope2D dummyExtent = new Envelope2D();
        while (stack.size() > 0) {
            RangePair pair;
            int k;
            PartitionNodes lambda;
            RangePair current = (RangePair)stack.get(stack.size() - 1);
            stack.remove(stack.size() - 1);
            if (current.length() <= load_factor) {
                Node node = new Node();
                node.children = new BaseNode[current.length()];
                Envelope2D nodeExtent = new Envelope2D();
                int i = current.from;
                int k2 = 0;
                while (i < current.to) {
                    node.children[k2] = nodes.get(i);
                    nodeExtent.merge(nodes.get(i).queryExtent(dummyExtent));
                    ++i;
                    ++k2;
                }
                node.setExtent(nodeExtent);
                res.add(node);
                continue;
            }
            int dir = SpatialTree2D.determineStrDirection_(false, nodes, current.from, current.to, progressTracker);
            int middle = current.from + current.length() / load_factor / 2 * load_factor;
            if (current.length() <= load_factor * 2) {
                middle = current.from + current.length() / 2;
            }
            if (current.to - (middle = NthElement.partitionApproximate(nodes, current.from, middle, current.to, lambda = new PartitionNodes(progressTracker, k = 0, dir), (int)Math.max((double)(load_factor * 100), 10000.0))) > 0) {
                pair = new RangePair();
                pair.from = middle;
                pair.to = current.to;
                stack.add(pair);
            }
            if (middle - current.from > 0) {
                pair = new RangePair();
                pair.from = current.from;
                pair.to = middle;
                stack.add(pair);
            }
            ProgressTracker.checkAndThrow(progressTracker);
        }
        return res;
    }

    private void setDepthInfoToNodes_() {
        ArrayList<Node> helper = new ArrayList<Node>();
        helper.add(this.m_root);
        this.m_root.setDepth(0);
        while (helper.size() > 0) {
            Node n = (Node)helper.get(helper.size() - 1);
            helper.remove(helper.size() - 1);
            int depth = n.depth();
            for (BaseNode child : n.children) {
                child.setDepth(depth + 1);
                if (child.isLeaf()) continue;
                helper.add((Node)child);
            }
        }
    }

    private int calculateTotalNodeCount_(BaseNode node) {
        ArrayList<Node> helper = new ArrayList<Node>();
        helper.add(this.m_root);
        int sz = 0;
        while (helper.size() > 0) {
            Node n = (Node)helper.get(helper.size() - 1);
            helper.remove(helper.size() - 1);
            sz += ((Node)node).children.length;
            for (BaseNode child : n.children) {
                if (child.isLeaf()) continue;
                helper.add((Node)child);
            }
        }
        return sz;
    }

    private void nullReferences(Node node) {
        if (node == null || node.children == null) {
            return;
        }
        ArrayList<Node> helper = new ArrayList<Node>(32);
        helper.add(this.m_root);
        while (helper.size() > 0) {
            Node n = (Node)helper.get(helper.size() - 1);
            helper.remove(helper.size() - 1);
            if (n.children == null) continue;
            for (int i = 0; i < n.children.length; ++i) {
                BaseNode child = n.children[i];
                n.children[i] = null;
                if (child.isLeaf()) {
                    ((LeafNode)child).data = null;
                    continue;
                }
                helper.add((Node)child);
            }
            n.children = null;
        }
    }

    private class PartitionNodes
    implements Comparator<BaseNode> {
        ProgressTracker progressTracker;
        int k;
        int dir;
        Point2D dummy1 = new Point2D();
        Point2D dummy2 = new Point2D();

        PartitionNodes(ProgressTracker p, int kk, int d) {
            this.progressTracker = p;
            this.k = kk;
            this.dir = d;
        }

        @Override
        public int compare(BaseNode n1, BaseNode n2) {
            ++this.k;
            if ((this.k & 0xFFFF) == 0) {
                ProgressTracker.checkAndThrow(this.progressTracker);
            }
            n1.queryCenter(this.dummy1);
            n2.queryCenter(this.dummy2);
            if (this.dir == 0) {
                return this.dummy1.compareX(this.dummy2);
            }
            return this.dummy1.compare(this.dummy2);
        }
    }

    private class Partition
    implements Comparator<ElementDescriptor> {
        ProgressTracker progressTracker;
        int k;
        int dir;
        Point2D dummy1 = new Point2D();
        Point2D dummy2 = new Point2D();

        Partition(ProgressTracker p, int kk, int d) {
            this.progressTracker = p;
            this.k = kk;
            this.dir = d;
        }

        @Override
        public int compare(ElementDescriptor e1, ElementDescriptor e2) {
            ++this.k;
            if ((this.k & 0xFFFF) == 0) {
                ProgressTracker.checkAndThrow(this.progressTracker);
            }
            e1.queryCenter(this.dummy1);
            e2.queryCenter(this.dummy2);
            if (this.dir == 0) {
                return this.dummy1.compareX(this.dummy2);
            }
            return this.dummy1.compare(this.dummy2);
        }
    }

    private static class RangePair {
        int from;
        int to;

        private RangePair() {
        }

        final int length() {
            return this.to - this.from;
        }
    }

    private static class NNCompareDistPair
    implements Comparator<DistPair> {
        private NNCompareDistPair() {
        }

        @Override
        public int compare(DistPair p1, DistPair p2) {
            return p1.dist < p2.dist ? 1 : (p1.dist > p2.dist ? -1 : 0);
        }
    }

    private static class DistPair {
        double dist;
        Node node;

        private DistPair() {
        }
    }

    @HadoopSDKPublic
    public static interface NNVisitor {
        public double visit(LeafNode var1, double var2);
    }

    @HadoopSDKPublic
    public static interface Visitor {
        public boolean visit(LeafNode var1);
    }

    @HadoopSDKPublic
    public static interface ElementDescriptor {
        public void queryCenter(Point2D var1);

        public void queryExtent(Envelope2D var1);

        public Object generateLeafNodeData(List<ElementDescriptor> var1);
    }

    @HadoopSDKPublic
    public static class Node
    extends BaseNode {
        BaseNode[] children;
    }

    @HadoopSDKPublic
    public static class LeafNode
    extends BaseNode {
        @HadoopSDKPublic
        public Object data;

        @HadoopSDKPublic
        public LeafNode() {
            this.flags = 1;
        }
    }

    @HadoopSDKPublic
    public static class BaseNode {
        @HadoopSDKPublic
        public double xmin;
        @HadoopSDKPublic
        public double ymin;
        @HadoopSDKPublic
        public double xmax;
        @HadoopSDKPublic
        public double ymax;
        int flags = 0;

        @HadoopSDKPublic
        public int depth() {
            return this.flags >> 1;
        }

        @HadoopSDKPublic
        public void setDepth(int depth) {
            this.flags = depth << 1 | this.flags & 1;
        }

        @HadoopSDKPublic
        public boolean isLeaf() {
            return (this.flags & 1) != 0;
        }

        @HadoopSDKPublic
        public void queryCenter(Point2D center) {
            center.x = (this.xmin + this.xmax) * 0.5;
            center.y = (this.ymin + this.ymax) * 0.5;
        }

        @HadoopSDKPublic
        public Envelope2D queryExtent(Envelope2D extent) {
            extent.setCoords(this.xmin, this.ymin, this.xmax, this.ymax);
            return extent;
        }

        @HadoopSDKPublic
        public void setExtent(Envelope2D extent) {
            this.xmin = extent.xmin;
            this.ymin = extent.ymin;
            this.xmax = extent.xmax;
            this.ymax = extent.ymax;
        }

        @HadoopSDKPublic
        public boolean isIntersecting(Envelope2D extent) {
            return extent.isIntersecting(this.xmin, this.ymin, this.xmax, this.ymax);
        }
    }
}

