/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.PeCoordSysValue;
import com.esri.core.geometry.PeVerticalCoordSysValue;
import com.esri.core.geometry.Unit;

@HadoopSDKExcluded
public final class SpatialReferencePrecisionDescriptor {
    double m_falseX;
    double m_falseY;
    double m_unitsXY;
    double m_falseZ;
    double m_unitsZ;
    double m_falseM;
    double m_unitsM;
    double m_toleranceXY;
    double m_toleranceZ;
    double m_toleranceM;
    Precision m_precision;

    public void assign(SpatialReferencePrecisionDescriptor src) {
        this.m_falseX = src.m_falseX;
        this.m_falseY = src.m_falseY;
        this.m_unitsXY = src.m_unitsXY;
        this.m_falseZ = src.m_falseZ;
        this.m_unitsZ = src.m_unitsZ;
        this.m_falseM = src.m_falseM;
        this.m_unitsM = src.m_unitsM;
        this.m_toleranceXY = src.m_toleranceXY;
        this.m_toleranceZ = src.m_toleranceZ;
        this.m_toleranceM = src.m_toleranceM;
        this.m_precision = src.m_precision;
    }

    public double getFalseX() {
        return this.m_falseX;
    }

    public double getFalseY() {
        return this.m_falseY;
    }

    public double getFalseZ() {
        return this.m_falseZ;
    }

    public double getFalseM() {
        return this.m_falseM;
    }

    public double getGridUnitsXY() {
        return this.m_unitsXY;
    }

    public double getGridUnitsZ() {
        return this.m_unitsZ;
    }

    public double getGridUnitsM() {
        return this.m_unitsM;
    }

    public Precision getPrecision() {
        return this.m_precision;
    }

    void _init() {
        this.m_falseX = 0.0;
        this.m_falseY = 0.0;
        this.m_unitsXY = 1.0;
        this.m_falseZ = 0.0;
        this.m_unitsZ = 1.0;
        this.m_falseM = 0.0;
        this.m_unitsM = 1.0;
        this.m_toleranceXY = NumberUtils.doubleEps() * 100.0;
        this.m_toleranceZ = NumberUtils.doubleEps() * 100.0;
        this.m_toleranceM = NumberUtils.doubleEps() * 100.0;
        this.m_precision = Precision.FloatingPoint;
    }

    void _init(PeCoordSysValue horzSys, PeVerticalCoordSysValue vertSys, Precision precision) {
        double resolution;
        double cOneMM;
        double cOneTenthMM;
        this._init();
        this.m_precision = precision;
        if (precision != Precision.FloatingPoint) {
            Envelope2D domain = new Envelope2D();
            horzSys.getDomainXY(domain);
            this.m_falseX = domain.xmin;
            this.m_falseY = domain.ymin;
        } else {
            this.m_falseX = -NumberUtils.doubleMax();
            this.m_falseY = -NumberUtils.doubleMax();
        }
        int type = horzSys.m_peCoordSys.getType();
        if (type == 1) {
            double cOneFiveHundredthAS = 5.555555555555555E-7;
            double resolution2 = (precision == Precision.Integer64 ? 1.0E-9 : 5.555555555555555E-7) * horzSys.getOneDegreeGCSUnit();
            this.m_unitsXY = 1.0 / resolution2;
        } else if (type == 2) {
            cOneTenthMM = 1.0E-4;
            cOneMM = 0.001;
            resolution = (precision == Precision.Integer64 ? 1.0E-4 : 0.001) * horzSys.getOneMeterPCSUnit();
            this.m_unitsXY = 1.0 / resolution;
        }
        if (vertSys != null) {
            cOneTenthMM = 1.0E-4;
            cOneMM = 0.001;
            resolution = (precision == Precision.Integer32 ? 0.001 : 1.0E-4) * vertSys.getOneMeterUnit();
            this.m_unitsZ = 1.0 / resolution;
        } else {
            this.m_unitsZ = 10000.0;
        }
        this.m_unitsM = 10000.0;
        this._snapPrecision();
        this.m_toleranceXY = horzSys.getUnitsPerMillimiter();
        this.m_toleranceZ = vertSys != null ? vertSys.getOneMeterUnit() * 0.001 : 0.001;
        this.m_toleranceM = NumberUtils.doubleEps() * 100.0;
    }

    void _initForLocalCS(Unit unit, Precision precision) {
        this._init();
        if (precision != Precision.Integer64 && precision != Precision.Integer32) {
            throw GeometryException.GeometryInternalError();
        }
        this.m_precision = precision;
        long s = precision == Precision.Integer32 ? 0x7FFFFFFDL : 0x1FFFFFFFFFFFFEL;
        double e = 1.0;
        e = unit.getUnitType() == Unit.UnitType.Angular ? 6.981317007977318 : 1.0E-5 * (double)(s / 2L);
        this.m_falseX = -(e /= unit.getUnitToBaseFactor());
        this.m_falseY = -e;
        this.m_unitsXY = (double)s / (2.0 * e);
        this._snapPrecision();
        this.m_toleranceXY = 10.0 / this.m_unitsXY;
        this.m_toleranceZ = NumberUtils.doubleEps() * 100.0;
        this.m_toleranceM = NumberUtils.doubleEps() * 100.0;
    }

    void _snapPrecision() {
        double maxY;
        if (this.m_precision == Precision.FloatingPoint) {
            return;
        }
        long s = this.m_precision == Precision.Integer64 ? 0x1FFFFFFFFFFFFEL : 0x7FFFFFFDL;
        double du = (double)s / this.m_unitsXY;
        double maxX = this.m_falseX + du;
        long s2 = (long)((maxX - this.m_falseX) * this.m_unitsXY);
        if (s2 > s) {
            this.m_unitsXY = (double)s / (maxX - this.m_falseX);
        }
        if ((s2 = (long)(((maxY = this.m_falseY + du) - this.m_falseY) * this.m_unitsXY)) > s) {
            this.m_unitsXY = (double)s / (maxY - this.m_falseY);
        }
    }

    public void setTolerance(int semantics, double tol) {
        switch (semantics) {
            case 0: {
                this.m_toleranceXY = tol;
            }
            case 1: {
                this.m_toleranceZ = tol;
            }
            case 2: {
                this.m_toleranceM = tol;
            }
        }
    }

    public double getTolerance(int semantics) {
        switch (semantics) {
            case 0: {
                return this.m_toleranceXY;
            }
            case 1: {
                return this.m_toleranceZ;
            }
            case 2: {
                return this.m_toleranceM;
            }
        }
        return 0.0;
    }

    public void setGridParams(double falseX, double falseY, double unitsXY) {
        this.m_falseX = falseX;
        this.m_falseY = falseY;
        this.m_unitsXY = unitsXY;
    }

    public void setZParams(double falseZ, double unitsZ) {
        this.m_falseZ = falseZ;
        this.m_unitsZ = unitsZ;
    }

    public void setMParams(double falseM, double unitsM) {
        this.m_falseM = falseM;
        this.m_unitsM = unitsM;
    }

    public Envelope2D getXYGridRange() {
        Envelope2D env = new Envelope2D();
        switch (this.getPrecision()) {
            case Integer32: {
                double delta = 2.147483645E9 / this.getGridUnitsXY();
                env.setCoords(this.getFalseX(), this.getFalseY(), this.getFalseX() + delta, this.getFalseY() + delta);
                break;
            }
            case Integer64: {
                double delta = 9.00719925474099E15 / this.getGridUnitsXY();
                env.setCoords(this.getFalseX(), this.getFalseY(), this.getFalseX() + delta, this.getFalseY() + delta);
                break;
            }
            case FloatingPoint: {
                env.setCoords(-1.7976931348623157E308, -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
                break;
            }
            default: {
                throw new GeometryException("internal error");
            }
        }
        return env;
    }

    public Envelope1D getZGridRange() {
        Envelope1D env = new Envelope1D();
        switch (this.getPrecision()) {
            case Integer32: {
                double delta = 2.147483645E9 / this.getGridUnitsZ();
                env.setCoords(this.getFalseZ(), this.getFalseZ() + delta);
                break;
            }
            case Integer64: {
                double delta = 9.00719925474099E15 / this.getGridUnitsZ();
                env.setCoords(this.getFalseZ(), this.getFalseZ() + delta);
                break;
            }
            case FloatingPoint: {
                env.setCoords(-1.7976931348623157E308, Double.MAX_VALUE);
                break;
            }
            default: {
                throw new GeometryException("internal error");
            }
        }
        return env;
    }

    public Envelope1D getMGridRange() {
        Envelope1D env = new Envelope1D();
        switch (this.getPrecision()) {
            case Integer32: {
                double delta = 2.147483645E9 / this.getGridUnitsM();
                env.setCoords(this.getFalseM(), this.getFalseM() + delta);
                break;
            }
            case Integer64: {
                double delta = 9.00719925474099E15 / this.getGridUnitsM();
                env.setCoords(this.getFalseM(), this.getFalseM() + delta);
                break;
            }
            case FloatingPoint: {
                env.setCoords(-1.7976931348623157E308, Double.MAX_VALUE);
                break;
            }
            default: {
                throw new GeometryException("internal error");
            }
        }
        return env;
    }

    public double getResolution(int semantics) {
        if (this.m_precision == Precision.FloatingPoint) {
            return 0.0;
        }
        switch (semantics) {
            case 0: {
                return 1.0 / this.m_unitsXY;
            }
            case 1: {
                return 1.0 / this.m_unitsZ;
            }
            case 2: {
                return 1.0 / this.m_unitsZ;
            }
        }
        return 0.0;
    }

    public SpatialReferencePrecisionDescriptor() {
        this._init();
    }

    public static enum Precision {
        Integer32(0),
        Integer64(1),
        FloatingPoint(2);

        private int enumValue;

        public int value() {
            return this.enumValue;
        }

        private Precision(int val) {
            this.enumValue = val;
        }

        public static Precision intToPrecision(int vv) {
            Precision[] v = Precision.values();
            for (int i = 0; i < v.length; ++i) {
                if (v[i].value() != vv) continue;
                return v[i];
            }
            throw new IllegalArgumentException();
        }
    }
}

