/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.ExternalTransform;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.LinearUnit;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.PeCoordSysValue;
import com.esri.core.geometry.PeInitializer;
import com.esri.core.geometry.PeVerticalCoordSysValue;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.ProjectionUtils;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferencePrecisionDescriptor;
import com.esri.core.geometry.SpheroidData;
import com.esri.core.geometry.Unit;
import com.esri.core.geometry.VertexDescription;
import com.esri.sde.sdk.pe.engine.PeCoordsys;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeNotationMgrs;
import com.esri.sde.sdk.pe.engine.PeObject;
import com.esri.sde.sdk.pe.engine.PePCSInfo;
import com.esri.sde.sdk.pe.engine.PeProjcs;
import com.esri.sde.sdk.pe.engine.PeProjectionException;
import com.esri.sde.sdk.pe.engine.PeSpheroid;
import com.esri.sde.sdk.pe.engine.PeVertcs;
import com.esri.sde.sdk.pe.factory.PeFactory;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

@HadoopSDKExcluded
class SpatialReferenceImpl
extends SpatialReference {
    public static final int c_SULIMIT32 = 0x7FFFFFFD;
    public static final long c_SULIMIT64 = 0x1FFFFFFFFFFFFEL;
    public ExternalTransform m_external_xform = null;
    public PeCoordSysValue m_peCoordSysVal = null;
    public PeVerticalCoordSysValue m_peVertSysVal = null;
    int m_userWkid = 0;
    int m_userVerticalWkid = 0;
    public SpatialReferencePrecisionDescriptor m_precisionDescriptor = new SpatialReferencePrecisionDescriptor();
    public Unit m_unit = null;
    public LinearUnit m_verticalUnit = null;
    private AtomicReference<SpatialReferenceImpl> m_geogSpatialReference = new AtomicReference<Object>(null);
    private ProjectionTransformation m_SRtoGCS = null;
    private ProjectionTransformation m_GCStoSR = null;
    static final ConcurrentHashMap<Integer, WeakReference<PeCoordSysValue>> st_wkidToPE = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, WeakReference<PeCoordSysValue>> st_wktToPE = new ConcurrentHashMap();
    static final ConcurrentHashMap<Integer, WeakReference<PeVerticalCoordSysValue>> st_wkidToVertPE = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, WeakReference<PeVerticalCoordSysValue>> st_wktToVertPE = new ConcurrentHashMap();
    private static final ReentrantLock st_lock = new ReentrantLock();
    private int m_hashCode = 0;

    @Override
    public boolean equalHorizontal(SpatialReference other) {
        return this.horizontalEqual((SpatialReferenceImpl)other);
    }

    @Override
    public boolean equalVertical(SpatialReference other) {
        return this.verticalEqual((SpatialReferenceImpl)other);
    }

    boolean horizontalEqual(SpatialReferenceImpl other) {
        return PeCoordSysValue.equal(this.m_peCoordSysVal, other.m_peCoordSysVal);
    }

    boolean verticalEqual(SpatialReferenceImpl other) {
        return PeVerticalCoordSysValue.equal(this.m_peVertSysVal, other.m_peVertSysVal);
    }

    @Override
    public String getText() {
        PeCoordsys peCoordsys = this.getPECoordSys();
        if (null == peCoordsys) {
            return null;
        }
        if (this.getPEVerticalCoordSys() != null) {
            return ProjectionUtils.getWKT(null, peCoordsys, this.getPEVerticalCoordSys(), -1);
        }
        return ProjectionUtils.getWKT(peCoordsys);
    }

    @Override
    public String getTextExtended(int verbosity) {
        PeCoordsys peCoordsys = this.getPECoordSys();
        if (null == peCoordsys) {
            return new String();
        }
        if (verbosity == -1001) {
            return this.m_peCoordSysVal.getCanonicalWkt();
        }
        if (this.getPEVerticalCoordSys() != null) {
            return ProjectionUtils.getWKT(null, peCoordsys, this.getPEVerticalCoordSys(), verbosity);
        }
        return ProjectionUtils.getWKT(peCoordsys, verbosity);
    }

    @Override
    public SpatialReference.Type getCoordinateSystemType() {
        PeCoordsys peCoordsys = this.getPECoordSys();
        if (null != peCoordsys) {
            int type = peCoordsys.getType();
            switch (type) {
                case 1: {
                    return SpatialReference.Type.Geographic;
                }
                case 2: {
                    return SpatialReference.Type.Projected;
                }
            }
            return SpatialReference.Type.Local;
        }
        return SpatialReference.Type.Local;
    }

    @Override
    public int getID() {
        return this.m_userWkid;
    }

    @Override
    public int getLatestID() {
        return this.m_peCoordSysVal != null ? this.m_peCoordSysVal.getLatestID() : 0;
    }

    @Override
    public int getOldID() {
        return this.m_peCoordSysVal != null ? this.m_peCoordSysVal.getOldID() : 0;
    }

    @Override
    public int getVerticalID() {
        return this.m_userVerticalWkid;
    }

    @Override
    public int getLatestVerticalID() {
        return this.m_peVertSysVal != null ? this.m_peVertSysVal.getLatestID() : 0;
    }

    @Override
    public int getOldVerticalID() {
        return this.m_peVertSysVal != null ? this.m_peVertSysVal.getOldID() : 0;
    }

    @Override
    public Unit getUnit() {
        return this.m_unit;
    }

    public PeCoordsys getHorzCoordSys() {
        return this.getPECoordSys();
    }

    @Override
    public double getTolerance(int semantics) {
        return this.m_precisionDescriptor.getTolerance(semantics);
    }

    void setTolerance(int semantics, double newValue) {
        if (newValue < 0.0) {
            throw new IllegalArgumentException("newValue < 0");
        }
        this.m_precisionDescriptor.setTolerance(semantics, newValue);
    }

    @Override
    public double getResolution(int semantics) {
        return this.m_precisionDescriptor.getResolution(semantics);
    }

    public void queryValidCoordinateRange(Envelope2D env2D) {
        env2D.setCoords(this.m_precisionDescriptor.getXYGridRange());
    }

    public boolean requiresReSimplify(SpatialReference dst) {
        return dst != this;
    }

    public void snapCoordinates(Point2D[] pointsInOut) {
        for (int i = 0; i < pointsInOut.length; ++i) {
            Point2D pt = pointsInOut[i];
            pointsInOut[i].x = (double)Math.round((pt.x - this.m_precisionDescriptor.getFalseX()) * this.m_precisionDescriptor.getGridUnitsXY()) / this.m_precisionDescriptor.getGridUnitsXY() + this.m_precisionDescriptor.getFalseX();
            pointsInOut[i].y = (double)Math.round((pt.y - this.m_precisionDescriptor.getFalseY()) * this.m_precisionDescriptor.getGridUnitsXY()) / this.m_precisionDescriptor.getGridUnitsXY() + this.m_precisionDescriptor.getFalseY();
        }
    }

    public void snapAttributes(int semantics, AttributeStreamBase attributesInOut, int pointCount) {
        block4: {
            block5: {
                block3: {
                    if (semantics != 0) break block3;
                    AttributeStreamOfDbl xyCoordsInOut = (AttributeStreamOfDbl)attributesInOut;
                    for (int i = 0; i < pointCount; ++i) {
                        xyCoordsInOut.write(2 * i, (double)Math.round((xyCoordsInOut.read(2 * i) - this.m_precisionDescriptor.getFalseX()) * this.m_precisionDescriptor.getGridUnitsXY()) / this.m_precisionDescriptor.getGridUnitsXY() + this.m_precisionDescriptor.getFalseX());
                        xyCoordsInOut.write(2 * i + 1, (double)Math.round((xyCoordsInOut.read(2 * i + 1) - this.m_precisionDescriptor.getFalseY()) * this.m_precisionDescriptor.getGridUnitsXY()) / this.m_precisionDescriptor.getGridUnitsXY() + this.m_precisionDescriptor.getFalseY());
                    }
                    break block4;
                }
                if (semantics != 1) break block5;
                AttributeStreamOfDbl zInOut = (AttributeStreamOfDbl)attributesInOut;
                for (int i = 0; i < pointCount; ++i) {
                    zInOut.write(i, (double)Math.round((zInOut.read(i) - this.m_precisionDescriptor.getFalseZ()) * this.m_precisionDescriptor.getGridUnitsZ()) / this.m_precisionDescriptor.getGridUnitsZ() + this.m_precisionDescriptor.getFalseZ());
                }
                break block4;
            }
            if (semantics != 2) break block4;
            AttributeStreamOfDbl mInOut = (AttributeStreamOfDbl)attributesInOut;
            for (int i = 0; i < pointCount; ++i) {
                mInOut.write(i, (double)Math.round((mInOut.read(i) - this.m_precisionDescriptor.getFalseM()) * this.m_precisionDescriptor.getGridUnitsM()) / this.m_precisionDescriptor.getGridUnitsM() + this.m_precisionDescriptor.getFalseM());
            }
        }
    }

    public void snapGeometry(Geometry geometry) {
        if (geometry.isEmpty()) {
            return;
        }
        int gt = geometry.getType().value();
        if (Geometry.isMultiVertex(gt)) {
            MultiVertexGeometryImpl mpImpl = (MultiVertexGeometryImpl)geometry._getImpl();
            VertexDescription vd = mpImpl.getDescription();
            int n = vd.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                int semantics = vd.getSemantics(i);
                AttributeStreamBase stream = mpImpl.getAttributeStreamRef(semantics);
                this.snapAttributes(semantics, stream, mpImpl.getPointCount());
            }
            mpImpl.notifyModified(2001);
        } else if (gt == 33) {
            Point point = (Point)geometry;
            Point2D pt = point.getXY();
            pt.x = (double)Math.round((pt.x - this.m_precisionDescriptor.getFalseX()) * this.m_precisionDescriptor.getGridUnitsXY()) / this.m_precisionDescriptor.getGridUnitsXY() + this.m_precisionDescriptor.getFalseX();
            pt.y = (double)Math.round((pt.y - this.m_precisionDescriptor.getFalseY()) * this.m_precisionDescriptor.getGridUnitsXY()) / this.m_precisionDescriptor.getGridUnitsXY() + this.m_precisionDescriptor.getFalseY();
            point.setXY(pt);
            if (point.hasAttribute(1)) {
                double z = point.getZ();
                z = (double)Math.round((z - this.m_precisionDescriptor.getFalseZ()) * this.m_precisionDescriptor.getGridUnitsZ()) / this.m_precisionDescriptor.getGridUnitsZ() + this.m_precisionDescriptor.getFalseZ();
                point.setZ(z);
            }
            if (point.hasAttribute(2)) {
                double m = point.getM();
                m = (double)Math.round((m - this.m_precisionDescriptor.getFalseM()) * this.m_precisionDescriptor.getGridUnitsM()) / this.m_precisionDescriptor.getGridUnitsM() + this.m_precisionDescriptor.getFalseM();
                point.setM(m);
            }
        }
    }

    public boolean hasVerticalCoordinateSystem() {
        return this.getPEVerticalCoordSys() != null;
    }

    @Override
    public String getAuthority() {
        PeCoordsys peCoordsys = this.getPECoordSys();
        if (null == peCoordsys) {
            return null;
        }
        return ProjectionUtils.getAuthority(peCoordsys);
    }

    @Override
    public SpatialReference getGCS() {
        SpatialReference.Type srType = this.getCoordinateSystemType();
        if (srType == SpatialReference.Type.Local) {
            throw new GeometryException("invalid call");
        }
        if (srType == SpatialReference.Type.Geographic) {
            return this;
        }
        if (srType == SpatialReference.Type.Image) {
            return this.m_external_xform.getBaseSpatialReference().getGCS();
        }
        SpatialReferenceImpl sr = this.m_geogSpatialReference.get();
        if (sr != null) {
            return sr;
        }
        PeCoordsys peCoordSys = this.getPECoordSys();
        PeGeogcs gcs = ((PeProjcs)peCoordSys).getGeogcs();
        if (null == gcs) {
            throw GeometryException.GeometryInternalError();
        }
        sr = SpatialReferenceImpl.createImpl((PeCoordsys)gcs, this.getPEVerticalCoordSys(), this.m_precisionDescriptor.getPrecision());
        if (this.m_geogSpatialReference.compareAndSet(null, sr)) {
            return sr;
        }
        return this.m_geogSpatialReference.get();
    }

    double getHorzUnitFactor() {
        return this.m_unit.getUnitToBaseFactor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PeCoordSysValue _cache(PeCoordsys peCoordSys, boolean check_wkid_cache) {
        PeCoordSysValue obj;
        PeCoordSysValue obj2;
        WeakReference<PeCoordSysValue> weakRef;
        int wkid = peCoordSys.getCode();
        if (wkid <= 0 && (wkid = PeFactory.getCode((PeObject)peCoordSys)) > 0) {
            PeCoordsys peCoordSysReal = PeFactory.coordsys((int)wkid);
            if (peCoordSysReal == null) {
                throw new IllegalArgumentException("Text to wkid mapping had failed: " + wkid);
            }
            return SpatialReferenceImpl._cache(peCoordSysReal, check_wkid_cache);
        }
        if (check_wkid_cache && wkid > 0 && (weakRef = st_wkidToPE.get(wkid)) != null && (obj2 = (PeCoordSysValue)weakRef.get()) != null) {
            return obj2;
        }
        String wkt = ProjectionUtils.getWKTForCaching(peCoordSys, wkid, false);
        WeakReference<PeCoordSysValue> weakRef2 = st_wktToPE.get(wkt);
        if (weakRef2 != null && (obj = (PeCoordSysValue)weakRef2.get()) != null) {
            return obj;
        }
        PeCoordsys cloneCoordSys = wkid <= 0 ? (PeCoordsys)peCoordSys.clone() : PeFactory.coordsys((int)wkid);
        obj = new PeCoordSysValue(cloneCoordSys);
        WeakReference<PeCoordSysValue> weakRefWKT = new WeakReference<PeCoordSysValue>(obj);
        WeakReference<PeCoordSysValue> weakRefWKID = new WeakReference<PeCoordSysValue>(obj);
        st_lock.lock();
        try {
            WeakReference<PeCoordSysValue> existing = st_wktToPE.putIfAbsent(wkt, weakRefWKT);
            if (existing == null) {
                if (wkid > 0) {
                    st_wkidToPE.put(wkid, weakRefWKID);
                }
                PeCoordSysValue peCoordSysValue = obj;
                return peCoordSysValue;
            }
            PeCoordSysValue existingObj = (PeCoordSysValue)existing.get();
            if (existingObj == null) {
                st_wktToPE.put(wkt, weakRefWKT);
                if (wkid > 0) {
                    st_wkidToPE.put(wkid, weakRefWKID);
                }
            } else {
                obj = existingObj;
            }
        }
        finally {
            st_lock.unlock();
        }
        return obj;
    }

    static PeCoordSysValue _cache(int wkid) {
        PeCoordSysValue obj;
        if (wkid <= 0) {
            throw new IllegalArgumentException("Invalid or unsupported wkid: " + wkid);
        }
        WeakReference<PeCoordSysValue> weakRef = st_wkidToPE.get(wkid);
        if (weakRef != null && (obj = (PeCoordSysValue)weakRef.get()) != null) {
            return obj;
        }
        PeCoordsys peCoordSys = PeFactory.coordsys((int)wkid);
        if (peCoordSys == null) {
            throw new IllegalArgumentException("Invalid or unsupported wkid: " + wkid);
        }
        PeCoordSysValue obj2 = SpatialReferenceImpl._cache(peCoordSys, false);
        if (obj2.getLatestID() != wkid) {
            st_wkidToPE.put(wkid, new WeakReference<PeCoordSysValue>(obj2));
        }
        return obj2;
    }

    static PeCoordSysValue _cache(String wkt) {
        if (wkt == null || wkt.length() == 0) {
            throw new IllegalArgumentException("Cannot create SpatialReference from null or empty text.");
        }
        PeCoordsys peCoordSys = null;
        try {
            peCoordSys = PeCoordsys.fromString((String)wkt);
        }
        catch (PeProjectionException ex) {
            throw new IllegalArgumentException("Cannot create SpatialReference from text. " + ex.getMessage());
        }
        return SpatialReferenceImpl._cache(peCoordSys, true);
    }

    private static PeVerticalCoordSysValue _cacheVertical(int vcsWkid) {
        PeVerticalCoordSysValue obj;
        InternalUtils.require(vcsWkid > 0);
        PeInitializer.touch();
        WeakReference<PeVerticalCoordSysValue> weakRef = st_wkidToVertPE.get(vcsWkid);
        if (weakRef != null && (obj = (PeVerticalCoordSysValue)weakRef.get()) != null) {
            return obj;
        }
        PeVertcs sys = PeFactory.vertcs((int)vcsWkid);
        InternalUtils.require(sys != null);
        PeVerticalCoordSysValue obj2 = SpatialReferenceImpl._cache(sys, false);
        if (obj2.getLatestID() != vcsWkid) {
            st_wkidToVertPE.put(vcsWkid, new WeakReference<PeVerticalCoordSysValue>(obj2));
        }
        return obj2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PeVerticalCoordSysValue _cache(PeVertcs vertcs, boolean check_wkid_cache) {
        PeVerticalCoordSysValue obj;
        PeVerticalCoordSysValue obj2;
        WeakReference<PeVerticalCoordSysValue> weakRef;
        int wkid = vertcs.getCode();
        if (wkid <= 0 && (wkid = PeFactory.getCode((PeObject)vertcs)) > 0) {
            PeVertcs peCoordSysReal = PeFactory.vertcs((int)wkid);
            InternalUtils.require(peCoordSysReal != null);
            return SpatialReferenceImpl._cache(peCoordSysReal, check_wkid_cache);
        }
        if (check_wkid_cache && wkid > 0 && (weakRef = st_wkidToVertPE.get(wkid)) != null && (obj2 = (PeVerticalCoordSysValue)weakRef.get()) != null) {
            return obj2;
        }
        String wkt = ProjectionUtils.getWKTForCaching(vertcs, wkid, false);
        WeakReference<PeVerticalCoordSysValue> weakRef2 = st_wktToVertPE.get(wkt);
        if (weakRef2 != null && (obj = (PeVerticalCoordSysValue)weakRef2.get()) != null) {
            return obj;
        }
        PeVertcs cloneCoordSys = wkid <= 0 ? (PeVertcs)vertcs.clone() : PeFactory.vertcs((int)wkid);
        InternalUtils.require(cloneCoordSys != null);
        obj = new PeVerticalCoordSysValue(cloneCoordSys);
        WeakReference<PeVerticalCoordSysValue> weakRefWKT = new WeakReference<PeVerticalCoordSysValue>(obj);
        WeakReference<PeVerticalCoordSysValue> weakRefWKID = new WeakReference<PeVerticalCoordSysValue>(obj);
        try {
            st_lock.lock();
            WeakReference<PeVerticalCoordSysValue> existing = st_wktToVertPE.putIfAbsent(wkt, weakRefWKT);
            if (existing == null) {
                if (wkid > 0) {
                    st_wkidToVertPE.put(wkid, weakRefWKID);
                }
                PeVerticalCoordSysValue peVerticalCoordSysValue = obj;
                return peVerticalCoordSysValue;
            }
            PeVerticalCoordSysValue existingObj = (PeVerticalCoordSysValue)existing.get();
            if (existingObj == null) {
                st_wktToVertPE.put(wkt, weakRefWKT);
                if (wkid > 0) {
                    st_wkidToVertPE.put(wkid, weakRefWKID);
                }
            } else {
                obj = existingObj;
            }
        }
        finally {
            st_lock.unlock();
        }
        return obj;
    }

    void _calculateHashCode() {
        if (this.m_peCoordSysVal != null) {
            this.m_hashCode = this.m_peCoordSysVal.hashCode();
            if (this.m_peVertSysVal != null) {
                this.m_hashCode = NumberUtils.hashCombine(this.m_hashCode, this.m_peVertSysVal.hashCode());
            }
        } else {
            this.m_hashCode = this.m_external_xform != null ? this.m_external_xform.hashCode() : this.m_unit.hashCode();
        }
    }

    public static SpatialReferenceImpl createImpl(int wkid) {
        return SpatialReferenceImpl.createImpl(wkid, false);
    }

    public static SpatialReferenceImpl createImpl(int wkid, boolean dontShortcut) {
        if (!dontShortcut) {
            if (wkid == 3857) {
                return SpatialReferenceImpl.webMercator();
            }
            if (wkid == 102100) {
                return SpatialReferenceImpl.webMercator102100();
            }
            if (wkid == 4326) {
                return SpatialReferenceImpl.wgs84();
            }
        }
        PeInitializer.touch();
        PeCoordSysValue peCoordSysVal = SpatialReferenceImpl._cache(wkid);
        SpatialReferenceImpl spatRef = new SpatialReferenceImpl();
        spatRef._setHorzProj(peCoordSysVal);
        spatRef.m_precisionDescriptor._init(peCoordSysVal, null, SpatialReferencePrecisionDescriptor.Precision.Integer64);
        spatRef._calculateHashCode();
        spatRef.m_userWkid = wkid;
        spatRef.m_userVerticalWkid = 0;
        return spatRef;
    }

    public static SpatialReferenceImpl createImpl(int wkid, int vcsWkid) {
        PeInitializer.touch();
        PeCoordSysValue peCoordSysVal = SpatialReferenceImpl._cache(wkid);
        PeVerticalCoordSysValue peVcsCoordSysVal = null;
        if (vcsWkid > 0) {
            peVcsCoordSysVal = SpatialReferenceImpl._cacheVertical(vcsWkid);
        }
        SpatialReferenceImpl spatRef = new SpatialReferenceImpl();
        spatRef._setHorzProj(peCoordSysVal);
        spatRef._setVertProj(peVcsCoordSysVal);
        spatRef.m_precisionDescriptor._init(peCoordSysVal, peVcsCoordSysVal, SpatialReferencePrecisionDescriptor.Precision.Integer64);
        spatRef._calculateHashCode();
        spatRef.m_userWkid = wkid;
        spatRef.m_userVerticalWkid = vcsWkid;
        return spatRef;
    }

    public void _setHorzProj(PeCoordSysValue peCoordSysVal) {
        this.m_peCoordSysVal = peCoordSysVal;
        this.m_unit = this.m_peCoordSysVal.getUnit();
    }

    public void _setVertProj(PeVerticalCoordSysValue peCoordSysVal) {
        this.m_peVertSysVal = peCoordSysVal;
        this.m_verticalUnit = this.m_peVertSysVal != null ? this.m_peVertSysVal.getVerticalUnit() : null;
    }

    public static SpatialReferenceImpl createImpl(String wkt) {
        PeInitializer.touch();
        PeCoordSysValue peCoordSysVal = SpatialReferenceImpl._cache(wkt);
        PeVerticalCoordSysValue peVertSysVal = SpatialReferenceImpl._cacheVerticalCanReturnNull(wkt);
        SpatialReferenceImpl spatRef = new SpatialReferenceImpl();
        spatRef.m_precisionDescriptor._init(peCoordSysVal, peVertSysVal, SpatialReferencePrecisionDescriptor.Precision.Integer64);
        spatRef._setHorzProj(peCoordSysVal);
        spatRef._setVertProj(peVertSysVal);
        spatRef._calculateHashCode();
        spatRef.m_userWkid = peCoordSysVal.getLatestID();
        if (peVertSysVal != null) {
            spatRef.m_userVerticalWkid = peVertSysVal.getLatestID();
        }
        return spatRef;
    }

    static PeVerticalCoordSysValue _cacheVerticalCanReturnNull(String wkt) {
        InternalUtils.require(wkt.length() > 0);
        PeInitializer.touch();
        PeVertcs sys = null;
        try {
            sys = PeVertcs.fromString((String)wkt);
        }
        catch (PeProjectionException ex) {
            sys = null;
        }
        if (sys == null) {
            return null;
        }
        return SpatialReferenceImpl._cache(sys, true);
    }

    public static SpatialReferenceImpl createImpl(PeCoordsys peCoordSys, PeVertcs vertCS, SpatialReferencePrecisionDescriptor.Precision precision, boolean cache) {
        if (peCoordSys == null) {
            throw new IllegalArgumentException("null pointer.");
        }
        SpatialReferenceImpl spatRef = new SpatialReferenceImpl();
        PeCoordSysValue peCoordSysVal = cache ? SpatialReferenceImpl._cache(peCoordSys, true) : new PeCoordSysValue((PeCoordsys)peCoordSys.clone());
        PeVerticalCoordSysValue vertSysVal = null;
        if (vertCS != null) {
            vertSysVal = SpatialReferenceImpl._cache(vertCS, true);
        }
        spatRef.m_precisionDescriptor._init(peCoordSysVal, vertSysVal, precision);
        spatRef._setHorzProj(peCoordSysVal);
        spatRef._setVertProj(vertSysVal);
        spatRef.m_userWkid = peCoordSysVal.getLatestID();
        if (vertSysVal != null) {
            spatRef.m_userVerticalWkid = vertSysVal.getLatestID();
        }
        return spatRef;
    }

    public static SpatialReferenceImpl createImpl(PeCoordsys peCoordSys, PeVertcs vertCS, SpatialReferencePrecisionDescriptor.Precision precision) {
        return SpatialReferenceImpl.createImpl(peCoordSys, vertCS, precision, true);
    }

    public static SpatialReferenceImpl createImpl(ExternalTransform externalXform) {
        if (externalXform == null) {
            new GeometryException("null value is not allowed");
        }
        SpatialReferenceImpl spatRef = new SpatialReferenceImpl();
        spatRef.m_unit = null;
        externalXform.queryPrecisionDescriptor(spatRef.m_precisionDescriptor);
        spatRef.m_external_xform = externalXform;
        spatRef._calculateHashCode();
        return spatRef;
    }

    public static SpatialReferenceImpl createWithNewPrecisionDescriptorImpl(SpatialReference sourceSR, SpatialReferencePrecisionDescriptor srd) {
        SpatialReferenceImpl spatRef = new SpatialReferenceImpl();
        SpatialReferenceImpl srcSpatRef = (SpatialReferenceImpl)sourceSR;
        spatRef.m_peCoordSysVal = srcSpatRef.m_peCoordSysVal;
        spatRef.m_peVertSysVal = srcSpatRef.m_peVertSysVal;
        spatRef.m_unit = srcSpatRef.m_unit;
        spatRef.m_verticalUnit = srcSpatRef.m_verticalUnit;
        spatRef.m_userWkid = srcSpatRef.m_userWkid;
        spatRef.m_userVerticalWkid = srcSpatRef.m_userVerticalWkid;
        spatRef.m_precisionDescriptor.assign(srd);
        return spatRef;
    }

    public static SpatialReferenceImpl createLocalImpl(Unit unit) {
        SpatialReferenceImpl spatRef = new SpatialReferenceImpl();
        spatRef.m_unit = unit != null ? unit : LinearUnit.create(9001);
        spatRef.m_precisionDescriptor._initForLocalCS(spatRef.m_unit, SpatialReferencePrecisionDescriptor.Precision.Integer64);
        return spatRef;
    }

    @Override
    public String[] toMilitaryGrid(int mgrsConversionMode, int numOfDigits, boolean rounding, boolean addSpaces, Point[] coordinates) {
        int mode;
        if (this.getCoordinateSystemType() == SpatialReference.Type.Local) {
            throw new GeometryException("invalid call");
        }
        if (coordinates == null || coordinates.length == 0) {
            return new String[0];
        }
        int n = coordinates.length;
        Point[] coordinatesGCS = null;
        SpatialReferenceImpl gcsSR = (SpatialReferenceImpl)this.getGCS();
        if (this.getCoordinateSystemType() == SpatialReference.Type.Projected) {
            coordinatesGCS = new Point[n];
            this.toGCS(coordinates, coordinatesGCS);
        } else {
            coordinatesGCS = coordinates;
            SpatialReferenceImpl.check_for_invalid_coords(coordinatesGCS);
        }
        double[] gcsArray = new double[2 * n];
        for (int i = 0; i < n; ++i) {
            gcsArray[2 * i] = coordinatesGCS[i].getX();
            gcsArray[2 * i + 1] = coordinatesGCS[i].getY();
        }
        String[] mgrsArray = new String[n];
        switch (mgrsConversionMode) {
            case 0: {
                mode = 0;
                break;
            }
            case 256: {
                mode = 256;
                break;
            }
            case 512: {
                mode = 512;
                break;
            }
            case 4352: {
                mode = 4352;
                break;
            }
            default: {
                mode = 4608;
            }
        }
        int res = PeNotationMgrs.geog_to_mgrs_extended((PeGeogcs)((PeGeogcs)gcsSR.getPECoordSys()), (int)n, (double[])gcsArray, (int)numOfDigits, (boolean)rounding, (int)mode, (String[])mgrsArray);
        if (res != n) {
            throw new GeometryException("conversion failed");
        }
        return mgrsArray;
    }

    @Override
    public Point[] fromMilitaryGrid(String[] mgrsStrings, int mgrsConversionMode) {
        int mode;
        if (this.getCoordinateSystemType() == SpatialReference.Type.Local) {
            throw new GeometryException("invalid call.");
        }
        if (mgrsStrings == null || 0 == mgrsStrings.length) {
            return new Point[0];
        }
        SpatialReferenceImpl gcsSR = (SpatialReferenceImpl)this.getGCS();
        int n = mgrsStrings.length;
        double[] pe_coords = new double[2 * n];
        switch (mgrsConversionMode) {
            case 0: {
                mode = 256;
                break;
            }
            case 256: {
                mode = 256;
                break;
            }
            case 512: {
                mode = 512;
                break;
            }
            case 4352: {
                mode = 4352;
                break;
            }
            default: {
                mode = 4608;
            }
        }
        int res = PeNotationMgrs.mgrs_to_geog_extended((PeGeogcs)((PeGeogcs)gcsSR.getPECoordSys()), (int)mgrsStrings.length, (String[])mgrsStrings, (int)mode, (double[])pe_coords);
        if (res != mgrsStrings.length) {
            throw new GeometryException("conversion failed");
        }
        Point[] result = new Point[mgrsStrings.length];
        for (int i = 0; i < n; ++i) {
            result[i] = new Point(pe_coords[2 * i], pe_coords[2 * i + 1]);
        }
        this.fromGCS(result, result);
        return result;
    }

    private void fromGCS(Point[] coordsSrc, Point[] coordsDst) {
        if (coordsSrc.length == 0) {
            return;
        }
        if (coordsSrc.length > coordsDst.length) {
            throw new IllegalArgumentException("Array length mismatch.");
        }
        if (this.getCoordinateSystemType() == SpatialReference.Type.Local) {
            throw new IllegalStateException();
        }
        if (this.getCoordinateSystemType() == SpatialReference.Type.Geographic) {
            if (coordsSrc != coordsDst) {
                System.arraycopy(coordsSrc, 0, coordsDst, 0, coordsSrc.length);
            }
            return;
        }
        OperatorProject project = (OperatorProject)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Project);
        ProjectionTransformation transform = this.getGCSToSRTransform();
        project.transform(transform, coordsSrc, coordsSrc.length, coordsDst);
    }

    private void toGCS(Point[] coordsSrc, Point[] coordsDst) {
        if (coordsSrc.length == 0) {
            return;
        }
        if (coordsSrc.length > coordsDst.length) {
            throw new IllegalArgumentException("Array length mismatch.");
        }
        if (this.getCoordinateSystemType() == SpatialReference.Type.Local) {
            throw new IllegalStateException();
        }
        if (this.getCoordinateSystemType() == SpatialReference.Type.Geographic) {
            if (coordsSrc != coordsDst) {
                System.arraycopy(coordsSrc, 0, coordsDst, 0, coordsSrc.length);
            }
            return;
        }
        OperatorProject project = (OperatorProject)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Project);
        ProjectionTransformation transform = this.getSRToGCSTransform();
        project.transform(transform, coordsSrc, coordsSrc.length, coordsDst);
    }

    ProjectionTransformation getSRToGCSTransform() {
        ProjectionTransformation projTrans = null;
        st_lock.lock();
        projTrans = this.m_SRtoGCS;
        st_lock.unlock();
        if (projTrans == null) {
            projTrans = ProjectionTransformation.createEx(this, this.getGCS(), null);
            st_lock.lock();
            this.m_SRtoGCS = projTrans;
            st_lock.unlock();
        }
        return projTrans;
    }

    ProjectionTransformation getGCSToSRTransform() {
        ProjectionTransformation projTrans = null;
        st_lock.lock();
        projTrans = this.m_GCStoSR;
        st_lock.unlock();
        if (projTrans == null) {
            projTrans = ProjectionTransformation.createEx(this.getGCS(), this, null);
            st_lock.lock();
            this.m_GCStoSR = projTrans;
            st_lock.unlock();
        }
        return projTrans;
    }

    @Override
    public ExternalTransform getExternalTransform() {
        return this.m_external_xform;
    }

    @Override
    public boolean isPannable() {
        SpatialReference.Type type = this.getCoordinateSystemType();
        if (type == SpatialReference.Type.Local || type == SpatialReference.Type.Image) {
            return false;
        }
        return this.m_peCoordSysVal.isPannable();
    }

    public boolean isPannableBase() {
        SpatialReference.Type t = this.getCoordinateSystemType();
        if (t == SpatialReference.Type.Local) {
            return false;
        }
        if (t == SpatialReference.Type.Image) {
            return this.m_external_xform.getBaseSpatialReference().isPannable();
        }
        return this.m_peCoordSysVal.isPannable();
    }

    double getAdjustedCentralMeridian() {
        if (this.getCoordinateSystemType() == SpatialReference.Type.Image) {
            return ((SpatialReferenceImpl)this.m_external_xform.getBaseSpatialReference()).getAdjustedCentralMeridian();
        }
        return this.m_peCoordSysVal.getAdjustedCentralMeridian();
    }

    double getGCSUnitFactor() {
        if (this.m_external_xform != null) {
            return ((SpatialReferenceImpl)this.m_external_xform.getBaseSpatialReference()).getGCSUnitFactor();
        }
        return this.m_peCoordSysVal.getGCSUnitFactor();
    }

    @Override
    public Envelope2D getPannableExtent() {
        if (!this.isPannable()) {
            throw new IllegalArgumentException("!isPannable()");
        }
        Envelope2D env = new Envelope2D();
        this.m_peCoordSysVal.getPannableExtent(env);
        return env;
    }

    public Envelope2D getPannableExtentInGCS() {
        if (!this.isPannable()) {
            throw new IllegalArgumentException("!isPannable()");
        }
        Envelope2D env = new Envelope2D();
        this.m_peCoordSysVal.getPannableExtentGCS(env);
        return env;
    }

    public void queryPannableExtent(Envelope2D env) {
        if (!this.isPannable()) {
            throw new IllegalArgumentException("!isPannable()");
        }
        this.m_peCoordSysVal.getPannableExtent(env);
    }

    public Envelope2D getPannableExtentByReferenceInternal() {
        if (!this.isPannable()) {
            throw new IllegalArgumentException("!isPannable()");
        }
        return this.m_peCoordSysVal.getPannableExtentByRef();
    }

    public double getPannableExtentXMin() {
        if (!this.isPannable()) {
            throw new IllegalArgumentException("!isPannable()");
        }
        return this.m_peCoordSysVal.getPannableExtentXMin();
    }

    public double getPannableExtentXMax() {
        if (!this.isPannable()) {
            throw new IllegalArgumentException("!isPannable()");
        }
        return this.m_peCoordSysVal.getPannableExtentXMax();
    }

    boolean getGCSHorisonIsInclusive() {
        return this.m_peCoordSysVal.getGCSHorisonIsInclusive();
    }

    @Override
    public SpheroidData getSpheroidData() {
        SpatialReference gcs = this.getGCS();
        SpatialReferenceImpl impl = (SpatialReferenceImpl)gcs;
        PeGeogcs pegeogcs = (PeGeogcs)impl.getPECoordSys();
        PeSpheroid spheroid = pegeogcs.getDatum().getSpheroid();
        double flattening = spheroid.getFlattening();
        double e_squared = spheroid.getESquared();
        double a = spheroid.getAxis();
        SpheroidData spheroid_data = new SpheroidData();
        spheroid_data.majorSemiAxis = a;
        spheroid_data.minorSemiAxis = spheroid.getSemiminorAxis();
        spheroid_data.e2 = e_squared;
        spheroid_data.flattening = flattening;
        return spheroid_data;
    }

    public PeCoordsys getPECoordSys() {
        return this.m_peCoordSysVal != null ? this.m_peCoordSysVal.m_peCoordSys : null;
    }

    private PeVertcs getPEVerticalCoordSys() {
        return this.m_peVertSysVal != null ? this.m_peVertSysVal.m_peVertcs : null;
    }

    double getSquareUnitFactor() {
        double f = this.getHorzUnitFactor();
        return f * f;
    }

    public Geometry getGCSHorizon() {
        return this.m_peCoordSysVal.getGCSHorizon();
    }

    public boolean gcsHorisonIsInclusive() {
        return this.m_peCoordSysVal.getGCSHorisonIsInclusive();
    }

    public Geometry getPCSHorizon() {
        return this.m_peCoordSysVal.getPCSHorizon();
    }

    public double getOneDegreeGCSUnit() {
        return this.m_peCoordSysVal.getOneDegreeGCSUnit();
    }

    public double getOneMeterPCSUnit() {
        return this.m_peCoordSysVal.getOneMeterPCSUnit();
    }

    public Point2D getPole(boolean south) {
        Point2D point = new Point2D();
        this.m_peCoordSysVal.getPole(south, point);
        return point;
    }

    public Envelope2D getDomainXY() {
        Envelope2D env = new Envelope2D();
        this.m_peCoordSysVal.getDomainXY(env);
        return env;
    }

    public double getUnitsPerMillimeter() {
        if (this.m_peCoordSysVal != null) {
            return this.m_peCoordSysVal.getUnitsPerMillimiter();
        }
        return NumberUtils.NaN();
    }

    @Override
    public Envelope2D getFullWorldExtent() {
        if (this.getCoordinateSystemType() == SpatialReference.Type.Local) {
            throw new GeometryException("invalid call");
        }
        if (this.getCoordinateSystemType() == SpatialReference.Type.Projected) {
            return this.getDomainXY();
        }
        return this.getPannableExtent();
    }

    @Override
    public Envelope2D getFullWorldExtentGCS() {
        if (this.getCoordinateSystemType() == SpatialReference.Type.Local) {
            throw new GeometryException("invalid call");
        }
        if (this.getCoordinateSystemType() == SpatialReference.Type.Projected) {
            Geometry gcsHorizon = this.getGCSHorizon();
            boolean GCS_horison_is_inclusive = this.gcsHorisonIsInclusive();
            if (!GCS_horison_is_inclusive) {
                return this.getGCS().getFullWorldExtent();
            }
            Envelope2D horizonEnv2D = new Envelope2D();
            gcsHorizon.queryEnvelope2D(horizonEnv2D);
            double widthThreshold = 359.0 * this.getOneDegreeGCSUnit();
            if (horizonEnv2D.getWidth() < widthThreshold) {
                return horizonEnv2D;
            }
            Envelope2D gcsWorld = this.getGCS().getFullWorldExtent();
            horizonEnv2D.xmin = gcsWorld.xmin;
            horizonEnv2D.xmax = gcsWorld.xmax;
            return horizonEnv2D;
        }
        return this.getPannableExtent();
    }

    public double getPrimeMeridian() {
        return this.m_peCoordSysVal.getPrimeMeridian();
    }

    public PePCSInfo getPCSInfo() {
        return this.m_peCoordSysVal.getPCSInfo();
    }

    @Override
    public void queryPrecisionDescriptor(SpatialReferencePrecisionDescriptor precisionDescriptor) {
        precisionDescriptor.assign(this.m_precisionDescriptor);
    }

    @Override
    public MapGeometry getAreaOfUse() {
        if (this.getCoordinateSystemType() == SpatialReference.Type.Local) {
            throw new GeometryException("invalid call");
        }
        if (this.getCoordinateSystemType() == SpatialReference.Type.Image) {
            return this.m_external_xform.getBaseSpatialReference().getAreaOfUse();
        }
        return new MapGeometry(this.m_peCoordSysVal.getAreaOfUse().copy(), SpatialReferenceImpl.wgs84());
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpatialReferenceImpl sr = (SpatialReferenceImpl)obj;
        if (!this.horizontalEqual(sr) || !this.verticalEqual(sr)) {
            return false;
        }
        if (sr.m_peCoordSysVal == null) {
            return this.getUnit().equals(sr.getUnit());
        }
        return true;
    }

    @Override
    public ProjectionTransformation getSRtoGCStransform() {
        return ProjectionTransformation.createEx(this, this.getGCS(), null);
    }

    @Override
    public ProjectionTransformation getGCStoSRtransform() {
        return ProjectionTransformation.createEx(this.getGCS(), this, null);
    }

    Polyline getGCSSplitLines() {
        return this.m_peCoordSysVal.getGCSSplitLines();
    }

    static double geodesicDistanceOnWGS84Impl(Point ptFrom, Point ptTo) {
        Polyline poly = new Polyline();
        poly.startPath(ptFrom);
        poly.lineTo(ptTo);
        return GeometryEngine.geodesicLength(poly, SpatialReference.create(4326), (LinearUnit)LinearUnit.create(9001));
    }

    boolean horizontal_equal_(SpatialReferenceImpl other) {
        return PeCoordSysValue.equal(this.m_peCoordSysVal, other.m_peCoordSysVal);
    }

    static void check_for_invalid_coords(Point[] coordinates) {
        for (int i = 0; i < coordinates.length; ++i) {
            if (!coordinates[i].isEmpty()) continue;
            throw new GeometryException("coordinates are out of range");
        }
    }

    private static SpatialReferenceImpl webMercator() {
        PeInitializer.touch();
        return StaticSRs.sr3857;
    }

    private static SpatialReferenceImpl webMercator102100() {
        PeInitializer.touch();
        return StaticSRs.sr102100;
    }

    private static SpatialReferenceImpl wgs84() {
        PeInitializer.touch();
        return StaticSRs.sr4326;
    }

    private static class StaticSRs {
        static SpatialReferenceImpl sr4326 = SpatialReferenceImpl.createImpl(4326, true);
        static SpatialReferenceImpl sr3857 = SpatialReferenceImpl.createImpl(3857, true);
        static SpatialReferenceImpl sr102100 = SpatialReferenceImpl.createImpl(102100, true);

        private StaticSRs() {
        }
    }
}

