/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.ExternalTransform;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.JsonGeometryException;
import com.esri.core.geometry.JsonParserReader;
import com.esri.core.geometry.JsonReader;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.SRSrlzr;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.SpatialReferencePrecisionDescriptor;
import com.esri.core.geometry.SpheroidData;
import com.esri.core.geometry.Unit;
import com.fasterxml.jackson.core.JsonParser;
import java.io.ObjectStreamException;
import java.io.Serializable;

@AndroidSDKPublic
@HadoopSDKExcluded
public abstract class SpatialReference
implements Serializable {
    private static final long serialVersionUID = 2L;

    protected SpatialReference() {
    }

    public static SpatialReference create(int wkid) {
        SpatialReferenceImpl spatRef = SpatialReferenceImpl.createImpl(wkid);
        return spatRef;
    }

    public static SpatialReference create(int wkid, int vert_wkid) {
        SpatialReferenceImpl spatRef = SpatialReferenceImpl.createImpl(wkid, vert_wkid);
        return spatRef;
    }

    @AndroidSDKPublic
    public static SpatialReference create(String wktext) {
        return SpatialReferenceImpl.createImpl(wktext);
    }

    public static SpatialReference createImage(ExternalTransform externalXform) {
        return SpatialReferenceImpl.createImpl(externalXform);
    }

    public static SpatialReference createLocal(Unit unit) {
        return SpatialReferenceImpl.createLocalImpl(unit);
    }

    public static SpatialReference createLocal() {
        return SpatialReference.createLocal(null);
    }

    public static SpatialReference createWithNewPrecision(SpatialReference sourceSr, SpatialReferencePrecisionDescriptor newPrecision) {
        return SpatialReferenceImpl.createWithNewPrecisionDescriptorImpl(sourceSr, newPrecision);
    }

    public boolean isLocal() {
        return this.getCoordinateSystemType() == Type.Local;
    }

    public boolean isGCS() {
        return this.getCoordinateSystemType() == Type.Geographic;
    }

    public boolean isPCS() {
        return this.getCoordinateSystemType() == Type.Projected;
    }

    public boolean isICS() {
        return this.getCoordinateSystemType() == Type.Image;
    }

    @Deprecated
    public static SpatialReference fromJson(JsonParser parser) throws Exception {
        return SpatialReference.fromJson(new JsonParserReader(parser));
    }

    public static SpatialReference fromJson(JsonReader parser) {
        boolean bFoundWkid = false;
        boolean bFoundLatestWkid = false;
        boolean bFoundVcsWkid = false;
        boolean bFoundLatestVcsWkid = false;
        boolean bFoundWkt = false;
        int wkid = -1;
        int latestWkid = -1;
        int vcs_wkid = -1;
        int latestVcsWkid = -1;
        String wkt = null;
        while (parser.nextToken() != JsonReader.Token.END_OBJECT) {
            String name = parser.currentString();
            parser.nextToken();
            if (!bFoundWkid && name.equals("wkid")) {
                bFoundWkid = true;
                if (parser.currentToken() != JsonReader.Token.VALUE_NUMBER_INT) continue;
                wkid = parser.currentIntValue();
                continue;
            }
            if (!bFoundLatestWkid && name.equals("latestWkid")) {
                bFoundLatestWkid = true;
                if (parser.currentToken() != JsonReader.Token.VALUE_NUMBER_INT) continue;
                latestWkid = parser.currentIntValue();
                continue;
            }
            if (!bFoundWkt && name.equals("wkt")) {
                bFoundWkt = true;
                if (parser.currentToken() != JsonReader.Token.VALUE_STRING) continue;
                wkt = parser.currentString();
                continue;
            }
            if (!bFoundVcsWkid && name.equals("vcsWkid")) {
                bFoundVcsWkid = true;
                if (parser.currentToken() != JsonReader.Token.VALUE_NUMBER_INT) continue;
                vcs_wkid = parser.currentIntValue();
                continue;
            }
            if (bFoundLatestVcsWkid || !name.equals("latestVcsWkid")) continue;
            bFoundLatestVcsWkid = true;
            if (parser.currentToken() != JsonReader.Token.VALUE_NUMBER_INT) continue;
            latestVcsWkid = parser.currentIntValue();
        }
        if (latestVcsWkid <= 0 && vcs_wkid > 0) {
            latestVcsWkid = vcs_wkid;
        }
        SpatialReference spatial_reference = null;
        if (wkt != null && wkt.length() != 0) {
            try {
                spatial_reference = SpatialReference.create(wkt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (spatial_reference == null && latestWkid > 0) {
            try {
                spatial_reference = SpatialReference.create(latestWkid, latestVcsWkid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (spatial_reference == null && wkid > 0) {
            try {
                spatial_reference = SpatialReference.create(wkid, vcs_wkid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return spatial_reference;
    }

    public static SpatialReference fromJson(String str) {
        JsonReader reader = JsonParserReader.createFromStringNNT(str);
        JsonReader.Token tok = reader.nextToken();
        if (tok == JsonReader.Token.VALUE_NULL) {
            return null;
        }
        if (tok != JsonReader.Token.START_OBJECT) {
            throw new JsonGeometryException("expected start of object or null");
        }
        return SpatialReference.fromJson(reader);
    }

    @AndroidSDKPublic
    public abstract Type getCoordinateSystemType();

    @AndroidSDKPublic
    public abstract int getID();

    @AndroidSDKPublic
    public abstract int getLatestID();

    @AndroidSDKPublic
    public abstract int getOldID();

    public abstract int getVerticalID();

    public abstract int getLatestVerticalID();

    public abstract int getOldVerticalID();

    @AndroidSDKPublic
    public abstract String getText();

    public abstract String getTextExtended(int var1);

    public abstract String getAuthority();

    @AndroidSDKPublic
    public abstract Unit getUnit();

    @AndroidSDKPublic
    public abstract String[] toMilitaryGrid(int var1, int var2, boolean var3, boolean var4, Point[] var5);

    @AndroidSDKPublic
    public abstract Point[] fromMilitaryGrid(String[] var1, int var2);

    public abstract double getTolerance(int var1);

    public abstract double getResolution(int var1);

    @AndroidSDKPublic
    public double getTolerance() {
        return this.getTolerance(0);
    }

    public abstract SpatialReference getGCS();

    Object writeReplace() throws ObjectStreamException {
        SRSrlzr srSerializer = new SRSrlzr();
        srSerializer.setSpatialReferenceByValue(this);
        return srSerializer;
    }

    public abstract Envelope2D getFullWorldExtent();

    public abstract Envelope2D getFullWorldExtentGCS();

    public abstract boolean isPannable();

    public abstract Envelope2D getPannableExtent();

    public abstract SpheroidData getSpheroidData();

    public abstract void queryPrecisionDescriptor(SpatialReferencePrecisionDescriptor var1);

    public abstract ProjectionTransformation getSRtoGCStransform();

    public abstract ProjectionTransformation getGCStoSRtransform();

    public abstract ExternalTransform getExternalTransform();

    public abstract MapGeometry getAreaOfUse();

    public abstract boolean equalHorizontal(SpatialReference var1);

    public abstract boolean equalVertical(SpatialReference var1);

    public String toString() {
        String snippet = "[ tol: " + this.getTolerance() + "; wkid: " + this.getID() + "; wkt: " + this.getText() + "]";
        if (snippet.length() > 200) {
            return snippet.substring(0, 197) + "... (" + snippet.length() + " characters)";
        }
        return snippet;
    }

    @AndroidSDKPublic
    public static enum Type {
        Local(0),
        Geographic(1),
        Projected(2),
        Image(3);

        private int enumValue;

        public int value() {
            return this.enumValue;
        }

        private Type(int val) {
            this.enumValue = val;
        }

        public static Type intToType(int vv) {
            Type[] v = Type.values();
            for (int i = 0; i < v.length; ++i) {
                if (v[i].value() != vv) continue;
                return v[i];
            }
            throw new IllegalArgumentException();
        }
    }
}

