/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCollection;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.InternalUtils;
import java.util.Arrays;
import java.util.Iterator;

@HadoopSDKPublic
public class SimpleGeometryCursor
extends GeometryCursor {
    private Geometry m_geom = null;
    private Iterator<Geometry> m_iterator = null;
    private int m_index = -1;
    private int m_count;

    @HadoopSDKPublic
    public SimpleGeometryCursor(Geometry geom) {
        this.m_geom = geom;
        this.m_count = 1;
    }

    @HadoopSDKPublic
    public SimpleGeometryCursor(GeometryCollection geom) {
        this.m_geom = geom;
        this.m_count = 1;
    }

    @HadoopSDKPublic
    public SimpleGeometryCursor(Geometry[] geoms) {
        InternalUtils.require(geoms != null);
        this.m_iterator = Arrays.asList(geoms).iterator();
        this.m_count = geoms.length;
    }

    @HadoopSDKPublic
    public SimpleGeometryCursor(Iterable<Geometry> iterable) {
        InternalUtils.require(iterable != null);
        this.m_iterator = iterable.iterator();
        this.m_count = Integer.MAX_VALUE;
    }

    @Override
    @HadoopSDKPublic
    public int getGeometryID() {
        return this.m_index;
    }

    @Override
    @HadoopSDKPublic
    public Geometry next() {
        if (this.m_geom != null) {
            if (this.m_index < this.m_count - 1) {
                ++this.m_index;
                return this.m_geom;
            }
            return null;
        }
        if (this.m_iterator != null) {
            if (!this.m_iterator.hasNext()) {
                return null;
            }
            ++this.m_index;
            return this.m_iterator.next();
        }
        return null;
    }
}

