/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.OperatorClip;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.sde.sdk.pe.engine.PeCSTransformations;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeProjcs;
import com.esri.sde.sdk.pe.engine.PeSpheroid;

@HadoopSDKExcluded
public class ShapePreservingLength {
    SpatialReferenceImpl m_sr;
    SpatialReferenceImpl m_gcs;
    ProgressTracker m_progress_tracker;
    ProjectionTransformation m_transformPcs2Gcs;
    int m_progress_counter = 0;

    ShapePreservingLength(SpatialReference sr, ProgressTracker progress_tracker) {
        this.m_sr = (SpatialReferenceImpl)sr;
        this.m_progress_tracker = progress_tracker;
        if (this.m_sr == null || this.m_sr.getCoordinateSystemType() == SpatialReference.Type.Local) {
            throw new IllegalArgumentException();
        }
        this.m_gcs = (SpatialReferenceImpl)this.m_sr.getGCS();
        if (this.m_gcs != this.m_sr) {
            this.m_transformPcs2Gcs = ProjectionTransformation.createEx(this.m_sr, this.m_gcs, null);
        }
    }

    double execute(Geometry geometry) {
        if (geometry.isEmpty() || geometry.getDimension() < 1) {
            return 0.0;
        }
        int type = geometry.getGeometryType();
        if (type == 197) {
            Polygon polygon = new Polygon();
            polygon.addEnvelope((Envelope)geometry, false);
            return this._ExecuteShapePreservingLength(polygon);
        }
        if (Geometry.isSegment(type)) {
            Polyline polyline = new Polyline();
            polyline.addSegment((Segment)geometry, true);
            return this._ExecuteShapePreservingLength(polyline);
        }
        return this._ExecuteShapePreservingLength((MultiPath)geometry);
    }

    private double _ExecuteShapePreservingLength(MultiPath multipath_) {
        MultiPath multipath = multipath_;
        if (multipath.hasNonLinearSegments()) {
            // empty if block
        }
        if (this.m_sr.isPannable()) {
            double y90 = 90.0;
            double yn90 = -90.0;
            double rpu = this.m_gcs.getUnit().getUnitToBaseFactor();
            if (rpu == 1.0) {
                y90 *= Math.PI / 180;
                yn90 *= Math.PI / 180;
            }
            if (this.m_sr.getCoordinateSystemType() == SpatialReference.Type.Projected) {
                double[][] points = new double[2][2];
                PeProjcs PE_projcs = (PeProjcs)this.m_sr.getPECoordSys();
                points[0][0] = 0.0;
                points[0][1] = y90;
                points[1][0] = 0.0;
                points[1][1] = yn90;
                int c_points_out = PeCSTransformations.geogToProj((PeProjcs)PE_projcs, (int)2, (double[][])points);
                assert (c_points_out == 2);
                y90 = points[0][1];
                yn90 = points[1][1];
            }
            Envelope2D clipWindow = new Envelope2D();
            multipath_.queryEnvelope2D(clipWindow);
            clipWindow.ymin = yn90;
            clipWindow.ymax = y90;
            multipath = (MultiPath)OperatorClip.local().execute(multipath, clipWindow, (SpatialReference)this.m_sr, this.m_progress_tracker);
        } else {
            Geometry pcsHorizon = this.m_sr.getPCSHorizon();
            multipath = (MultiPath)OperatorIntersection.local().execute(multipath, pcsHorizon, (SpatialReference)this.m_sr, this.m_progress_tracker);
            if (multipath == pcsHorizon) {
                multipath = (MultiPath)multipath.copy();
            }
        }
        if (multipath.isEmpty()) {
            return 0.0;
        }
        return this._ExecuteIterativeApproach(multipath, 1);
    }

    private void get_3D_point(double a, double eSquared, double L, double fi, Point3D pt) {
        double sinfi = Math.sin(fi);
        double cosfi = Math.cos(fi);
        double sinL = Math.sin(L);
        double cosL = Math.cos(L);
        double N = a / Math.sqrt(1.0 - eSquared * sinfi * sinfi);
        pt.x = N * cosfi * cosL;
        pt.y = N * cosfi * sinL;
        pt.z = N * (1.0 - eSquared) * sinfi;
    }

    private double distance_3D(double a, Point3D pt1, Point3D pt2) {
        double N = a;
        double chord = Point3D.distance(pt1, pt2);
        double arcLength = 2.0 * N * Math.asin(chord / (2.0 * N));
        assert (arcLength >= 0.0);
        return arcLength;
    }

    double _ExecuteIterativeApproach(MultiPath multipath, int c_extra_splits) {
        PeGeogcs PE_geogcs = (PeGeogcs)this.m_gcs.getPECoordSys();
        PeSpheroid spheroid = PE_geogcs.getDatum().getSpheroid();
        double flattening = spheroid.getFlattening();
        double a = spheroid.getAxis();
        double e_squared = flattening * (2.0 - flattening);
        double rpu = this.m_gcs.getUnit().getUnitToBaseFactor();
        int max_top_stack = 40;
        StackStruct[] stack_struct_array = new StackStruct[40];
        int[] stack_extra_splits = new int[40];
        StackStruct stack_1 = new StackStruct();
        StackStruct stack_2 = new StackStruct();
        double[][] points = new double[2][2];
        PeProjcs PE_projcs = this.m_sr.isPCS() ? (PeProjcs)this.m_sr.getPECoordSys() : null;
        Point2D p_1 = new Point2D();
        Point2D p_2 = new Point2D();
        Point2D pGcs1 = new Point2D();
        Point2D pGcs2 = new Point2D();
        Point2D pGcs = new Point2D();
        Point3D xyz1 = new Point3D();
        Point3D xyz2 = new Point3D();
        Point3D xyz = new Point3D();
        Point2D p = new Point2D();
        double totalLength = 0.0;
        SegmentIterator seg_iter = multipath.querySegmentIterator();
        while (seg_iter.nextPath()) {
            block1: while (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                segment.getStartXY(p_1);
                segment.getEndXY(p_2);
                if (this.m_sr.getCoordinateSystemType() == SpatialReference.Type.Projected) {
                    p_1.queryCoords(points[0]);
                    p_2.queryCoords(points[1]);
                    int c_points_out = PeCSTransformations.projToGeog((PeProjcs)PE_projcs, (int)2, (double[][])points);
                    assert (c_points_out == 2);
                    pGcs1.x = points[0][0] * rpu;
                    pGcs1.y = points[0][1] * rpu;
                    pGcs2.x = points[1][0] * rpu;
                    pGcs2.y = points[1][1] * rpu;
                } else {
                    pGcs1.setCoords(p_1);
                    pGcs2.setCoords(p_2);
                    pGcs1.scale(rpu);
                    pGcs2.scale(rpu);
                }
                this.get_3D_point(a, e_squared, pGcs1.x, pGcs1.y, xyz1);
                this.get_3D_point(a, e_squared, pGcs2.x, pGcs2.y, xyz2);
                double geoLength = this.distance_3D(a, xyz1, xyz2);
                stack_1.setValues(0.0, pGcs1, Double.NaN, xyz1);
                stack_2.setValues(1.0, pGcs2, geoLength, xyz2);
                int extra_splits = c_extra_splits;
                stack_struct_array[0] = stack_2.setTo(stack_struct_array[0]);
                stack_extra_splits[0] = c_extra_splits;
                int stack_top = 0;
                while (stack_top >= 0) {
                    boolean bPrecisionCriteria;
                    this.progress();
                    double factor = (stack_1.m_factor + stack_2.m_factor) * 0.5;
                    segment.getCoord2D(factor, p);
                    if (this.m_sr.getCoordinateSystemType() == SpatialReference.Type.Projected) {
                        p.queryCoords(points[0]);
                        int c_points_out = PeCSTransformations.projToGeog((PeProjcs)PE_projcs, (int)1, (double[][])points);
                        assert (c_points_out == 1);
                        pGcs.x = points[0][0] * rpu;
                        pGcs.y = points[0][1] * rpu;
                    } else {
                        pGcs.setCoords(p);
                        pGcs.scale(rpu);
                    }
                    pGcs1.setCoords(stack_1.m_pGcs);
                    pGcs2.setCoords(stack_2.m_pGcs);
                    this.get_3D_point(a, e_squared, pGcs.x, pGcs.y, xyz);
                    double geoLength1 = this.distance_3D(a, stack_1.m_xyz, xyz);
                    double geoLength2 = this.distance_3D(a, stack_2.m_xyz, xyz);
                    geoLength = stack_2.m_geoLength;
                    if (Double.isNaN(geoLength)) {
                        geoLength = this.distance_3D(a, stack_1.m_xyz, stack_2.m_xyz);
                    }
                    double geoLength1_2 = geoLength1 + geoLength2;
                    boolean bl = bPrecisionCriteria = extra_splits == c_extra_splits && geoLength1_2 >= 20.0 && Math.abs(geoLength1_2 - geoLength) > 1.0E-8 * (geoLength + geoLength1_2);
                    if (stack_top + 2 < 40 && (bPrecisionCriteria || Math.abs(geoLength1_2 - geoLength) > 0.0 && extra_splits > 0)) {
                        stack_2.setLength(geoLength2);
                        stack_struct_array[stack_top] = stack_2.setTo(stack_struct_array[stack_top]);
                        stack_2.setValues(factor, pGcs, geoLength1, xyz);
                        stack_struct_array[++stack_top] = stack_2.setTo(stack_struct_array[stack_top]);
                        assert (stack_top < 40);
                        if (!bPrecisionCriteria) {
                            stack_extra_splits[stack_top - 1] = --extra_splits;
                            stack_extra_splits[stack_top] = extra_splits;
                            continue;
                        }
                        extra_splits = c_extra_splits;
                        stack_extra_splits[stack_top] = c_extra_splits;
                        continue;
                    }
                    totalLength += geoLength1_2;
                    if (stack_top == 0) continue block1;
                    stack_1.assign(stack_2);
                    stack_2.assign(stack_struct_array[--stack_top]);
                    extra_splits = stack_extra_splits[stack_top];
                }
            }
        }
        return totalLength;
    }

    private void progress() {
        ++this.m_progress_counter;
        if ((this.m_progress_counter & 0xFFF) == 0) {
            ProgressTracker.checkAndThrow(this.m_progress_tracker);
            this.m_progress_counter = 0;
        }
    }

    private static class StackStruct {
        Point2D m_pGcs = new Point2D();
        Point3D m_xyz = new Point3D();
        double m_factor;
        double m_geoLength;

        private StackStruct() {
        }

        void setValues(double factor, Point2D pGcs, double geoLength, Point3D xyz) {
            this.m_factor = factor;
            this.m_pGcs.setCoords(pGcs);
            this.m_xyz.setCoords(xyz);
            this.m_geoLength = geoLength;
        }

        void assign(StackStruct src) {
            this.m_factor = src.m_factor;
            this.m_pGcs.setCoords(src.m_pGcs);
            this.m_xyz.setCoords(src.m_xyz);
            this.m_geoLength = src.m_geoLength;
        }

        StackStruct setTo(StackStruct dst_) {
            StackStruct dst = dst_;
            if (dst == null) {
                dst = new StackStruct();
            }
            dst.m_factor = this.m_factor;
            dst.m_pGcs.setCoords(this.m_pGcs);
            dst.m_xyz.setCoords(this.m_xyz);
            dst.m_geoLength = this.m_geoLength;
            return dst;
        }

        void setLength(double geoLength) {
            this.m_geoLength = geoLength;
        }
    }
}

