/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.ExternalTransform;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferencePrecisionDescriptor;
import com.esri.core.geometry.Unit;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

@HadoopSDKExcluded
final class SRSrlzr
implements Serializable {
    private static final long serialVersionUID = 2L;
    Serializable ext_tr;
    String wkt = null;
    int wkid = 0;
    Unit unit = null;
    double m_falseX;
    double m_falseY;
    double m_unitsXY;
    double m_falseZ;
    double m_unitsZ;
    double m_falseM;
    double m_unitsM;
    double m_toleranceXY;
    double m_toleranceZ;
    double m_toleranceM;
    int m_precision;
    int m_type = 0;

    SRSrlzr() {
    }

    Object readResolve() throws ObjectStreamException {
        SpatialReference sr = null;
        try {
            SpatialReference.Type type = SpatialReference.Type.intToType(this.m_type);
            sr = type == SpatialReference.Type.Local ? SpatialReference.createLocal(this.unit) : (type == SpatialReference.Type.Image ? SpatialReference.createImage((ExternalTransform)((Object)this.ext_tr)) : (this.wkid != 0 ? SpatialReference.create(this.wkid) : SpatialReference.create(this.wkt)));
        }
        catch (Exception ex) {
            throw new InvalidObjectException("Cannot read spatial reference from stream");
        }
        SpatialReferencePrecisionDescriptor srd = new SpatialReferencePrecisionDescriptor();
        srd.m_precision = SpatialReferencePrecisionDescriptor.Precision.intToPrecision(this.m_precision);
        srd.setGridParams(this.m_falseX, this.m_falseY, this.m_unitsXY);
        srd.setMParams(this.m_falseM, this.m_unitsM);
        srd.setZParams(this.m_falseZ, this.m_unitsZ);
        srd.setTolerance(0, this.m_toleranceXY);
        srd.setTolerance(1, this.m_toleranceZ);
        srd.setTolerance(2, this.m_toleranceM);
        return SpatialReference.createWithNewPrecision(sr, srd);
    }

    public void setSpatialReferenceByValue(SpatialReference sr) throws ObjectStreamException {
        try {
            SpatialReference.Type type = sr.getCoordinateSystemType();
            this.m_type = type.value();
            this.wkt = null;
            this.wkid = 0;
            this.unit = null;
            if (type == SpatialReference.Type.Local) {
                this.unit = sr.getUnit();
            } else if (type == SpatialReference.Type.Image) {
                this.ext_tr = (Serializable)((Object)sr.getExternalTransform());
            } else {
                this.wkt = null;
                this.wkid = sr.getLatestID();
                if (this.wkid == 0) {
                    this.wkt = sr.getText();
                }
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectException("Cannot serialize this spatial reference");
        }
        SpatialReferencePrecisionDescriptor srd = new SpatialReferencePrecisionDescriptor();
        sr.queryPrecisionDescriptor(srd);
        this.m_falseM = srd.getFalseM();
        this.m_falseZ = srd.getFalseZ();
        this.m_falseX = srd.getFalseX();
        this.m_falseY = srd.getFalseY();
        this.m_unitsM = srd.getGridUnitsM();
        this.m_unitsZ = srd.getGridUnitsZ();
        this.m_unitsXY = srd.getGridUnitsXY();
        this.m_toleranceXY = srd.m_toleranceXY;
        this.m_toleranceM = srd.m_toleranceM;
        this.m_toleranceZ = srd.m_toleranceZ;
        this.m_precision = srd.m_precision.value();
    }
}

