/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.ECoordinate;
import com.esri.core.geometry.EPoint2D;
import com.esri.core.geometry.EPoint3D;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;

@HadoopSDKExcluded
class RoundEarthUtils {
    RoundEarthUtils() {
    }

    static void curv_to_cart(double a, double e2, Point2D pt_curv_rad, Point3D result) {
        double lam = pt_curv_rad.x;
        double phi = pt_curv_rad.y;
        double cos_lam = Math.cos(lam);
        double sin_lam = Math.sin(lam);
        double cos_phi = Math.cos(phi);
        double sin_phi = Math.sin(phi);
        RoundEarthUtils.curv_to_cart(a, e2, cos_lam, sin_lam, cos_phi, sin_phi, result);
    }

    static Point3D curv_to_cart(double a, double e2, Point2D pt_curv_rad) {
        Point3D res = new Point3D();
        RoundEarthUtils.curv_to_cart(a, e2, pt_curv_rad, res);
        return res;
    }

    static Point3D curv_to_cart(double a, double e2, double cos_lam, double sin_lam, double cos_phi, double sin_phi) {
        Point3D res = new Point3D();
        RoundEarthUtils.curv_to_cart(a, e2, cos_lam, sin_lam, cos_phi, sin_phi, res);
        return res;
    }

    static void curv_to_cart(double a, double e2, double cos_lam, double sin_lam, double cos_phi, double sin_phi, Point3D result) {
        double w = Math.sqrt(1.0 - e2 * sin_phi * sin_phi);
        double n = a / w;
        double x = n * cos_phi * cos_lam;
        double y = n * cos_phi * sin_lam;
        double z = n * (1.0 - e2) * sin_phi;
        result.setCoords(x, y, z);
    }

    static EPoint3D ecurv_to_ecart(double a, double e2, EPoint2D ept_curv_rad) {
        ECoordinate ecos_lam = new ECoordinate();
        ECoordinate esin_lam = new ECoordinate();
        ECoordinate ecos_phi = new ECoordinate();
        ECoordinate esin_phi = new ECoordinate();
        ecos_lam.cos(ept_curv_rad.x);
        esin_lam.sin(ept_curv_rad.x);
        ecos_phi.cos(ept_curv_rad.y);
        esin_phi.sin(ept_curv_rad.y);
        ECoordinate w = new ECoordinate(esin_phi);
        w.mul(esin_phi);
        w.mul(e2);
        w.mul(-1.0);
        w.add(1.0);
        w.sqrt();
        ECoordinate n = new ECoordinate(a);
        n.div(w);
        ECoordinate x = new ECoordinate(n);
        x.mul(ecos_phi);
        x.mul(ecos_lam);
        ECoordinate y = new ECoordinate(n);
        y.mul(ecos_phi);
        y.mul(esin_lam);
        ECoordinate z = new ECoordinate(n);
        z.mul(1.0 - e2);
        z.mul(esin_phi);
        return new EPoint3D(x, y, z);
    }

    static void cart_to_curv(double a, double e2, Point3D pt_cart, Point2D result) {
        double x = pt_cart.x;
        double y = pt_cart.y;
        double z = pt_cart.z;
        double lam = Math.atan2(y, x);
        double hyp = Math.sqrt(x * x + y * y);
        double phi = Math.atan2(z, (1.0 - e2) * hyp);
        result.setCoords(lam, phi);
    }

    static Point2D cart_to_curv(double a, double e2, Point3D pt_cart) {
        Point2D result = new Point2D();
        RoundEarthUtils.cart_to_curv(a, e2, pt_cart, result);
        return result;
    }

    static double intersect_great_elliptic_with_meridian(double a, double e2, Point2D pt_1_rad, Point2D pt_2_rad, double meridian) {
        if (Math.abs(pt_1_rad.x - pt_2_rad.x) > Math.PI) {
            return NumberUtils.NaN();
        }
        if (Math.abs(pt_1_rad.y) > 1.5707963267948966 || Math.abs(pt_2_rad.y) > 1.5707963267948966) {
            return NumberUtils.NaN();
        }
        if ((Math.abs(pt_1_rad.y) == 1.5707963267948966 || Math.abs(pt_2_rad.y) == 1.5707963267948966) && pt_1_rad.x != pt_2_rad.x) {
            return NumberUtils.NaN();
        }
        double min_lon = Math.min(pt_1_rad.x, pt_2_rad.x);
        double max_lon = Math.max(pt_1_rad.x, pt_2_rad.x);
        double meridian_normalized = meridian;
        Envelope1D interval = new Envelope1D(pt_1_rad.x, pt_2_rad.x);
        if (!interval.contains(meridian_normalized = RoundEarthUtils.normalize_lam_(meridian_normalized, min_lon, max_lon))) {
            return NumberUtils.NaN();
        }
        EPoint2D ept_1_rad = new EPoint2D(pt_1_rad);
        EPoint2D ept_2_rad = new EPoint2D(pt_2_rad);
        EPoint3D ept_1_cart = RoundEarthUtils.ecurv_to_ecart(1.0, e2, ept_1_rad);
        EPoint3D ept_2_cart = RoundEarthUtils.ecurv_to_ecart(1.0, e2, ept_2_rad);
        EPoint3D normal = ept_1_cart.crossProduct_(ept_2_cart);
        if (normal.z.isZero()) {
            double phi = pt_1_rad.y;
            return phi;
        }
        ECoordinate lam = new ECoordinate(normal.x);
        lam.div(normal.z);
        lam.mul(-1.0);
        ECoordinate mu = new ECoordinate(normal.y);
        mu.div(normal.z);
        mu.mul(-1.0);
        ECoordinate mu2 = new ECoordinate(mu);
        mu2.mul(mu);
        ECoordinate hypot = new ECoordinate(lam);
        hypot.mul(lam);
        hypot.add(mu2);
        hypot.sqrt();
        if (hypot.isZero() || lam.isZero() && mu.isZero()) {
            double phi = pt_1_rad.y;
            return phi;
        }
        double theta_v = Math.atan2(mu.value(), lam.value());
        double phi = Math.atan2(hypot.value() * Math.cos(theta_v - meridian_normalized), 1.0 - e2);
        Point3D v1 = RoundEarthUtils.curv_to_cart(1.0, e2, new Point2D(meridian_normalized, phi));
        Point3D v2 = new Point3D(v1.x, v1.y, -v1.z);
        double d1 = normal.value().dotProduct(v1);
        double d2 = normal.value().dotProduct(v2);
        if (Math.abs(d2) < Math.abs(d1)) {
            phi = -phi;
        }
        return phi;
    }

    static int intersect_great_elliptic_with_parallel(double a, double e2, Point2D pt_1_rad, Point2D pt_2_rad, double parallel, double[] lams) {
        lams[0] = NumberUtils.NaN();
        lams[1] = NumberUtils.NaN();
        if (Math.abs(pt_1_rad.x - pt_2_rad.x) > Math.PI) {
            return 0;
        }
        if (Math.abs(pt_1_rad.y) > 1.5707963267948966 || Math.abs(pt_2_rad.y) > 1.5707963267948966) {
            return 0;
        }
        if ((Math.abs(pt_1_rad.y) == 1.5707963267948966 || Math.abs(pt_2_rad.y) == 1.5707963267948966) && pt_1_rad.x != pt_2_rad.x) {
            return 0;
        }
        if (Math.abs(parallel) >= 1.5707963267948966) {
            return 0;
        }
        if (pt_1_rad.y > 0.0 && pt_2_rad.y > 0.0 && pt_1_rad.y > parallel && pt_2_rad.y > parallel || pt_1_rad.y < 0.0 && pt_2_rad.y < 0.0 && pt_1_rad.y < parallel && pt_2_rad.y < parallel) {
            return 0;
        }
        EPoint2D ept_1_rad = new EPoint2D(pt_1_rad);
        EPoint2D ept_2_rad = new EPoint2D(pt_2_rad);
        EPoint3D ept_1_cart = RoundEarthUtils.ecurv_to_ecart(1.0, e2, ept_1_rad);
        EPoint3D ept_2_cart = RoundEarthUtils.ecurv_to_ecart(1.0, e2, ept_2_rad);
        EPoint3D normal = ept_1_cart.crossProduct_(ept_2_cart);
        if (normal.z.isZero()) {
            Envelope1D interval = new Envelope1D(pt_1_rad.y, pt_2_rad.y);
            if (interval.contains(parallel)) {
                lams[0] = pt_1_rad.x;
                return 1;
            }
            return 0;
        }
        ECoordinate lam = new ECoordinate(normal.x);
        lam.div(normal.z);
        lam.mul(-1.0);
        ECoordinate mu = new ECoordinate(normal.y);
        mu.div(normal.z);
        mu.mul(-1.0);
        ECoordinate mu2 = new ECoordinate(mu);
        mu2.mul(mu);
        ECoordinate hypot = new ECoordinate(lam);
        hypot.mul(lam);
        hypot.add(mu2);
        hypot.sqrt();
        if (hypot.isZero() || lam.isZero() && mu.isZero()) {
            if (parallel == 0.0) {
                lams[0] = pt_1_rad.x;
                lams[1] = pt_2_rad.x;
                return 2;
            }
            return 0;
        }
        double cos_offset = (1.0 - e2) * Math.tan(parallel) / hypot.value();
        if (Math.abs(cos_offset) > 1.0) {
            return 0;
        }
        double offset = Math.acos(cos_offset);
        double theta_v = Math.atan2(mu.value(), lam.value());
        double theta_1 = theta_v - offset;
        double theta_2 = theta_v + offset;
        double min_lon = Math.min(pt_1_rad.x, pt_2_rad.x);
        double max_lon = Math.max(pt_1_rad.x, pt_2_rad.x);
        theta_1 = RoundEarthUtils.normalize_lam_(theta_1, min_lon, max_lon);
        theta_2 = parallel != 0.0 ? RoundEarthUtils.normalize_lam_(theta_2, min_lon, max_lon) : theta_1;
        int res = 0;
        if (min_lon <= theta_1 && theta_1 <= max_lon) {
            lams[res] = theta_1;
            ++res;
        }
        if (theta_2 != theta_1 && min_lon <= theta_2 && theta_2 <= max_lon) {
            lams[res] = theta_2;
            if (++res == 2 && Math.abs(lams[0] - pt_1_rad.x) > Math.abs(lams[1] - pt_1_rad.x)) {
                double temp = lams[0];
                lams[0] = lams[1];
                lams[1] = temp;
            }
        }
        assert (res < 1 || Math.abs(parallel - RoundEarthUtils.intersect_great_elliptic_with_meridian(a, e2, pt_1_rad, pt_2_rad, lams[0])) <= 1.0E-10);
        assert (res < 2 || Math.abs(parallel - RoundEarthUtils.intersect_great_elliptic_with_meridian(a, e2, pt_1_rad, pt_2_rad, lams[1])) <= 1.0E-10);
        return res;
    }

    private static double normalize_lam_(double lam_, double lam1, double lam2) {
        double lam = lam_;
        if (lam > lam2) {
            double f = Math.ceil((lam - lam2) / (Math.PI * 2));
            lam -= f * 2.0 * Math.PI;
        } else if (lam < lam1) {
            double f = Math.ceil((lam1 - lam) / (Math.PI * 2));
            lam += f * 2.0 * Math.PI;
        }
        return lam;
    }

    static void lam_phi_reduction(double[] lam_rad, double[] phi_rad) {
        if (phi_rad[0] > 1.5707963267948966) {
            lam_rad[0] = lam_rad[0] + Math.PI;
            phi_rad[0] = Math.PI - phi_rad[0];
        } else if (phi_rad[0] < -1.5707963267948966) {
            lam_rad[0] = lam_rad[0] - Math.PI;
            phi_rad[0] = -Math.PI - phi_rad[0];
        }
    }
}

