/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.RasterizedGeometry2DImpl;

@HadoopSDKPublic
public abstract class RasterizedGeometry2D {
    @HadoopSDKPublic
    public abstract HitType queryPointInGeometry(double var1, double var3);

    @HadoopSDKPublic
    public abstract HitType queryEnvelopeInGeometry(Envelope2D var1);

    @HadoopSDKPublic
    public static RasterizedGeometry2D create(Geometry geom, double toleranceXY, int rasterSizeBytes) {
        if (!RasterizedGeometry2D.canUseAccelerator(geom)) {
            throw new IllegalArgumentException();
        }
        RasterizedGeometry2DImpl gc = RasterizedGeometry2DImpl.createImpl(geom, toleranceXY, rasterSizeBytes);
        return gc;
    }

    public static RasterizedGeometry2D create(MultiVertexGeometryImpl geom, double toleranceXY, int rasterSizeBytes) {
        if (!RasterizedGeometry2D.canUseAccelerator(geom)) {
            throw new IllegalArgumentException();
        }
        RasterizedGeometry2DImpl gc = RasterizedGeometry2DImpl.createImpl(geom, toleranceXY, rasterSizeBytes);
        return gc;
    }

    @HadoopSDKPublic
    public static int rasterSizeFromAccelerationDegree(Geometry.GeometryAccelerationDegree accelDegree) {
        int value = 0;
        switch (accelDegree) {
            case enumMild: {
                value = 1024;
                break;
            }
            case enumMedium: {
                value = 16384;
                break;
            }
            case enumHot: {
                value = 262144;
                break;
            }
            default: {
                throw GeometryException.GeometryInternalError();
            }
        }
        return value;
    }

    static boolean canUseAccelerator(Geometry geom) {
        return !geom.isEmpty() && (geom.getType() == Geometry.Type.Polyline || geom.getType() == Geometry.Type.Polygon);
    }

    @HadoopSDKPublic
    public abstract double getToleranceXY();

    @HadoopSDKPublic
    public abstract int getRasterSize();

    @HadoopSDKPublic
    public abstract boolean dbgSaveToBitmap(String var1);

    @HadoopSDKPublic
    public static enum HitType {
        Outside(0),
        Inside(1),
        Border(2);

        public int enumVal;

        private HitType(int val) {
            this.enumVal = val;
        }
    }
}

