/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.StridedIndexTypeCollection;

@HadoopSDKExcluded
class QuadEdgeStructure {
    private StridedIndexTypeCollection m_quad_edges = new StridedIndexTypeCollection(6);
    private StridedIndexTypeCollection m_primary_clusters;
    private StridedIndexTypeCollection m_dual_clusters;
    private UserCallback m_user_callback;
    private int m_first_primary_cluster;
    private int m_last_primary_cluster;
    private int m_primary_options;

    QuadEdgeStructure(int primary_options) {
        this.m_primary_clusters = new StridedIndexTypeCollection(QuadEdgeStructure.getPrimaryClusterFieldsSize_(primary_options));
        this.m_primary_options = primary_options;
        this.m_first_primary_cluster = -1;
        this.m_last_primary_cluster = -1;
        assert (this.m_primary_clusters.getStride() == QuadEdgeStructure.getPrimaryClusterFieldsSize_(primary_options));
    }

    void setUserCallback(UserCallback user_callback) {
        this.m_user_callback = user_callback;
    }

    void reserveEdges(int num_canonical_edges) {
        this.m_quad_edges.setCapacity(num_canonical_edges);
    }

    void reservePrimaryClusters(int num_primary_clusters) {
        this.m_primary_clusters.setCapacity(num_primary_clusters);
    }

    int getFirstPrimaryIncidentEdge() {
        if (this.m_first_primary_cluster == -1) {
            return -1;
        }
        return this.getPrimaryIncidentEdge_(this.m_first_primary_cluster);
    }

    int getFirstDualIncidentEdge() {
        throw new UnsupportedOperationException();
    }

    int getPrimaryIncidentEdge(int c) {
        assert (this.isPrimaryCluster(c));
        return this.getPrimaryIncidentEdge_(c);
    }

    int getDualIncidentEdge(int c) {
        throw new UnsupportedOperationException();
    }

    int makePrimaryEdge() {
        int q = this.makeEdgeNoClusters_();
        int e_0 = QuadEdgeStructure.getEdgeFromQuadEdge_(q, 0);
        int e_2 = QuadEdgeStructure.getSym_(e_0);
        int c_0 = this.makePrimaryCluster_(e_0);
        int c_2 = this.makePrimaryCluster_(e_2);
        this.setPrimaryOrg_(q, 0, c_0);
        this.setPrimaryOrg_(q, 1, c_2);
        return e_0;
    }

    int makePrimaryEdgeAndSplice(int a) {
        assert (this.isPrimaryEdge(a));
        int q = this.makeEdgeNoClusters_();
        int b = QuadEdgeStructure.getEdgeFromQuadEdge_(q, 0);
        int b_sym = QuadEdgeStructure.getSym_(b);
        this.splice_(b, a);
        int c = this.makePrimaryCluster_(b_sym);
        this.setPrimaryOrg_(q, 0, this.getPrimaryOrg_(a));
        this.setPrimaryOrg_(q, 1, c);
        return b;
    }

    void splicePrimary(int a, int b) {
        assert (this.isPrimaryEdge(a) && this.isPrimaryEdge(b));
        this.splice_(a, b);
        this.updateSplicedPrimaryOrgs_(a, b);
    }

    int connectPrimary(int a, int b) {
        assert (a != -1 && b != -1);
        assert (this.isPrimaryEdge(a) && this.isPrimaryEdge(b));
        int q = this.makeEdgeNoClusters_();
        int e = QuadEdgeStructure.getEdgeFromQuadEdge_(q, 0);
        int e_sym = QuadEdgeStructure.getSym_(e);
        this.connectPrimaryWithEdge_(a, b, q, e, e_sym);
        return e;
    }

    void movePrimary(int e, int a, int b) {
        assert (e != -1);
        assert (this.isPrimaryEdge(e));
        if (QuadEdgeStructure.getClusterOffsetFromEdge_(e) != 0) {
            int e_sym = QuadEdgeStructure.getSym_(e);
            int b_rprev = this.getRPrev(b);
            int a_rnext = this.getRNext(a);
            this.movePrimary_(e_sym, b_rprev, a_rnext);
            assert (this.getRPrev(e) == a);
            assert (this.getRNext(e) == b);
            return;
        }
        this.movePrimary_(e, a, b);
        assert (this.getRPrev(e) == a);
        assert (this.getRNext(e) == b);
    }

    int splitPrimary(int e) {
        assert (e != -1);
        assert (this.isPrimaryEdge(e));
        int e_sym = QuadEdgeStructure.getSym_(e);
        int e_sym_oprev = this.getOPrev(e_sym);
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e_sym);
        int e_sym_offset = QuadEdgeStructure.getClusterOffsetFromEdge_(e_sym);
        int e_sym_org = this.getPrimaryOrg_(q, e_sym_offset);
        int q2 = this.makeEdgeNoClusters_();
        int e2 = QuadEdgeStructure.getEdgeFromQuadEdge_(q2, 0);
        int e2_sym = QuadEdgeStructure.getSym_(e2);
        assert (QuadEdgeStructure.getClusterOffsetFromEdge_(e2) == 0);
        assert (QuadEdgeStructure.getClusterOffsetFromEdge_(e2_sym) == 1);
        if (e_sym != e_sym_oprev) {
            this.splice_(e_sym, e_sym_oprev);
            this.splice_(e_sym, e2);
            this.splice_(e2_sym, e_sym_oprev);
        } else {
            this.splice_(e_sym, e2);
        }
        int e2_org = this.makePrimaryCluster_(e2);
        this.setPrimaryOrg_(q2, 0, e2_org);
        this.setPrimaryOrg_(q2, 1, e_sym_org);
        this.setPrimaryIncidentEdge_(e_sym_org, e2_sym);
        this.setPrimaryOrg_(q, e_sym_offset, e2_org);
        assert (this.getONext(e_sym) == e2);
        assert (this.getONext(e2) == e_sym);
        assert (this.getPrimaryDest(e) == this.getPrimaryOrg(e2));
        assert (this.getPrimaryIncidentEdge_(e2_org) == e2);
        assert (this.getPrimaryIncidentEdge_(e_sym_org) == e2_sym);
        return e2_org;
    }

    void deletePrimaryEdge(int e) {
        assert (e != -1);
        assert (this.isPrimaryEdge(e));
        int e_sym = QuadEdgeStructure.getSym_(e);
        int e_oprev = this.getOPrev(e);
        int e_sym_oprev = this.getOPrev(e_sym);
        this.removePrimaryClustersFromEdges_(e, e_sym);
        this.splice_(e, e_oprev);
        this.splice_(e_sym, e_sym_oprev);
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        this.m_quad_edges.deleteElement(q);
        assert (this.getFirstPrimaryIncidentEdge() != -1 || this.getFirstPrimaryIncidentEdge() == -1 && this.getCanonicalEdgeCount() == 0);
    }

    boolean isPrimaryEdge(int e) {
        return QuadEdgeStructure.isPrimaryEdge_(e);
    }

    boolean isPrimaryCluster(int c) {
        return QuadEdgeStructure.isPrimaryCluster_(c);
    }

    int getRot(int e) {
        int e_rot = QuadEdgeStructure.getRot_(e);
        return e_rot;
    }

    int getSym(int e) {
        int e_sym = QuadEdgeStructure.getSym_(e);
        return e_sym;
    }

    int getRotInv(int e) {
        int e_rot_inv = QuadEdgeStructure.getRotInv_(e);
        return e_rot_inv;
    }

    int getONext(int e) {
        int e_next = this.getNext_(e);
        return e_next;
    }

    int getOPrev(int e) {
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int quarter_record = QuadEdgeStructure.getQuarterRecordFromEdge_(e);
        int r = QuadEdgeStructure.getQuarterRecordRot_(quarter_record);
        int e_rot_next = this.getNext_(q, r);
        int e_oprev = QuadEdgeStructure.getRot_(e_rot_next);
        return e_oprev;
    }

    int getDNext(int e) {
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int quarter_record = QuadEdgeStructure.getQuarterRecordFromEdge_(e);
        int r = QuadEdgeStructure.getQuarterRecordSym_(quarter_record);
        int e_sym_next = this.getNext_(q, r);
        int e_dnext = QuadEdgeStructure.getSym_(e_sym_next);
        return e_dnext;
    }

    int getDPrev(int e) {
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int quarter_record = QuadEdgeStructure.getQuarterRecordFromEdge_(e);
        int r = QuadEdgeStructure.getQuarterRecordRotInv_(quarter_record);
        int e_rot_inv_next = this.getNext_(q, r);
        int e_dprev = QuadEdgeStructure.getRotInv_(e_rot_inv_next);
        return e_dprev;
    }

    int getRNext(int e) {
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int quarter_record = QuadEdgeStructure.getQuarterRecordFromEdge_(e);
        int r = QuadEdgeStructure.getQuarterRecordRotInv_(quarter_record);
        int e_rot_inv_next = this.getNext_(q, r);
        int e_rnext = QuadEdgeStructure.getRot_(e_rot_inv_next);
        return e_rnext;
    }

    int getRPrev(int e) {
        int e_next = this.getNext_(e);
        int e_rprev = QuadEdgeStructure.getSym_(e_next);
        return e_rprev;
    }

    int getLNext(int e) {
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int quarter_record = QuadEdgeStructure.getQuarterRecordFromEdge_(e);
        int r = QuadEdgeStructure.getQuarterRecordRot_(quarter_record);
        int e_rot_next = this.getNext_(q, r);
        int e_lnext = QuadEdgeStructure.getRotInv_(e_rot_next);
        return e_lnext;
    }

    int getLPrev(int e) {
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int quarter_record = QuadEdgeStructure.getQuarterRecordFromEdge_(e);
        int r = QuadEdgeStructure.getQuarterRecordSym_(quarter_record);
        int e_lprev = this.getNext_(q, r);
        return e_lprev;
    }

    int getOrgVertex(int e) {
        if (this.isPrimaryEdge(e)) {
            return this.getPrimaryOrgVertex(e);
        }
        int c = this.getDualOrg_(e);
        int v = this.getDualVertex_(c);
        return v;
    }

    int getPrimaryOrgVertex(int e) {
        assert (this.isPrimaryEdge(e));
        return this.getPrimaryVertex_(this.getPrimaryOrg_(e));
    }

    int getDestVertex(int e) {
        int e_sym = QuadEdgeStructure.getSym_(e);
        return this.getOrgVertex(e_sym);
    }

    int getPrimaryDestVertex(int e) {
        assert (this.isPrimaryEdge(e));
        return this.getPrimaryVertex_(this.getPrimaryDest_(e));
    }

    int getPrimaryVertex(int c) {
        assert (this.isPrimaryCluster(c));
        return this.getPrimaryVertex_(c);
    }

    void setOrgVertex(int e, int v) {
        if (this.isPrimaryEdge(e)) {
            this.setPrimaryOrgVertex(e, v);
            return;
        }
        int c = this.getDualOrg_(e);
        this.setDualVertex_(c, v);
    }

    void setPrimaryOrgVertex(int e, int v) {
        assert (this.isPrimaryEdge(e));
        this.setPrimaryVertex_(this.getPrimaryOrg_(e), v);
    }

    void setDestVertex(int e, int v) {
        int e_sym = QuadEdgeStructure.getSym_(e);
        this.setOrgVertex(e_sym, v);
    }

    void setPrimaryDestVertex(int e, int v) {
        assert (this.isPrimaryEdge(e));
        this.setPrimaryVertex_(this.getPrimaryDest_(e), v);
    }

    int getOrg(int e) {
        return this.getOrg_(e);
    }

    int getPrimaryOrg(int e) {
        assert (this.isPrimaryEdge(e));
        return this.getPrimaryOrg_(e);
    }

    int getDest(int e) {
        return this.getDest_(e);
    }

    int getPrimaryDest(int e) {
        assert (this.isPrimaryEdge(e));
        return this.getPrimaryDest_(e);
    }

    int getCanonicalEdgeCount() {
        return this.m_quad_edges.size();
    }

    int getPrimaryEdgeCount() {
        return 2 * this.getCanonicalEdgeCount();
    }

    int getDualEdgeCount() {
        return 2 * this.getCanonicalEdgeCount();
    }

    int getPrimaryClusterCount() {
        return this.m_primary_clusters.size();
    }

    int getDualClusterCount() {
        if (this.m_dual_clusters == null) {
            return -1;
        }
        return this.m_dual_clusters.size();
    }

    Polyline getStructureAsPolylineDbg(int start_edge) {
        if (this.m_user_callback == null || (this.m_user_callback.getUserCallbackOptions() & 2) == 0) {
            return new Polyline();
        }
        Polyline p = new Polyline();
        Line l = new Line();
        boolean b_start_new_path = true;
        ConnectedComponentEdgeIterator iter = new ConnectedComponentEdgeIterator(this, start_edge);
        int e = iter.next();
        while (e != -1) {
            Point2D pt_org = this.m_user_callback.onGetXY(this.getOrgVertex(e));
            Point2D pt_dest = this.m_user_callback.onGetXY(this.getDestVertex(e));
            if (!pt_org.isNaN() && !pt_dest.isNaN()) {
                l.setStartXY(pt_org);
                l.setEndXY(pt_dest);
                p.addSegment(l, b_start_new_path);
                b_start_new_path = false;
            }
            e = iter.next();
        }
        return p;
    }

    Polyline getPrimaryStructureAsPolylineDbg() {
        return this.getStructureAsPolylineDbg_(false);
    }

    Polyline getDualStructureAsPolylineDbg() {
        return this.getStructureAsPolylineDbg_(true);
    }

    private static int getPrimaryClusterFieldsSize_(int primary_options) {
        int cluster_fields_size = 3;
        if ((primary_options & 2) != 0) {
            ++cluster_fields_size;
        }
        return cluster_fields_size;
    }

    private int makeEdgeNoClusters_() {
        int q_0 = this.m_quad_edges.newElement();
        if (q_0 << 2 < 0) {
            throw new GeometryException("Too many edges.");
        }
        int e_0 = QuadEdgeStructure.getEdgeFromQuadEdge_(q_0, 0);
        int e_1 = QuadEdgeStructure.getEdgeFromQuadEdge_(q_0, 1);
        int e_2 = QuadEdgeStructure.getEdgeFromQuadEdge_(q_0, 2);
        int e_3 = QuadEdgeStructure.getEdgeFromQuadEdge_(q_0, 3);
        this.setNext_(q_0, 0, e_0);
        this.setNext_(q_0, 1, e_3);
        this.setNext_(q_0, 2, e_2);
        this.setNext_(q_0, 3, e_1);
        return q_0;
    }

    private void movePrimary_(int e, int a, int b) {
        assert (QuadEdgeStructure.getClusterOffsetFromEdge_(e) == 0);
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int e_sym = QuadEdgeStructure.getSym_(e);
        int e_oprev = this.getOPrev(e);
        int e_sym_oprev = this.getOPrev(e_sym);
        this.removePrimaryClustersFromEdges_(e, e_sym);
        this.splice_(e, e_oprev);
        this.splice_(e_sym, e_sym_oprev);
        this.connectPrimaryWithEdge_(a, b, q, e, e_sym);
    }

    private void connectPrimaryWithEdge_(int a, int b, int q, int e, int e_sym) {
        assert (this.isPrimaryEdge(e));
        assert (this.isPrimaryEdge(e_sym));
        assert (QuadEdgeStructure.getClusterOffsetFromEdge_(e) == 0);
        assert (QuadEdgeStructure.getClusterOffsetFromEdge_(e_sym) == 1);
        int a_rnext = this.getRNext(a);
        this.splice_(e, a_rnext);
        this.splice_(e_sym, b);
        this.setPrimaryOrg_(q, 0, this.getPrimaryOrg_(a_rnext));
        this.setPrimaryOrg_(q, 1, this.getPrimaryOrg_(b));
    }

    private void splice_(int a, int b) {
        if (a == b) {
            assert (this.getOrg_(a) == this.getOrg_(b));
            return;
        }
        int a_next = this.getNext_(a);
        int b_next = this.getNext_(b);
        int alpha = QuadEdgeStructure.getRot_(a_next);
        int beta = QuadEdgeStructure.getRot_(b_next);
        int alpha_next = this.getNext_(alpha);
        int beta_next = this.getNext_(beta);
        assert (alpha_next == QuadEdgeStructure.getRotInv_(a));
        assert (beta_next == QuadEdgeStructure.getRotInv_(b));
        this.setNext_(a, b_next);
        this.setNext_(b, a_next);
        this.setNext_(alpha, beta_next);
        this.setNext_(beta, alpha_next);
    }

    private void updateSplicedPrimaryOrgs_(int a, int b) {
        int cx = this.getPrimaryOrg_(a);
        int cy = this.getPrimaryOrg_(b);
        int c = -1;
        int start = -1;
        int end = -1;
        if (cx != cy) {
            start = this.getNext_(b);
            end = a;
            c = cy;
            this.deletePrimaryOrg_(a);
        } else {
            start = this.getNext_(a);
            end = a;
            c = this.makePrimaryCluster_(a);
        }
        this.updateClockwisePrimaryOrbit_(start, end, c);
    }

    private void updateClockwisePrimaryOrbit_(int start, int end, int new_value) {
        int e = start;
        while (e != end) {
            this.setPrimaryOrg_(e, new_value);
            e = this.getNext_(e);
        }
        this.setPrimaryOrg_(end, new_value);
    }

    private void removePrimaryClustersFromEdges_(int e, int e_sym) {
        int c_sym;
        int c = this.getPrimaryOrg_(e);
        if (c != (c_sym = this.getPrimaryOrg_(e_sym))) {
            int e_next = this.getNext_(e);
            assert (e_next != e_sym);
            if (e_next != e) {
                int c_incident = this.getPrimaryIncidentEdge_(c);
                if (c_incident == e) {
                    this.setPrimaryIncidentEdge_(c, e_next);
                }
            } else {
                this.deletePrimaryOrg_(e);
                this.setPrimaryOrg_(e, -1);
            }
            int e_sym_next = this.getNext_(e_sym);
            assert (e_sym_next != e);
            if (e_sym_next != e_sym) {
                int c_sym_incident = this.getPrimaryIncidentEdge_(c_sym);
                if (c_sym_incident == e_sym) {
                    this.setPrimaryIncidentEdge_(c_sym, e_sym_next);
                }
            } else {
                this.deletePrimaryOrg_(e_sym);
                this.setPrimaryOrg_(e_sym, -1);
            }
        } else {
            int next = this.getNext_(e);
            if (next == e_sym) {
                next = this.getNext_(next);
            }
            if (next != e) {
                int c_incident = this.getPrimaryIncidentEdge_(c);
                int c_sym_incident = this.getPrimaryIncidentEdge_(c_sym);
                assert (c_incident == c_sym_incident);
                if (c_incident == e || c_incident == e_sym) {
                    this.setPrimaryIncidentEdge_(c, next);
                }
            } else {
                this.deletePrimaryOrg_(e);
                this.setPrimaryOrg_(e, -1);
            }
        }
    }

    private void addPrimaryClusterToList_(int c) {
        if (this.m_first_primary_cluster == -1) {
            assert (this.m_last_primary_cluster == -1);
            this.m_first_primary_cluster = c;
            this.m_last_primary_cluster = c;
            return;
        }
        this.setNextPrimaryCluster_(this.m_last_primary_cluster, c);
        if ((this.m_primary_options & 2) != 0) {
            this.setPrevPrimaryCluster_(c, this.m_last_primary_cluster);
        }
        this.m_last_primary_cluster = c;
    }

    private void removePrimaryClusterFromList_(int c) {
        int prev_cluster = this.getPrevPrimaryCluster_(c);
        int next_cluster = this.getNextPrimaryCluster_(c);
        assert (this.m_first_primary_cluster != -1 && this.m_last_primary_cluster != -1);
        if (this.m_first_primary_cluster == c) {
            if (next_cluster != -1) {
                this.setPrevPrimaryCluster_(next_cluster, -1);
                this.m_first_primary_cluster = next_cluster;
            } else {
                assert (this.m_first_primary_cluster == this.m_last_primary_cluster);
                this.m_first_primary_cluster = -1;
                this.m_last_primary_cluster = -1;
            }
        } else if (this.m_last_primary_cluster == c) {
            assert (prev_cluster != -1);
            this.setNextPrimaryCluster_(prev_cluster, -1);
            this.m_last_primary_cluster = prev_cluster;
        } else {
            assert (next_cluster != -1 && prev_cluster != -1);
            this.setPrevPrimaryCluster_(next_cluster, prev_cluster);
            this.setNextPrimaryCluster_(prev_cluster, next_cluster);
        }
    }

    private int getNext_(int e) {
        assert (e != -1);
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int quarter_record = QuadEdgeStructure.getQuarterRecordFromEdge_(e);
        return this.getNext_(q, quarter_record);
    }

    private int getNext_(int q, int quarter_record) {
        assert (q != -1);
        assert (quarter_record >= 0 && quarter_record <= 3);
        return this.m_quad_edges.getField(q, quarter_record);
    }

    private void setNext_(int e, int next) {
        assert (e != -1);
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int quarter_record = QuadEdgeStructure.getQuarterRecordFromEdge_(e);
        this.setNext_(q, quarter_record, next);
    }

    private void setNext_(int q, int quarter_record, int next) {
        assert (q != -1);
        assert (quarter_record >= 0 && quarter_record <= 3);
        this.m_quad_edges.setField(q, quarter_record, next);
    }

    private int getOrg_(int e) {
        if (this.isPrimaryEdge(e)) {
            return this.getPrimaryOrg_(e);
        }
        return this.getDualOrg_(e);
    }

    private int getPrimaryOrg_(int e) {
        assert (e != -1);
        assert (this.isPrimaryEdge(e));
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int cluster_offset = QuadEdgeStructure.getClusterOffsetFromEdge_(e);
        return this.getPrimaryOrg_(q, cluster_offset);
    }

    private int getPrimaryOrg_(int q, int cluster_offset) {
        assert (q != -1);
        assert (cluster_offset == 0 || cluster_offset == 1);
        return this.m_quad_edges.getField(q, 4 + cluster_offset);
    }

    private int getDualOrg_(int e) {
        assert (e != -1);
        assert (!this.isPrimaryEdge(e));
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int cluster_offset = QuadEdgeStructure.getClusterOffsetFromEdge_(e);
        return this.getDualOrg_(q, cluster_offset);
    }

    private int getDualOrg_(int q, int cluster_offset) {
        assert (q != -1);
        assert (cluster_offset == 0 || cluster_offset == 1);
        if (this.m_dual_clusters == null) {
            return -1;
        }
        throw new UnsupportedOperationException();
    }

    private void setPrimaryOrg_(int e, int org) {
        assert (e != -1);
        assert (this.isPrimaryEdge(e));
        assert (org == -1 || this.isPrimaryCluster(org));
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int cluster_offset = QuadEdgeStructure.getClusterOffsetFromEdge_(e);
        this.setPrimaryOrg_(q, cluster_offset, org);
    }

    private void setPrimaryOrg_(int q, int cluster_offset, int org) {
        assert (q != -1);
        assert (cluster_offset == 0 || cluster_offset == 1);
        this.m_quad_edges.setField(q, 4 + cluster_offset, org);
    }

    private int getDest_(int e) {
        assert (e != -1);
        int sym = QuadEdgeStructure.getSym_(e);
        return this.getOrg_(sym);
    }

    private int getPrimaryDest_(int e) {
        assert (e != -1);
        assert (this.isPrimaryEdge(e));
        int sym = QuadEdgeStructure.getSym_(e);
        return this.getPrimaryOrg_(sym);
    }

    private static int getRot_(int e) {
        assert (e != -1);
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int quarter_record = QuadEdgeStructure.getQuarterRecordFromEdge_(e);
        return QuadEdgeStructure.getRot_(q, quarter_record);
    }

    private static int getSym_(int e) {
        assert (e != -1);
        return e ^ 2;
    }

    private static int getRotInv_(int e) {
        assert (e != -1);
        int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
        int quarter_record = QuadEdgeStructure.getQuarterRecordFromEdge_(e);
        return QuadEdgeStructure.getRotInv_(q, quarter_record);
    }

    private static int getRot_(int q, int quarter_record) {
        assert (q != -1);
        assert (quarter_record >= 0 && quarter_record <= 3);
        int r = QuadEdgeStructure.getQuarterRecordRot_(quarter_record);
        return QuadEdgeStructure.getEdgeFromQuadEdge_(q, r);
    }

    private static int getRotInv_(int q, int quarter_record) {
        assert (q != -1);
        assert (quarter_record >= 0 && quarter_record <= 3);
        int r = QuadEdgeStructure.getQuarterRecordRotInv_(quarter_record);
        return QuadEdgeStructure.getEdgeFromQuadEdge_(q, r);
    }

    private static boolean isPrimaryEdge_(int e) {
        return (e & 1) == 0;
    }

    private static boolean isPrimaryCluster_(int c) {
        return (c & 1) == 0;
    }

    private static int getQuarterRecordRot_(int quarter_record) {
        return quarter_record + 1 & 3;
    }

    private static int getQuarterRecordSym_(int quarter_record) {
        return quarter_record ^ 2;
    }

    private static int getQuarterRecordRotInv_(int quarter_record) {
        return quarter_record + 3 & 3;
    }

    private static int getQuarterRecordFromEdge_(int e) {
        int quarter_record = e & 3;
        return quarter_record;
    }

    private static int getClusterOffsetFromEdge_(int e) {
        int cluster_offset = (e & 2) >> 1;
        return cluster_offset;
    }

    private static int getQuadEdgeFromEdge_(int e) {
        int q = e >> 2;
        return q;
    }

    private static int getEdgeFromQuadEdge_(int q, int quarter_record) {
        assert (q != -1);
        assert (quarter_record >= 0 && quarter_record <= 3);
        int e = q << 2 | quarter_record;
        return e;
    }

    private static int getClusterFromTaggedCluster_(int tc) {
        int c = tc >> 1;
        return c;
    }

    private static int getTaggedClusterFromCluster_(int c, int tag) {
        assert (c != -1);
        assert (tag >= 0 && tag <= 3);
        int tc = c << 1 | tag;
        return tc;
    }

    private int makePrimaryCluster_(int incident_edge) {
        assert (this.isPrimaryEdge(incident_edge));
        int c = this.m_primary_clusters.newElement();
        if (c << 1 < 0) {
            throw new GeometryException("Too many clusters.");
        }
        int tagged_cluster = QuadEdgeStructure.getTaggedClusterFromCluster_(c, 0);
        this.setPrimaryVertex_(tagged_cluster, -1);
        this.setPrimaryIncidentEdge_(tagged_cluster, incident_edge);
        this.addPrimaryClusterToList_(tagged_cluster);
        return tagged_cluster;
    }

    private void deletePrimaryOrg_(int e) {
        assert (this.isPrimaryEdge(e));
        if ((this.m_primary_options & 2) == 0) {
            throw new RuntimeException("invalid call");
        }
        int c = this.getPrimaryOrg_(e);
        this.removePrimaryClusterFromList_(c);
        if (this.m_user_callback != null && (this.m_user_callback.getUserCallbackOptions() & 1) != 0) {
            this.m_user_callback.onDeleteVertex(this.getPrimaryVertex_(c));
        }
        this.m_primary_clusters.deleteElement(QuadEdgeStructure.getClusterFromTaggedCluster_(c));
    }

    private int getPrimaryVertex_(int c) {
        assert (c != -1);
        assert (this.isPrimaryCluster(c));
        return this.m_primary_clusters.getField(QuadEdgeStructure.getClusterFromTaggedCluster_(c), 0);
    }

    private int getDualVertex_(int c) {
        assert (c != -1);
        if (this.m_dual_clusters == null) {
            return -1;
        }
        return this.m_dual_clusters.getField(QuadEdgeStructure.getClusterFromTaggedCluster_(c), 0);
    }

    private void setPrimaryVertex_(int c, int v) {
        assert (c != -1);
        assert (this.isPrimaryCluster(c));
        this.m_primary_clusters.setField(QuadEdgeStructure.getClusterFromTaggedCluster_(c), 0, v);
    }

    private void setDualVertex_(int c, int v) {
        assert (c != -1);
        if (this.m_dual_clusters == null) {
            throw new RuntimeException("invalid call");
        }
        this.m_dual_clusters.setField(QuadEdgeStructure.getClusterFromTaggedCluster_(c), 0, v);
    }

    private int getPrimaryIncidentEdge_(int c) {
        assert (c != -1);
        assert (this.isPrimaryCluster(c));
        return this.m_primary_clusters.getField(QuadEdgeStructure.getClusterFromTaggedCluster_(c), 1);
    }

    private void setPrimaryIncidentEdge_(int c, int incident_edge) {
        assert (c != -1);
        assert (this.isPrimaryCluster(c));
        this.m_primary_clusters.setField(QuadEdgeStructure.getClusterFromTaggedCluster_(c), 1, incident_edge);
    }

    private int getNextPrimaryCluster_(int c) {
        assert (c != -1);
        return this.m_primary_clusters.getField(QuadEdgeStructure.getClusterFromTaggedCluster_(c), 2);
    }

    private void setNextPrimaryCluster_(int c, int next) {
        assert (c != -1);
        this.m_primary_clusters.setField(QuadEdgeStructure.getClusterFromTaggedCluster_(c), 2, next);
    }

    private int getPrevPrimaryCluster_(int c) {
        assert (c != -1);
        return this.m_primary_clusters.getField(QuadEdgeStructure.getClusterFromTaggedCluster_(c), 3);
    }

    private void setPrevPrimaryCluster_(int c, int prev) {
        assert (c != -1);
        this.m_primary_clusters.setField(QuadEdgeStructure.getClusterFromTaggedCluster_(c), 3, prev);
    }

    private Polyline getStructureAsPolylineDbg_(boolean b_dual) {
        int first_incident_edge;
        int n = first_incident_edge = !b_dual ? this.getFirstPrimaryIncidentEdge() : this.getFirstDualIncidentEdge();
        if (first_incident_edge == -1) {
            return new Polyline();
        }
        if (this.m_user_callback == null || (this.m_user_callback.getUserCallbackOptions() & 2) == 0) {
            return new Polyline();
        }
        Polyline p = new Polyline();
        Line l = new Line();
        ClusterIterator cluster_iterator = new ClusterIterator(this, b_dual);
        ConnectedComponentEdgeIterator edge_iterator = new ConnectedComponentEdgeIterator(this, -1);
        int iteration = 0;
        while (cluster_iterator.next()) {
            int incident_edge;
            int c = cluster_iterator.getCurrentCluster();
            int n2 = incident_edge = !b_dual ? this.getPrimaryIncidentEdge(c) : this.getDualIncidentEdge(c);
            if (iteration == 0) assert (incident_edge == first_incident_edge);
            if (edge_iterator.isOrgVisited(incident_edge)) continue;
            edge_iterator.reset(incident_edge);
            boolean b_start_new_path = true;
            int e = edge_iterator.next();
            while (e != -1) {
                Point2D pt_org = this.m_user_callback.onGetXY(this.getOrgVertex(e));
                Point2D pt_dest = this.m_user_callback.onGetXY(this.getDestVertex(e));
                if (!pt_org.isNaN() && !pt_dest.isNaN()) {
                    l.setStartXY(pt_org);
                    l.setEndXY(pt_dest);
                    p.addSegment(l, b_start_new_path);
                    b_start_new_path = false;
                }
                e = edge_iterator.next();
            }
            ++iteration;
        }
        return p;
    }

    static final class ClusterIterator {
        private QuadEdgeStructure m_qes;
        private int m_current_cluster;
        private int m_next_cluster;
        private boolean m_b_dual;

        ClusterIterator(QuadEdgeStructure qes, boolean b_dual) {
            this.m_qes = qes;
            this.m_b_dual = b_dual;
            if (b_dual) {
                throw new UnsupportedOperationException();
            }
            this.reset();
        }

        boolean next() {
            this.m_current_cluster = this.m_next_cluster;
            if (this.m_b_dual) {
                throw new UnsupportedOperationException();
            }
            if (this.m_current_cluster != -1) {
                this.m_next_cluster = this.m_qes.getNextPrimaryCluster_(this.m_current_cluster);
                return true;
            }
            return false;
        }

        int getCurrentCluster() {
            return this.m_current_cluster;
        }

        void reset() {
            this.m_current_cluster = -1;
            if (this.m_b_dual) {
                throw new UnsupportedOperationException();
            }
            this.m_next_cluster = this.m_qes.m_first_primary_cluster;
        }
    }

    static final class ConnectedComponentEdgeIterator {
        private QuadEdgeStructure m_qes;
        private ClusterUserIndex m_cluster_indices;
        private int m_start_edge;
        private int m_current_edge;
        private boolean m_b_started;
        private boolean m_b_dual;

        ConnectedComponentEdgeIterator(QuadEdgeStructure qes, int start_edge) {
            this.m_qes = qes;
            this.reset(start_edge);
        }

        int next() {
            if (this.m_b_started && this.m_current_edge == -1) {
                return -1;
            }
            int e = -1;
            if (!this.m_b_started) {
                this.m_b_started = true;
                if (this.m_start_edge == -1) {
                    this.m_current_edge = -1;
                    return -1;
                }
                this.initialize_();
                e = this.m_qes.getOPrev(this.m_start_edge);
            } else {
                e = QuadEdgeStructure.getSym_(this.m_current_edge);
            }
            int v = this.m_cluster_indices.getIndex(this.m_qes.getOrg(e));
            if (v != -1) {
                int v_next = this.m_qes.getNext_(v);
                if (v_next == this.m_start_edge) {
                    this.m_current_edge = -1;
                    return -1;
                }
                this.m_current_edge = v_next;
            } else {
                int e_next;
                this.m_current_edge = e_next = this.m_qes.getNext_(e);
            }
            this.m_cluster_indices.setIndex(this.m_qes.getOrg(e), this.m_current_edge);
            return this.m_current_edge;
        }

        boolean isOrgVisited(int e) {
            if (this.m_cluster_indices == null) {
                return false;
            }
            int v = this.m_cluster_indices.getIndex(this.m_qes.getOrg(e));
            return v != -1;
        }

        void reset() {
            this.reset(this.m_start_edge);
        }

        void reset(int start_edge) {
            this.m_b_started = false;
            this.m_current_edge = -1;
            if (start_edge != -1) {
                this.m_start_edge = start_edge;
                this.m_b_dual = !this.m_qes.isPrimaryEdge(start_edge);
            } else {
                this.m_start_edge = -1;
                this.m_b_dual = false;
            }
        }

        private void initialize_() {
            if (this.m_cluster_indices == null) {
                this.m_cluster_indices = new ClusterUserIndex(this.m_qes, this.m_b_dual);
            } else {
                this.m_cluster_indices.reset();
            }
        }
    }

    static final class EdgeUserIndex {
        private StridedIndexTypeCollection m_quad_edges;
        private AttributeStreamOfInt32 m_stream = new AttributeStreamOfInt32(0);
        private boolean m_b_dual;

        EdgeUserIndex(QuadEdgeStructure qes, boolean b_dual) {
            this.m_b_dual = b_dual;
            this.m_quad_edges = qes.m_quad_edges;
            this.m_stream.resize(2 * this.m_quad_edges.capacity(), -1.0);
        }

        void setIndex(int e, int value) {
            assert (this.isValid_(e));
            int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
            int edge_offset = (e & 2) >> 1;
            int quad_edge_index = this.m_quad_edges.elementToIndex(q);
            int edge_index = 2 * quad_edge_index + edge_offset;
            int edges_size = 2 * this.m_quad_edges.size();
            if (this.m_stream.size() <= edge_index) {
                this.m_stream.resize(edges_size, -1.0);
            }
            this.m_stream.write(edge_index, value);
        }

        int getIndex(int e) {
            assert (this.isValid_(e));
            int q = QuadEdgeStructure.getQuadEdgeFromEdge_(e);
            int edge_offset = (e & 2) >> 1;
            int quad_edge_index = this.m_quad_edges.elementToIndex(q);
            int edge_index = 2 * quad_edge_index + edge_offset;
            if (this.m_stream.size() <= edge_index) {
                return -1;
            }
            return this.m_stream.read(edge_index);
        }

        void reset() {
            this.m_stream.setRange(-1.0, 0, this.m_stream.size());
        }

        private boolean isValid_(int e) {
            boolean b_dual = !QuadEdgeStructure.isPrimaryEdge_(e);
            return this.m_b_dual == b_dual;
        }
    }

    static final class ClusterUserIndex {
        private StridedIndexTypeCollection m_clusters;
        private AttributeStreamOfInt32 m_stream;
        private boolean m_b_dual;

        ClusterUserIndex(QuadEdgeStructure qes, boolean b_dual) {
            this.m_b_dual = b_dual;
            this.m_stream = new AttributeStreamOfInt32(0);
            StridedIndexTypeCollection stridedIndexTypeCollection = this.m_clusters = !b_dual ? qes.m_primary_clusters : qes.m_dual_clusters;
            if (b_dual && this.m_clusters == null) {
                throw new RuntimeException("invalid call");
            }
            this.m_stream.resize(this.m_clusters.capacity(), -1.0);
        }

        void setIndex(int c, int value) {
            assert (this.isValid_(c));
            int cluster_index = this.m_clusters.elementToIndex(QuadEdgeStructure.getClusterFromTaggedCluster_(c));
            if (this.m_stream.size() <= cluster_index) {
                this.m_stream.resize(this.m_clusters.size(), -1.0);
            }
            this.m_stream.write(cluster_index, value);
        }

        int getIndex(int c) {
            assert (this.isValid_(c));
            int cluster_index = this.m_clusters.elementToIndex(QuadEdgeStructure.getClusterFromTaggedCluster_(c));
            if (this.m_stream.size() <= cluster_index) {
                return -1;
            }
            return this.m_stream.read(cluster_index);
        }

        void reset() {
            this.m_stream.setRange(-1.0, 0, this.m_stream.size());
        }

        private boolean isValid_(int c) {
            boolean b_dual = !QuadEdgeStructure.isPrimaryCluster_(c);
            return this.m_b_dual == b_dual;
        }
    }

    static abstract class UserCallback {
        private Point2D m_empty_pt = new Point2D();
        private int m_callback_options;

        UserCallback(int callback_options) {
            this.m_empty_pt.setNaN();
            this.m_callback_options = callback_options;
        }

        int getUserCallbackOptions() {
            return this.m_callback_options;
        }

        void onDeleteVertex(int v) {
        }

        Point2D onGetXY(int v) {
            return this.m_empty_pt;
        }

        static interface UserCallbackOptions {
            public static final int Default = 0;
            public static final int OnDeleteVertex = 1;
            public static final int OnGetXY = 2;
        }
    }

    static interface PrimaryOptions {
        public static final int Default = 0;
        public static final int EnableClusterLinkedListDC = 2;
    }
}

