/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKExcluded;
import com.esri.core.geometry.AngleUtils;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Clipper;
import com.esri.core.geometry.CompositeGeographicTransformationImpl;
import com.esri.core.geometry.Cracker;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.ExternalTransform;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorClip;
import com.esri.core.geometry.OperatorContains;
import com.esri.core.geometry.OperatorDensifyByLength;
import com.esri.core.geometry.OperatorDifference;
import com.esri.core.geometry.OperatorDisjoint;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.OperatorUnion;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.PointInPolygonHelper;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.PolygonUtils;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.ProjectionTransformationImpl;
import com.esri.core.geometry.RoundEarthUtils;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.SegmentIterator;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.Transformation2D;
import com.esri.sde.sdk.pe.engine.PeAuthority;
import com.esri.sde.sdk.pe.engine.PeCSTransformations;
import com.esri.sde.sdk.pe.engine.PeCoordsys;
import com.esri.sde.sdk.pe.engine.PeDouble;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeHVCoordsys;
import com.esri.sde.sdk.pe.engine.PeLineType;
import com.esri.sde.sdk.pe.engine.PePCSInfo;
import com.esri.sde.sdk.pe.engine.PeProjcs;
import com.esri.sde.sdk.pe.engine.PeSpheroid;
import com.esri.sde.sdk.pe.engine.PeVertcs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

@AndroidSDKExcluded
@HadoopSDKExcluded
final class ProjectionUtils {
    static final String cg_upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static final double c_GCSLargeDeltaDegrees = 210.0;

    ProjectionUtils() {
    }

    static void upperCaseAsciiInternal(StringBuilder buf) {
        int n = buf.length();
        for (int i = 0; i < n; ++i) {
            char ch = buf.charAt(i);
            if (ch < 'a' || ch > 'z') continue;
            buf.setCharAt(i, cg_upper.charAt(ch - 97));
        }
    }

    static String getWKTForCaching(PeCoordsys coordsys, int wkid, boolean force_canonical) {
        if (force_canonical || wkid > 0) {
            StringBuilder b = new StringBuilder(coordsys.toString(128));
            ProjectionUtils.upperCaseAsciiInternal(b);
            return b.toString();
        }
        return coordsys.toString(1);
    }

    static String getWKTForCaching(PeCoordsys coordsys) {
        String b = coordsys.toString(128);
        b = b.toUpperCase();
        return b;
    }

    static String getAuthority(PeCoordsys coordsys) {
        PeAuthority authority = coordsys.getAuth();
        if (authority == null) {
            return new String("");
        }
        return authority.getName();
    }

    static String getWKTForCaching(PeVertcs coordsys, int wkid, boolean force_canonical) {
        if (force_canonical || wkid > 0) {
            StringBuilder b = new StringBuilder(coordsys.toString(128));
            ProjectionUtils.upperCaseAsciiInternal(b);
            return b.toString();
        }
        return coordsys.toString(1);
    }

    static String getWKT(PeCoordsys coordsys, int verbosity) {
        if (verbosity > 1 || verbosity < -1) {
            throw new IllegalArgumentException();
        }
        if (verbosity == -1) {
            return coordsys.toString();
        }
        int mode = verbosity == 0 ? 1 : 2;
        return coordsys.toString(mode);
    }

    static String getWKT(PeVertcs coordsys, int verbosity) {
        if (verbosity > 1 || verbosity < -1) {
            throw new IllegalArgumentException();
        }
        if (verbosity == -1) {
            return coordsys.toString();
        }
        int mode = verbosity == 0 ? 1 : 2;
        return coordsys.toString(mode);
    }

    static String getWKT(String name, PeCoordsys coordsys, PeVertcs vertcs, int verbosity) {
        if (verbosity > 1 || verbosity < -1 || coordsys == null || vertcs == null) {
            throw new IllegalArgumentException();
        }
        PeCoordsys cs = (PeCoordsys)coordsys.clone();
        PeVertcs vcs = (PeVertcs)vertcs.clone();
        PeHVCoordsys hv = PeHVCoordsys.fromArgs((String)name, (PeCoordsys)cs, (PeVertcs)vcs);
        if (verbosity == -1) {
            return hv.toString();
        }
        int mode = verbosity == 0 ? 1 : 2;
        return hv.toString(mode);
    }

    static String getWKT(PeCoordsys coordsys) {
        return ProjectionUtils.getWKT(coordsys, -1);
    }

    static void PEprojToGeogCenter(SpatialReferenceImpl sr, double centerLongitude, MultiVertexGeometry multiVertex, double[][] batchOfCoords) {
        boolean bAdjustForJump;
        int maxPointBatchSize = batchOfCoords.length;
        int pointCount = multiVertex.getPointCount();
        if (pointCount == 0) {
            return;
        }
        AttributeStreamOfDbl xyStream = (AttributeStreamOfDbl)((MultiVertexGeometryImpl)multiVertex._getImpl()).getAttributeStreamRef(0);
        int pointBatchSize = Math.min(pointCount, maxPointBatchSize);
        int pointIndex = 0;
        PeProjcs peProjcs = (PeProjcs)sr.getPECoordSys();
        if (Double.isNaN(centerLongitude)) {
            centerLongitude = 0.0;
        }
        double gcs360 = (bAdjustForJump = sr.isPannable()) ? ((SpatialReferenceImpl)sr.getGCS()).getPannableExtentByReferenceInternal().getWidth() : 0.0;
        double gcs179 = gcs360 * 179.0 / 360.0;
        double[][] points = batchOfCoords;
        while (pointCount > 0) {
            xyStream.readRange(pointIndex << 1, pointBatchSize << 1, points, 0, true);
            int cPointsOut = PeCSTransformations.projToGeogCenter((PeProjcs)peProjcs, (int)pointBatchSize, (double[][])points, (double)centerLongitude);
            assert (pointBatchSize == cPointsOut);
            if (bAdjustForJump) {
                for (int i = 0; i < pointBatchSize; ++i) {
                    double pcsX;
                    double newX = points[i][0] - centerLongitude;
                    int sign = MathUtils.sign(newX);
                    if (sign * MathUtils.sign(pcsX = xyStream.read(2 * (pointIndex + i))) >= 0 || !(Math.abs(newX) > gcs179)) continue;
                    double[] dArray = points[i];
                    dArray[0] = dArray[0] + (double)(-sign) * gcs360;
                }
            }
            xyStream.writeRange(pointIndex << 1, pointBatchSize << 1, points, 0, true);
            pointIndex += pointBatchSize;
            pointBatchSize = Math.min(pointCount -= pointBatchSize, maxPointBatchSize);
        }
        ((MultiVertexGeometryImpl)multiVertex._getImpl()).notifyModified(2001);
    }

    static void PEprojToGeogCenter(SpatialReferenceImpl sr, double center_longitude, Point point, double[][] batchOfCoords) {
        int sign;
        assert (!point.isEmpty());
        PeProjcs PE_projcs = (PeProjcs)sr.getPECoordSys();
        if (Double.isNaN(center_longitude)) {
            center_longitude = 0.0;
        }
        double old_x = point.getX();
        double[][] coords = batchOfCoords;
        coords[0][0] = old_x;
        coords[0][1] = point.getY();
        int c_points_out = PeCSTransformations.projToGeogCenter((PeProjcs)PE_projcs, (int)1, (double[][])coords, (double)center_longitude);
        assert (c_points_out == 1);
        if (sr.isPannable() && (sign = MathUtils.sign(coords[0][0] - center_longitude)) * MathUtils.sign(old_x) < 0) {
            double gcs360 = ((SpatialReferenceImpl)sr.getGCS()).getPannableExtentByReferenceInternal().getWidth();
            double gcs179 = gcs360 * 179.0 / 360.0;
            if (Math.abs(coords[0][0]) > gcs179) {
                double[] dArray = coords[0];
                dArray[0] = dArray[0] - (double)sign * gcs360;
            }
        }
        point.setXY(coords[0][0], coords[0][1]);
    }

    static void PEprojToGeogCenter(SpatialReferenceImpl sr, double center_longitude, Point2D[] points, int count, double[][] batchOfCoords) {
        assert (sr.getCoordinateSystemType() == SpatialReference.Type.Projected);
        PeProjcs PE_projcs = (PeProjcs)sr.getPECoordSys();
        if (Double.isNaN(center_longitude)) {
            center_longitude = 0.0;
        }
        boolean b_adjust_for_jumps = sr.isPannable();
        double gcs1 = sr.getOneDegreeGCSUnit();
        double gcs360 = gcs1 * 360.0;
        double gcs179 = gcs1 * 179.0;
        int maxPointBatchSize = batchOfCoords.length;
        int index = 0;
        while (index < count) {
            for (int s = index; s < count && points[s].isNaN(); ++s) {
                ++index;
            }
            int sz = Math.min(maxPointBatchSize, count - index);
            if (sz <= 0) continue;
            assert (!points[index].isNaN());
            int s = 1;
            int j = index + 1;
            while (s < sz) {
                if (points[j].isNaN()) {
                    sz = s;
                    break;
                }
                ++s;
                ++j;
            }
            InternalUtils.copyPoint2DArray(batchOfCoords, 0, points, index, sz);
            PeCSTransformations.projToGeogCenter((PeProjcs)PE_projcs, (int)sz, (double[][])batchOfCoords, (double)center_longitude);
            if (b_adjust_for_jumps) {
                s = 0;
                j = index;
                while (s < sz) {
                    double oldX = points[j].x;
                    double x = batchOfCoords[s][0] - center_longitude;
                    int sign = MathUtils.sign(x);
                    if (sign * MathUtils.sign(oldX) < 0 && Math.abs(x) > gcs179) {
                        double[] dArray = batchOfCoords[s];
                        dArray[0] = dArray[0] - (double)sign * gcs360;
                        assert (MathUtils.sign(batchOfCoords[s][0] - center_longitude) * MathUtils.sign(oldX) >= 0);
                    }
                    ++s;
                    ++j;
                }
            }
            InternalUtils.copyPoint2DArray(points, index, batchOfCoords, 0, sz);
            index += sz;
        }
    }

    static void PEgeogToProj(SpatialReferenceImpl sr, MultiVertexGeometry multiVertex, double[][] batchOfCoords) {
        assert (batchOfCoords[0].length == 2);
        int maxPointBatchSize = batchOfCoords.length;
        int pointCount = multiVertex.getPointCount();
        if (pointCount < 1) {
            return;
        }
        AttributeStreamOfDbl xyStream = (AttributeStreamOfDbl)((MultiVertexGeometryImpl)multiVertex._getImpl()).getAttributeStreamRef(0);
        int pointBatchSize = Math.min(pointCount, maxPointBatchSize);
        int pointIndex = 0;
        PeProjcs peProjcs = (PeProjcs)sr.getPECoordSys();
        boolean bAdjustForJumps = sr.isPannable();
        double pcs360 = bAdjustForJumps ? sr.getPannableExtentByReferenceInternal().getWidth() : 0.0;
        double pcs179 = pcs360 * 179.0 / 360.0;
        double centralLong2InGCS2Units = 0.0;
        if (bAdjustForJumps) {
            centralLong2InGCS2Units = sr.getAdjustedCentralMeridian();
        }
        double[][] points = batchOfCoords;
        while (pointCount > 0) {
            xyStream.readRange(pointIndex << 1, pointBatchSize << 1, points, 0, true);
            int cPointsOut = PeCSTransformations.geogToProj((PeProjcs)peProjcs, (int)pointBatchSize, (double[][])points);
            assert (pointBatchSize == cPointsOut);
            if (bAdjustForJumps) {
                for (int i = 0; i < pointBatchSize; ++i) {
                    double old_x;
                    double new_x = points[i][0];
                    int sign = MathUtils.sign(new_x);
                    if (sign * MathUtils.sign(old_x = xyStream.read(2 * (pointIndex + i)) - centralLong2InGCS2Units) >= 0 || !(Math.abs(new_x) > pcs179)) continue;
                    double[] dArray = points[i];
                    dArray[0] = dArray[0] + (double)(-sign) * pcs360;
                }
            }
            xyStream.writeRange(pointIndex << 1, pointBatchSize << 1, points, 0, true);
            pointIndex += pointBatchSize;
            pointBatchSize = Math.min(pointCount -= pointBatchSize, maxPointBatchSize);
        }
        ((MultiVertexGeometryImpl)multiVertex._getImpl()).notifyModified(2001);
    }

    static void PEgeogToProj(SpatialReferenceImpl sr, Point point, double[][] batchOfCoords) {
        if (point.isEmpty()) {
            return;
        }
        PeProjcs PE_projcs = (PeProjcs)sr.getPECoordSys();
        double[][] coords = batchOfCoords;
        coords[0][0] = point.getX();
        coords[0][1] = point.getY();
        int c_points_out = PeCSTransformations.geogToProj((PeProjcs)PE_projcs, (int)1, (double[][])coords);
        assert (c_points_out <= 1);
        if (sr.isPannable()) {
            int sign = MathUtils.sign(coords[0][0]);
            double centralLong2InGCS2Units = sr.getAdjustedCentralMeridian();
            if (sign * MathUtils.sign(point.getX() - centralLong2InGCS2Units) < 0) {
                double pcs360 = sr.getPannableExtentByReferenceInternal().getWidth();
                double pcs179 = pcs360 * 179.0 / 360.0;
                if (Math.abs(coords[0][0]) > pcs179) {
                    double[] dArray = coords[0];
                    dArray[0] = dArray[0] - (double)sign * pcs360;
                }
            }
        }
        point.setXY(coords[0][0], coords[0][1]);
    }

    static void PEgeogToProj(SpatialReferenceImpl sr, Point2D[] points, int count, double[][] batchOfCoords) {
        if (count == 0) {
            return;
        }
        PeProjcs PE_projcs = (PeProjcs)sr.getPECoordSys();
        boolean b_adjust_for_jumps = sr.isPannable();
        double pcs360 = b_adjust_for_jumps ? sr.getPannableExtentByReferenceInternal().getWidth() : 0.0;
        double pcs179 = pcs360 * 179.0 / 360.0;
        double centralLong2InGCS2Units = 0.0;
        if (b_adjust_for_jumps) {
            centralLong2InGCS2Units = sr.getAdjustedCentralMeridian();
        }
        int index = 0;
        while (index < count) {
            for (int s = index; s < count && points[s].isNaN(); ++s) {
                ++index;
            }
            int sz = Math.min(batchOfCoords.length, count - index);
            if (sz <= 0) continue;
            assert (!points[index].isNaN());
            int s = 1;
            int j = index + 1;
            while (s < sz) {
                if (points[j].isNaN()) {
                    sz = s;
                    break;
                }
                ++s;
                ++j;
            }
            InternalUtils.copyPoint2DArray(batchOfCoords, 0, points, index, sz);
            PeCSTransformations.geogToProj((PeProjcs)PE_projcs, (int)sz, (double[][])batchOfCoords);
            if (b_adjust_for_jumps) {
                int k = index;
                for (int i = 0; i < sz; ++i) {
                    double old_x;
                    double new_x = batchOfCoords[i][0];
                    int sign = MathUtils.sign(new_x);
                    if (sign * MathUtils.sign(old_x = points[k].x - centralLong2InGCS2Units) >= 0 || !(Math.abs(new_x) > pcs179)) continue;
                    double[] dArray = batchOfCoords[i];
                    dArray[0] = dArray[0] - (double)sign * pcs360;
                }
            }
            InternalUtils.copyPoint2DArray(points, index, batchOfCoords, 0, sz);
            index += sz;
        }
    }

    static boolean PEgeogToGeog(ProjectionTransformationImpl projTransform, MultiVertexGeometry multiVertex, boolean hack_poles, double[][] batchOfCoords) {
        int pointCount = multiVertex.getPointCount();
        if (pointCount == 0) {
            return false;
        }
        AttributeStreamOfDbl xyStream = (AttributeStreamOfDbl)((MultiVertexGeometryImpl)multiVertex._getImpl()).getAttributeStreamRef(0);
        SpatialReferenceImpl srIn = (SpatialReferenceImpl)projTransform.getInputSR();
        SpatialReferenceImpl srOut = (SpatialReferenceImpl)projTransform.getOutputSR();
        double inGCSCoordFactor = ((SpatialReferenceImpl)srIn.getGCS()).getHorzUnitFactor();
        double outGCSCoordFactor = ((SpatialReferenceImpl)srOut.getGCS()).getHorzUnitFactor();
        double inGCS1 = srIn.getOneDegreeGCSUnit();
        double outGCS1 = srOut.getOneDegreeGCSUnit();
        CompositeGeographicTransformationImpl compositeTran = (CompositeGeographicTransformationImpl)projTransform.getGeographicTransformations();
        if (compositeTran == null || compositeTran.count() == 0) {
            double factor = inGCSCoordFactor / outGCSCoordFactor;
            double primeMeridianDelta = (srIn.getPrimeMeridian() - srOut.getPrimeMeridian()) * outGCS1;
            double ymin = inGCS1 * -90.0;
            double ymax = inGCS1 * 90.0;
            boolean modified = false;
            int n = pointCount * 2;
            for (int index = 1; index < n; index += 2) {
                double y = xyStream.get(index);
                double v = NumberUtils.snap(y, ymin, ymax);
                if (v == y) continue;
                xyStream.set(index, v);
                modified = true;
            }
            if (primeMeridianDelta != 0.0 || factor != 1.0) {
                modified = true;
                assert (factor == 1.0 || Math.abs(factor - 1.0) > 2.0 * NumberUtils.doubleEps());
                Point2D pt = new Point2D();
                for (int i = 0; i < pointCount; ++i) {
                    xyStream.read(2 * i, pt);
                    pt.x *= factor;
                    pt.x += primeMeridianDelta;
                    pt.y *= factor;
                    xyStream.write(2 * i, pt);
                }
            }
            if (modified) {
                ((MultiVertexGeometryImpl)multiVertex._getImpl()).notifyModified(2001);
            }
            return modified;
        }
        int maxPointBatchSize = batchOfCoords.length;
        int pointBatchSize = Math.min(pointCount, maxPointBatchSize);
        double[] batchInputX = new double[pointBatchSize];
        double[] deltaLatArray = null;
        double[][] coords = batchOfCoords;
        int point_index = 0;
        double inGCS89 = NumberUtils.NaN();
        double outGCS90 = NumberUtils.NaN();
        double outGCS360 = outGCS1 * 360.0;
        double angularConversionFactor = outGCS1 / inGCS1;
        if (hack_poles) {
            outGCS90 = outGCS1 * 90.0;
            inGCS89 = inGCS1 * 89.9;
            deltaLatArray = new double[pointBatchSize];
        }
        boolean bFirst = true;
        double deltaShift = 0.0;
        while (pointCount != 0) {
            int i;
            int i2;
            boolean batchAdjustAtPoles = false;
            xyStream.readRange(point_index << 1, pointBatchSize << 1, coords, 0, true);
            for (i2 = 0; i2 < pointBatchSize; ++i2) {
                batchInputX[i2] = coords[i2][0];
            }
            if (hack_poles) {
                for (i2 = 0; i2 < pointBatchSize; ++i2) {
                    double delta = Math.abs(coords[i2][1]) - inGCS89;
                    if (!(delta > 0.0)) continue;
                    double y = coords[i2][1];
                    coords[i2][1] = MathUtils.copySign(inGCS89, y);
                    deltaLatArray[i2] = MathUtils.copySign(delta, y);
                    batchAdjustAtPoles = true;
                }
            }
            double x0 = coords[0][0];
            int c_points_out = compositeTran.transform(coords, pointBatchSize, inGCSCoordFactor, outGCSCoordFactor);
            assert (c_points_out <= pointBatchSize);
            if (bFirst) {
                deltaShift = coords[0][0] - angularConversionFactor * x0;
                bFirst = false;
            }
            for (i = 0; i < pointBatchSize; ++i) {
                double delta = coords[i][0] - batchInputX[i] * angularConversionFactor - deltaShift;
                if (!(Math.abs(delta) > 200.0)) continue;
                if (delta > 0.0) {
                    double[] dArray = coords[i];
                    dArray[0] = dArray[0] - outGCS360;
                    continue;
                }
                double[] dArray = coords[i];
                dArray[0] = dArray[0] + outGCS360;
            }
            if (batchAdjustAtPoles) {
                for (i = 0; i < pointBatchSize; ++i) {
                    if (deltaLatArray[i] == 0.0) continue;
                    double[] dArray = coords[i];
                    dArray[1] = dArray[1] + angularConversionFactor * deltaLatArray[i];
                    if (coords[i][1] > outGCS90) {
                        coords[i][1] = outGCS90;
                        continue;
                    }
                    if (!(coords[i][1] < -outGCS90)) continue;
                    coords[i][1] = -outGCS90;
                }
                Arrays.fill(deltaLatArray, 0, pointBatchSize, 0.0);
            }
            xyStream.writeRange(point_index << 1, pointBatchSize << 1, coords, 0, true);
            point_index += pointBatchSize;
            pointBatchSize = Math.min(pointCount -= pointBatchSize, maxPointBatchSize);
        }
        ((MultiVertexGeometryImpl)multiVertex._getImpl()).notifyModified(2001);
        return true;
    }

    static boolean PEgeogToGeog(ProjectionTransformationImpl proj_transform, Point point, boolean adjust_at_poles, double[][] batchOfCoords) {
        if (point.isEmpty()) {
            return false;
        }
        SpatialReferenceImpl srIn = (SpatialReferenceImpl)proj_transform.getInputSR();
        SpatialReferenceImpl srOut = (SpatialReferenceImpl)proj_transform.getOutputSR();
        CompositeGeographicTransformationImpl compositeTran = (CompositeGeographicTransformationImpl)proj_transform.getGeographicTransformations();
        double inGCSCoordFactor = ((SpatialReferenceImpl)srIn.getGCS()).getHorzUnitFactor();
        double outGCSCoordFactor = ((SpatialReferenceImpl)srOut.getGCS()).getHorzUnitFactor();
        double[][] coords = batchOfCoords;
        coords[0][0] = point.getX();
        coords[0][1] = point.getY();
        boolean modified = false;
        if (compositeTran != null && compositeTran.count() > 0) {
            modified = true;
            boolean batchAdjustAtPoles = false;
            double inGCS89 = NumberUtils.NaN();
            double outGCS90 = NumberUtils.NaN();
            double deltaLat = 0.0;
            double angularConversionFactor = 1.0;
            if (adjust_at_poles) {
                double inGCS1 = srIn.getOneDegreeGCSUnit();
                double outGCS1 = srOut.getOneDegreeGCSUnit();
                angularConversionFactor = outGCS1 / inGCS1;
                outGCS90 = outGCS1 * 90.0;
                inGCS89 = inGCS1 * 89.9;
                double delta = Math.abs(coords[0][1]) - inGCS89;
                if (delta > 0.0) {
                    double y = coords[0][1];
                    coords[0][1] = MathUtils.copySign(inGCS89, y);
                    deltaLat = MathUtils.copySign(delta, y);
                    batchAdjustAtPoles = true;
                }
            }
            compositeTran.transform(coords, 1, inGCSCoordFactor, outGCSCoordFactor);
            if (batchAdjustAtPoles && deltaLat != 0.0) {
                double[] dArray = coords[0];
                dArray[1] = dArray[1] + angularConversionFactor * deltaLat;
                if (coords[0][1] > outGCS90) {
                    coords[0][1] = outGCS90;
                } else if (coords[0][1] < -outGCS90) {
                    coords[0][1] = -outGCS90;
                }
            }
            point.setXY(coords[0][0], coords[0][1]);
        } else {
            double inGCS1 = srIn.getOneDegreeGCSUnit();
            double v = NumberUtils.snap(coords[0][1], -90.0 * inGCS1, 90.0 * inGCS1);
            modified = v != coords[0][1];
            double outGCS1 = srOut.getOneDegreeGCSUnit();
            double primeMeridianDelta = (srIn.getPrimeMeridian() - srOut.getPrimeMeridian()) * outGCS1;
            double factor = inGCSCoordFactor / outGCSCoordFactor;
            if (factor != 1.0 || primeMeridianDelta != 0.0) {
                modified = true;
                double[] dArray = coords[0];
                dArray[0] = dArray[0] * factor;
                double[] dArray2 = coords[0];
                dArray2[0] = dArray2[0] + primeMeridianDelta;
                double[] dArray3 = coords[0];
                dArray3[1] = dArray3[1] * factor;
            }
            if (modified) {
                point.setXY(coords[0][0], coords[0][1]);
            }
        }
        return modified;
    }

    static boolean PEgeogToGeog(ProjectionTransformationImpl proj_transform, Point2D[] points, int count, boolean hack_poles, double[][] batchOfCoords) {
        if (proj_transform.isIdentityGeogToGeog()) {
            double inGCS_90 = ((SpatialReferenceImpl)proj_transform.getInputSR()).getOneDegreeGCSUnit() * 90.0;
            boolean modified = InternalUtils.snapY(points, count, -inGCS_90, inGCS_90);
            return modified;
        }
        CompositeGeographicTransformationImpl compositeTran = (CompositeGeographicTransformationImpl)proj_transform.getGeographicTransformations();
        SpatialReferenceImpl srIn = (SpatialReferenceImpl)proj_transform.getInputSR();
        SpatialReferenceImpl srOut = (SpatialReferenceImpl)proj_transform.getOutputSR();
        double inGCSCoordFactor = srIn.getGCSUnitFactor();
        double outGCSCoordFactor = srOut.getGCSUnitFactor();
        double inGCS1 = srIn.getOneDegreeGCSUnit();
        double inGCS90 = inGCS1 * 90.0;
        double outGCS1 = srOut.getOneDegreeGCSUnit();
        if (compositeTran == null || compositeTran.count() == 0) {
            double factor = inGCSCoordFactor / outGCSCoordFactor;
            double primeMeridianDelta = (srIn.getPrimeMeridian() - srOut.getPrimeMeridian()) * outGCS1;
            boolean modified = InternalUtils.snapY(points, count, -inGCS90, inGCS90);
            if (primeMeridianDelta != 0.0 || factor != 1.0) {
                modified = true;
                assert (factor == 1.0 || Math.abs(factor - 1.0) > 2.0 * NumberUtils.doubleEps());
                for (int i = 0; i < count; ++i) {
                    points[i].x *= factor;
                    points[i].x += primeMeridianDelta;
                    points[i].y *= factor;
                }
            }
            return modified;
        }
        int pointBatchSize = Math.min(count, batchOfCoords.length);
        double[] batchInputX = new double[pointBatchSize];
        double[] deltaLatArray = hack_poles ? new double[pointBatchSize] : null;
        double inGCS89 = NumberUtils.NaN();
        double outGCS90 = NumberUtils.NaN();
        double outGCS360 = outGCS1 * 360.0;
        double angularConversionFactor = outGCS1 / inGCS1;
        if (hack_poles) {
            outGCS90 = outGCS1 * 90.0;
            inGCS89 = inGCS1 * 89.9;
        }
        boolean bFirst = true;
        double deltaShift = 0.0;
        int point_count = count;
        int point_index = 0;
        while (point_count != 0) {
            int i;
            int i2;
            boolean batchAdjustAtPoles = false;
            for (i2 = 0; i2 < pointBatchSize; ++i2) {
                batchInputX[i2] = points[i2 + point_index].x;
            }
            if (hack_poles) {
                for (i2 = 0; i2 < pointBatchSize; ++i2) {
                    double delta = Math.abs(points[i2 + point_index].y) - inGCS89;
                    if (!(delta > 0.0)) continue;
                    double y = points[i2 + point_index].y;
                    points[i2 + point_index].y = MathUtils.copySign(inGCS89, y);
                    deltaLatArray[i2] = MathUtils.copySign(delta, y);
                    batchAdjustAtPoles = true;
                }
            }
            double x0 = points[0].x;
            InternalUtils.copyPoint2DArray(batchOfCoords, 0, points, point_index, pointBatchSize);
            compositeTran.transform(batchOfCoords, pointBatchSize, inGCSCoordFactor, outGCSCoordFactor);
            InternalUtils.copyPoint2DArray(points, point_index, batchOfCoords, 0, pointBatchSize);
            if (bFirst) {
                deltaShift = points[0].x - angularConversionFactor * x0;
                bFirst = false;
            }
            for (i = 0; i < pointBatchSize; ++i) {
                double delta = points[point_index + i].x - batchInputX[i] * angularConversionFactor - deltaShift;
                if (!(Math.abs(delta) > 200.0)) continue;
                if (delta > 0.0) {
                    points[point_index + i].x -= outGCS360;
                    continue;
                }
                points[point_index + i].x += outGCS360;
            }
            if (batchAdjustAtPoles) {
                for (i = 0; i < pointBatchSize; ++i) {
                    if (deltaLatArray[i] == 0.0) continue;
                    points[point_index + i].y += angularConversionFactor * deltaLatArray[i];
                    if (points[point_index + i].y > outGCS90) {
                        points[point_index + i].y = outGCS90;
                    } else if (points[point_index + i].y < -outGCS90) {
                        points[point_index + i].y = -outGCS90;
                    }
                    deltaLatArray[i] = 0.0;
                }
            }
            point_index += pointBatchSize;
            pointBatchSize = Math.min(point_count -= pointBatchSize, batchOfCoords.length);
        }
        return true;
    }

    static MultiPath geoNormalizePannable(MultiPath _gcsGeom, SpatialReferenceImpl gcs, double _centralLongitude, double densify_dist, boolean b_fold_by_great_elliptic) {
        return (MultiPath)ProjectionUtils.foldInto360DegreeRange(_gcsGeom, gcs, NumberUtils.isNaN(_centralLongitude) ? 0.0 : _centralLongitude, true, densify_dist, null);
    }

    static Envelope2D getAdjustedPannableExtent(SpatialReference sr, double centralLongitude) {
        Envelope2D env = sr.getPannableExtent();
        if (!NumberUtils.isNaN(centralLongitude)) {
            env.centerAt(centralLongitude, 0.0);
        }
        return env;
    }

    static Polygon geoNormalizePolygonGeometry(Polygon originalPolygon, SpatialReferenceImpl originalSR, Polyline poly, SpatialReferenceImpl pannableSR, double centralLongitude, ProgressTracker progress_tracker, int pole_flags, double pole_snapping_tolerance) {
        Envelope2D pannableExtent = ProjectionUtils.getAdjustedPannableExtent(pannableSR, centralLongitude);
        double width360 = pannableExtent.getWidth();
        double degree = width360 / 360.0;
        double GCSLargeDelta = 210.0 * degree;
        AttributeStreamOfDbl originalXYStream = (AttributeStreamOfDbl)((MultiPathImpl)originalPolygon._getImpl()).getAttributeStreamRef(0);
        boolean compareWithOriginal = originalSR.isPannable();
        double originalToGCS = compareWithOriginal ? width360 / originalSR.getPannableExtentByReferenceInternal().getWidth() : 0.0;
        boolean adjustedAtPoles = false;
        Polygon geonormalizedResult = new Polygon(poly.getDescription());
        int npaths = poly.getPathCount();
        for (int ipath = 0; ipath < npaths; ++ipath) {
            Polygon result;
            Point2D end;
            Point2D start;
            boolean ringIsClosed;
            boolean compareRingWithOriginal = compareWithOriginal;
            Polyline singlePartPath = new Polyline(poly.getDescription());
            singlePartPath.addPath(poly, ipath, true);
            if (pole_flags != 0 && (adjustedAtPoles |= ProjectionUtils.adjustPathAtPoles(true, singlePartPath, pannableExtent.ymax - pole_snapping_tolerance, pannableExtent.ymax, pole_flags))) {
                compareRingWithOriginal = false;
            }
            int originalPathStart = -1;
            if (compareRingWithOriginal) {
                originalPathStart = originalPolygon.getPathStart(ipath);
            }
            AttributeStreamOfDbl xyStream = (AttributeStreamOfDbl)singlePartPath.m_impl.getAttributeStreamRef(0);
            int pointCount = singlePartPath.getPointCount();
            double xShift = 0.0;
            double xPrev = xyStream.read(0);
            int largeDeltas = 0;
            double tol3 = 3.0 * pannableSR.getTolerance(0);
            boolean ringSimplifyIsNeeded = false;
            Point2D pt1 = new Point2D();
            pt1.setNaN();
            Point2D pt2 = new Point2D();
            pt2.setNaN();
            boolean writeValues = false;
            for (int i = 1; i < pointCount; ++i) {
                Point2D pt = new Point2D(xyStream.readAsDbl(2 * i), xyStream.readAsDbl(2 * i + 1));
                double xRead = pt.x;
                double x = xRead + xShift;
                double step = x - xPrev;
                pt.x = x;
                if (Math.abs(step) > GCSLargeDelta) {
                    if (compareRingWithOriginal) {
                        int i1 = originalPathStart + i - 1;
                        int i2 = originalPathStart + (i + 1 < pointCount ? i : 0);
                        double orgXPrev = originalXYStream.read(i1 * 2);
                        double orgX = originalXYStream.read(i2 * 2);
                        double orgStep = (orgX - orgXPrev) * originalToGCS;
                        if (Math.abs(step - orgStep) > 1.0 * degree) {
                            compareRingWithOriginal = false;
                        }
                    }
                    if (!compareRingWithOriginal) {
                        double correction = MathUtils.copySign(width360, x - xPrev);
                        x = xRead + (xShift -= correction);
                        ++largeDeltas;
                        writeValues = xShift != 0.0;
                        pt.x = x;
                    }
                } else if (!ringSimplifyIsNeeded && InternalUtils.isAngleTooSharp(pt2, pt1, pt, tol3, true)) {
                    ringSimplifyIsNeeded = true;
                }
                if (writeValues) {
                    xyStream.write(2 * i, x);
                }
                xPrev = x;
                pt2.setCoords(pt1);
                pt1.setCoords(pt);
            }
            if (largeDeltas > 0) {
                singlePartPath.m_impl.notifyModified(2001);
            }
            boolean bl = ringIsClosed = Point2D.distance(start = singlePartPath.getXY(0), end = singlePartPath.getXY(pointCount - 1)) < tol3;
            if (ringIsClosed) {
                result = ProjectionUtils.finalizeGeoNormalizeClosedRing_(originalPolygon, ipath, singlePartPath, pannableSR, centralLongitude, progress_tracker, ringSimplifyIsNeeded);
                geonormalizedResult.add(result, false);
                continue;
            }
            result = ProjectionUtils.finalizeGeoNormalizeOpenRing_(originalPolygon, ipath, singlePartPath, pannableSR, centralLongitude, progress_tracker);
            geonormalizedResult.add(result, false);
        }
        double tol = pannableSR.getTolerance(0);
        double twoDegreeDensify = pannableExtent.getWidth() / 180.0;
        ProjectionUtils.snapToHorizonEnvelope(geonormalizedResult, pannableExtent, tol * 0.1, false);
        Polygon restoredPolygonClipped = (Polygon)Clipper.clip(geonormalizedResult, pannableExtent, tol, twoDegreeDensify, progress_tracker);
        boolean simplify = geonormalizedResult != restoredPolygonClipped;
        double originalArea = originalPolygon.calculateArea2D();
        double newArea = restoredPolygonClipped.calculateArea2D();
        int addEnv = 0;
        if (newArea > 0.0 && originalArea < 0.0) {
            addEnv = 1;
        } else if (newArea <= 0.0 && originalArea > 0.0) {
            if (newArea == 0.0) {
                double horizonArea = NumberUtils.NaN();
                if (originalSR.getCoordinateSystemType() == SpatialReference.Type.Projected) {
                    horizonArea = originalSR.getPCSHorizon().calculateArea2D();
                } else if (originalSR.getCoordinateSystemType() == SpatialReference.Type.Geographic) {
                    horizonArea = originalSR.getPannableExtentByReferenceInternal().getArea();
                }
                if (originalArea > horizonArea * 0.99) {
                    addEnv = -1;
                }
            } else {
                addEnv = -1;
            }
        }
        if (addEnv != 0) {
            Polygon polyTmp = new Polygon(restoredPolygonClipped.getDescription());
            polyTmp.addEnvelope(pannableExtent, false);
            polyTmp = (Polygon)OperatorDensifyByLength.local().execute(polyTmp, twoDegreeDensify, progress_tracker);
            polyTmp.add(restoredPolygonClipped, false);
            simplify = true;
            restoredPolygonClipped = polyTmp;
        }
        if (simplify) {
            restoredPolygonClipped = (Polygon)OperatorSimplify.local().execute(restoredPolygonClipped, (SpatialReference)pannableSR, false, progress_tracker);
        }
        return restoredPolygonClipped;
    }

    private static Polygon finalizeGeoNormalizeOpenRing_(Polygon originalMultipath, int originalPathIndex, Polyline onePathPolyline, SpatialReferenceImpl pannableSR, double centralLongitude, ProgressTracker progress_tracker) {
        int pointCount = onePathPolyline.getPointCount();
        Point2D start = onePathPolyline.getXY(0);
        Point2D end = onePathPolyline.getXY(pointCount - 1);
        Envelope2D pannableExtent = ProjectionUtils.getAdjustedPannableExtent(pannableSR, centralLongitude);
        double width360 = pannableExtent.getWidth();
        int openRingDirection = MathUtils.sign(end.x - start.x);
        Envelope2D geomEnv = new Envelope2D();
        onePathPolyline.queryLooseEnvelope(geomEnv);
        double centerx = pannableExtent.getCenterX();
        double firstShift = 0.0;
        double leftLimit = centerx - width360;
        double rightLimit = centerx + width360;
        if (openRingDirection >= 0) {
            double shiftLeft = Math.ceil((leftLimit - geomEnv.xmin) / width360);
            shiftLeft *= width360;
            while (leftLimit > geomEnv.xmin + shiftLeft) {
                shiftLeft += width360;
            }
            while (leftLimit < geomEnv.xmax + shiftLeft) {
                shiftLeft -= width360;
            }
            firstShift = shiftLeft;
            if (geomEnv.getWidth() > 720.0) {
                rightLimit = leftLimit + Math.ceil(geomEnv.getWidth() / 360.0) * 360.0;
            }
        } else {
            double shiftRight = Math.ceil((rightLimit - geomEnv.xmax) / width360);
            shiftRight *= width360;
            while (rightLimit < geomEnv.xmax + shiftRight) {
                shiftRight -= width360;
            }
            while (rightLimit > geomEnv.xmin + shiftRight) {
                shiftRight += width360;
            }
            firstShift = shiftRight;
            if (geomEnv.getWidth() > 720.0) {
                leftLimit = rightLimit - Math.ceil(geomEnv.getWidth() / 360.0) * 360.0;
            }
        }
        double deltaShiftX = (double)openRingDirection * width360;
        Envelope2D shiftedGeomEnv = new Envelope2D(geomEnv);
        shiftedGeomEnv.move(firstShift, 0.0);
        Transformation2D shift = new Transformation2D();
        shift.setShift(firstShift, 0.0);
        onePathPolyline.applyTransformation(shift);
        Polyline stitchedPolyline = new Polyline(onePathPolyline.getDescription());
        stitchedPolyline.add(onePathPolyline, false);
        Point2D ptLast = onePathPolyline.getXY(pointCount - 1);
        int firstPointPos = 0;
        double firstPointX = stitchedPolyline.getXY((int)0).x;
        int progressTrackerCallCount = 0;
        while (openRingDirection > 0 ? shiftedGeomEnv.xmax < rightLimit : shiftedGeomEnv.xmin > leftLimit) {
            if (progressTrackerCallCount >= 1024) {
                progressTrackerCallCount = 0;
            }
            shiftedGeomEnv.move(deltaShiftX, 0.0);
            shift.xd = deltaShiftX;
            onePathPolyline.applyTransformation(shift);
            firstPointX += deltaShiftX;
            if (pannableExtent.xmin <= firstPointX && pannableExtent.xmax >= firstPointX) {
                firstPointPos = stitchedPolyline.getPointCount() - 1;
            }
            onePathPolyline.setXY(0, ptLast);
            ptLast = onePathPolyline.getXY(pointCount - 1);
            stitchedPolyline.addSegmentsFromPath(onePathPolyline, 0, 0, pointCount - 1, false);
        }
        Polygon restoredRing = new Polygon(stitchedPolyline.getDescription());
        double area = originalMultipath.calculateRingArea2D(originalPathIndex);
        boolean clockWise = area > 0.0;
        restoredRing.add(stitchedPolyline, false);
        Point2D ptStart = stitchedPolyline.getXY(0);
        Point2D ptEnd = stitchedPolyline.getXY(stitchedPolyline.getPointCount() - 1);
        boolean upper = openRingDirection < 0 ? clockWise : !clockWise;
        int relativeInterpolateFrom = restoredRing.getPathCount() - 1;
        if (upper) {
            Point2D pt = new Point2D(ptEnd.x, pannableExtent.ymax);
            restoredRing.lineTo(pt);
            Point2D pt1 = new Point2D(pannableExtent.getCenterX(), pannableExtent.ymax);
            restoredRing.lineTo(pt1);
            Point2D pt2 = new Point2D(ptStart.x, pannableExtent.ymax);
            restoredRing.lineTo(pt2);
        } else {
            Point2D pt = new Point2D(ptEnd.x, pannableExtent.ymin);
            restoredRing.lineTo(pt);
            Point2D pt1 = new Point2D(pannableExtent.getCenterX(), pannableExtent.ymin);
            restoredRing.lineTo(pt1);
            Point2D pt2 = new Point2D(ptStart.x, pannableExtent.ymin);
            restoredRing.lineTo(pt2);
        }
        restoredRing.interpolateAttributes(0, relativeInterpolateFrom, 0);
        restoredRing.m_impl.changeRingStartPoint(firstPointPos);
        return restoredRing;
    }

    private static Polygon finalizeGeoNormalizeClosedRing_(Polygon originalPolygon, int originalPathIndex, Polyline onePathPolyline, SpatialReferenceImpl pannableSr, double centralLongitude, ProgressTracker progress_tracker, boolean simplifyIt) {
        boolean simplifyIsNeeded;
        Polygon singlePartRing = new Polygon(onePathPolyline.getDescription());
        singlePartRing.add(onePathPolyline, false);
        singlePartRing.removePoint(0, singlePartRing.getPointCount() - 1);
        Envelope2D partEnv = new Envelope2D();
        singlePartRing.queryLooseEnvelope(partEnv);
        Envelope2D pannableExtent = ProjectionUtils.getAdjustedPannableExtent(pannableSr, centralLongitude);
        double width360 = pannableExtent.getWidth();
        double shiftLeft = Math.ceil((pannableExtent.xmin - partEnv.xmin) / width360);
        shiftLeft *= width360;
        while (pannableExtent.xmin > partEnv.xmin + shiftLeft) {
            shiftLeft += width360;
        }
        while (pannableExtent.xmin < partEnv.xmax + shiftLeft) {
            shiftLeft -= width360;
        }
        if ((shiftLeft += width360) != 0.0) {
            partEnv.move(shiftLeft, 0.0);
            Transformation2D shift = new Transformation2D();
            shift.setShift(shiftLeft, 0.0);
            singlePartRing.applyTransformation(shift);
        }
        if (pannableExtent.xmin <= partEnv.xmin && pannableExtent.xmax > partEnv.xmax) {
            Polygon resPolygon = singlePartRing;
            if (simplifyIt) {
                boolean reversed;
                double area1 = resPolygon.calculateArea2D();
                resPolygon = (Polygon)OperatorSimplify.local().execute(resPolygon, (SpatialReference)pannableSr, true, progress_tracker);
                double area2 = resPolygon.calculateArea2D();
                boolean bl = reversed = MathUtils.sign(area1) != MathUtils.sign(area2);
                if (reversed) {
                    resPolygon.reverseAllPaths();
                }
            }
            return resPolygon;
        }
        Polygon duplicatedRings = new Polygon(onePathPolyline.getDescription());
        duplicatedRings.add(singlePartRing, false);
        boolean bl = simplifyIsNeeded = simplifyIt || partEnv.getWidth() > width360 - pannableSr.getTolerance(0);
        while (partEnv.xmin < pannableExtent.xmax) {
            partEnv.move(width360, 0.0);
            Transformation2D shift = new Transformation2D();
            shift.setShift(width360, 0.0);
            singlePartRing.applyTransformation(shift);
            duplicatedRings.add(singlePartRing, false);
        }
        if (simplifyIsNeeded) {
            boolean reversed;
            double area1 = duplicatedRings.calculateArea2D();
            duplicatedRings.setFillRule(1);
            duplicatedRings = (Polygon)OperatorSimplify.local().execute(duplicatedRings, (SpatialReference)pannableSr, true, progress_tracker);
            double area2 = duplicatedRings.calculateArea2D();
            boolean bl2 = reversed = MathUtils.sign(area1) != MathUtils.sign(area2);
            if (reversed) {
                duplicatedRings.reverseAllPaths();
            }
        }
        return duplicatedRings;
    }

    static boolean adjustPathAtPoles(boolean originalyClosedPath, Polyline singlePartPath, double y90, double trueY90, int poleFlags) {
        AttributeStreamOfDbl xyStream = (AttributeStreamOfDbl)singlePartPath.m_impl.getAttributeStreamRef(0);
        int pointCount = singlePartPath.getPointCount();
        boolean foundPolarCase = false;
        for (int i = 0; i < pointCount; ++i) {
            Point2D pt = new Point2D(xyStream.readAsDbl(2 * i), xyStream.readAsDbl(2 * i + 1));
            if ((poleFlags & 1) != 0 && pt.y >= y90) {
                foundPolarCase = true;
                break;
            }
            if ((poleFlags & 2) == 0 || !(pt.y <= -y90)) continue;
            foundPolarCase = true;
            break;
        }
        if (!foundPolarCase) {
            return false;
        }
        boolean wasClosedPath = false;
        if (originalyClosedPath) {
            wasClosedPath = ((MultiPathImpl)singlePartPath._getImpl()).isClosedPathInXYPlane(0);
        }
        EditShape shape = new EditShape();
        int geom = shape.addGeometry(singlePartPath);
        int path = shape.getFirstPath(geom);
        int prevPole = -1;
        boolean first = true;
        Point2D prevPt = new Point2D();
        prevPt.setNaN();
        Point point = new Point();
        int protected_polar = -1;
        int vertex = shape.getFirstVertex(path);
        while (vertex != -1) {
            Point2D pt = shape.getXY(vertex);
            int pole = (poleFlags & 1) != 0 && pt.y >= 90.0 ? 1 : 0;
            if (prevPole > 0 && prevPole != (pole |= (poleFlags & 2) != 0 && pt.y <= -y90 ? 2 : 0)) {
                if (prevPt.x != pt.x) {
                    prevPt.x = pt.x;
                    int polarVertex = shape.getPrevVertex(vertex);
                    shape.queryPoint(polarVertex, point);
                    int inserted_vertex = shape.insertVertex_(path, vertex, point);
                    shape.setXY(inserted_vertex, prevPt);
                }
                if (wasClosedPath) {
                    int v = protected_polar != -1 ? shape.getNextVertex(protected_polar) : shape.getFirstVertex(path);
                    int to = shape.getPrevVertex(vertex);
                    while (v != to) {
                        v = shape.removeVertex(v, false);
                    }
                }
                protected_polar = -1;
            }
            if (pole > 0) {
                pt.y = MathUtils.copySign(trueY90, pt.y);
                shape.setXY(vertex, pt);
                if (!first && prevPole != pole) {
                    if (pt.x != prevPt.x) {
                        shape.queryPoint(vertex, point);
                        int inserted_vertex = shape.insertVertex_(path, vertex, point);
                        shape.setXY(inserted_vertex, prevPt.x, pt.y);
                        protected_polar = inserted_vertex;
                    } else {
                        protected_polar = vertex;
                    }
                }
            }
            prevPole = pole;
            prevPt = pt;
            first = false;
            vertex = shape.getNextVertex(vertex);
        }
        if (wasClosedPath) {
            int v2;
            int v1;
            if (protected_polar != -1) {
                int v = shape.getNextVertex(protected_polar);
                while (v != -1) {
                    v = shape.removeVertex(v, false);
                }
            }
            if (!shape.isEqualXY(v1 = shape.getFirstVertex(path), v2 = shape.getLastVertex(path))) {
                shape.queryPoint(v1, point);
                shape.insertVertex_(path, -1, point);
            }
        }
        shape.getGeometry(geom).copyTo(singlePartPath);
        return true;
    }

    static boolean ringAccelerationNeeded(Geometry polygon, int exterior_ring) {
        assert (polygon.getType() == Geometry.Type.Polygon);
        MultiPathImpl mp_impl = (MultiPathImpl)polygon._getImpl();
        int number_of_holes = 0;
        int size_of_positive_ring = mp_impl.getPathSize(exterior_ring);
        int n = mp_impl.getPathCount();
        for (int i_ring = exterior_ring + 1; i_ring < n; ++i_ring) {
            boolean posRingGCS;
            boolean bl = posRingGCS = mp_impl.calculateRingArea2D(i_ring) > 0.0;
            if (posRingGCS) break;
            ++number_of_holes;
        }
        return size_of_positive_ring > 64 && number_of_holes >= 3;
    }

    static Geometry intersectWithGCSHorizon(Geometry _geom, SpatialReferenceImpl pcs, HorizonClipOption clipOption, ProgressTracker progressTracker) {
        double firstShift;
        Geometry geom = _geom;
        if (geom.isEmpty() || clipOption == HorizonClipOption.DontClip) {
            return geom;
        }
        Geometry.Type geomType = geom.getType();
        if (geomType == Geometry.Type.Point) {
            Point point = (Point)geom;
            Point2D[] pt = new Point2D[]{point.getXY()};
            ProjectionUtils.intersectWithGCSHorizon(pt, 1, pcs, clipOption);
            if (pt[0].isNaN()) {
                point.setEmpty();
            } else {
                point.setXY(pt[0]);
            }
            return _geom;
        }
        SpatialReferenceImpl gcs = (SpatialReferenceImpl)pcs.getGCS();
        double GCS1 = gcs.getOneDegreeGCSUnit();
        double GCS90 = GCS1 * 90.0;
        double GCS180 = GCS1 * 180.0;
        double GCS360 = GCS1 * 360.0;
        double centralMeridian = pcs.getAdjustedCentralMeridian();
        double densificationStep = 0.5 * GCS1;
        Envelope2D geomEnv2D = new Envelope2D();
        geom.queryEnvelope2D(geomEnv2D);
        Geometry gcsHorizon = pcs.getGCSHorizon();
        boolean GCS_horison_is_inclusive = pcs.gcsHorisonIsInclusive();
        Geometry.Type GCSHorizonType = gcsHorizon.getType();
        boolean GCSHorizonIsEnvelope = GCSHorizonType == Geometry.Type.Envelope;
        Envelope2D horizonEnv2D = new Envelope2D();
        gcsHorizon.queryEnvelope2D(horizonEnv2D);
        if (clipOption == HorizonClipOption.PannableFold) {
            double width = gcs.getPannableExtentByReferenceInternal().getWidth();
            horizonEnv2D.xmin = centralMeridian - width * 0.5;
            horizonEnv2D.xmax = horizonEnv2D.xmin + width;
        }
        if (geomEnv2D.ymin < -GCS90 || geomEnv2D.ymax > GCS90) {
            Envelope2D clipEnv2D = new Envelope2D();
            clipEnv2D.setCoords(geomEnv2D.xmin - GCS1, -GCS90, geomEnv2D.xmax + GCS1, GCS90);
            geom = OperatorClip.local().execute(geom, horizonEnv2D, (SpatialReference)gcs, progressTracker);
            if (geom.isEmpty()) {
                return geom;
            }
            geom.queryEnvelope2D(geomEnv2D);
        }
        if (GCS_horison_is_inclusive && (horizonEnv2D.ymax < geomEnv2D.ymin || horizonEnv2D.ymin > geomEnv2D.ymax)) {
            return geom.createInstance();
        }
        if (geomEnv2D.getWidth() > GCS360) {
            geom = ProjectionUtils.foldGeometry(geom, centralMeridian - GCS180, GCS360, gcs, true, 0.0, true, progressTracker);
            geom.queryEnvelope2D(geomEnv2D);
        }
        if ((firstShift = ProjectionUtils.calculateIntervalShift(geomEnv2D.xmin, geomEnv2D.xmax, horizonEnv2D.xmin, horizonEnv2D.xmax, GCS360)) != 0.0) {
            geomEnv2D.move(firstShift, 0.0);
        }
        if (geomEnv2D.xmax > horizonEnv2D.xmax || geomEnv2D.xmin < horizonEnv2D.xmin) {
            if (geomEnv2D.xmax > horizonEnv2D.xmax) {
                while (geomEnv2D.xmin >= horizonEnv2D.xmax) {
                    geomEnv2D.move(-GCS360, 0.0);
                    firstShift -= GCS360;
                }
            }
            while (geomEnv2D.xmin < horizonEnv2D.xmax - GCS360) {
                geomEnv2D.move(GCS360, 0.0);
                firstShift += GCS360;
            }
        }
        double toleranceGCS = InternalUtils.calculateToleranceFromGeometryForRel((SpatialReference)gcs, gcsHorizon, false);
        if (firstShift != 0.0) {
            Transformation2D shiftTransform = new Transformation2D();
            shiftTransform.setShift(firstShift, 0.0);
            geom.applyTransformation(shiftTransform);
            firstShift = 0.0;
        }
        if (GCS_horison_is_inclusive) {
            if (GCSHorizonIsEnvelope && horizonEnv2D.contains(geomEnv2D)) {
                return geom;
            }
            Geometry[] geoms = new Geometry[2];
            for (int istep = 0; istep < 2; ++istep) {
                Geometry modifiedGeom = null;
                if (GCSHorizonIsEnvelope) {
                    modifiedGeom = Geometry.isMultiPath(geomType.value()) ? Clipper.clip(geom, horizonEnv2D, toleranceGCS, densificationStep, progressTracker) : Clipper.clip(geom, horizonEnv2D, toleranceGCS, 0.0, progressTracker);
                } else {
                    modifiedGeom = OperatorIntersection.local().execute(geom, gcsHorizon, (SpatialReference)gcs, progressTracker);
                    if (modifiedGeom == gcsHorizon) {
                        modifiedGeom = Geometry._clone(modifiedGeom);
                    }
                }
                if (horizonEnv2D.xmin <= geomEnv2D.xmin && horizonEnv2D.xmax >= geomEnv2D.xmax) {
                    return modifiedGeom;
                }
                if (horizonEnv2D.xmin >= geomEnv2D.xmin && horizonEnv2D.xmax <= geomEnv2D.xmax) {
                    return modifiedGeom;
                }
                geoms[istep] = modifiedGeom;
                if (istep != 0) continue;
                geomEnv2D.move(-GCS360, 0.0);
                Transformation2D shiftTransform = new Transformation2D();
                shiftTransform.setShift(-GCS360, 0.0);
                geom.applyTransformation(shiftTransform);
            }
            if (geomType == Geometry.Type.MultiPoint) {
                ((MultiPoint)geoms[0]).add((MultiPoint)geoms[1], 0, -1);
            } else if (Geometry.isMultiPath(geomType.value())) {
                ((MultiPath)geoms[0]).add((MultiPath)geoms[1], false);
            } else if (geomType == Geometry.Type.Point) {
                if (geoms[0].isEmpty()) {
                    geoms[0] = geoms[1];
                }
            } else {
                new GeometryException("intersect_with_GCS_horizon: unexpected geometry type");
            }
            return geoms[0];
        }
        if (horizonEnv2D.ymax < geomEnv2D.ymin || horizonEnv2D.ymin > geomEnv2D.ymax) {
            return geom;
        }
        double shift = 0.0;
        while (!geom.isEmpty() && geomEnv2D.xmax > horizonEnv2D.xmin) {
            Geometry resGeom;
            if (shift != 0.0) {
                Transformation2D shiftTransform = new Transformation2D();
                shiftTransform.setShift(shift, 0.0);
                geom.applyTransformation(shiftTransform);
            }
            if (!OperatorDisjoint.local().execute(geom, gcsHorizon, gcs, progressTracker) && gcsHorizon == (geom = (resGeom = OperatorDifference.local().execute(geom, gcsHorizon, (SpatialReference)gcs, progressTracker)))) {
                geom = Geometry._clone(geom);
            }
            if (shift != 0.0) {
                Transformation2D unshiftTransform = new Transformation2D();
                unshiftTransform.setShift(-shift, 0.0);
                geom.applyTransformation(unshiftTransform);
            }
            shift -= GCS360;
            geomEnv2D.move(-GCS360, 0.0);
        }
        return geom;
    }

    static int intersectWithGCSHorizon(Point2D[] points, int count, SpatialReferenceImpl pcs, HorizonClipOption clip_option) {
        if (count == 0 || clip_option == HorizonClipOption.DontClip) {
            return count;
        }
        if (clip_option == HorizonClipOption.PannableFold) {
            Envelope2D pannable_extent = pcs.getPannableExtentInGCS();
            int res_cnt = count;
            for (int i = 0; i < count; ++i) {
                if (!(points[i].y > pannable_extent.ymax) && !(points[i].y < pannable_extent.ymin)) continue;
                points[i].setNaN();
                --res_cnt;
            }
            if (res_cnt == 0) {
                return 0;
            }
            ProjectionUtils.foldGeometry(points, count, pannable_extent.xmin, pannable_extent.getWidth(), true);
            return res_cnt;
        }
        double GCS1 = pcs.getOneDegreeGCSUnit();
        double GCS90 = GCS1 * 90.0;
        double GCS180 = GCS1 * 180.0;
        double GCS360 = GCS1 * 360.0;
        int res_cnt = count;
        for (int i = 0; i < count; ++i) {
            if (!(points[i].y > GCS90) && !(points[i].y < -GCS90)) continue;
            points[i].setNaN();
            --res_cnt;
        }
        if (res_cnt == 0) {
            return 0;
        }
        Envelope2D geomEnv2D = new Envelope2D();
        geomEnv2D.setFromPoints(points, count);
        Geometry gcsHorizon = pcs.getGCSHorizon();
        boolean GCS_horison_is_inclusive = pcs.getGCSHorisonIsInclusive();
        int GCSHorizonType = gcsHorizon.getGeometryType();
        boolean GCSHorizonIsEnvelope = GCSHorizonType == 197;
        Envelope2D horizonEnv2D = new Envelope2D();
        gcsHorizon.queryEnvelope2D(horizonEnv2D);
        if (GCS_horison_is_inclusive && (horizonEnv2D.ymax < geomEnv2D.ymin || horizonEnv2D.ymin > geomEnv2D.ymax)) {
            return 0;
        }
        if (GCS_horison_is_inclusive) {
            double horizon_center = horizonEnv2D.getCenterX();
            ProjectionUtils.foldGeometry(points, count, horizon_center - GCS180, GCS360, true);
            res_cnt = count;
            if (GCSHorizonIsEnvelope) {
                for (int i = 0; i < count; ++i) {
                    if (horizonEnv2D.contains(points[i])) continue;
                    points[i].setNaN();
                    --res_cnt;
                }
            } else {
                double toleranceGCS = InternalUtils.calculateToleranceFromGeometryForRel(pcs.getGCS(), gcsHorizon, false);
                for (int i = 0; i < count; ++i) {
                    boolean contains;
                    boolean bl = contains = PolygonUtils.PiPResult.PiPOutside != PolygonUtils.isPointInPolygon2D((Polygon)gcsHorizon, points[i], toleranceGCS);
                    if (contains) continue;
                    points[i].setNaN();
                    --res_cnt;
                }
            }
        } else {
            ProjectionUtils.foldGeometry(points, count, -GCS180, GCS360, true);
            res_cnt = count;
            double toleranceGCS = InternalUtils.calculateToleranceFromGeometryForRel(pcs.getGCS(), gcsHorizon, false);
            for (int i = 0; i < count; ++i) {
                boolean contains;
                Point2D pt = points[i];
                if (pt.isNaN()) {
                    --res_cnt;
                }
                double shift = ProjectionUtils.calculateShift(pt.x, horizonEnv2D.xmin, horizonEnv2D.xmax, GCS360);
                pt.x += shift;
                boolean bl = contains = PolygonUtils.PiPResult.PiPOutside != PolygonUtils.isPointInPolygon2D((Polygon)gcsHorizon, pt, toleranceGCS);
                if (!contains) continue;
                points[i].setNaN();
                --res_cnt;
            }
        }
        return res_cnt;
    }

    static int getRingPoleBits(Polygon multiPath, int iPath, SpatialReferenceImpl sr) {
        assert (iPath < 0);
        if (iPath >= 0 && !multiPath.isClosedPath(iPath)) {
            return 0;
        }
        int poleInRingBits = 0;
        SpatialReference.Type srType = sr.getCoordinateSystemType();
        if (srType == SpatialReference.Type.Geographic) {
            double GCS90 = 90.0 * sr.getOneDegreeGCSUnit();
            double GCSDelta = 2.0E-7 * (GCS90 * 2.0 / Math.PI);
            GCS90 -= GCSDelta;
            Envelope2D env_2D = new Envelope2D();
            multiPath.queryEnvelope2D(env_2D);
            if (env_2D.ymax >= GCS90) {
                poleInRingBits = 1;
            }
            if (env_2D.ymin <= -GCS90) {
                poleInRingBits |= 2;
            }
            return poleInRingBits;
        }
        PePCSInfo pcsInfo = sr.getPCSInfo();
        if (pcsInfo == null) {
            return 0;
        }
        MultiPathImpl multiPathImpl = null;
        if (iPath >= 0) {
            multiPathImpl = (MultiPathImpl)multiPath._getImpl();
        }
        for (int i = 0; i < 2; ++i) {
            Point2D pole;
            int inPoleLocation;
            int n = inPoleLocation = i > 0 ? pcsInfo.getSouthPoleLocation() : pcsInfo.getNorthPoleLocation();
            if (inPoleLocation == 0 || (pole = sr.getPole(i > 0)).isNaN()) continue;
            int ringPoleBits = iPath < 0 ? PointInPolygonHelper.isPointInAnyOuterRing(multiPath, pole, 0.0) : PointInPolygonHelper.isPointInRing(multiPathImpl, iPath, pole, 0.0, null);
            poleInRingBits |= ringPoleBits << i;
        }
        return poleInRingBits;
    }

    static Geometry foldGeometry(Geometry geometry, double intervalMin, double intervalWidth, SpatialReference sr, boolean bCanModifyInput, double densify_dist, boolean right_inclusive, ProgressTracker progressTracker) {
        Geometry.Type geomType = geometry.getType();
        double intervalMax = intervalMin + intervalWidth;
        if (geomType.equals((Object)Geometry.Type.Point)) {
            Point point = bCanModifyInput ? (Point)geometry : (Point)geometry.copy();
            double x = point.getX();
            if (x < intervalMin || x >= intervalMax || right_inclusive && x == intervalMax) {
                x += Math.ceil((intervalMin - x) / intervalWidth) * intervalWidth;
                assert (intervalMin - 1.0E-5 < x && x < intervalMax + 1.0E-5);
                x = NumberUtils.snap(x, intervalMin, intervalMax);
                point.setX(x);
            }
            return point;
        }
        if (geometry.isEmpty()) {
            return geometry;
        }
        Envelope2D geomEnvelope2D = new Envelope2D();
        geometry.queryEnvelope2D(geomEnvelope2D);
        if (geomEnvelope2D.isEmpty()) {
            return geometry;
        }
        Envelope1D geomIntervalX = new Envelope1D();
        geomEnvelope2D.queryIntervalX(geomIntervalX);
        Envelope1D interval = new Envelope1D();
        interval.setCoords(intervalMin, intervalMax);
        if (interval.contains(geomIntervalX)) {
            if (interval.vmax != geomIntervalX.vmax) {
                return geometry;
            }
            return geometry;
        }
        Envelope2D clipEnvelope2D = new Envelope2D();
        clipEnvelope2D.setCoords(geomEnvelope2D);
        if (geomType.equals((Object)Geometry.Type.MultiPoint)) {
            Geometry resultGeom = bCanModifyInput ? geometry : geometry.copy();
            MultiVertexGeometryImpl resultGeometryImpl = (MultiVertexGeometryImpl)resultGeom._getImpl();
            AttributeStreamOfDbl xyStream = (AttributeStreamOfDbl)resultGeometryImpl.getAttributeStreamRef(0);
            int cDoubles = resultGeometryImpl.getPointCount() * 2;
            boolean modified = false;
            for (int i = 0; i < cDoubles; i += 2) {
                double x = xyStream.read(i);
                if (!(x < interval.vmin) && !(x >= interval.vmax) && (!right_inclusive || x != interval.vmax)) continue;
                modified = true;
                x += Math.ceil((interval.vmin - x) / intervalWidth) * intervalWidth;
                assert (interval.vmin - 1.0E-5 < x && x < interval.vmax + 1.0E-5);
                x = interval.snapClip(x);
                xyStream.write(i, x);
            }
            if (modified) {
                resultGeometryImpl.notifyModified(2001);
            }
            return resultGeom;
        }
        if (geomType == Geometry.Type.Envelope) {
            Envelope env = bCanModifyInput ? (Envelope)geometry : (Envelope)geometry.copy();
            geomEnvelope2D.intersect(clipEnvelope2D);
            env.setEnvelope2D(geomEnvelope2D);
            return env;
        }
        double d = Math.max(geomEnvelope2D.getHeight(), geomEnvelope2D.getWidth()) * 0.1 * 1.0;
        clipEnvelope2D.inflate(0.0, d);
        Geometry foldedGeom = geometry;
        double tolerance = sr.getTolerance(0);
        OperatorUnion operatorUnion = (OperatorUnion)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Union);
        Transformation2D transformShift = new Transformation2D();
        while (true) {
            double n0 = Math.floor((geomIntervalX.vmin - intervalMin) / intervalWidth);
            double n1 = Math.ceil((geomIntervalX.vmax - intervalMin) / intervalWidth);
            if (!(n1 - n0 > 3.0)) break;
            double midN = Math.floor((n1 + n0) * 0.5);
            clipEnvelope2D.xmin = geomEnvelope2D.xmin - d;
            clipEnvelope2D.xmax = intervalMin + intervalWidth * midN;
            Geometry geom1 = Clipper.clip(foldedGeom, clipEnvelope2D, tolerance, densify_dist, progressTracker);
            clipEnvelope2D.xmin = clipEnvelope2D.xmax;
            clipEnvelope2D.xmax = geomEnvelope2D.xmax + d;
            Geometry geom2 = Clipper.clip(foldedGeom, clipEnvelope2D, tolerance, densify_dist, progressTracker);
            transformShift.setShift((midN - n1) * intervalWidth, 0.0);
            geom2.applyTransformation(transformShift);
            if (geomType == Geometry.Type.Polygon) {
                foldedGeom = operatorUnion.execute(geom1, geom2, sr, null);
            } else {
                foldedGeom = geom1;
                ((MultiPath)foldedGeom).add((MultiPath)geom2, false);
            }
            foldedGeom.queryEnvelope2D(geomEnvelope2D);
            geomEnvelope2D.queryIntervalX(geomIntervalX);
        }
        clipEnvelope2D.xmin = intervalMin;
        clipEnvelope2D.xmax = intervalMin + intervalWidth;
        Envelope2D clipEnvelope2DInflated = new Envelope2D();
        clipEnvelope2DInflated.setCoords(clipEnvelope2D);
        clipEnvelope2DInflated.inflate(tolerance, 0.0);
        double initialShift = Math.floor((geomEnvelope2D.xmin - clipEnvelope2D.xmin) / intervalWidth) * intervalWidth;
        if (initialShift != 0.0) {
            clipEnvelope2D.move(initialShift, 0.0);
            transformShift.setShift(-initialShift, 0.0);
        } else {
            transformShift.setIdentity();
        }
        assert (geomEnvelope2D.xmax > clipEnvelope2D.xmin);
        MultiPath clippedUnionGeom = geomType == Geometry.Type.Polyline ? new Polyline(foldedGeom.getDescription()) : new Polygon(foldedGeom.getDescription());
        Envelope2D envUnion = new Envelope2D();
        Envelope2D envClippedGeom = new Envelope2D();
        while (geomEnvelope2D.xmax > clipEnvelope2D.xmin) {
            Geometry clippedGeom = Clipper.clip(foldedGeom, clipEnvelope2D, tolerance, 0.0, progressTracker);
            clippedGeom.queryEnvelope2D(envClippedGeom);
            boolean bCanAdd = false;
            if (geomType == Geometry.Type.Polyline) {
                bCanAdd = !clippedGeom.isEmpty() && (envClippedGeom.getWidth() > tolerance || envClippedGeom.getHeight() > tolerance);
            } else {
                boolean bl = bCanAdd = !clippedGeom.isEmpty() && (geomType != Geometry.Type.Polygon || envClippedGeom.getWidth() > tolerance);
            }
            if (bCanAdd) {
                clippedGeom.applyTransformation(transformShift);
                clippedGeom.queryEnvelope2D(envClippedGeom);
                clippedUnionGeom.queryEnvelope2D(envUnion);
                envUnion.inflate(tolerance, tolerance);
                if (envUnion.isIntersecting(envClippedGeom) && geomType == Geometry.Type.Polygon) {
                    clippedUnionGeom = (MultiPath)operatorUnion.execute(clippedUnionGeom, clippedGeom, sr, null);
                } else {
                    clippedUnionGeom.add((MultiPath)clippedGeom, false);
                }
            }
            clipEnvelope2D.move(intervalWidth, 0.0);
            transformShift.shift(-intervalWidth, 0.0);
        }
        return clippedUnionGeom;
    }

    static void foldGeometry(Point2D[] points, int count, double interval_min, double interval_width, boolean right_inclusive) {
        double xmin = interval_min;
        double xmax = interval_min + interval_width;
        for (int i = 0; i < count; ++i) {
            double x = points[i].x;
            if (xmin <= x && x < xmax || !(x < xmin) && !(x > xmax) && (!right_inclusive || x != xmax)) continue;
            x += Math.ceil((xmin - x) / interval_width) * interval_width;
            assert (xmin - 1.0E-5 < x && x < xmax + 1.0E-5);
            points[i].x = x = NumberUtils.snap(x, xmin, xmax);
        }
    }

    static Geometry foldInto360DegreeRange(Geometry _geom, SpatialReferenceImpl sr, double centralLongitude, boolean bCanModifyInput, double densify_dist, ProgressTracker progressTracker) {
        double CS360;
        double leftLong;
        if (!sr.isPannable()) {
            throw new GeometryException("fold_into_360_degree_range");
        }
        if (_geom.isEmpty()) {
            return _geom;
        }
        if (sr.getCoordinateSystemType() == SpatialReference.Type.Projected) {
            leftLong = sr.getPannableExtentXMin();
            CS360 = sr.getPannableExtentXMax() - leftLong;
        } else {
            double GCS1 = sr.getOneDegreeGCSUnit();
            double GCS180 = GCS1 * 180.0;
            CS360 = GCS1 * 360.0;
            leftLong = centralLongitude - GCS180;
        }
        return ProjectionUtils.foldGeometry(_geom, leftLong, CS360, sr, bCanModifyInput, densify_dist, true, progressTracker);
    }

    static void foldInto360DegreeRange(Point2D[] pt_in, int count, SpatialReferenceImpl sr, double central_longitude) {
        double CS360;
        double leftLong;
        if (sr.getCoordinateSystemType() == SpatialReference.Type.Projected) {
            leftLong = sr.getPannableExtentXMin();
            CS360 = sr.getPannableExtentXMax() - leftLong;
        } else {
            double GCS1 = sr.getOneDegreeGCSUnit();
            double GCS180 = GCS1 * 180.0;
            CS360 = GCS1 * 360.0;
            leftLong = central_longitude - GCS180;
        }
        ProjectionUtils.foldGeometry(pt_in, count, leftLong, CS360, true);
    }

    static Geometry clipGeometryFromTopAndBottom(Geometry _geom, SpatialReference pannableSR) {
        assert (((SpatialReferenceImpl)pannableSR).isPannable());
        Envelope2D pannableExtent = ((SpatialReferenceImpl)pannableSR).getPannableExtentByReferenceInternal();
        if (_geom.getGeometryType() == 33) {
            Point point = (Point)_geom;
            double y = point.getY();
            if (pannableExtent.ymin <= y && y <= pannableExtent.ymax) {
                return _geom;
            }
            return _geom.createInstance();
        }
        Envelope2D geomExtent = new Envelope2D();
        _geom.queryEnvelope2D(geomExtent);
        Envelope2D clipExtent = new Envelope2D();
        clipExtent.setCoords(pannableExtent);
        pannableExtent = null;
        clipExtent.xmin = geomExtent.xmin;
        clipExtent.xmax = geomExtent.xmax;
        clipExtent.inflate(clipExtent.getHeight() * 0.01, 0.0);
        double tolerance = InternalUtils.calculateToleranceFromGeometryForRel(pannableSR, geomExtent, false);
        Geometry geom = !clipExtent.contains(geomExtent) ? Clipper.clip(_geom, clipExtent, tolerance, 0.0, null) : _geom;
        return geom;
    }

    static double snapX_(double x, Envelope2D env, double tolerance) {
        if (x > env.xmax && x - env.xmax < tolerance) {
            return env.xmax;
        }
        if (x < env.xmin && env.xmin - x < tolerance) {
            return env.xmin;
        }
        return x;
    }

    static void snapToHorizonEnvelope(Point2D pointIn, Envelope2D horizon_env, double storage_error, Point2D pointOut) {
        pointOut.x = ProjectionUtils.snapX_(pointIn.x, horizon_env, storage_error);
        pointOut.y = pointIn.y;
    }

    static void snapToHorizonEnvelopeAndClip(Point2D[] points_in_out, int count, Envelope2D horizon_env, double storage_error) {
        for (int i = 0; i < count; ++i) {
            if (points_in_out[i].y < horizon_env.ymin || points_in_out[i].y > horizon_env.ymax) {
                points_in_out[i].setNaN();
                continue;
            }
            double x = points_in_out[i].x;
            points_in_out[i].x = ProjectionUtils.snapX_(x, horizon_env, storage_error);
        }
    }

    static void snapToHorizonEnvelope(Geometry input_output_geom, Envelope2D horizon_env, double storage_error, boolean ignorePolygons) {
        if (input_output_geom.isEmpty()) {
            return;
        }
        Geometry.Type gt = input_output_geom.getType();
        if (ignorePolygons && gt == Geometry.Type.Polygon) {
            return;
        }
        if (Geometry.isMultiVertex(gt.value())) {
            MultiVertexGeometryImpl impl = (MultiVertexGeometryImpl)input_output_geom._getImpl();
            AttributeStreamOfDbl buf_res_xy = (AttributeStreamOfDbl)impl.getAttributeStreamRef(0);
            int n = impl.getPointCount();
            for (int i = 0; i < n; ++i) {
                double x = buf_res_xy.read(2 * i);
                double xn = ProjectionUtils.snapX_(x, horizon_env, storage_error);
                if (xn == x) continue;
                buf_res_xy.write(2 * i, xn);
            }
            impl.notifyModified(2001);
        } else if (gt == Geometry.Type.Envelope) {
            Envelope input_e = (Envelope)input_output_geom;
            Envelope2D e = new Envelope2D();
            input_e.queryEnvelope2D(e);
            e.xmin = ProjectionUtils.snapX_(e.xmin, horizon_env, storage_error);
            e.xmax = ProjectionUtils.snapX_(e.xmax, horizon_env, storage_error);
            input_e.setEnvelope2D(e);
        } else if (gt == Geometry.Type.Point) {
            Point p = (Point)input_output_geom;
            p.setX(ProjectionUtils.snapX_(p.getX(), horizon_env, storage_error));
        } else {
            throw GeometryException.GeometryInternalError();
        }
    }

    static MultiPath insertGeodeticPoints(MultiPath multipath, SpatialReferenceImpl spatialReference, int curveType, boolean bMeridian, double axisCoord) {
        EditShape shape = new EditShape();
        int geometry = shape.addGeometry(multipath);
        double tolerance = InternalUtils.calculateToleranceFromGeometryForRel((SpatialReference)spatialReference, multipath, false);
        ProjectionUtils.insertGeodeticPoints(shape, geometry, spatialReference, tolerance, curveType, bMeridian, axisCoord);
        return (MultiPath)shape.getGeometry(geometry);
    }

    static void insertGeodeticPoints(EditShape shape, int geometry, SpatialReferenceImpl spatialReference, double tolerance, int curveType, boolean bMeridian, double axisCoord) {
        if (!spatialReference.isPannable()) {
            throw new IllegalArgumentException("invalid call");
        }
        Envelope2D srExtentImmutable = spatialReference.getPannableExtentByReferenceInternal();
        SpatialReferenceImpl gcs = (SpatialReferenceImpl)spatialReference.getGCS();
        PeGeogcs pegeogcs = (PeGeogcs)gcs.getPECoordSys();
        PeSpheroid spheroid = pegeogcs.getDatum().getSpheroid();
        double rpu = gcs.getUnit().getUnitToBaseFactor();
        double flattening = spheroid.getFlattening();
        double a = spheroid.getAxis();
        double eSquared = flattening * (2.0 - flattening);
        double gcsAxisCoordRad = 0.0;
        Envelope1D srXExtent = new Envelope1D();
        srExtentImmutable.queryIntervalX(srXExtent);
        PeProjcs peProjcs = null;
        double[][] points = new double[2][2];
        if (spatialReference.getCoordinateSystemType() == SpatialReference.Type.Projected) {
            int cPointsOut;
            peProjcs = (PeProjcs)spatialReference.getPECoordSys();
            if (bMeridian) {
                points[0][0] = ProjectionUtils.normalizeX(axisCoord, srXExtent);
                points[0][1] = srExtentImmutable.getCenterY();
                cPointsOut = PeCSTransformations.projToGeog((PeProjcs)peProjcs, (int)1, (double[][])points);
                assert (cPointsOut == 1);
                gcsAxisCoordRad = points[0][0] * rpu;
            } else {
                points[0][0] = srExtentImmutable.getCenterX();
                points[0][1] = axisCoord;
                cPointsOut = PeCSTransformations.projToGeog((PeProjcs)peProjcs, (int)1, (double[][])points);
                assert (cPointsOut == 1);
                gcsAxisCoordRad = points[0][1] * rpu;
            }
        } else {
            assert (spatialReference.getCoordinateSystemType() == SpatialReference.Type.Geographic);
            gcsAxisCoordRad = axisCoord * rpu;
        }
        if (!bMeridian && gcsAxisCoordRad != 0.0 && curveType != 2) {
            throw new GeometryException("invalid argument");
        }
        PeDouble peDouble = new PeDouble();
        double[] t = new double[1];
        Point2D pt = new Point2D();
        Point2D gcsPt = new Point2D();
        Point2D gcsPt2 = new Point2D();
        Point2D[] gcsPts = new Point2D[2];
        Point2D pt1 = new Point2D();
        Point2D pt2 = new Point2D();
        Point2D GCSPt1 = new Point2D();
        Point2D GCSPt2 = new Point2D();
        int path = shape.getFirstPath(geometry);
        while (path != -1) {
            int startVertex;
            int firstVertex = shape.getFirstVertex(path);
            shape.getXY(firstVertex, pt1);
            boolean bStartedLoop = false;
            int vertex = startVertex = shape.getNextVertex(firstVertex);
            while (vertex != -1) {
                block29: {
                    int res;
                    block31: {
                        block32: {
                            block30: {
                                if (vertex == startVertex) {
                                    if (bStartedLoop) break;
                                    bStartedLoop = true;
                                }
                                shape.getXY(vertex, pt2);
                                if (!(bMeridian && (tolerance < axisCoord - pt1.x && pt2.x - axisCoord > tolerance || tolerance < axisCoord - pt2.x && pt1.x - axisCoord > tolerance)) && (bMeridian || !(axisCoord != 0.0 || tolerance < -pt1.y && pt2.y > tolerance) && (!(tolerance < -pt2.y) || !(pt1.y > tolerance))) || Math.abs(pt1.x - pt2.x) >= srXExtent.getWidth() * 0.5) break block29;
                                if (spatialReference.getCoordinateSystemType() == SpatialReference.Type.Projected) {
                                    points[0][0] = ProjectionUtils.normalizeX(pt1.x, srXExtent);
                                    points[0][1] = pt1.y;
                                    points[1][0] = ProjectionUtils.normalizeX(pt2.x, srXExtent);
                                    points[1][1] = pt2.y;
                                    int cPointsOut = PeCSTransformations.projToGeogCenter((PeProjcs)peProjcs, (int)2, (double[][])points, (double)0.0);
                                    assert (cPointsOut == 2);
                                    GCSPt1.x = points[0][0] * rpu;
                                    GCSPt1.y = points[0][1] * rpu;
                                    GCSPt2.y = points[1][1] * rpu;
                                } else {
                                    GCSPt1.x = pt1.x * rpu;
                                    GCSPt1.y = pt1.y * rpu;
                                    GCSPt2.y = pt2.y * rpu;
                                }
                                GCSPt2.x = (pt2.x - pt1.x) * 2.0 * Math.PI / srXExtent.getWidth() + GCSPt1.x;
                                res = 0;
                                if (!bMeridian) break block30;
                                gcsPt.x = gcsAxisCoordRad;
                                gcsPt.y = ProjectionUtils.intersectWithMeridian_(a, eSquared, GCSPt1, GCSPt2, gcsAxisCoordRad, curveType);
                                if (NumberUtils.isNaN(gcsPt.y)) break block29;
                                gcsPts[0] = gcsPt;
                                res = 1;
                                break block31;
                            }
                            if (curveType != 2) break block32;
                            double[] lons = new double[2];
                            res = RoundEarthUtils.intersect_great_elliptic_with_parallel(a, eSquared, GCSPt1, GCSPt2, gcsAxisCoordRad, lons);
                            if (res == 0) break block29;
                            gcsPt.x = lons[0];
                            gcsPt.y = gcsAxisCoordRad;
                            gcsPts[0] = gcsPt;
                            if (res == 2) {
                                gcsPt2.x = lons[1];
                                gcsPt2.y = gcsAxisCoordRad;
                                gcsPts[1] = gcsPt2;
                            }
                            break block31;
                        }
                        gcsPt.x = ProjectionUtils.intersectWithEquator_(a, eSquared, GCSPt1, GCSPt2, curveType);
                        if (NumberUtils.isNaN(gcsPt.x)) break block29;
                        gcsPt.y = 0.0;
                        gcsPts[0] = gcsPt;
                        res = 1;
                    }
                    double prev_t = -1.0;
                    for (int i = 0; i < res; ++i) {
                        PeLineType.geodetic_distance((double)a, (double)eSquared, (double)GCSPt1.x, (double)GCSPt1.y, (double)GCSPt2.x, (double)GCSPt2.y, (PeDouble)peDouble, null, null, (int)curveType);
                        double t1 = peDouble.val;
                        PeLineType.geodetic_distance((double)a, (double)eSquared, (double)GCSPt1.x, (double)GCSPt1.y, (double)gcsPts[i].x, (double)gcsPts[i].y, (PeDouble)peDouble, null, null, (int)curveType);
                        double t2 = peDouble.val;
                        if (spatialReference.getCoordinateSystemType() == SpatialReference.Type.Projected) {
                            points[0][0] = gcsPts[i].x / rpu;
                            points[0][1] = gcsPts[i].y / rpu;
                            int c_points_out = PeCSTransformations.geogToProj((PeProjcs)peProjcs, (int)1, (double[][])points);
                            assert (c_points_out == 1);
                            if (bMeridian) {
                                pt.y = points[0][1];
                                pt.x = axisCoord;
                            } else {
                                pt.x = ProjectionUtils.inverseNormalizeX(points[0][0], pt1.x, pt2.x, srXExtent);
                                pt.y = axisCoord;
                            }
                        } else if (bMeridian) {
                            pt.x = axisCoord;
                            pt.y = gcsPts[i].y / rpu;
                        } else {
                            pt.x = ProjectionUtils.inverseNormalizeX(gcsPts[i].x / rpu, pt1.x, pt2.x, srXExtent);
                            pt.y = axisCoord;
                        }
                        double d = t[0] = t1 > 0.0 ? NumberUtils.snap(t2 / t1, 0.0, 1.0) : 0.5;
                        if (t[0] == 0.0 || t[0] == 1.0) break;
                        if (prev_t > t[0]) continue;
                        int prevVertex = shape.getPrevVertex(vertex);
                        shape.splitSegment(prevVertex, t, 1);
                        int geodeticVertex = shape.getNextVertex(prevVertex);
                        shape.setXY(geodeticVertex, pt.x, pt.y);
                        prev_t = t[0];
                        assert (bMeridian && (pt1.x < pt.x && pt.x < pt2.x || pt1.x > pt.x && pt.x > pt2.x) || !bMeridian && (axisCoord != 0.0 || pt1.y < pt.y && pt.y < pt2.y || pt1.y > pt.y && pt.y > pt2.y));
                    }
                }
                pt1.setCoords(pt2);
                vertex = shape.getNextVertex(vertex);
            }
            path = shape.getNextPath(path);
        }
    }

    static double normalizeX(double x, Envelope1D interval) {
        double width = interval.vmax - interval.vmin;
        double xx = interval.snapClip(x - Math.floor((x - interval.vmin) / width) * width);
        return xx;
    }

    static double inverseNormalizeX(double x, double x1, double x2, Envelope1D srInterval) {
        Envelope1D interval = new Envelope1D();
        interval.setCoords(x1, x2);
        double period = srInterval.getWidth();
        double xx = Math.floor((x - x1) / period) * period + x;
        double c = interval.getCenter();
        while (Math.abs(xx - c) > Math.abs(xx + period - c)) {
            xx += period;
        }
        assert (interval.contains(xx) || Math.abs(interval.vmin - xx) < 1.0E-12 * (Math.abs(interval.vmin) + Math.abs(interval.vmax)) + 1.0E-14 || Math.abs(interval.vmax - xx) < 1.0E-12 * (Math.abs(interval.vmin) + Math.abs(interval.vmax)) + 1.0E-14);
        return xx;
    }

    private static boolean isXBetween_(double x1, double x2, double x) {
        double x1d = AngleUtils.convertToDegrees(x1);
        double x2d = AngleUtils.convertToDegrees(x2);
        double d_1 = AngleUtils.shorterArcDistance(x1d, x2d);
        double d_2 = AngleUtils.shorterArcDistance(x1d, AngleUtils.convertToDegrees(x));
        if (d_2 == 0.0) {
            return true;
        }
        if (d_1 > 0.0 && d_2 > 0.0 && d_2 <= d_1) {
            return true;
        }
        return d_1 < 0.0 && d_2 < 0.0 && d_2 >= d_1;
    }

    static double intersectWithMeridian_(double a, double eSquared, Point2D GCSPt1_, Point2D GCSPt2_, double x, int curveType) {
        Point2D GCSPt2;
        Point2D GCSPt1;
        if (curveType == 2) {
            double lat = RoundEarthUtils.intersect_great_elliptic_with_meridian(a, eSquared, GCSPt1_, GCSPt2_, x);
            return lat;
        }
        if (Math.abs(GCSPt1_.x - GCSPt2_.x) >= Math.PI || !ProjectionUtils.isXBetween_(GCSPt1_.x, GCSPt2_.x, x)) {
            return NumberUtils.NaN();
        }
        if (GCSPt1_.x > GCSPt2_.x) {
            GCSPt1 = GCSPt2_;
            GCSPt2 = GCSPt1_;
        } else {
            GCSPt1 = GCSPt1_;
            GCSPt2 = GCSPt2_;
        }
        PeDouble peAz1 = new PeDouble();
        PeDouble param1 = new PeDouble();
        PeDouble param2 = new PeDouble();
        PeLineType.geodetic_distance((double)a, (double)eSquared, (double)GCSPt1.x, (double)GCSPt1.y, (double)GCSPt2.x, (double)GCSPt2.y, (PeDouble)param1, (PeDouble)peAz1, null, (int)curveType);
        double len = param1.val;
        double leftFactor = 0.0;
        double rightFactor = 1.0;
        Point2D pt = new Point2D();
        pt.setCoords(GCSPt1);
        while (len * (rightFactor - leftFactor) > a * 1.0E-12) {
            double midFactor = 0.5 * (leftFactor + rightFactor);
            PeLineType.geodetic_coordinate((double)a, (double)eSquared, (double)GCSPt1.x, (double)GCSPt1.y, (double)(len * midFactor), (double)peAz1.val, (PeDouble)param1, (PeDouble)param2, (int)curveType);
            pt.x = param1.val;
            pt.y = param2.val;
            if (pt.x == x) {
                return pt.y;
            }
            if (ProjectionUtils.isXBetween_(GCSPt1.x, pt.x, x)) {
                rightFactor = midFactor;
                continue;
            }
            if (ProjectionUtils.isXBetween_(GCSPt2.x, pt.x, x)) {
                leftFactor = midFactor;
                continue;
            }
            assert (false);
            return NumberUtils.NaN();
        }
        return pt.y;
    }

    static double intersectWithEquator_(double a, double eSquared, Point2D GCSPt1_, Point2D GCSPt2_, int curveType) {
        Point2D GCSPt2;
        Point2D GCSPt1;
        if (curveType == 2) {
            double[] lons = new double[2];
            RoundEarthUtils.intersect_great_elliptic_with_parallel(a, eSquared, GCSPt1_, GCSPt2_, 0.0, lons);
            return lons[0];
        }
        if (GCSPt1_.y > GCSPt2_.y) {
            GCSPt1 = GCSPt2_;
            GCSPt2 = GCSPt1_;
        } else {
            GCSPt1 = GCSPt1_;
            GCSPt2 = GCSPt2_;
        }
        Envelope1D interval = new Envelope1D();
        interval.setCoords(GCSPt1.y, GCSPt2.y);
        if (!interval.contains(0.0) || Math.abs(GCSPt1.x - GCSPt2.x) >= Math.PI) {
            return NumberUtils.NaN();
        }
        if (GCSPt1.x == GCSPt2.x) {
            return GCSPt1.x;
        }
        PeDouble peAz1 = new PeDouble();
        PeDouble param1 = new PeDouble();
        PeDouble param2 = new PeDouble();
        PeLineType.geodetic_distance((double)a, (double)eSquared, (double)GCSPt1.x, (double)GCSPt1.y, (double)GCSPt2.x, (double)GCSPt2.y, (PeDouble)param1, (PeDouble)peAz1, null, (int)curveType);
        double len = param1.val;
        double leftFactor = 0.0;
        double rightFactor = 1.0;
        Point2D pt = new Point2D();
        pt.setCoords(GCSPt1);
        while (len * (rightFactor - leftFactor) > a * 1.0E-12) {
            double midFactor = 0.5 * (leftFactor + rightFactor);
            PeLineType.geodetic_coordinate((double)a, (double)eSquared, (double)GCSPt1.x, (double)GCSPt1.y, (double)(len * midFactor), (double)peAz1.val, (PeDouble)param1, (PeDouble)param2, (int)curveType);
            pt.x = param1.val;
            pt.y = param2.val;
            interval.setCoords(GCSPt1.y, pt.y);
            if (pt.y == 0.0) {
                return pt.x;
            }
            if (interval.contains(0.0)) {
                rightFactor = midFactor;
                continue;
            }
            interval.setCoords(GCSPt2.y, pt.y);
            if (interval.contains(0.0)) {
                leftFactor = midFactor;
                continue;
            }
            assert (false);
            return NumberUtils.NaN();
        }
        return pt.x;
    }

    static int transformPointsInPlace(ProjectionTransformation projectionTransform, double[] points_in, int srcPosXY, int countXY, double[] points_out, int dstPosXY) {
        if (points_in == points_out && srcPosXY != dstPosXY) {
            throw new IllegalArgumentException();
        }
        if (countXY <= 0) {
            return 0;
        }
        if (projectionTransform.isIdentity()) {
            System.arraycopy(points_in, srcPosXY * 2, points_out, dstPosXY * 2, countXY * 2);
            return countXY;
        }
        if (countXY <= 2) {
            Point2D[] pts = new Point2D[]{new Point2D(), new Point2D()};
            for (int i = 0; i < countXY; ++i) {
                pts[i].setCoords(points_in[2 * i], points_in[2 * i + 1]);
            }
            int res = OperatorProject.local().transform(projectionTransform, pts, countXY, pts, false);
            for (int i = 0; i < countXY; ++i) {
                points_out[2 * i] = pts[i].x;
                points_out[2 * i + 1] = pts[i].y;
            }
            return res;
        }
        ProjectionTransformationImpl transformSG = (ProjectionTransformationImpl)projectionTransform;
        SpatialReferenceImpl inSR = (SpatialReferenceImpl)transformSG.getInputSR();
        SpatialReferenceImpl outSR = (SpatialReferenceImpl)transformSG.getOutputSR();
        SpatialReference.Type srTypeIn = inSR.getCoordinateSystemType();
        SpatialReference.Type srTypeOut = outSR.getCoordinateSystemType();
        if (srTypeIn == SpatialReference.Type.Local && srTypeIn == srTypeOut) {
            double factorIn = inSR.getHorzUnitFactor();
            double factorOut = outSR.getHorzUnitFactor();
            double coef = factorIn / factorOut;
            Transformation2D trans = new Transformation2D();
            trans.setScale(coef, coef);
            trans.transform(points_in, srcPosXY, points_out, dstPosXY, countXY);
            return countXY;
        }
        MultiPoint mp = new MultiPoint();
        MultiPointImpl mpImpl = (MultiPointImpl)mp._getImpl();
        mp.addAttribute(3);
        mp.resize(countXY);
        AttributeStreamOfDbl src_xy = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(0);
        AttributeStreamOfInt32 ids = (AttributeStreamOfInt32)mpImpl.getAttributeStreamRef(3);
        int i = 0;
        int posIn = srcPosXY * 2;
        int posOut = dstPosXY * 2;
        while (i < countXY) {
            double x = points_in[posIn++];
            double y = points_in[posIn++];
            int id = posOut;
            if (NumberUtils.isNaN(x) || NumberUtils.isNaN(y)) {
                x = 0.0;
                y = 0.0;
                id = -1;
            }
            ids.write(i, id);
            src_xy.write(2 * i, x);
            src_xy.write(2 * i + 1, y);
            ++i;
            posOut += 2;
        }
        mp.notifyModified();
        MultiPoint mpResult = (MultiPoint)OperatorProject.local().execute(mp, projectionTransform, null);
        int i2 = 0;
        int j = dstPosXY * 2;
        int n = countXY;
        while (i2 < n) {
            points_out[j] = Double.NaN;
            points_out[j + 1] = Double.NaN;
            ++i2;
            j += 2;
        }
        if (mpResult.isEmpty()) {
            return 0;
        }
        MultiPointImpl mpResImpl = (MultiPointImpl)mpResult._getImpl();
        AttributeStreamOfInt32 res_ids = (AttributeStreamOfInt32)mpResImpl.getAttributeStreamRef(3);
        AttributeStreamOfDbl res_xy = (AttributeStreamOfDbl)mpResImpl.getAttributeStreamRef(0);
        int sizeXY = 0;
        int n2 = mpResult.getPointCount();
        for (int i3 = 0; i3 < n2; ++i3) {
            int index = res_ids.read(i3);
            if (index == -1) continue;
            double x = res_xy.read(2 * i3);
            double y = res_xy.read(2 * i3 + 1);
            points_out[index] = x;
            points_out[index + 1] = y;
            ++sizeXY;
        }
        return sizeXY;
    }

    static boolean projectMultiPathVerticesPCSToGCS(ProjectionTransformation pcs_to_gcs, MultiPath multi_path_src, MultiPath multi_path_dst, ProgressTracker progress_tracker) {
        double coef2;
        double coef;
        assert (pcs_to_gcs.getGeographicTransformations() == null);
        if (!pcs_to_gcs.getInputSR().isPannable()) {
            return false;
        }
        MultiPoint mplocal = new MultiPoint(multi_path_src.getDescription());
        mplocal.add(multi_path_src, 0, -1);
        MultiPoint mpresult = (MultiPoint)OperatorProject.local().execute(mplocal, pcs_to_gcs, progress_tracker);
        int pc = multi_path_src.getPointCount();
        multi_path_dst.setEmpty();
        if (pc != mpresult.getPointCount()) {
            return false;
        }
        Envelope2D env1 = new Envelope2D();
        multi_path_src.queryEnvelope2D(env1);
        Envelope2D env2 = new Envelope2D();
        mpresult.queryEnvelope2D(env2);
        double width1 = env1.getWidth();
        double width2 = env2.getWidth();
        if (width1 != 0.0 && width2 != 0.0 ? Math.abs((coef = width2 / width1) / (coef2 = pcs_to_gcs.getOutputSR().getPannableExtent().getWidth() / pcs_to_gcs.getInputSR().getPannableExtent().getWidth()) - 1.0) > 1.0E-10 : width1 != 0.0 || width2 != 0.0) {
            return false;
        }
        multi_path_dst.add(multi_path_src, false);
        Point2D pt = new Point2D();
        for (int i = 0; i < pc; ++i) {
            mpresult.getXY(i, pt);
            multi_path_dst.setXY(i, pt);
        }
        return true;
    }

    public static double adjustCentralMeridian(double central_meridian, double gcs1) {
        double adjusted = central_meridian % (gcs1 * 360.0);
        if (adjusted >= gcs1 * 180.0) {
            adjusted -= gcs1 * 360.0;
        }
        return adjusted;
    }

    public static MultiPath processWithPCSHorizon(MultiPath input_geometry, SpatialReferenceImpl pcsSR, HorizonClipOption clip_option, ProgressTracker progressTracker) {
        MultiPath multi_path = input_geometry;
        if (clip_option == HorizonClipOption.Clip) {
            Geometry pcsHorizon = pcsSR.getPCSHorizon();
            Geometry.Type PCSHorizonType = pcsHorizon.getType();
            if (PCSHorizonType == Geometry.Type.Envelope) {
                Envelope2D horizonEnv2D = new Envelope2D();
                pcsHorizon.queryEnvelope2D(horizonEnv2D);
                double tolerancePCS = InternalUtils.calculateToleranceFromGeometryForRel((SpatialReference)pcsSR, horizonEnv2D, false);
                multi_path = (MultiPath)Clipper.clip(multi_path, horizonEnv2D, tolerancePCS, pcsSR.getOneMeterPCSUnit() * 50000.0, progressTracker);
            } else if (!OperatorContains.local().execute(pcsHorizon, multi_path, pcsSR, progressTracker) && (multi_path = (MultiPath)OperatorIntersection.local().execute(multi_path, pcsHorizon, (SpatialReference)pcsSR, progressTracker)) == pcsHorizon) {
                multi_path = (MultiPath)MultiPath._clone(multi_path);
            }
        } else if (pcsSR.isPannable()) {
            Envelope2D ge = new Envelope2D();
            multi_path.queryLooseEnvelope(ge);
            if (!pcsSR.getPannableExtentByReferenceInternal().contains(ge)) {
                ProjectionUtils.snapToHorizonEnvelope(multi_path, pcsSR.getPannableExtentByReferenceInternal(), pcsSR.getTolerance(0), true);
                if (clip_option == HorizonClipOption.PannableFold) {
                    multi_path = (MultiPath)ProjectionUtils.clipGeometryFromTopAndBottom(multi_path, pcsSR);
                }
                multi_path = (MultiPath)ProjectionUtils.foldInto360DegreeRange(multi_path, pcsSR, 0.0, true, pcsSR.getOneMeterPCSUnit() * 100000.0, null);
            }
        }
        return multi_path;
    }

    public static MultiPath applySplitLines(MultiPath multiPath, SpatialReferenceImpl pcs, ProgressTracker progress_tarcker) {
        Polyline splitLines = pcs.getGCSSplitLines();
        if (splitLines == null) {
            return multiPath;
        }
        SpatialReferenceImpl gcs = (SpatialReferenceImpl)pcs.getGCS();
        double gcs360 = gcs.getPannableExtentByReferenceInternal().getWidth();
        Envelope2D envGeom = new Envelope2D();
        multiPath.queryLooseEnvelope(envGeom);
        Envelope1D envXGeom = new Envelope1D();
        envGeom.queryIntervalX(envXGeom);
        SegmentIterator segIter = splitLines.querySegmentIterator();
        Polyline normalizedSplitLines = null;
        Transformation2D offset = new Transformation2D();
        while (segIter.nextPath()) {
            while (segIter.hasNextSegment()) {
                Segment seg = segIter.nextSegment();
                Envelope1D xInterval = seg.queryInterval(0, 0);
                Envelope1D interval = new Envelope1D();
                interval.setCoords(xInterval);
                int count = 0;
                while (interval.vmax > envXGeom.vmin) {
                    interval.move(-gcs360);
                    --count;
                }
                while (interval.vmin <= envXGeom.vmax) {
                    if (interval.isIntersecting(envXGeom)) {
                        if (normalizedSplitLines == null) {
                            normalizedSplitLines = new Polyline();
                        }
                        Line line = new Line(seg.getStartXY(), seg.getEndXY());
                        if (count != 0) {
                            offset.setShift((double)count * gcs360, 0.0);
                            line.applyTransformation(offset);
                        }
                        normalizedSplitLines.addSegment(line, true);
                    }
                    interval.move(gcs360);
                    ++count;
                }
            }
        }
        if (normalizedSplitLines != null) {
            double tolerance = InternalUtils.calculateToleranceFromGeometryForOp((SpatialReference)gcs, normalizedSplitLines, true);
            tolerance = InternalUtils.adjust_tolerance_for_TE_clustering(tolerance);
            return Cracker.crackAWithB(multiPath, normalizedSplitLines, tolerance, progress_tarcker);
        }
        return multiPath;
    }

    public static double calculateIntervalShift(double left, double right, double horizonLeftX, double horizonRightX, double period) {
        if (left >= horizonLeftX && right <= horizonRightX) {
            return 0.0;
        }
        double value = (right + left) * 0.5;
        double shift = ProjectionUtils.calculateShift(value, horizonLeftX, horizonRightX, period);
        return shift;
    }

    public static double calculateShift(double value, double horizonLeftX, double horizonRightX, double period) {
        double horizonMiddle = (horizonRightX + horizonLeftX) * 0.5;
        double n = MathUtils.round((horizonMiddle - value) / period);
        double shift = n * period;
        return shift;
    }

    public static Polyline geoNormalizePolylineGeometry(Polyline originalMultipath, SpatialReferenceImpl originalSR, Polyline poly, SpatialReferenceImpl pannableSR, double centralLongitude, ProgressTracker progressTracker, int poleFlags, double poleSnappingTolerance) {
        Envelope2D pannableExtent = ProjectionUtils.getAdjustedPannableExtent(pannableSR, centralLongitude);
        double width360 = pannableExtent.getWidth();
        double degree = width360 / 360.0;
        double GCSLargeDelta = 210.0 * degree;
        AttributeStreamOfDbl originalXYStream = (AttributeStreamOfDbl)((MultiPathImpl)originalMultipath._getImpl()).getAttributeStreamRef(0);
        boolean compareWithOriginal = originalSR.isPannable();
        double origianalToGCS = compareWithOriginal ? width360 / originalSR.getPannableExtentByReferenceInternal().getWidth() : 0.0;
        boolean adjustedAtPoles = false;
        Polyline geoNormalizedResult = (Polyline)originalMultipath.createInstance();
        int npaths = poly.getPathCount();
        for (int ipath = 0; ipath < npaths; ++ipath) {
            Point2D end;
            Point2D start;
            boolean comparePathWithOriginal = compareWithOriginal;
            Polyline singlePartPath = new Polyline(poly.getDescription());
            singlePartPath.addPath(poly, ipath, true);
            boolean closed = poly.isClosedPath(ipath);
            if (poleFlags != 0 && (adjustedAtPoles = ProjectionUtils.adjustPathAtPoles(closed, singlePartPath, pannableExtent.ymax - poleSnappingTolerance, pannableExtent.ymax, poleFlags))) {
                comparePathWithOriginal = false;
            }
            int originalPathStart = -1;
            int singlePartPathPointCount = singlePartPath.getPointCount();
            boolean originalPathClosed = false;
            if (comparePathWithOriginal) {
                originalPathStart = originalMultipath.getPathStart(ipath);
                originalPathClosed = originalMultipath.isClosedPath(ipath);
            }
            AttributeStreamOfDbl xyStream = (AttributeStreamOfDbl)((MultiPathImpl)singlePartPath._getImpl()).getAttributeStreamRef(0);
            double xShift = 0.0;
            double xPrev = xyStream.read(0);
            int largeDeltas = 0;
            double tol3 = 3.0 * pannableSR.getTolerance(0);
            boolean ringSimplifyIsNeeded = false;
            Point2D pt2 = new Point2D();
            pt2.setNaN();
            Point2D pt1 = new Point2D();
            pt1.setNaN();
            boolean writeValues = false;
            for (int i = 1; i < singlePartPathPointCount; ++i) {
                Point2D pt = new Point2D(xyStream.readAsDbl(2 * i), xyStream.readAsDbl(2 * i + 1));
                double xRead = pt.x;
                double x = xRead + xShift;
                double step = x - xPrev;
                pt.x = x;
                if (Math.abs(step) > GCSLargeDelta) {
                    if (comparePathWithOriginal) {
                        int i1 = originalPathStart + i - 1;
                        int i2 = originalPathStart;
                        if (!originalPathClosed || i + 1 < singlePartPathPointCount) {
                            i2 += i;
                        }
                        double orgXPrev = originalXYStream.read(i1 * 2);
                        double orgX = originalXYStream.read(i2 * 2);
                        double orgStep = (orgX - orgXPrev) * origianalToGCS;
                        if (Math.abs(step - orgStep) > 1.0 * degree) {
                            compareWithOriginal = false;
                        }
                    }
                    if (!comparePathWithOriginal) {
                        double correction = MathUtils.copySign(width360, x - xPrev);
                        x = xRead + (xShift -= correction);
                        ++largeDeltas;
                        writeValues = xShift != 0.0;
                        pt.x = x;
                    }
                } else if (!ringSimplifyIsNeeded && InternalUtils.isAngleTooSharp(pt2, pt1, pt, tol3, true)) {
                    ringSimplifyIsNeeded = true;
                }
                if (writeValues) {
                    xyStream.write(2 * i, x);
                }
                xPrev = x;
                pt2.setCoords(pt1);
                pt1.setCoords(pt);
            }
            if (largeDeltas != 0) {
                ((MultiPathImpl)singlePartPath._getImpl()).notifyModified(2001);
            }
            boolean ringIsClosed = Point2D.distance(start = singlePartPath.getXY(0), end = singlePartPath.getXY(singlePartPathPointCount - 1)) < tol3;
            double central_longitude = NumberUtils.isNaN(centralLongitude) ? 0.0 : centralLongitude;
            Polyline result = ProjectionUtils.finalizeGeoNormalizePolylinePath(originalMultipath, ipath, singlePartPath, ringIsClosed, pannableSR, central_longitude, progressTracker);
            geoNormalizedResult.add(result, false);
        }
        double tol = pannableSR.getTolerance(0);
        double twoDegreeDensify = pannableExtent.getWidth() / 180.0;
        ProjectionUtils.snapToHorizonEnvelope(geoNormalizedResult, pannableExtent, tol * 0.1, false);
        Polyline restoredPolylineClipped = (Polyline)Clipper.clip(geoNormalizedResult, pannableExtent, tol, twoDegreeDensify, progressTracker);
        geoNormalizedResult = null;
        return restoredPolylineClipped;
    }

    private static Polyline finalizeGeoNormalizePolylinePath(Polyline originalMultipath, int originalPathIndex, Polyline onePathPolyline, boolean newPathIsClosed, SpatialReferenceImpl pannableSR, double central_longitude, ProgressTracker progressTracker) {
        Polyline resPoly = onePathPolyline;
        return (Polyline)ProjectionUtils.foldInto360DegreeRange(resPoly, pannableSR, central_longitude, true, 0.0, progressTracker);
    }

    static void intersectArrayWithPolygonOrEnv(Geometry geom, SpatialReference sr, Point2D[] points, int count) {
        Geometry.Type type = geom.getType();
        if (type == Geometry.Type.Polygon) {
            double tol = sr != null ? sr.getTolerance(0) : 0.0;
            Polygon polygon = (Polygon)geom;
            for (int i = 0; i < count; ++i) {
                if (PolygonUtils.PiPResult.PiPInside == PolygonUtils.isPointInPolygon2D(polygon, points[i], tol)) continue;
                points[i].setNaN();
            }
            return;
        }
        if (type == Geometry.Type.Envelope) {
            Envelope env = (Envelope)geom;
            for (int i = 0; i < count; ++i) {
                if (env.contains(points[i])) continue;
                points[i].setNaN();
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    static void clipImage(ExternalTransform et, Point2D[] points, int count, boolean input_true_output_false) {
        if (count < 32) {
            Point pt = new Point();
            for (int i = 0; i < count; ++i) {
                pt.setXY(points[i]);
                ((Point)et.clipImage(pt, input_true_output_false)).getXY(points[i]);
            }
        } else {
            MultiPoint mpt = new MultiPoint();
            mpt.addAttribute(3);
            mpt.reserve(count);
            mpt.addPoints(points, 0, count);
            AttributeStreamOfInt32 ids = (AttributeStreamOfInt32)mpt.getAttributeStreamRef(3);
            for (int i = 0; i < count; ++i) {
                ids.write(i, i);
            }
            Geometry res = et.clipImage(mpt, input_true_output_false);
            MultiPoint res_mp = (MultiPoint)res;
            AttributeStreamOfDbl xy = (AttributeStreamOfDbl)res_mp.getAttributeStreamRef(0);
            ids = (AttributeStreamOfInt32)res_mp.getAttributeStreamRef(3);
            Arrays.fill(points, 0, count, new Point2D(Double.NaN, Double.NaN));
            int res_count = res_mp.getPointCount();
            for (int i = 0; i < res_count; ++i) {
                int pos = ids.read(i);
                xy.read(i * 2, points[pos]);
            }
        }
    }

    static void clipBase(ExternalTransform et, Point2D[] points, int count, boolean input_true_output_false) {
        if (count < 32) {
            Point pt = new Point();
            for (int i = 0; i < count; ++i) {
                pt.setXY(points[i]);
                ((Point)et.clipBase(pt, input_true_output_false)).getXY(points[i]);
            }
        } else {
            MultiPoint mpt = new MultiPoint();
            mpt.addAttribute(3);
            mpt.reserve(count);
            mpt.addPoints(points, 0, count);
            AttributeStreamOfInt32 ids = (AttributeStreamOfInt32)mpt.getAttributeStreamRef(3);
            for (int i = 0; i < count; ++i) {
                ids.write(i, i);
            }
            Geometry res = et.clipBase(mpt, input_true_output_false);
            MultiPoint res_mp = (MultiPoint)res;
            AttributeStreamOfDbl xy = (AttributeStreamOfDbl)res_mp.getAttributeStreamRef(0);
            ids = (AttributeStreamOfInt32)res_mp.getAttributeStreamRef(3);
            Arrays.fill(points, 0, count, new Point2D(Double.NaN, Double.NaN));
            int res_count = res_mp.getPointCount();
            for (int i = 0; i < res_count; ++i) {
                int pos = ids.read(i);
                xy.read(i * 2, points[pos]);
            }
        }
    }

    static class PolygonFromPolylineHelper {
        private MultiPath m_polyline;
        private Envelope2D m_extent = new Envelope2D();

        private static void add_boundary_points_(Point2D p0, Point2D p_1, Polygon polygon, Envelope2D env_2D, boolean clockwise, double densify_dist) {
            double bound_dist_1;
            assert (env_2D.isPointOnBoundary(p0, 0.0) && env_2D.isPointOnBoundary(p_1, 0.0));
            double bound_dist_0 = env_2D._boundaryDistance(p0);
            if (bound_dist_0 == (bound_dist_1 = env_2D._boundaryDistance(p_1))) {
                return;
            }
            if (bound_dist_1 == 0.0) {
                bound_dist_1 = env_2D.getLength();
            }
            int side_0 = env_2D._envelopeSide(p0);
            int side_1 = env_2D._envelopeSide(p_1);
            if (p_1.isEqual(env_2D.queryCorner(side_1))) {
                side_1 = side_1 + 3 & 3;
            }
            if (side_0 == side_1 && bound_dist_1 > bound_dist_0 == clockwise) {
                int c_points;
                Point2D delta = new Point2D();
                delta.setCoords(p_1.x - p0.x, p_1.y - p0.y);
                if (densify_dist != 0.0 && (c_points = (int)(delta.norm(0) / densify_dist)) != 0) {
                    delta.scale(1.0 / (double)(c_points + 1));
                    for (int i = 0; i < c_points; ++i) {
                        p0.add(delta);
                        polygon.lineTo(p0);
                    }
                }
            } else {
                do {
                    if (clockwise) {
                        side_0 = side_0 + 1 & 3;
                    }
                    Point2D corner = env_2D.queryCorner(side_0);
                    if (densify_dist != 0.0) {
                        PolygonFromPolylineHelper.add_boundary_points_(p0, corner, polygon, env_2D, clockwise, densify_dist);
                    }
                    polygon.lineTo(corner);
                    p0 = corner;
                    if (clockwise) continue;
                    side_0 = side_0 + 3 & 3;
                } while (side_0 != side_1);
                if (densify_dist != 0.0) {
                    PolygonFromPolylineHelper.add_boundary_points_(p0, p_1, polygon, env_2D, clockwise, densify_dist);
                }
            }
        }

        Polygon create_polygon_from_polyline_impl_(boolean add_envelope, double tolerance, double densify_dist, int corner_is_inside) {
            int j_path;
            double boundary_distance_1;
            double boundary_distance_0;
            int idx_to;
            int idx_from;
            int path;
            int c_paths = this.m_polyline.getPathCount();
            ArrayList<Boundary_struct> boundary_struct_array = new ArrayList<Boundary_struct>();
            boundary_struct_array.ensureCapacity(c_paths * 2);
            ArrayList<Path_struct> path_struct_array = new ArrayList<Path_struct>();
            boundary_struct_array.ensureCapacity(c_paths);
            for (int i = 0; i < c_paths; ++i) {
                path_struct_array.add(new Path_struct());
            }
            boolean clockwise = true;
            Point2D from_point_2D = new Point2D();
            Point2D to_point_2D = new Point2D();
            int i_ring = -1;
            Polygon polygon = new Polygon(this.m_polyline.getDescription());
            for (path = 0; path < c_paths; ++path) {
                Path_struct pathStruct = new Path_struct();
                pathStruct.initialize();
                idx_from = this.m_polyline.getPathStart(path);
                this.m_polyline.getXY(idx_from, from_point_2D);
                idx_to = this.m_polyline.getPathEnd(path) - 1;
                this.m_polyline.getXY(idx_to, to_point_2D);
                boolean from_point_on_boundary = this.m_extent.isPointOnBoundary(from_point_2D, 0.0);
                boolean to_point_on_boundary = this.m_extent.isPointOnBoundary(to_point_2D, 0.0);
                boundary_distance_0 = from_point_on_boundary ? this.m_extent._boundaryDistance(from_point_2D) : -1.0;
                double d = boundary_distance_1 = to_point_on_boundary ? this.m_extent._boundaryDistance(to_point_2D) : -1.0;
                if (boundary_distance_0 != boundary_distance_1) {
                    Boundary_struct boundaryStruct;
                    if (from_point_on_boundary) {
                        boundaryStruct = new Boundary_struct();
                        boundaryStruct.set_values(boundary_distance_0, path, idx_from, true);
                        boundary_struct_array.add(boundaryStruct);
                        pathStruct.m_boundary_dist_1 = boundary_distance_0;
                    }
                    if (to_point_on_boundary) {
                        boundaryStruct = new Boundary_struct();
                        boundaryStruct.set_values(boundary_distance_1, path, idx_to - 1, false);
                        boundary_struct_array.add(boundaryStruct);
                        pathStruct.m_boundary_dist_2 = boundary_distance_1;
                    } else {
                        boolean paths_connect = false;
                        int minj_path = -1;
                        double min_dist = Double.MAX_VALUE;
                        j_path = path;
                        Path_struct temp_path_struct1 = null;
                        while (!paths_connect && (j_path = (j_path + c_paths - 1) % c_paths) != path) {
                            temp_path_struct1 = (Path_struct)path_struct_array.get(j_path);
                            if (j_path < path) {
                                paths_connect = temp_path_struct1.m_boundary_dist_1 < 0.0 && temp_path_struct1.m_boundary_dist_2 >= 0.0;
                                continue;
                            }
                            idx_from = this.m_polyline.getPathStart(j_path);
                            this.m_polyline.getXY(idx_from, from_point_2D);
                            double dist = Point2D.distance(from_point_2D, to_point_2D);
                            boolean bl = paths_connect = dist == 0.0;
                            if (!(min_dist > dist)) continue;
                            min_dist = dist;
                            minj_path = j_path;
                        }
                        if (!paths_connect && min_dist < NumberUtils.doubleEps() * 10.0 * this.m_extent.getWidth()) {
                            j_path = minj_path;
                        }
                        assert (j_path != path);
                        if (j_path == path) {
                            throw GeometryException.GeometryInternalError();
                        }
                        Path_struct temp_path_struct = new Path_struct();
                        temp_path_struct.assign(temp_path_struct1);
                        pathStruct.m_next_path = j_path;
                        temp_path_struct.m_prev_path = path;
                        path_struct_array.set(j_path, temp_path_struct);
                    }
                }
                path_struct_array.set(path, pathStruct);
            }
            boolean left_lower_inside = true;
            boundary_distance_0 = -1.0;
            boundary_distance_1 = -1.0;
            int c_boundary_structs = boundary_struct_array.size();
            assert ((c_boundary_structs & 1) == 0);
            if (c_boundary_structs != 0) {
                Collections.sort(boundary_struct_array, new Clipper_compare_boundary_structs());
                Boundary_struct boundary_struct_1 = (Boundary_struct)boundary_struct_array.get(0);
                boolean bl = left_lower_inside = corner_is_inside > 0;
                if (corner_is_inside == -1) {
                    left_lower_inside = boundary_struct_1.m_is_from_point;
                }
                int i_boundary_struct = c_boundary_structs;
                boolean first = true;
                while (i_boundary_struct >= 2) {
                    boolean is_from_2;
                    boolean is_from_1;
                    if (!first || !left_lower_inside) {
                        boundary_struct_1 = (Boundary_struct)boundary_struct_array.get(--i_boundary_struct);
                    }
                    Boundary_struct boundary_struct_2 = (Boundary_struct)boundary_struct_array.get(--i_boundary_struct);
                    if (first && left_lower_inside) {
                        boundary_distance_0 = boundary_struct_1.m_dist;
                        boundary_distance_1 = boundary_struct_2.m_dist;
                    }
                    first = false;
                    int path_1 = boundary_struct_1.m_path;
                    int path_2 = boundary_struct_2.m_path;
                    Path_struct path_struct_1 = (Path_struct)path_struct_array.get(path_1);
                    boolean bl2 = is_from_1 = boundary_struct_1.m_dist == path_struct_1.m_boundary_dist_1 == path_struct_1.m_forward;
                    if (path_1 == path_2) {
                        path_struct_1.m_next_path = path_1;
                        path_struct_1.m_prev_path = path_1;
                        continue;
                    }
                    Path_struct path_struct_2 = (Path_struct)path_struct_array.get(path_2);
                    boolean bl3 = is_from_2 = boundary_struct_2.m_dist == path_struct_2.m_boundary_dist_1 == path_struct_2.m_forward;
                    if (is_from_1 == is_from_2) {
                        is_from_2 = !is_from_2;
                        path_struct_2.reverse();
                        int n = path = is_from_1 ? path_struct_2.m_prev_path : path_struct_2.m_next_path;
                        while (path >= 0) {
                            Path_struct pathStruct = (Path_struct)path_struct_array.get(path);
                            pathStruct.reverse();
                            path = is_from_1 ? pathStruct.m_prev_path : pathStruct.m_next_path;
                        }
                    }
                    if (is_from_1) {
                        path_struct_1.m_prev_path = path_2;
                        path_struct_2.m_next_path = path_1;
                        continue;
                    }
                    path_struct_1.m_next_path = path_2;
                    path_struct_2.m_prev_path = path_1;
                }
            }
            for (path = 0; path < c_paths; ++path) {
                Path_struct pathStruct = (Path_struct)path_struct_array.get(path);
                if (!pathStruct.m_active) continue;
                boolean forward = pathStruct.m_forward;
                if (pathStruct.m_boundary_dist_1 < 0.0 && pathStruct.m_boundary_dist_2 < 0.0) {
                    ++i_ring;
                    polygon.addPath(this.m_polyline, path, forward);
                    polygon.removePoint(-1, -1);
                    continue;
                }
                if ((forward ? pathStruct.m_boundary_dist_1 : pathStruct.m_boundary_dist_2) < 0.0) continue;
                ++i_ring;
                polygon.addPath(this.m_polyline, path, forward);
                pathStruct.m_active = false;
                j_path = path;
                int iter = c_paths + 1;
                while (--iter != 0) {
                    int offset;
                    double bound_dist_1;
                    while (forward ? pathStruct.m_boundary_dist_2 < 0.0 : pathStruct.m_boundary_dist_1 < 0.0) {
                        j_path = pathStruct.m_next_path;
                        Path_struct ps = (Path_struct)path_struct_array.get(j_path);
                        pathStruct = new Path_struct();
                        pathStruct.assign(ps);
                        forward = pathStruct.m_forward;
                        if (forward) {
                            polygon.insertPoints(i_ring, -1, this.m_polyline, j_path, 1, this.m_polyline.getPathSize(j_path) - 1, true);
                        } else {
                            polygon.insertPoints(i_ring, -1, this.m_polyline, j_path, 0, this.m_polyline.getPathSize(j_path) - 2, false);
                        }
                        pathStruct.m_active = false;
                        path_struct_array.set(j_path, pathStruct);
                    }
                    forward = pathStruct.m_forward;
                    idx_to = forward ? this.m_polyline.getPathEnd(j_path) - 1 : this.m_polyline.getPathStart(j_path);
                    to_point_2D = this.m_polyline.getXY(idx_to);
                    double bound_dist_0 = forward ? pathStruct.m_boundary_dist_2 : pathStruct.m_boundary_dist_1;
                    j_path = pathStruct.m_next_path;
                    assert (j_path >= 0);
                    Path_struct ps = (Path_struct)path_struct_array.get(j_path);
                    pathStruct = new Path_struct();
                    pathStruct.assign(ps);
                    forward = pathStruct.m_forward;
                    idx_from = forward ? this.m_polyline.getPathStart(j_path) : this.m_polyline.getPathEnd(j_path) - 1;
                    from_point_2D = this.m_polyline.getXY(idx_from);
                    double d = bound_dist_1 = forward ? pathStruct.m_boundary_dist_1 : pathStruct.m_boundary_dist_2;
                    if (corner_is_inside >= 0) {
                        assert (this.m_extent.isPointOnBoundary(to_point_2D, 0.0) && this.m_extent.isPointOnBoundary(from_point_2D, 0.0));
                        if (left_lower_inside && bound_dist_0 == boundary_distance_0 && bound_dist_1 == boundary_distance_1) {
                            left_lower_inside = false;
                            clockwise = false;
                        } else if (left_lower_inside && bound_dist_0 == boundary_distance_1 && bound_dist_1 == boundary_distance_0) {
                            left_lower_inside = false;
                            clockwise = true;
                        } else {
                            clockwise = bound_dist_0 < bound_dist_1;
                        }
                    }
                    int interpolate_from_idx = polygon.getPointCount() - 1;
                    PolygonFromPolylineHelper.add_boundary_points_(to_point_2D, from_point_2D, polygon, this.m_extent, clockwise, densify_dist);
                    if (j_path == path) {
                        offset = polygon.getPathEnd(i_ring - 1);
                        polygon.interpolateAttributes(i_ring, interpolate_from_idx -= offset, 0);
                        break;
                    }
                    pathStruct.m_active = false;
                    path_struct_array.set(j_path, pathStruct);
                    boolean is_endpoint_inside = pathStruct.m_forward ? pathStruct.m_boundary_dist_2 < 0.0 : pathStruct.m_boundary_dist_1 < 0.0;
                    polygon.insertPoints(i_ring, -1, this.m_polyline, j_path, 0, this.m_polyline.getPathSize(j_path), pathStruct.m_forward);
                    int interpolate_to_idx = polygon.getPointCount() - this.m_polyline.getPathSize(j_path);
                    if (i_ring > 0) {
                        offset = polygon.getPathEnd(i_ring - 1);
                        interpolate_from_idx -= offset;
                        interpolate_to_idx -= offset;
                    }
                    polygon.interpolateAttributes(i_ring, interpolate_from_idx, interpolate_to_idx);
                    assert (!is_endpoint_inside || pathStruct.m_next_path != path);
                }
                assert (iter > 0);
            }
            if (add_envelope && polygon.calculateArea2D() < 0.0) {
                Polygon res_poly;
                if (densify_dist != 0.0) {
                    Envelope env_extent = new Envelope(this.m_extent);
                    res_poly = (Polygon)OperatorDensifyByLength.local().execute(env_extent, densify_dist, null);
                } else {
                    res_poly = new Polygon(polygon.getDescription());
                    res_poly.addEnvelope(this.m_extent, false);
                }
                res_poly.add(polygon, false);
                polygon = res_poly;
            }
            return polygon;
        }

        PolygonFromPolylineHelper(Envelope2D extent) {
            this.m_extent.setCoords(extent);
        }

        static Polygon create_polygon_from_polyline(MultiPath polyline, Envelope2D env_2D, boolean add_envelope, double tolerance, double densify_dist, int corner_is_inside) {
            PolygonFromPolylineHelper clipper = new PolygonFromPolylineHelper(env_2D);
            clipper.m_polyline = polyline;
            return clipper.create_polygon_from_polyline_impl_(add_envelope, tolerance, densify_dist, corner_is_inside);
        }

        int compare_boundary_structs(Boundary_struct bs1, Boundary_struct bs2) {
            if (bs1.m_dist < bs2.m_dist) {
                return -1;
            }
            if (bs1.m_dist > bs2.m_dist) {
                return 1;
            }
            if (bs1.m_path == bs2.m_path) {
                return 0;
            }
            boolean side_0 = bs1.m_dist < this.m_extent.getHeight();
            MultiPathImpl mp_impl = (MultiPathImpl)this.m_polyline._getImpl();
            SegmentBuffer seg_buffer = new SegmentBuffer();
            mp_impl.getSegment(bs1.m_point_idx, seg_buffer, true);
            Point2D v_1 = seg_buffer.get()._getTangent(bs1.m_is_from_point ? 0.0 : 1.0);
            if (!bs1.m_is_from_point) {
                v_1.negate();
            }
            mp_impl.getSegment(bs2.m_point_idx, seg_buffer, true);
            Point2D v_2 = seg_buffer.get()._getTangent(bs2.m_is_from_point ? 0.0 : 1.0);
            if (!bs2.m_is_from_point) {
                v_2.negate();
            }
            if (side_0) {
                v_1.negate();
                v_2.negate();
            }
            int comp = Point2D._compareVectors(v_1, v_2);
            if (side_0) {
                comp = -comp;
            }
            return comp;
        }

        class Clipper_compare_boundary_structs
        implements Comparator<Boundary_struct> {
            Clipper_compare_boundary_structs() {
            }

            @Override
            public int compare(Boundary_struct v1, Boundary_struct v2) {
                return PolygonFromPolylineHelper.this.compare_boundary_structs(v1, v2);
            }
        }

        class Path_struct {
            double m_boundary_dist_1;
            double m_boundary_dist_2;
            int m_next_path;
            int m_prev_path;
            boolean m_active;
            boolean m_forward;

            Path_struct() {
            }

            void initialize() {
                this.m_next_path = -1;
                this.m_prev_path = -1;
                this.m_forward = true;
                this.m_boundary_dist_1 = -1.0;
                this.m_boundary_dist_2 = -1.0;
                this.m_active = true;
            }

            void reverse() {
                this.m_forward = !this.m_forward;
                int tempPath = this.m_next_path;
                this.m_next_path = this.m_prev_path;
                this.m_prev_path = tempPath;
            }

            void assign(Path_struct src) {
                this.m_boundary_dist_1 = src.m_boundary_dist_1;
                this.m_boundary_dist_2 = src.m_boundary_dist_2;
                this.m_next_path = src.m_next_path;
                this.m_prev_path = src.m_prev_path;
                this.m_active = src.m_active;
                this.m_forward = src.m_forward;
            }
        }

        static class Boundary_struct {
            double m_dist;
            int m_path;
            int m_point_idx;
            boolean m_is_from_point;

            Boundary_struct() {
            }

            void set_values(double dist, int path_idx, int point_idx, boolean is_from_point) {
                this.m_dist = dist;
                this.m_path = path_idx;
                this.m_point_idx = point_idx;
                this.m_is_from_point = is_from_point;
            }

            void assign(Boundary_struct src) {
                this.m_dist = src.m_dist;
                this.m_path = src.m_path;
                this.m_point_idx = src.m_point_idx;
                this.m_is_from_point = src.m_is_from_point;
            }
        }
    }

    static enum HorizonClipOption {
        Clip,
        DontClip,
        PannableFold;

    }
}

