/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.CompositeGeographicTransformation;
import com.esri.core.geometry.CompositeGeographicTransformationImpl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.GeogTranDefaults;
import com.esri.core.geometry.GeogTranQuickIDCache;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.LegacyProject;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.ObjectCacheTable;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.sde.sdk.pe.engine.PeCoordsys;
import com.esri.sde.sdk.pe.engine.PeGCSExtent;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeInteger;
import com.esri.sde.sdk.pe.factory.PeGTlistExtended;
import com.esri.sde.sdk.pe.factory.PeGTlistExtendedEntry;
import java.util.concurrent.locks.ReentrantLock;

@HadoopSDKExcluded
class ProjectionTransformationImpl
extends ProjectionTransformation {
    private static final long serialVersionUID = 1L;
    private SpatialReference m_inputSR;
    private SpatialReference m_outputSR;
    private ProjectionTransformation.ExtendedParams m_extendedParams = new ProjectionTransformation.ExtendedParams();
    private ExtendedParamsInternal m_extendedParamsInternal = new ExtendedParamsInternal();
    private boolean m_bIdentity = true;
    private boolean m_identityGeogToGeog = true;
    private CompositeGeographicTransformation m_geogTran;
    private LegacyProject m_projector;
    static ObjectCacheTable<Object, ProjectionTransformationImpl> st_projectionCache = new ObjectCacheTable(10);
    private static final ReentrantLock m_lock = new ReentrantLock();

    ProjectionTransformationImpl() {
    }

    static CompositeGeographicTransformation _quickLookup(int gcsID1, int gcsID2) {
        return GeogTranQuickIDCache.Lookup(gcsID1, gcsID2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectionTransformationImpl createImpl(SpatialReferenceImpl inputSR, SpatialReferenceImpl outputSR, Envelope2D inputEnvelope2D) {
        if (inputSR == null || outputSR == null) {
            throw new IllegalArgumentException();
        }
        Envelope2D envelope2D = new Envelope2D();
        envelope2D.setCoords(inputEnvelope2D);
        SpatialReference.Type srTypeIn = inputSR.getCoordinateSystemType();
        SpatialReference.Type srTypeOut = outputSR.getCoordinateSystemType();
        if (srTypeIn != SpatialReference.Type.Local || srTypeOut != SpatialReference.Type.Local) {
            // empty if block
        }
        if (srTypeIn == SpatialReference.Type.Local || srTypeOut == SpatialReference.Type.Local) {
            return ProjectionTransformationImpl.createExImpl(inputSR, outputSR, null);
        }
        int gcsID1 = inputSR.getGCS().getID();
        int gcsID2 = outputSR.getGCS().getID();
        if (gcsID1 > 0 && gcsID1 == gcsID2) {
            return ProjectionTransformationImpl.createExImpl(inputSR, outputSR, null);
        }
        ProjTransformKey key = new ProjTransformKey(inputSR, outputSR, inputEnvelope2D);
        try {
            m_lock.lock();
            if (st_projectionCache.contains(key)) {
                ProjectionTransformationImpl projectionTransformationImpl = st_projectionCache.get(key);
                return projectionTransformationImpl;
            }
        }
        finally {
            m_lock.unlock();
        }
        if (!envelope2D.isEmpty() && srTypeIn != SpatialReference.Type.Geographic) {
            SpatialReference inputGCS = inputSR.getGCS();
            Envelope envelope = new Envelope(envelope2D);
            OperatorFactoryLocal engine = OperatorFactoryLocal.getInstance();
            ProjectionTransformation projTransform = ProjectionTransformation.createEx(inputSR, inputGCS, null);
            OperatorProject operatorProject = (OperatorProject)engine.getOperator(Operator.Type.Project);
            envelope = (Envelope)operatorProject.execute(envelope, projTransform, null);
            envelope.queryEnvelope2D(envelope2D);
        }
        boolean b_cache_hit = false;
        CompositeGeographicTransformationImpl compositeGT = null;
        if (inputEnvelope2D.isEmpty() && gcsID1 > 0 && gcsID2 > 0) {
            compositeGT = (CompositeGeographicTransformationImpl)GeogTranQuickIDCache.Lookup(gcsID1, gcsID2);
            if (compositeGT != null) {
                b_cache_hit = true;
            }
            if (compositeGT == null && (compositeGT = (CompositeGeographicTransformationImpl)GeogTranDefaults.Lookup(gcsID1, gcsID2)) == null) {
                int old_GCS_ID_1 = inputSR.getGCS().getOldID();
                int old_GCS_ID_2 = outputSR.getGCS().getOldID();
                if (gcsID1 != old_GCS_ID_1 || gcsID2 != old_GCS_ID_2) {
                    compositeGT = (CompositeGeographicTransformationImpl)GeogTranDefaults.Lookup(old_GCS_ID_1, old_GCS_ID_2);
                }
            }
        }
        if (!inputEnvelope2D.isEmpty()) {
            PeInteger numEntries;
            PeGTlistExtendedEntry[] gtTransformEx;
            PeGCSExtent peGCSExtent = null;
            PeCoordsys peGeogcsIn = ((SpatialReferenceImpl)inputSR.getGCS()).getPECoordSys();
            PeCoordsys peGeogcsOut = ((SpatialReferenceImpl)outputSR.getGCS()).getPECoordSys();
            if (!envelope2D.isEmpty()) {
                double pmLongitude = ((PeGeogcs)peGeogcsIn).getPrimem().getLongitude();
                double conversionFactor = ((PeGeogcs)peGeogcsIn).getUnit().getUnitFactor();
                peGCSExtent = new PeGCSExtent(envelope2D.xmin, envelope2D.ymin, envelope2D.xmax, envelope2D.ymax, pmLongitude, conversionFactor);
            }
            if ((gtTransformEx = PeGTlistExtended.getGTlist((PeCoordsys)peGeogcsIn, (PeCoordsys)peGeogcsOut, (int)2, (int)11, peGCSExtent, (PeInteger)(numEntries = new PeInteger(1)))) != null) {
                compositeGT = CompositeGeographicTransformationImpl.createImpl(gtTransformEx[0]);
            }
        }
        if (gcsID1 > 0 && gcsID2 > 0 && inputEnvelope2D.isEmpty() && !b_cache_hit) {
            if (compositeGT != null) {
                GeogTranQuickIDCache.Register(gcsID1, gcsID2, compositeGT);
            } else {
                GeogTranQuickIDCache.Register(gcsID1, gcsID2, CompositeGeographicTransformation.create());
            }
        }
        if (compositeGT != null && compositeGT.count() == 0) {
            compositeGT = null;
        }
        ProjectionTransformationImpl resultPT = ProjectionTransformationImpl.createExImpl(inputSR, outputSR, compositeGT);
        try {
            m_lock.lock();
            if (!st_projectionCache.contains(key)) {
                st_projectionCache.add(key, resultPT);
            }
        }
        finally {
            m_lock.unlock();
        }
        return resultPT;
    }

    public static ProjectionTransformationImpl createExImpl(SpatialReferenceImpl inputSR, SpatialReferenceImpl outputSR, CompositeGeographicTransformation geogTran) {
        return ProjectionTransformationImpl.createExImpl(inputSR, outputSR, geogTran, null, null);
    }

    public static ProjectionTransformationImpl createExImpl(SpatialReferenceImpl inputSR, SpatialReferenceImpl outputSR, CompositeGeographicTransformation geogTran, ProjectionTransformation.ExtendedParams extendedParams, ExtendedParamsInternal extendedParamsInternal) {
        ProjectionTransformationImpl transform = new ProjectionTransformationImpl();
        transform._init(inputSR, outputSR, geogTran, extendedParams, extendedParamsInternal);
        return transform;
    }

    private void _init(SpatialReferenceImpl inputSR, SpatialReferenceImpl outputSR, CompositeGeographicTransformation geogTran, ProjectionTransformation.ExtendedParams extendedParams, ExtendedParamsInternal extendedParamsInternal) {
        double centralMeridianOfOutputGCS;
        if (inputSR == null || outputSR == null) {
            throw new GeometryException("invalidArgument");
        }
        this.m_inputSR = inputSR;
        this.m_outputSR = outputSR;
        this.m_bIdentity = false;
        this.m_identityGeogToGeog = false;
        if (extendedParams != null) {
            this.m_extendedParams = extendedParams.copy();
        }
        if (extendedParamsInternal != null) {
            this.m_extendedParamsInternal._cloneParameterValues(extendedParamsInternal);
        }
        boolean centralMeridianChange = false;
        if (outputSR.getCoordinateSystemType() == SpatialReference.Type.Geographic && extendedParams != null && !NumberUtils.isNaN(centralMeridianOfOutputGCS = extendedParams.centralMeridianOfOutputGCS) && centralMeridianOfOutputGCS != 0.0) {
            centralMeridianChange = true;
        }
        if (inputSR == outputSR) {
            this.m_bIdentity = !centralMeridianChange;
            this.m_identityGeogToGeog = true;
            this.updateProjector();
            return;
        }
        SpatialReference.Type srTypeIn = inputSR.getCoordinateSystemType();
        SpatialReference.Type srTypeOut = outputSR.getCoordinateSystemType();
        if (srTypeIn == SpatialReference.Type.Local || srTypeOut == SpatialReference.Type.Local) {
            assert (geogTran != null);
            if (geogTran != null) {
                throw new IllegalArgumentException();
            }
            if (inputSR.getUnit() != null && outputSR.getUnit() != null) {
                this.m_bIdentity = inputSR.getUnit().equals(outputSR.getUnit());
            }
            this.updateProjector();
            return;
        }
        this.m_bIdentity = srTypeIn == SpatialReference.Type.Image || srTypeOut == SpatialReference.Type.Image ? inputSR.equals(outputSR) : (((SpatialReferenceImpl)this.m_inputSR).horizontal_equal_((SpatialReferenceImpl)this.m_outputSR) ? !centralMeridianChange : false);
        this.m_geogTran = geogTran;
        if (this.m_geogTran != null) {
            ((CompositeGeographicTransformationImpl)this.m_geogTran).setReadonly();
        }
        this.m_identityGeogToGeog = (this.m_geogTran == null || this.m_geogTran.count() == 0) && this.m_inputSR.getGCS().equals(this.m_outputSR.getGCS());
        this.updateProjector();
    }

    @Override
    public ProjectionTransformation getInverse() {
        ProjectionTransformationImpl inverse = new ProjectionTransformationImpl();
        inverse.m_inputSR = this.m_outputSR;
        inverse.m_outputSR = this.m_inputSR;
        if (this.m_geogTran != null) {
            inverse.m_geogTran = this.m_geogTran.getInverse();
        }
        inverse.m_bIdentity = this.m_bIdentity;
        inverse.m_identityGeogToGeog = this.m_identityGeogToGeog;
        inverse.updateProjector();
        return inverse;
    }

    @Override
    public SpatialReference getInputSR() {
        return this.m_inputSR;
    }

    @Override
    public SpatialReference getOutputSR() {
        return this.m_outputSR;
    }

    @Override
    public boolean isIdentity() {
        return this.m_bIdentity;
    }

    @Override
    public ProjectionTransformation.ExtendedParams getExtendedParams() {
        return this.m_extendedParams.copy();
    }

    @Override
    public CompositeGeographicTransformation getGeographicTransformations() {
        return this.m_geogTran;
    }

    @Override
    public boolean equals(ProjectionTransformation other) {
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ProjectionTransformationImpl o = (ProjectionTransformationImpl)other;
        if (!this.m_inputSR.equals(o.m_inputSR)) {
            return false;
        }
        if (!this.m_outputSR.equals(o.m_outputSR)) {
            return false;
        }
        if (this.m_geogTran == o.m_geogTran) {
            return true;
        }
        if (this.m_geogTran == null || o.m_geogTran == null) {
            return false;
        }
        return this.m_geogTran.equals(o.m_geogTran);
    }

    @Override
    public boolean referencesMissingData() {
        if (this.m_geogTran == null) {
            return false;
        }
        return this.m_geogTran.referencesMissingData();
    }

    public ExtendedParamsInternal getExtendedParamsInternal() {
        return this.m_extendedParamsInternal;
    }

    private void updateProjector() {
        this.m_projector = new LegacyProject(this);
    }

    public LegacyProject getProjector() {
        return this.m_projector;
    }

    public boolean isIdentityGeogToGeog() {
        return this.m_identityGeogToGeog;
    }

    static class ProjTransformKey {
        private SpatialReferenceImpl m_inputSR;
        private SpatialReferenceImpl m_outputSR;
        private Envelope2D m_env;
        private int m_hashCode;

        public ProjTransformKey(SpatialReferenceImpl inputSR, SpatialReferenceImpl outputSR, Envelope2D env) {
            this.m_inputSR = inputSR;
            this.m_outputSR = outputSR;
            this.m_env = new Envelope2D();
            this.m_env.setCoords(env);
            this.m_hashCode = this.m_inputSR.hashCode() + 53 * this.m_outputSR.hashCode();
            if (!this.m_env.isEmpty()) {
                this.m_hashCode = this.m_hashCode * 53 + NumberUtils.hash(this.m_env.xmin);
                this.m_hashCode = this.m_hashCode * 53 + NumberUtils.hash(this.m_env.xmax);
                this.m_hashCode = this.m_hashCode * 53 + NumberUtils.hash(this.m_env.ymin);
                this.m_hashCode = this.m_hashCode * 53 + NumberUtils.hash(this.m_env.ymax);
            }
        }

        public int hashCode() {
            return this.m_hashCode;
        }

        public boolean equals(Object other) {
            ProjTransformKey otherP = (ProjTransformKey)other;
            return this == otherP || this.m_inputSR.equals(otherP.m_inputSR) && this.m_outputSR.equals(otherP.m_outputSR) && this.m_env.equals(otherP.m_env);
        }
    }

    static class ExtendedParamsInternal {
        int flagsMask = 0;

        ExtendedParamsInternal() {
        }

        void setFlag(int flag, boolean b_yes_no) {
            this.flagsMask = b_yes_no ? (this.flagsMask |= flag) : (this.flagsMask &= ~flag);
        }

        boolean hasFlag(int flag) {
            return (this.flagsMask & flag) != 0;
        }

        public static ExtendedParamsInternal _clone(ExtendedParamsInternal other) {
            assert (other != null);
            ExtendedParamsInternal copy = new ExtendedParamsInternal();
            copy.flagsMask = other.flagsMask;
            return copy;
        }

        public void _cloneParameterValues(ExtendedParamsInternal other) {
            assert (other != null);
            this.flagsMask = other.flagsMask;
        }

        public static enum FlagsInternal {
            Dont_Geonomalize_Polygon(Integer.MIN_VALUE),
            Dont_Adjust_At_Poles(0x40000000);

            private final int value;

            private FlagsInternal(int value) {
                this.value = value;
            }

            public int getValue() {
                return this.value;
            }
        }
    }
}

