/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.CompositeGeographicTransformation;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.PrTrSrlz;
import com.esri.core.geometry.ProjectionTransformationImpl;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import java.io.ObjectStreamException;
import java.io.Serializable;

@AndroidSDKPublic
@HadoopSDKExcluded
public abstract class ProjectionTransformation
implements Serializable {
    private static final long serialVersionUID = 1L;

    @AndroidSDKPublic
    public static ProjectionTransformation create(SpatialReference inputSR, SpatialReference outputSR, Envelope extentOfInterest) {
        Envelope2D env = new Envelope2D();
        if (extentOfInterest != null) {
            extentOfInterest.queryEnvelope2D(env);
        } else {
            env.setEmpty();
        }
        return ProjectionTransformationImpl.createImpl((SpatialReferenceImpl)inputSR, (SpatialReferenceImpl)outputSR, env);
    }

    @AndroidSDKPublic
    public static ProjectionTransformation create(SpatialReference inputSR, SpatialReference outputSR) {
        return ProjectionTransformation.create(inputSR, outputSR, null);
    }

    @AndroidSDKPublic
    public static ProjectionTransformation createEx(SpatialReference inputSR, SpatialReference outputSR, CompositeGeographicTransformation compositeGeogTransforms) {
        return ProjectionTransformation.createEx(inputSR, outputSR, compositeGeogTransforms, null);
    }

    @AndroidSDKPublic
    public static ProjectionTransformation createEx(SpatialReference inputSR, SpatialReference outputSR, CompositeGeographicTransformation compositeGeogTransforms, ExtendedParams extendedParams) {
        return ProjectionTransformationImpl.createExImpl((SpatialReferenceImpl)inputSR, (SpatialReferenceImpl)outputSR, compositeGeogTransforms, extendedParams, null);
    }

    @AndroidSDKPublic
    public abstract SpatialReference getInputSR();

    @AndroidSDKPublic
    public abstract SpatialReference getOutputSR();

    @AndroidSDKPublic
    public abstract CompositeGeographicTransformation getGeographicTransformations();

    @AndroidSDKPublic
    public abstract ProjectionTransformation getInverse();

    @AndroidSDKPublic
    public abstract boolean isIdentity();

    public abstract boolean referencesMissingData();

    @AndroidSDKPublic
    public abstract ExtendedParams getExtendedParams();

    Object writeReplace() throws ObjectStreamException {
        PrTrSrlz pt = new PrTrSrlz();
        pt.setPT(this);
        return pt;
    }

    public abstract boolean equals(ProjectionTransformation var1);

    public static class ExtendedParams {
        public double centralMeridianOfOutputGCS = NumberUtils.NaN();
        public double densificationStep = NumberUtils.NaN();
        public int flagsMask = 3;

        public void setClipWithInputHorizon(boolean bYesNo) {
            this.setFlag(1, bYesNo);
        }

        public void setClipWithOutputHorizon(boolean bYesNo) {
            this.setFlag(2, bYesNo);
        }

        public boolean hasClipWithInputHorizon() {
            return this.hasFlag(1);
        }

        public boolean hasClipWithOutputHorizon() {
            return this.hasFlag(2);
        }

        public void setFlag(int flag, boolean bYesNo) {
            this.flagsMask = bYesNo ? (this.flagsMask |= flag) : (this.flagsMask &= ~flag);
        }

        public boolean hasFlag(int flag) {
            return (this.flagsMask & flag) != 0;
        }

        public ExtendedParams copy() {
            ExtendedParams dst = new ExtendedParams();
            dst.centralMeridianOfOutputGCS = this.centralMeridianOfOutputGCS;
            dst.densificationStep = this.densificationStep;
            dst.flagsMask = this.flagsMask;
            return dst;
        }

        public static interface Flags {
            public static final int clipWithInputHorizon = 1;
            public static final int clipWithOutputHorizon = 2;
        }
    }
}

