/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.NumberUtils;
import java.io.Serializable;

@HadoopSDKPublic
public final class Point3D
implements Serializable {
    private static final long serialVersionUID = 1L;
    @HadoopSDKPublic
    public double x;
    @HadoopSDKPublic
    public double y;
    @HadoopSDKPublic
    public double z;
    @HadoopSDKPublic
    public static final int dimensions = 3;

    @HadoopSDKPublic
    public Point3D() {
    }

    @HadoopSDKPublic
    public Point3D(Point3D other) {
        this.setCoords(other);
    }

    @HadoopSDKPublic
    public Point3D(double x, double y, double z) {
        this.setCoords(x, y, z);
    }

    @HadoopSDKPublic
    public static Point3D construct(double x, double y, double z) {
        Point3D pt = new Point3D();
        pt.setCoords(x, y, z);
        return pt;
    }

    @HadoopSDKPublic
    public void setCoords(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @HadoopSDKPublic
    public void setCoords(Point3D other) {
        this.setCoords(other.x, other.y, other.z);
    }

    @HadoopSDKPublic
    public void setZero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    @HadoopSDKPublic
    public void normalize() {
        double len = this.length();
        if (len == 0.0) {
            this.x = 1.0;
            this.y = 0.0;
            this.z = 0.0;
        } else {
            this.x /= len;
            this.y /= len;
            this.z /= len;
        }
    }

    @HadoopSDKPublic
    public double dotProduct(Point3D other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    @HadoopSDKPublic
    public void crossProductVector(Point3D p1, Point3D p2) {
        double xx = p1.y * p2.z - p2.y * p1.z;
        double yy = p2.x * p1.z - p1.x * p2.z;
        double zz = p1.x * p2.y - p2.x * p1.y;
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    @HadoopSDKPublic
    public double sqrLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @HadoopSDKPublic
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @HadoopSDKPublic
    public static double sqrDistance(Point3D p1, Point3D p2) {
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        double dz = p1.z - p2.z;
        return dx * dx + dy * dy + dz * dz;
    }

    @HadoopSDKPublic
    public static double distance(Point3D p1, Point3D p2) {
        return Math.sqrt(Point3D.sqrDistance(p1, p2));
    }

    @HadoopSDKPublic
    public void add(Point3D other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
    }

    @HadoopSDKPublic
    public void sub(Point3D other) {
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
    }

    @HadoopSDKPublic
    public void sub(Point3D p1, Point3D p2) {
        this.x = p1.x - p2.x;
        this.y = p1.y - p2.y;
        this.z = p1.z - p2.z;
    }

    @HadoopSDKPublic
    public void scale(double f, Point3D other) {
        this.x = f * other.x;
        this.y = f * other.y;
        this.z = f * other.z;
    }

    @HadoopSDKPublic
    public void scaleAdd(double f1, Point3D other1, double f2, Point3D other2) {
        this.x = f1 * other1.x + f2 * other2.x;
        this.y = f1 * other1.y + f2 * other2.y;
        this.z = f1 * other1.z + f2 * other2.z;
    }

    @HadoopSDKPublic
    public void mul(double factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
    }

    @HadoopSDKPublic
    public void div(double factor) {
        this.x /= factor;
        this.y /= factor;
        this.z /= factor;
    }

    @HadoopSDKPublic
    public boolean isEqual(Point3D other) {
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    @HadoopSDKPublic
    public boolean isEqual(double x_, double y_, double z_) {
        return this.x == x_ && this.y == y_ && this.z == z_;
    }

    @HadoopSDKPublic
    public boolean isEqual(Point3D other, double tol) {
        return Math.abs(this.x - other.x) <= tol && Math.abs(this.y - other.y) <= tol && Math.abs(this.z - other.z) <= tol;
    }

    @HadoopSDKPublic
    public boolean isEqual(double[] coord, double tol) {
        return Math.abs(this.x - coord[0]) <= tol && Math.abs(this.y - coord[1]) <= tol && Math.abs(this.z - coord[2]) <= tol;
    }

    @HadoopSDKPublic
    public boolean equals(Point3D other) {
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    @HadoopSDKPublic
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Point3D)) {
            return false;
        }
        Point3D v = (Point3D)other;
        return this.x == v.x && this.y == v.y && this.z == v.z;
    }

    @HadoopSDKPublic
    public void setNaN() {
        this.x = NumberUtils.NaN();
        this.y = NumberUtils.NaN();
        this.z = NumberUtils.NaN();
    }

    public boolean isNaN() {
        return NumberUtils.isNaN(this.x) || NumberUtils.isNaN(this.y) || NumberUtils.isNaN(this.z);
    }

    @HadoopSDKPublic
    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        return this.z;
    }

    @HadoopSDKPublic
    public void set(int i, double v) {
        switch (i) {
            case 0: {
                this.x = v;
                break;
            }
            case 1: {
                this.y = v;
                break;
            }
            default: {
                this.z = v;
            }
        }
    }
}

