/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.LinearUnit;
import com.esri.core.geometry.ProjectionUtils;
import com.esri.core.geometry.UnitFactoryImpl;
import com.esri.sde.sdk.pe.engine.PeLinunit;
import com.esri.sde.sdk.pe.engine.PeObject;
import com.esri.sde.sdk.pe.engine.PeVertcs;
import com.esri.sde.sdk.pe.factory.PeFactory;
import com.esri.sde.sdk.pe.factory.PeFactoryCodechange;

@HadoopSDKExcluded
class PeVerticalCoordSysValue {
    private int m_hashCode;
    private int m_WKID;
    private volatile int m_old_WKID;
    private String m_canonicalWkt;
    private double m_one_meter;
    private LinearUnit m_unit;
    public PeVertcs m_peVertcs;

    PeVerticalCoordSysValue(PeVertcs cs) {
        this.m_peVertcs = cs;
        this.m_canonicalWkt = ProjectionUtils.getWKTForCaching(cs, 0, true);
        this.m_hashCode = this.m_canonicalWkt.hashCode();
        int code = cs.getCode();
        this.m_WKID = code > 0 ? code : PeFactory.getCode((PeObject)cs);
        if (this.m_WKID < 0) {
            this.m_WKID = 0;
        }
        this.m_old_WKID = -1973;
        PeLinunit unit = this.m_peVertcs.getUnit();
        this.m_unit = UnitFactoryImpl.create(cs);
        double metersPerUnit = unit.getUnitFactor();
        this.m_one_meter = 1.0 / metersPerUnit;
        PeFactory.getCode((PeObject)cs);
        cs.getAuth();
    }

    public static boolean equal(PeVerticalCoordSysValue v1, PeVerticalCoordSysValue v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 != null && v2 != null && v1.m_WKID == 0 && v2.m_WKID == 0) {
            return v1.m_hashCode == v2.m_hashCode && v1.m_canonicalWkt.equals(v2.m_canonicalWkt);
        }
        return false;
    }

    int getLatestID() {
        return this.m_WKID;
    }

    int getOldID() {
        int code = this.m_old_WKID;
        if (code < 0) {
            code = 0;
            if (this.m_WKID > 0) {
                code = this.m_WKID;
                PeFactoryCodechange oldCode = new PeFactoryCodechange();
                PeFactoryCodechange newCode = new PeFactoryCodechange();
                if (PeFactoryCodechange.queryChange((int)this.m_peVertcs.getType(), (int)this.m_WKID, (PeFactoryCodechange)oldCode, (PeFactoryCodechange)newCode) == 0 && (code = oldCode.getCode()) < 0) {
                    code = 0;
                }
            }
            this.m_old_WKID = code;
        }
        return code;
    }

    double getOneMeterUnit() {
        return this.m_one_meter;
    }

    LinearUnit getVerticalUnit() {
        return this.m_unit;
    }

    public int hashCode() {
        return this.m_hashCode;
    }
}

