/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.ListeningGeometryCursor;
import com.esri.core.geometry.OperatorDensifyByLength;
import com.esri.core.geometry.OperatorDifference;
import com.esri.core.geometry.OperatorDisjoint;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.OperatorUnion;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProjectionUtils;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.SpatialReferencePrecisionDescriptor;
import com.esri.core.geometry.Unit;
import com.esri.core.geometry.UnitFactoryImpl;
import com.esri.sde.sdk.pe.engine.PeAngunit;
import com.esri.sde.sdk.pe.engine.PeCSTransformations;
import com.esri.sde.sdk.pe.engine.PeCoordsys;
import com.esri.sde.sdk.pe.engine.PeDatum;
import com.esri.sde.sdk.pe.engine.PeGCSExtent;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeHorizon;
import com.esri.sde.sdk.pe.engine.PeLinunit;
import com.esri.sde.sdk.pe.engine.PeMetadata;
import com.esri.sde.sdk.pe.engine.PeObject;
import com.esri.sde.sdk.pe.engine.PePCSInfo;
import com.esri.sde.sdk.pe.engine.PeProjcs;
import com.esri.sde.sdk.pe.engine.PeSpheroid;
import com.esri.sde.sdk.pe.factory.PeFactory;
import com.esri.sde.sdk.pe.factory.PeFactoryCodechange;
import java.util.concurrent.locks.ReentrantLock;

@HadoopSDKExcluded
final class PeCoordSysValue {
    private ReentrantLock m_lock = new ReentrantLock();
    private Geometry m_pcsHorizon = null;
    private Geometry m_gcsHorizon = null;
    private Polyline m_GCS_split_lines;
    private boolean m_GCSHorisonIsInclusive = false;
    private double m_oneMeterPCS = 0.0;
    private double m_oneDegreeGCS = 0.0;
    private Point2D m_northPole = new Point2D();
    private Point2D m_southPole = new Point2D();
    private volatile boolean m_polesUpdated = false;
    private Envelope2D m_domain = new Envelope2D();
    private double m_primeMeridian;
    private double m_oneMillimeter = 0.0;
    private double m_gcsUnitFactor = 0.0;
    private PePCSInfo m_pPCSInfoNoDomain = null;
    private int m_hashCode;
    private int m_wkid;
    private volatile int m_old_wkid;
    private boolean m_isPannable = false;
    private Envelope2D m_pannableExtent;
    private Envelope2D m_pannableExtentGCS;
    private SpatialReference.Type m_cs_type;
    private String m_canonicalWkt;
    private Envelope m_areaOfUse = null;
    private Unit m_unit = null;
    private double m_adjustedCentralMeridian = 0.0;
    public PeCoordsys m_peCoordSys;

    public PeCoordSysValue(PeCoordsys cs) {
        double radiansPerUnit;
        PeGeogcs gcs;
        PeProjcs pcs;
        this.m_peCoordSys = cs;
        GeometryException.releaseAssert(cs != null);
        this.m_canonicalWkt = ProjectionUtils.getWKTForCaching(this.m_peCoordSys, 0, true);
        this.m_hashCode = this.m_canonicalWkt.hashCode();
        this.m_northPole.setNaN();
        this.m_southPole.setNaN();
        this.m_primeMeridian = Double.NaN;
        int code = cs.getCode();
        if (code > 0) {
            this.m_wkid = code;
            PeFactory.getCode((PeObject)cs);
        } else {
            this.m_wkid = PeFactory.getCode((PeObject)cs);
        }
        assert (this.m_wkid >= 0);
        if (this.m_wkid < 0) {
            this.m_wkid = 0;
        }
        this.m_old_wkid = -1973;
        int type = this.m_peCoordSys.getType();
        GeometryException.releaseAssert(type == 2 || type == 1);
        SpatialReference.Type type2 = this.m_cs_type = type == 2 ? SpatialReference.Type.Projected : SpatialReference.Type.Geographic;
        if (type == 2 && !(pcs = (PeProjcs)cs).loadConstants()) {
            throw new IllegalArgumentException("PeProjcs.loadConstants failed");
        }
        PeGeogcs peGeogcs = gcs = type == 1 ? (PeGeogcs)this.m_peCoordSys : ((PeProjcs)this.m_peCoordSys).getGeogcs();
        if (type != 1) {
            PeFactory.getCode((PeObject)gcs);
            gcs.getAuth();
        }
        this.m_unit = UnitFactoryImpl.create(cs);
        this.m_primeMeridian = gcs.getPrimem().getLongitude();
        PeAngunit gcs_unit = gcs.getUnit();
        this.m_gcsUnitFactor = radiansPerUnit = gcs_unit.getUnitFactor();
        double oneDegreeGCS = Math.PI / (180.0 * radiansPerUnit);
        if (Math.abs(oneDegreeGCS - 1.0) < 1.0E-10) {
            oneDegreeGCS = 1.0;
        }
        this.m_oneDegreeGCS = oneDegreeGCS;
        if ((type & 2) != 0) {
            PeProjcs pcs2 = (PeProjcs)this.m_peCoordSys;
            PeLinunit unit = pcs2.getUnit();
            double metersPerUnit = unit.getUnitFactor();
            this.m_oneMeterPCS = 1.0 / metersPerUnit;
            this.m_oneMillimeter = 0.001 / ((PeProjcs)this.m_peCoordSys).getUnit().getUnitFactor();
            this.m_pPCSInfoNoDomain = PePCSInfo.generate((PeProjcs)pcs2, (int)0);
            this.m_isPannable = this.m_pPCSInfoNoDomain.isPannableRectangle();
            this.m_adjustedCentralMeridian = ProjectionUtils.adjustCentralMeridian(this.m_pPCSInfoNoDomain.getCentralMeridian(), this.m_oneDegreeGCS);
        } else {
            assert ((type & 1) != 0);
            this.m_isPannable = true;
            this.m_polesUpdated = true;
            this.m_oneMeterPCS = 0.0;
            double rpu = gcs.getUnit().getUnitFactor();
            double upr = 1.0 / rpu;
            PeDatum datum = gcs.getDatum();
            PeSpheroid spheroid = datum.getSpheroid();
            double semimajor = spheroid.getAxis();
            this.m_oneMillimeter = 0.001 / semimajor * upr;
            this.m_adjustedCentralMeridian = 0.0;
        }
        cs.getAuth();
        if (this.m_isPannable) {
            this.updateGCSHorizon();
            this.updatePCSHorizon();
            this.updatePoles();
            this.updateDomain();
            this.updatePannableExtent();
            this.updatePannableExtentGCS();
        }
    }

    public int getLatestID() {
        return this.m_wkid;
    }

    public int getOldID() {
        int code = this.m_old_wkid;
        if (code < 0) {
            code = 0;
            if (this.m_wkid > 0) {
                code = this.m_wkid;
                PeFactoryCodechange oldCode = new PeFactoryCodechange();
                PeFactoryCodechange newCode = new PeFactoryCodechange();
                if (PeFactoryCodechange.queryChange((int)this.m_peCoordSys.getType(), (int)this.m_wkid, (PeFactoryCodechange)oldCode, (PeFactoryCodechange)newCode) == 0 && (code = oldCode.getCode()) < 0) {
                    code = 0;
                }
            }
            this.m_old_wkid = code;
        }
        return code;
    }

    public PePCSInfo getPCSInfo() {
        return this.m_pPCSInfoNoDomain;
    }

    public String getCanonicalWkt() {
        return this.m_canonicalWkt;
    }

    public static boolean equal(PeCoordSysValue v1, PeCoordSysValue v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 != null && v2 != null && v1.m_wkid == 0 && v2.m_wkid == 0) {
            return v1.m_hashCode == v2.m_hashCode && v1.m_canonicalWkt.equals(v2.m_canonicalWkt);
        }
        return false;
    }

    public boolean isPannable() {
        return this.m_isPannable;
    }

    public void getPannableExtent(Envelope2D extent) {
        extent.setCoords(this.m_pannableExtent);
    }

    public Envelope2D getPannableExtentByRef() {
        return this.m_pannableExtent;
    }

    public double getPannableExtentXMin() {
        return this.m_pannableExtent.xmin;
    }

    public double getPannableExtentXMax() {
        return this.m_pannableExtent.xmax;
    }

    public void getPannableExtentGCS(Envelope2D extent) {
        extent.setCoords(this.m_pannableExtentGCS);
    }

    private void updatePannableExtent() {
        int type = this.m_peCoordSys.getType();
        if (type == 2) {
            PeProjcs PE_projcs = (PeProjcs)this.m_peCoordSys;
            PePCSInfo pcsInfo = this.getPCSInfo();
            double centralMeridian = pcsInfo.getCentralMeridian();
            PeGeogcs peGcs = PE_projcs.getGeogcs();
            if (peGcs == null) {
                throw new GeometryException("internal error");
            }
            double gcs_unit_factor = peGcs.getUnit().getUnitFactor();
            double GCSXMax = 1.0 / gcs_unit_factor * Math.PI;
            double[] coords = new double[]{centralMeridian + GCSXMax, 0.0};
            PeCSTransformations.geogToProj((PeProjcs)PE_projcs, (int)1, (double[])coords);
            double PCSXEdge = coords[0];
            double falseEasting = PE_projcs.getParameters()[0].getValue();
            Geometry pcsHorizon = this.getPCSHorizon();
            Envelope2D horizonEnv2D = new Envelope2D();
            pcsHorizon.queryEnvelope2D(horizonEnv2D);
            double PCSXBaseMax = Math.abs(PCSXEdge - falseEasting);
            double PCSXBaseMin = -1.0 * PCSXBaseMax;
            double PCSXMax = PCSXBaseMax + falseEasting;
            double PCSXMin = PCSXBaseMin + falseEasting;
            double PCSYMax = horizonEnv2D.ymax;
            double PCSYMin = horizonEnv2D.ymin;
            Envelope2D pcs_env_2D = new Envelope2D();
            pcs_env_2D.setCoords(PCSXMin, PCSYMin, PCSXMax, PCSYMax);
            this.m_lock.lock();
            if (this.m_pannableExtent == null) {
                this.m_pannableExtent = pcs_env_2D;
            }
            this.m_lock.unlock();
        } else if (type == 1) {
            PeGeogcs PE_geogcs = (PeGeogcs)this.m_peCoordSys;
            double factor = PE_geogcs.getUnit().getUnitFactor();
            double GCSXMax = 1.0 / factor * Math.PI;
            Envelope2D env_2D = new Envelope2D();
            env_2D.setCoords(-GCSXMax, -GCSXMax / 2.0, GCSXMax, GCSXMax / 2.0);
            this.m_lock.lock();
            if (this.m_pannableExtent == null) {
                this.m_pannableExtent = env_2D;
            }
            this.m_lock.unlock();
        } else {
            throw new GeometryException("internal error");
        }
    }

    private void updatePannableExtentGCS() {
        int type = this.m_peCoordSys.getType();
        if (type == 2) {
            PeProjcs PE_projcs = (PeProjcs)this.m_peCoordSys;
            PePCSInfo pcsInfo = this.getPCSInfo();
            double centralMeridian = pcsInfo.getCentralMeridian();
            PeGeogcs peGcs = PE_projcs.getGeogcs();
            if (peGcs == null) {
                throw new GeometryException("internal error");
            }
            double gcs_unit_factor = peGcs.getUnit().getUnitFactor();
            double GCSXMax = 1.0 / gcs_unit_factor * Math.PI;
            Geometry gcsHorizon = this.getGCSHorizon();
            Envelope2D gcs_horizonEnv2D = new Envelope2D();
            gcsHorizon.queryEnvelope2D(gcs_horizonEnv2D);
            Envelope2D gcs_env_2D = new Envelope2D();
            gcs_env_2D.setCoords(centralMeridian - GCSXMax, gcs_horizonEnv2D.ymin, centralMeridian + GCSXMax, gcs_horizonEnv2D.ymax);
            this.m_lock.lock();
            if (this.m_pannableExtentGCS == null) {
                this.m_pannableExtentGCS = gcs_env_2D;
            }
            this.m_lock.unlock();
        } else if (type == 1) {
            PeGeogcs PE_geogcs = (PeGeogcs)this.m_peCoordSys;
            double factor = PE_geogcs.getUnit().getUnitFactor();
            double GCSXMax = 1.0 / factor * Math.PI;
            Envelope2D env_2D = new Envelope2D();
            env_2D.setCoords(-GCSXMax, -GCSXMax / 2.0, GCSXMax, GCSXMax / 2.0);
            this.m_lock.lock();
            if (this.m_pannableExtentGCS == null) {
                this.m_pannableExtentGCS = env_2D;
            }
            this.m_lock.unlock();
        } else {
            throw new GeometryException("internal error");
        }
    }

    public double getUnitsPerMillimiter() {
        return this.m_oneMillimeter;
    }

    public double getOneDegreeGCSUnit() {
        return this.m_oneDegreeGCS;
    }

    public double getOneMeterPCSUnit() {
        return this.m_oneMeterPCS;
    }

    private Geometry getGCSHorizonPannable_() {
        assert (this.m_isPannable);
        return this.m_gcsHorizon;
    }

    public Geometry getGCSHorizon() {
        if (this.m_isPannable) {
            return this.getGCSHorizonPannable_();
        }
        this.m_lock.lock();
        Geometry gcsHorizon = this.m_gcsHorizon;
        this.m_lock.unlock();
        if (gcsHorizon != null) {
            return gcsHorizon;
        }
        this.updateGCSHorizon();
        return this.m_gcsHorizon;
    }

    public Polyline getGCSSplitLines() {
        if (this.m_isPannable) {
            return null;
        }
        this.m_lock.lock();
        Geometry gcsHorizon = this.m_gcsHorizon;
        this.m_lock.unlock();
        if (gcsHorizon != null) {
            return this.m_GCS_split_lines;
        }
        this.updateGCSHorizon();
        return this.m_GCS_split_lines;
    }

    private void updateGCSHorizon() {
        if (this.m_peCoordSys.getType() != 2) {
            return;
        }
        boolean GCS_horison_is_inclusive = true;
        PeProjcs pcsPE = (PeProjcs)this.m_peCoordSys;
        PeGeogcs gcsPE = pcsPE.getGeogcs();
        PeHorizon[] peHorizon = pcsPE.horizonGcsGenerate();
        if (peHorizon == null) {
            return;
        }
        int nump = peHorizon[0].getNump();
        int horizonKind = peHorizon[0].getKind();
        int pathPointCount = 0;
        GCS_horison_is_inclusive = peHorizon[0].getInclusive() > 0;
        boolean inclusive = false;
        double GCS1 = this.getOneDegreeGCSUnit();
        double GCS90 = GCS1 * 90.0;
        double GCS180 = GCS1 * 180.0;
        double GCS360 = GCS1 * 360.0;
        double GCS370 = GCS1 * 370.0;
        double GCSDelta = GCS180 * 2.0E-7 / Math.PI;
        Envelope2D env_2D = new Envelope2D();
        Polyline GCS_split_lines = null;
        if (nump > 1) {
            for (int i = 1; i < nump; ++i) {
                if (peHorizon[i].getKind() != 2) continue;
                if (GCS_split_lines == null) {
                    GCS_split_lines = new Polyline();
                }
                double[][] coord = peHorizon[i].getCoord();
                GCS_split_lines.startPath(coord[0][0], coord[0][1]);
                GCS_split_lines.lineTo(coord[1][0], coord[1][1]);
            }
        }
        if (horizonKind == 0) {
            assert (nump == 1);
            assert (GCS_horison_is_inclusive);
            double[][] points = peHorizon[0].getCoord();
            env_2D.setCoords(points[0][0], points[0][1]);
            env_2D.merge(points[1][0], points[1][1]);
            if (Math.abs(env_2D.ymax - GCS90) < GCSDelta * 1.0E-7) {
                env_2D.ymax = GCS90;
            }
            if (Math.abs(env_2D.ymin + GCS90) < GCSDelta * 1.0E-7) {
                env_2D.ymin = -GCS90;
            }
            if (env_2D.getWidth() > GCS370) {
                double xMin = -400.0 * GCS1;
                double xMax = xMin + 5.0 * GCS360;
                env_2D.setCoords(xMin, env_2D.ymin, xMax, env_2D.ymax);
            }
            Envelope gcsHorizon = new Envelope(env_2D);
            this.m_lock.lock();
            if (this.m_gcsHorizon == null) {
                this.m_gcsHorizon = gcsHorizon;
                this.m_GCSHorisonIsInclusive = GCS_horison_is_inclusive;
            }
            this.m_lock.unlock();
        } else {
            assert (horizonKind == 1);
            Polygon horizonPoly = new Polygon();
            boolean innerRingsOverlap = this.getPCSInfo().isGcsHorizonMultiOverlap();
            SpatialReferenceImpl gcs = SpatialReferenceImpl.createImpl((PeCoordsys)gcsPE, null, SpatialReferencePrecisionDescriptor.Precision.Integer64);
            assert (GCS_horison_is_inclusive && !innerRingsOverlap || !GCS_horison_is_inclusive);
            if (!innerRingsOverlap) {
                for (int i = 0; i < nump; ++i) {
                    if (peHorizon[i].getKind() != 1) continue;
                    pathPointCount = peHorizon[i].getSize();
                    double[][] coords = peHorizon[i].getCoord();
                    Point2D[] points = new Point2D[pathPointCount];
                    for (int j = 0; j < pathPointCount; ++j) {
                        points[j] = new Point2D(coords[j][0], coords[j][1]);
                    }
                    boolean bl = inclusive = peHorizon[i].getInclusive() > 0;
                    assert (inclusive == GCS_horison_is_inclusive);
                    horizonPoly.addPath(points, pathPointCount - 1, true);
                }
            } else {
                ListeningGeometryCursor curs = new ListeningGeometryCursor();
                GeometryCursor resultCursor = OperatorUnion.local().execute(curs, gcs, null);
                for (int i = 0; i < nump; ++i) {
                    if (peHorizon[i].getKind() != 1) continue;
                    pathPointCount = peHorizon[i].getSize();
                    double[][] coords = peHorizon[i].getCoord();
                    Point2D[] points = new Point2D[pathPointCount];
                    for (int j = 0; j < pathPointCount; ++j) {
                        points[j] = new Point2D(coords[j][0], coords[j][1]);
                    }
                    boolean bl = inclusive = peHorizon[i].getInclusive() > 0;
                    assert (inclusive == GCS_horison_is_inclusive);
                    if (!innerRingsOverlap) continue;
                    Polygon ringPolygon = new Polygon();
                    ringPolygon.addPath(points, pathPointCount - 1, true);
                    curs.tick(ringPolygon);
                    resultCursor.tock();
                }
                horizonPoly = (Polygon)resultCursor.next();
            }
            if (GCS_horison_is_inclusive) {
                OperatorIntersection.local().accelerateGeometry(horizonPoly, gcs, Geometry.GeometryAccelerationDegree.enumMedium);
            } else {
                OperatorDifference.local().accelerateGeometry(horizonPoly, gcs, Geometry.GeometryAccelerationDegree.enumMedium);
            }
            OperatorDisjoint.local().accelerateGeometry(horizonPoly, gcs, Geometry.GeometryAccelerationDegree.enumMedium);
            this.m_lock.lock();
            if (this.m_gcsHorizon == null) {
                this.m_gcsHorizon = horizonPoly;
                this.m_GCSHorisonIsInclusive = GCS_horison_is_inclusive;
                this.m_GCS_split_lines = GCS_split_lines;
            }
            this.m_lock.unlock();
        }
    }

    public boolean getGCSHorisonIsInclusive() {
        if (this.m_isPannable) {
            return this.m_GCSHorisonIsInclusive;
        }
        this.m_lock.lock();
        Geometry gcsHorizon = this.m_gcsHorizon;
        this.m_lock.unlock();
        if (gcsHorizon == null) {
            this.updateGCSHorizon();
        }
        return this.m_GCSHorisonIsInclusive;
    }

    private void updatePCSHorizon() {
        Geometry pcsHorizon;
        if (this.m_cs_type != SpatialReference.Type.Projected) {
            return;
        }
        PeProjcs pcsPe = (PeProjcs)this.m_peCoordSys;
        PeHorizon[] peHorizon = pcsPe.horizonPcsGenerate();
        if (peHorizon == null) {
            return;
        }
        this.getPCSInfo();
        int horizonKind = peHorizon[0].getKind();
        int PCSHorizonIsInclusive = peHorizon[0].getInclusive();
        assert (PCSHorizonIsInclusive != 0);
        int nump = peHorizon[0].getNump();
        boolean b_polygon = false;
        if (horizonKind == 0) {
            double[][] points = peHorizon[0].getCoord();
            Envelope2D env_2D = new Envelope2D();
            env_2D.setCoords(points[0][0], points[0][1]);
            env_2D.merge(points[1][0], points[1][1]);
            pcsHorizon = new Envelope(env_2D);
        } else {
            int i_ring = -1;
            for (int i = 0; i < nump; ++i) {
                if (peHorizon[i].getKind() != 1) continue;
                assert (i_ring == -1);
                i_ring = i;
            }
            assert (i_ring > -1);
            int point_count = peHorizon[i_ring].getSize() - 1;
            double[][] coords = peHorizon[i_ring].getCoord();
            Point2D[] points = new Point2D[point_count];
            for (int j = 0; j < point_count; ++j) {
                points[j] = new Point2D(coords[j][0], coords[j][1]);
            }
            Polygon pcsHorizonPolygon = new Polygon();
            pcsHorizon = pcsHorizonPolygon;
            pcsHorizonPolygon.addPath(points, point_count, true);
            b_polygon = true;
        }
        if (this.getPCSInfo().isDensificationNeeded()) {
            GeometryException.releaseAssert(horizonKind != 0);
            double densify_dist = 100000.0 * this.getOneMeterPCSUnit();
            pcsHorizon = OperatorDensifyByLength.local().execute(pcsHorizon, densify_dist, null);
        }
        PeHorizon.Delete((PeHorizon[])peHorizon);
        if (b_polygon) {
            Envelope dummy = new Envelope();
            pcsHorizon.queryEnvelope(dummy);
            pcsHorizon.calculateArea2D();
            pcsHorizon.calculateLength2D();
            ((Polygon)pcsHorizon).getExteriorRingCount();
            OperatorIntersection.local().accelerateGeometry(pcsHorizon, null, Geometry.GeometryAccelerationDegree.enumMedium);
        }
        this.m_lock.lock();
        if (this.m_pcsHorizon == null) {
            this.m_pcsHorizon = pcsHorizon;
        }
        this.m_lock.unlock();
    }

    private Geometry getPCSHorizonPannable_() {
        return this.m_pcsHorizon;
    }

    public Geometry getPCSHorizon() {
        if (this.m_isPannable) {
            return this.getPCSHorizonPannable_();
        }
        this.m_lock.lock();
        Geometry pcsHorizon = this.m_pcsHorizon;
        this.m_lock.unlock();
        if (pcsHorizon != null) {
            return pcsHorizon;
        }
        this.updatePCSHorizon();
        return this.m_pcsHorizon;
    }

    private void updatePoles() {
        if (this.m_peCoordSys.getType() == 2) {
            double GCS90 = 90.0 * this.getOneDegreeGCSUnit();
            double[] poles = new double[]{0.0, GCS90, 0.0, -GCS90};
            PeCSTransformations.geogToProj((PeProjcs)((PeProjcs)this.m_peCoordSys), (int)2, (double[])poles);
            PePCSInfo info = this.getPCSInfo();
            boolean bNorth = info.getNorthPoleLocation() != 0;
            boolean bSouth = info.getSouthPoleLocation() != 0;
            this.m_lock.lock();
            if (!this.m_polesUpdated) {
                if (bNorth) {
                    this.m_northPole.setCoords(poles[0], poles[1]);
                }
                if (bSouth) {
                    this.m_southPole.setCoords(poles[2], poles[3]);
                }
            }
            this.m_lock.unlock();
        }
        this.m_polesUpdated = true;
    }

    public void getPole(boolean south, Point2D point) {
        boolean updated;
        boolean bl = updated = this.m_isPannable || this.m_polesUpdated;
        if (!updated) {
            this.updatePoles();
        }
        if (south) {
            point.setCoords(this.m_southPole);
        } else {
            point.setCoords(this.m_northPole);
        }
    }

    private void updateDomain() {
        if (this.m_cs_type == SpatialReference.Type.Geographic) {
            double GCS1 = this.getOneDegreeGCSUnit();
            double e = 400.0 * GCS1;
            this.m_domain.setCoords(-e, -e, e, e);
        } else {
            PePCSInfo info = PePCSInfo.generate((PeProjcs)((PeProjcs)this.m_peCoordSys), (int)1);
            Envelope2D d = new Envelope2D(info.getDomainMinx(), info.getDomainMiny(), info.getDomainMaxx(), info.getDomainMaxy());
            this.m_lock.lock();
            if (this.m_domain.isEmpty()) {
                this.m_domain.setCoords(d);
            }
            this.m_lock.unlock();
        }
    }

    public void getDomainXY(Envelope2D domain) {
        if (this.m_isPannable) {
            domain.setCoords(this.m_domain);
        }
        boolean needsDomain = false;
        this.m_lock.lock();
        needsDomain = this.m_domain.isEmpty();
        this.m_lock.unlock();
        if (needsDomain) {
            this.updateDomain();
        }
        domain.setCoords(this.m_domain);
    }

    double getPrimeMeridian() {
        return this.m_primeMeridian;
    }

    Envelope getAreaOfUse() {
        this.m_lock.lock();
        Envelope areaOfUse = this.m_areaOfUse;
        this.m_lock.unlock();
        if (areaOfUse != null) {
            return areaOfUse;
        }
        return this.updateAreaOfUse();
    }

    private Envelope updateAreaOfUse() {
        PeMetadata metadata = PeFactory.metadata((int)this.m_peCoordSys.getType(), (int)this.getLatestID());
        if (metadata == null) {
            return null;
        }
        PeGCSExtent extent = metadata.getGCSExtent();
        if (extent == null) {
            return null;
        }
        double leftLong = extent.getLLon();
        double rightLong = extent.getRLon();
        double northLat = extent.getNLat();
        double southLat = extent.getSLat();
        if (leftLong > rightLong) {
            rightLong += 360.0;
        }
        Envelope envAreaofUse = new Envelope(leftLong, southLat, rightLong, northLat);
        this.m_lock.lock();
        if (this.m_areaOfUse == null) {
            this.m_areaOfUse = envAreaofUse;
        }
        this.m_lock.unlock();
        return this.m_areaOfUse;
    }

    public double getAdjustedCentralMeridian() {
        return this.m_adjustedCentralMeridian;
    }

    public Unit getUnit() {
        return this.m_unit;
    }

    public double getGCSUnitFactor() {
        return this.m_gcsUnitFactor;
    }

    public int hashCode() {
        return this.m_hashCode;
    }
}

