/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorSubCurve;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.SegmentIterator;

@HadoopSDKPublic
public class OperatorSubCurveLocal
extends OperatorSubCurve {
    @Override
    public Polyline getSubCurve(MultiPath multipath, double fromDistance, double toDistance, boolean bAsRatio) {
        double pathLength;
        int ipath;
        InternalUtils.require(multipath != null);
        InternalUtils.require(fromDistance <= toDistance, "fromDistance is greater than toDistance");
        double fromDist = fromDistance;
        double toDist = toDistance;
        double length = multipath.calculateLength2D();
        if (bAsRatio) {
            fromDist *= length;
            toDist *= length;
        }
        if (fromDist <= 0.0 && toDist >= length) {
            if (multipath.getGeometryType() == 1607) {
                return (Polyline)multipath;
            }
            Polyline polyline = new Polyline(multipath.getDescription());
            polyline.add(multipath, false);
            ((MultiPathImpl)polyline._getImpl()).openAllPathsAndDuplicateStartVertex();
            return polyline;
        }
        Polyline polyline = new Polyline(multipath.getDescription());
        double cumulativeLength = 0.0;
        SegmentBuffer segmentBuffer = new SegmentBuffer();
        segmentBuffer.createLine();
        SegmentIterator segIter = multipath.querySegmentIterator();
        while (segIter.nextPath()) {
            double subLength;
            double segmentLength;
            Segment segment;
            ipath = segIter.getPathIndex();
            pathLength = multipath.calculatePathLength2D(ipath);
            if (cumulativeLength + pathLength <= fromDist) {
                cumulativeLength += pathLength;
                continue;
            }
            while (segIter.hasNextSegment()) {
                segment = segIter.nextSegment();
                segmentLength = segment.calculateLength2D();
                if (cumulativeLength + segmentLength <= fromDist) {
                    cumulativeLength += segmentLength;
                    continue;
                }
                subLength = fromDist - cumulativeLength;
                if (cumulativeLength + segmentLength >= toDist) {
                    double t2 = toDist - cumulativeLength;
                    segment.cut(segment.lengthToT(subLength), segment.lengthToT(t2), segmentBuffer);
                    polyline.addSegment(segmentBuffer.get(), true);
                    return polyline;
                }
                cumulativeLength += segmentLength;
                segment.cut(segment.lengthToT(subLength), 1.0, segmentBuffer);
                polyline.addSegment(segmentBuffer.get(), true);
                break;
            }
            while (segIter.hasNextSegment()) {
                segment = segIter.nextSegment();
                segmentLength = segment.calculateLength2D();
                if (cumulativeLength + segmentLength >= toDist) {
                    subLength = toDist - cumulativeLength;
                    double t2 = segment.lengthToT(subLength);
                    segment.cut(0.0, t2, segmentBuffer);
                    polyline.addSegment(segmentBuffer.get(), false);
                    return polyline;
                }
                cumulativeLength += segmentLength;
                polyline.addSegment(segment, false);
            }
            break block0;
        }
        while (segIter.nextPath()) {
            ipath = segIter.getPathIndex();
            pathLength = multipath.calculatePathLength2D(ipath);
            if (cumulativeLength + pathLength <= toDist) {
                cumulativeLength += pathLength;
                polyline.addPath(multipath, ipath, true);
                continue;
            }
            boolean bNewPath = true;
            while (segIter.hasNextSegment()) {
                Segment segment = segIter.nextSegment();
                double segmentLength = segment.calculateLength2D();
                if (cumulativeLength + segmentLength <= toDist) {
                    cumulativeLength += segmentLength;
                    polyline.addSegment(segment, bNewPath);
                    bNewPath = false;
                    continue;
                }
                double subLength = toDist - cumulativeLength;
                double t2 = subLength / segmentLength;
                if (t2 > 0.0) {
                    double tt2 = segment.lengthToT(subLength);
                    segment.cut(0.0, tt2, segmentBuffer);
                    polyline.addSegment(segmentBuffer.get(), bNewPath);
                    bNewPath = false;
                }
                return polyline;
            }
        }
        return polyline;
    }

    public static OperatorSubCurve local() {
        return OperatorFactoryLocal.st_subcurve;
    }
}

