/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryAccelerators;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;

@HadoopSDKPublic
public abstract class OperatorRelate
extends Operator {
    @Override
    @HadoopSDKPublic
    public Operator.Type getType() {
        return Operator.Type.Relate;
    }

    @HadoopSDKPublic
    public abstract boolean execute(Geometry var1, Geometry var2, SpatialReference var3, String var4, ProgressTracker var5);

    @HadoopSDKPublic
    public static OperatorRelate local() {
        return OperatorFactoryLocal.st_relate;
    }

    @Override
    @HadoopSDKPublic
    public boolean canAccelerateGeometry(Geometry geometry) {
        return AccelerateHelper.can_accelerate_geometry(geometry);
    }

    @Override
    @HadoopSDKPublic
    public boolean accelerateGeometry(Geometry geometry, SpatialReference spatialReference, Geometry.GeometryAccelerationDegree accelDegree) {
        return AccelerateHelper.accelerate_geometry(geometry, spatialReference, accelDegree);
    }

    static final class AccelerateHelper {
        AccelerateHelper() {
        }

        static boolean accelerate_geometry(Geometry geometry, SpatialReference sr, Geometry.GeometryAccelerationDegree accel_degree) {
            Geometry.Type type;
            if (!AccelerateHelper.can_accelerate_geometry(geometry)) {
                return false;
            }
            double tol = InternalUtils.calculateToleranceFromGeometryForRel(sr, geometry, false);
            boolean bAccelerated = false;
            if (GeometryAccelerators.canUseRasterizedGeometry(geometry)) {
                bAccelerated |= ((MultiVertexGeometryImpl)geometry._getImpl())._buildRasterizedGeometryAccelerator(tol, accel_degree);
            }
            if (((type = geometry.getType()) == Geometry.Type.Polygon || type == Geometry.Type.Polyline) && GeometryAccelerators.canUseQuadTree(geometry) && accel_degree != Geometry.GeometryAccelerationDegree.enumMild) {
                bAccelerated |= ((MultiVertexGeometryImpl)geometry._getImpl())._buildQuadTreeAccelerator(accel_degree);
            }
            if ((type == Geometry.Type.Polygon || type == Geometry.Type.Polyline) && GeometryAccelerators.canUseQuadTreeForPaths(geometry) && accel_degree != Geometry.GeometryAccelerationDegree.enumMild) {
                bAccelerated |= ((MultiPathImpl)geometry._getImpl())._buildQuadTreeForPathsAccelerator(accel_degree);
            }
            return bAccelerated;
        }

        static boolean can_accelerate_geometry(Geometry geometry) {
            return GeometryAccelerators.canUseRasterizedGeometry(geometry) || GeometryAccelerators.canUseQuadTree(geometry) || GeometryAccelerators.canUseQuadTreeForPaths(geometry);
        }
    }
}

