/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.LegacyProject;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.OperatorProjectCursor;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.SpatialReference;

@HadoopSDKExcluded
final class OperatorProjectLocal
extends OperatorProject {
    OperatorProjectLocal() {
    }

    @Override
    public GeometryCursor execute(GeometryCursor inputGeoms, ProjectionTransformation transform, ProgressTracker progressTracker) {
        if (transform.isIdentity()) {
            return inputGeoms;
        }
        return new OperatorProjectCursor(inputGeoms, transform, progressTracker);
    }

    @Override
    public Geometry execute(Geometry inputGeom, ProjectionTransformation transform, ProgressTracker progressTracker) {
        return LegacyProject.project(inputGeom, transform, progressTracker);
    }

    @Override
    public int transform(ProjectionTransformation transform, Point[] pointsIn, int count, Point[] pointsOut) {
        return LegacyProject.transform(transform, pointsIn, count, pointsOut, true);
    }

    @Override
    public int transform(ProjectionTransformation transform, Point[] pointsIn, int count, Point[] pointsOut, boolean removeClippedOutPoints) {
        return LegacyProject.transform(transform, pointsIn, count, pointsOut, removeClippedOutPoints);
    }

    @Override
    public double[] transform(ProjectionTransformation transform, double[] coordsSrc, int pointCount) {
        return LegacyProject.transform(transform, coordsSrc, pointCount);
    }

    @Override
    public int transform(ProjectionTransformation transform, Point2D[] pointsIn, int count, Point2D[] pointsOut) {
        return LegacyProject.transform(transform, pointsIn, count, pointsOut);
    }

    @Override
    public int transform(ProjectionTransformation transform, Point2D[] pointsIn, int count, Point2D[] pointsOut, boolean removeClippedPoints) {
        if (removeClippedPoints) {
            return LegacyProject.transform(transform, pointsIn, count, pointsOut);
        }
        return LegacyProject.transformInPlace(transform, pointsIn, count, pointsOut);
    }

    @Override
    public int transform(ProjectionTransformation transform, Point3D[] pointsIn, int count, Point3D[] pointsOut) {
        return LegacyProject.transform(transform, pointsIn, count, pointsOut);
    }

    @Override
    public Geometry foldInto360RangeGeodetic(Geometry _geom, SpatialReference pannableSR, int curveType) {
        return LegacyProject.foldInto360RangeGeodetic(_geom, pannableSR, curveType, null);
    }

    @Override
    public Geometry foldInto360Range(Geometry geom, SpatialReference pannableSR) {
        return LegacyProject.foldInto360Range(geom, pannableSR, null);
    }

    @Override
    public Geometry clipToSpatialReference(Geometry geometry, SpatialReference sr, ProgressTracker progressTracker, OperatorProject.DomainClipOptions options) {
        return LegacyProject.clipToSpatialReference(geometry, sr, progressTracker, options);
    }
}

