/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.LegacyProject;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionTransformation;

@HadoopSDKExcluded
final class OperatorProjectCursor
extends GeometryCursor {
    GeometryCursor m_inputGeoms;
    ProjectionTransformation m_projTrans;
    int m_index = -1;
    ProgressTracker m_progressTracker;

    public OperatorProjectCursor(GeometryCursor inputGeoms, ProjectionTransformation transform, ProgressTracker progressTracker) {
        if (inputGeoms == null) {
            throw new IllegalArgumentException();
        }
        this.m_inputGeoms = inputGeoms;
        this.m_projTrans = transform;
        this.m_progressTracker = progressTracker;
    }

    @Override
    public Geometry next() {
        Geometry geom;
        if (this.m_inputGeoms != null && (geom = this.m_inputGeoms.next()) != null) {
            this.m_index = this.m_inputGeoms.getGeometryID();
            return LegacyProject.project(geom, this.m_projTrans, this.m_progressTracker);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }
}

