/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCollection;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.LocateBetween;
import com.esri.core.geometry.ProgressTracker;

@HadoopSDKExcluded
public class OperatorLocateBetweenCursor
extends GeometryCursor {
    private GeometryCursor m_input_geoms;
    private GeometryCursor m_collection_cursor = null;
    private Envelope1D m_interval;
    private ProgressTracker m_progress_tracker;
    private int m_index;

    OperatorLocateBetweenCursor(GeometryCursor input_geoms, Envelope1D interval_M, ProgressTracker progress_tracker) {
        this.m_interval = new Envelope1D(interval_M);
        this.m_input_geoms = input_geoms;
        this.m_progress_tracker = progress_tracker;
        this.m_index = -1;
    }

    @Override
    public Geometry next() {
        Geometry current_geometry;
        if (this.m_collection_cursor != null) {
            current_geometry = this.m_collection_cursor.next();
            if (current_geometry != null) {
                return current_geometry;
            }
            this.m_collection_cursor = null;
        }
        if ((current_geometry = this.m_input_geoms.next()) == null) {
            return null;
        }
        this.m_index = this.m_input_geoms.getGeometryID();
        Geometry result_geom = LocateBetween.execute(current_geometry, 2, 0, this.m_interval, this.m_progress_tracker);
        if (result_geom.getGeometryType() == 3594) {
            this.m_collection_cursor = GeometryCollection.generateGeometryCursor((GeometryCollection)result_geom, -1);
            Geometry res = this.m_collection_cursor.next();
            assert (res != null);
            return res;
        }
        return result_geom;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }
}

