/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Centroid;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorProximity2D;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.PolygonUtils;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Proximity2DResult;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;

@HadoopSDKExcluded
public class OperatorLabelPointCursor
extends GeometryCursor {
    private GeometryCursor m_inputGeoms;
    private int m_index = -1;

    OperatorLabelPointCursor(GeometryCursor inputGeoms, ProgressTracker progress_tracker) {
        this.m_inputGeoms = inputGeoms;
    }

    @Override
    public Geometry next() {
        Geometry geom = this.m_inputGeoms.next();
        if (geom != null) {
            this.m_index = this.m_inputGeoms.getGeometryID();
            return this.label_point(geom);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    public Point label_point(Geometry geom) {
        if (geom == null) {
            throw new GeometryException("Expects a non-null geometry.");
        }
        if (geom.getType() == Geometry.Type.Point) {
            return (Point)geom;
        }
        if (geom.isEmpty()) {
            return (Point)geom.createInstance();
        }
        Geometry.Type type = geom.getType();
        switch (type) {
            case Polygon: {
                return this.label_point((Polygon)geom);
            }
            case Polyline: {
                return this.label_point((Polyline)geom);
            }
            case MultiPoint: {
                return this.label_point((MultiPoint)geom);
            }
            case Envelope: {
                return this.label_point((Envelope)geom);
            }
        }
        throw new GeometryException("geometry is not supported");
    }

    public Point label_point(Polygon polygon) {
        int start_index;
        double ymin;
        double xmin;
        MultiPathImpl mp_impl = (MultiPathImpl)polygon._getImpl();
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)mp_impl.getAttributeStreamRef(0);
        double xmax = xmin = position.read(0);
        double ymax = ymin = position.read(1);
        for (int i = 1; i < polygon.getPathEnd(0); ++i) {
            double x = position.read(2 * i);
            double y = position.read(2 * i + 1);
            if (x < xmin) {
                xmin = x;
            } else if (x > xmax) {
                xmax = x;
            }
            if (y < ymin) {
                ymin = y;
                continue;
            }
            if (!(y > ymax)) continue;
            ymax = y;
        }
        double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(null, polygon, true);
        Point2D centroid = new Point2D();
        double area = polygon.calculateRingArea2D(0);
        if (Math.abs(area) <= 2.0 * tolerance * tolerance) {
            centroid.setNaN();
        } else {
            centroid = Centroid.calculatePolygonCentroid2D(polygon, 0);
        }
        if (NumberUtils.isNaN(centroid.x)) {
            Point result_point = new Point(polygon.getDescription());
            result_point.setXY((xmax + xmin) / 2.0, (ymax + ymin) / 2.0);
            return result_point;
        }
        if (polygon.getPointCount() < 4) {
            Point result_point = new Point(polygon.getDescription());
            result_point.setXY(centroid.x, centroid.y);
            return result_point;
        }
        Point2D[] candidatePoints = new Point2D[4];
        double[] distanceToBoundary = new double[4];
        double[] distanceToCentroidSq = new double[4];
        OperatorProximity2D opProximity = OperatorProximity2D.local();
        Boolean bPolygonContainsCentroid = false;
        Proximity2DResult proxResult = opProximity.getNearestCoordinate(polygon, new Point(centroid.x, centroid.y), true, false);
        if (proxResult.getDistance() == 0.0) {
            bPolygonContainsCentroid = true;
            candidatePoints[0] = centroid;
            proxResult = opProximity.getNearestCoordinate(polygon, new Point(centroid), false, false);
        }
        distanceToBoundary[0] = proxResult.getDistance();
        distanceToCentroidSq[0] = 0.0;
        boolean bFoundGoodParacentroid = false;
        double ratio = 0.25;
        double max_dist = -1.0;
        double dist = NumberUtils.NaN();
        Point2D maxCandidatePoint = new Point2D();
        maxCandidatePoint.setNaN();
        do {
            candidatePoints[1] = this.calculateParacentroid(polygon, ratio * (xmax - xmin) + xmin, tolerance);
            proxResult = opProximity.getNearestCoordinate(polygon, new Point(candidatePoints[1]), false, false);
            dist = proxResult.getDistance();
            if (dist > tolerance && PolygonUtils.isPointInPolygon2D(polygon, new Point(candidatePoints[1]), tolerance) == PolygonUtils.PiPResult.PiPInside) {
                bFoundGoodParacentroid = true;
                distanceToBoundary[1] = dist;
                distanceToCentroidSq[1] = Point2D.sqrDistance(candidatePoints[1], centroid);
                continue;
            }
            if (dist > max_dist) {
                max_dist = dist;
                maxCandidatePoint.setCoords(candidatePoints[1]);
            }
            if (!((ratio -= 0.01) < 0.1)) continue;
            assert (max_dist > 0.0);
            bFoundGoodParacentroid = true;
            distanceToBoundary[1] = max_dist;
            candidatePoints[1] = maxCandidatePoint;
            distanceToCentroidSq[1] = Point2D.sqrDistance(candidatePoints[1], centroid);
        } while (!bFoundGoodParacentroid);
        bFoundGoodParacentroid = false;
        ratio = 0.5;
        max_dist = -1.0;
        dist = NumberUtils.NaN();
        double offset = 0.01;
        int offsetsign = 1;
        do {
            candidatePoints[2] = this.calculateParacentroid(polygon, ratio * (xmax - xmin) + xmin, tolerance);
            proxResult = opProximity.getNearestCoordinate(polygon, new Point(candidatePoints[2]), false, false);
            dist = proxResult.getDistance();
            if (dist > tolerance && PolygonUtils.isPointInPolygon2D(polygon, new Point(candidatePoints[2]), tolerance) == PolygonUtils.PiPResult.PiPInside) {
                bFoundGoodParacentroid = true;
                distanceToBoundary[2] = dist;
                distanceToCentroidSq[2] = Point2D.sqrDistance(candidatePoints[2], centroid);
                continue;
            }
            if (dist > max_dist) {
                max_dist = dist;
                maxCandidatePoint.setCoords(candidatePoints[2]);
            }
            ratio = 0.5 + offset * (double)offsetsign;
            offset += 0.01;
            offsetsign *= -1;
            if (!(ratio < 0.3) && !(ratio > 0.7)) continue;
            assert (max_dist > 0.0);
            bFoundGoodParacentroid = true;
            distanceToBoundary[2] = max_dist;
            candidatePoints[2] = maxCandidatePoint;
            distanceToCentroidSq[2] = Point2D.sqrDistance(candidatePoints[2], centroid);
        } while (!bFoundGoodParacentroid);
        bFoundGoodParacentroid = false;
        ratio = 0.75;
        max_dist = -1.0;
        dist = NumberUtils.NaN();
        do {
            candidatePoints[3] = this.calculateParacentroid(polygon, ratio * (xmax - xmin) + xmin, tolerance);
            proxResult = opProximity.getNearestCoordinate(polygon, new Point(candidatePoints[3]), false, false);
            dist = proxResult.getDistance();
            if (dist > tolerance && PolygonUtils.isPointInPolygon2D(polygon, new Point(candidatePoints[3]), tolerance) == PolygonUtils.PiPResult.PiPInside) {
                bFoundGoodParacentroid = true;
                distanceToBoundary[3] = dist;
                distanceToCentroidSq[3] = Point2D.sqrDistance(candidatePoints[3], centroid);
                continue;
            }
            if (dist > max_dist) {
                max_dist = dist;
                maxCandidatePoint.setCoords(candidatePoints[3]);
            }
            if (!((ratio += 0.01) > 0.9)) continue;
            assert (max_dist > 0.0);
            bFoundGoodParacentroid = true;
            distanceToBoundary[3] = max_dist;
            candidatePoints[3] = maxCandidatePoint;
            distanceToCentroidSq[3] = Point2D.sqrDistance(candidatePoints[3], centroid);
        } while (!bFoundGoodParacentroid);
        int[] candidateIndices = new int[]{0, 1, 2, 3};
        for (int i = start_index = bPolygonContainsCentroid != false ? 0 : 1; i < 4; ++i) {
            for (int j = start_index; j < 3; ++j) {
                double distanceSq = distanceToCentroidSq[j];
                double distanceSqNext = distanceToCentroidSq[j + 1];
                if (!(distanceSq > distanceSqNext)) continue;
                int index = candidateIndices[j];
                candidateIndices[j] = candidateIndices[j + 1];
                candidateIndices[j + 1] = index;
                distanceToCentroidSq[j] = distanceSqNext;
                distanceToCentroidSq[j + 1] = distanceSq;
            }
        }
        int bestCandidate = start_index;
        double maxScore = 0.0;
        double score = 0.0;
        for (int i = start_index; i < 4; ++i) {
            switch (i) {
                case 0: {
                    score = distanceToBoundary[candidateIndices[i]] * 2.0;
                    break;
                }
                case 1: {
                    score = distanceToBoundary[candidateIndices[i]] * 1.66666666;
                    break;
                }
                case 2: {
                    score = distanceToBoundary[candidateIndices[i]] * 1.33333333;
                    break;
                }
                case 3: {
                    score = distanceToBoundary[candidateIndices[i]];
                }
            }
            if (!(score > maxScore)) continue;
            maxScore = score;
            bestCandidate = candidateIndices[i];
        }
        Point result_point = new Point(polygon.getDescription());
        result_point.setXY(candidatePoints[bestCandidate].x, candidatePoints[bestCandidate].y);
        return result_point;
    }

    public Point label_point(Polyline polyline) {
        Point2D lp = new Point2D();
        lp.setNaN();
        int point_count = polyline.getPointCount();
        int path_count = polyline.getPathCount();
        if (point_count > 2 * path_count) {
            int maxPathLengthIndex = -1;
            double maxPathLength = -NumberUtils.doubleMax();
            int n = polyline.getPathCount();
            for (int ipath = 0; ipath < n; ++ipath) {
                double pathLength;
                if (polyline.getPathSize(ipath) <= 2 || !((pathLength = polyline.calculatePathLength2D(ipath)) > maxPathLength)) continue;
                maxPathLength = pathLength;
                maxPathLengthIndex = ipath;
            }
            int istart = polyline.getPathStart(maxPathLengthIndex);
            int iend = polyline.getPathEnd(maxPathLengthIndex);
            int imiddle = (istart + iend) / 2;
            lp = polyline.getXY(imiddle);
        } else {
            double maxSegmentLength = -NumberUtils.doubleMax();
            SegmentIterator seg_iter = polyline.querySegmentIterator();
            while (seg_iter.nextPath()) {
                Segment segment;
                double segment_length;
                if (!seg_iter.hasNextSegment() || !((segment_length = (segment = seg_iter.nextSegment()).calculateLength2D()) > maxSegmentLength)) continue;
                maxSegmentLength = segment_length;
                lp = segment.getCoord2D(0.5);
            }
        }
        Point result_point = new Point(polyline.getDescription());
        result_point.setXY(lp.x, lp.y);
        return result_point;
    }

    public Point label_point(MultiPoint multipoint) {
        Envelope2D envelope = new Envelope2D();
        multipoint.queryEnvelope2D(envelope);
        Point2D center = envelope.getCenter();
        Proximity2DResult proxResult = OperatorProximity2D.local().getNearestCoordinate(multipoint, new Point(center.x, center.y), false, false);
        Point result_point = proxResult.getCoordinate();
        result_point.assignVertexDescription(multipoint.getDescription());
        return result_point;
    }

    public Point label_point(Envelope envelope) {
        Point result_point = envelope.getCenter();
        result_point.assignVertexDescription(envelope.getDescription());
        return result_point;
    }

    private Point2D calculateParacentroid(Polygon polygon, double xparacentroid, double tolerance) {
        Envelope2D envelope = new Envelope2D();
        polygon.queryEnvelope2D(envelope);
        Point2D paracentroid = new Point2D();
        paracentroid.x = xparacentroid;
        double y1 = NumberUtils.doubleMax();
        double y2 = NumberUtils.doubleMax();
        boolean bFoundY1 = false;
        boolean bFoundY2 = false;
        Line vertical_line = new Line();
        vertical_line.setStartXY(paracentroid.x, envelope.ymin - 1.0);
        vertical_line.setEndXY(paracentroid.x, envelope.ymax + 1.0);
        Envelope2D segmentBoundingBox = new Envelope2D();
        Point2D paracentroidStart = new Point2D();
        Point2D paracentroidEnd = new Point2D();
        Point2D[] intersection_points = new Point2D[2];
        SegmentIterator seg_iter = polygon.querySegmentIterator();
        while (seg_iter.nextPath()) {
            while (seg_iter.hasNextSegment()) {
                int cIntersections;
                Segment segment = seg_iter.nextSegment();
                segment.queryEnvelope2D(segmentBoundingBox);
                paracentroidStart.setCoords(vertical_line.getStartXY());
                paracentroidEnd.setCoords(vertical_line.getEndXY());
                if (segmentBoundingBox.clipLine(paracentroidStart, paracentroidEnd) == 0 || (cIntersections = vertical_line.intersect(segment, intersection_points, null, null, tolerance)) != 1) continue;
                double y = intersection_points[0].y;
                if (y1 > y2) {
                    if (!(y < y1)) continue;
                    y1 = y;
                    bFoundY1 = true;
                    continue;
                }
                if (!(y < y2)) continue;
                y2 = y;
                bFoundY2 = true;
            }
        }
        assert (bFoundY1 && bFoundY2);
        paracentroid.y = (y1 + y2) / 2.0;
        return paracentroid;
    }
}

