/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.JSONUtils;
import com.esri.core.geometry.JsonGeometryException;
import com.esri.core.geometry.JsonReader;
import com.esri.core.geometry.JsonReaderCursor;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.MapGeometryCursor;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;

class OperatorImportFromJsonCursor
extends MapGeometryCursor {
    JsonReaderCursor m_inputJsonParsers;
    int m_type;
    int m_index = -1;

    public OperatorImportFromJsonCursor(int type, JsonReaderCursor jsonParsers) {
        if (jsonParsers == null) {
            throw new IllegalArgumentException();
        }
        this.m_type = type;
        this.m_inputJsonParsers = jsonParsers;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    @Override
    public MapGeometry next() {
        JsonReader jsonReader = this.m_inputJsonParsers.next();
        if (jsonReader != null) {
            this.m_index = this.m_inputJsonParsers.getID();
            return OperatorImportFromJsonCursor.importFromJsonParser(this.m_type, 0, jsonReader);
        }
        return null;
    }

    static MapGeometry importFromJsonParser(int gt, int importFlags, JsonReader parser) throws JsonGeometryException {
        MapGeometry mp;
        try {
            double nan;
            if (!JSONUtils.isObjectStart(parser)) {
                return null;
            }
            boolean bFoundSpatial_reference = false;
            boolean bFoundHasZ = false;
            boolean bFoundHasM = false;
            boolean bFoundPolygon = false;
            boolean bFoundPolyline = false;
            boolean bFoundMultiPoint = false;
            boolean bFoundX = false;
            boolean bFoundY = false;
            boolean bFoundZ = false;
            boolean bFoundM = false;
            boolean bFoundXMin = false;
            boolean bFoundYMin = false;
            boolean bFoundXMax = false;
            boolean bFoundYMax = false;
            boolean bFoundZMin = false;
            boolean bFoundZMax = false;
            boolean bFoundMMin = false;
            boolean bFoundMMax = false;
            double x = nan = Double.NaN;
            double y = nan;
            double z = nan;
            double m = nan;
            double xmin = nan;
            double ymin = nan;
            double xmax = nan;
            double ymax = nan;
            double zmin = nan;
            double zmax = nan;
            double mmin = nan;
            double mmax = nan;
            boolean bHasZ = false;
            boolean bHasM = false;
            AttributeStreamBase as = null;
            AttributeStreamBase bs = null;
            Geometry geometry = null;
            SpatialReference spatial_reference = null;
            while (parser.nextToken() != JsonReader.Token.END_OBJECT) {
                String name = parser.currentString();
                parser.nextToken();
                if (!bFoundSpatial_reference && name.equals("spatialReference")) {
                    bFoundSpatial_reference = true;
                    if (parser.currentToken() == JsonReader.Token.START_OBJECT) {
                        spatial_reference = SpatialReference.fromJson(parser);
                    } else if (parser.currentToken() != JsonReader.Token.VALUE_NULL) {
                        throw new GeometryException("failed to parse spatial reference: object or null is expected");
                    }
                } else if (!bFoundHasZ && name.equals("hasZ")) {
                    bFoundHasZ = true;
                    bHasZ = parser.currentToken() == JsonReader.Token.VALUE_TRUE;
                } else if (!bFoundHasM && name.equals("hasM")) {
                    bFoundHasM = true;
                    bHasM = parser.currentToken() == JsonReader.Token.VALUE_TRUE;
                } else {
                    PairAsBs asbs;
                    if (!bFoundPolygon && name.equals("rings") && (gt == 0 || gt == 1736)) {
                        bFoundPolygon = true;
                        asbs = new PairAsBs();
                        geometry = OperatorImportFromJsonCursor.importFromJsonMultiPath(true, importFlags, parser, asbs);
                        as = asbs.as;
                        bs = asbs.bs;
                        continue;
                    }
                    if (!bFoundPolyline && name.equals("paths") && (gt == 0 || gt == 1607)) {
                        bFoundPolyline = true;
                        asbs = new PairAsBs();
                        geometry = OperatorImportFromJsonCursor.importFromJsonMultiPath(false, importFlags, parser, asbs);
                        as = asbs.as;
                        bs = asbs.bs;
                        continue;
                    }
                    if (!bFoundMultiPoint && name.equals("points") && (gt == 0 || gt == 550)) {
                        bFoundMultiPoint = true;
                        as = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
                        bs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
                        geometry = OperatorImportFromJsonCursor.importFromJsonMultiPoint(parser, (AttributeStreamOfDbl)as, (AttributeStreamOfDbl)bs);
                        continue;
                    }
                    if (!bFoundX && name.equals("x") && (gt == 0 || gt == 33)) {
                        bFoundX = true;
                        x = OperatorImportFromJsonCursor.readDouble(parser);
                    } else if (!bFoundY && name.equals("y") && (gt == 0 || gt == 33)) {
                        bFoundY = true;
                        y = OperatorImportFromJsonCursor.readDouble(parser);
                    } else if (!bFoundZ && name.equals("z") && (gt == 0 || gt == 33)) {
                        bFoundZ = true;
                        z = OperatorImportFromJsonCursor.readDouble(parser);
                    } else if (!bFoundM && name.equals("m") && (gt == 0 || gt == 33)) {
                        bFoundM = true;
                        m = OperatorImportFromJsonCursor.readDouble(parser);
                    }
                }
                if (!bFoundXMin && name.equals("xmin") && (gt == 0 || gt == 197)) {
                    bFoundXMin = true;
                    xmin = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundYMin && name.equals("ymin") && (gt == 0 || gt == 197)) {
                    bFoundYMin = true;
                    ymin = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundMMin && name.equals("mmin") && (gt == 0 || gt == 197)) {
                    bFoundMMin = true;
                    mmin = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundZMin && name.equals("zmin") && (gt == 0 || gt == 197)) {
                    bFoundZMin = true;
                    zmin = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundXMax && name.equals("xmax") && (gt == 0 || gt == 197)) {
                    bFoundXMax = true;
                    xmax = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundYMax && name.equals("ymax") && (gt == 0 || gt == 197)) {
                    bFoundYMax = true;
                    ymax = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundMMax && name.equals("mmax") && (gt == 0 || gt == 197)) {
                    bFoundMMax = true;
                    mmax = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                if (!bFoundZMax && name.equals("zmax") && (gt == 0 || gt == 197)) {
                    bFoundZMax = true;
                    zmax = OperatorImportFromJsonCursor.readDouble(parser);
                    continue;
                }
                OperatorImportFromJsonCursor.windup(parser);
            }
            if (bFoundPolygon || bFoundPolyline || bFoundMultiPoint) {
                assert (geometry != null);
                MultiVertexGeometryImpl mvImpl = (MultiVertexGeometryImpl)geometry._getImpl();
                AttributeStreamBase zs = null;
                AttributeStreamBase ms = null;
                geometry.assignVertexDescription(VertexDescriptionDesignerImpl.getVertexDescription(bHasZ, bHasM, false));
                if (bHasZ && (zs = as) == null) {
                    zs = AttributeStreamBase.createDoubleStream(mvImpl.getPointCount(), NumberUtils.NaN());
                }
                if (bHasM) {
                    AttributeStreamBase attributeStreamBase = ms = !bHasZ ? as : bs;
                }
                if (bHasZ && zs != null) {
                    mvImpl.setAttributeStreamRef(1, zs);
                }
                if (bHasM && ms != null) {
                    mvImpl.setAttributeStreamRef(2, ms);
                }
                mvImpl.notifyModified(0xFFFFFF);
            } else if (bFoundX || bFoundY || bFoundY || bFoundZ) {
                if (NumberUtils.isNaN(y) || NumberUtils.isNaN(x)) {
                    x = NumberUtils.NaN();
                    y = NumberUtils.NaN();
                }
                Point p = new Point(VertexDescriptionDesignerImpl.getVertexDescription(bHasZ, bHasM, false));
                p.setXY(x, y);
                if (bFoundZ) {
                    p.setZ(z);
                }
                if (bFoundM) {
                    p.setM(m);
                }
                geometry = p;
            } else if (bFoundXMin || bFoundYMin || bFoundXMax || bFoundYMax || bFoundZMin || bFoundZMax || bFoundMMin || bFoundMMax) {
                if (NumberUtils.isNaN(ymin) || NumberUtils.isNaN(xmax) || NumberUtils.isNaN(ymax)) {
                    xmin = NumberUtils.NaN();
                }
                Envelope e = new Envelope(VertexDescriptionDesignerImpl.getVertexDescription(bHasZ, bHasM, false));
                e.setCoords(xmin, ymin, xmax, ymax);
                if (bFoundZMin && bFoundZMax) {
                    e.setInterval(1, 0, zmin, zmax);
                }
                if (bFoundMMin && bFoundMMax) {
                    e.setInterval(2, 0, mmin, mmax);
                }
                geometry = e;
            }
            mp = new MapGeometry(geometry, spatial_reference);
        }
        catch (Exception e) {
            return null;
        }
        return mp;
    }

    public static MapGeometry fromJsonToUnknown(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(0, 0, parser);
    }

    public static MapGeometry fromJsonToEnvelope(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(197, 0, parser);
    }

    public static MapGeometry fromJsonToPoint(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(33, 0, parser);
    }

    public static MapGeometry fromJsonToPolygon(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(1736, 0, parser);
    }

    public static MapGeometry fromJsonToPolyline(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(1607, 0, parser);
    }

    public static MapGeometry fromJsonToMultiPoint(JsonReader parser) throws Exception {
        return OperatorImportFromJsonCursor.importFromJsonParser(550, 0, parser);
    }

    private static void windup(JsonReader parser) {
        parser.skipChildren();
    }

    private static double readDouble(JsonReader parser) {
        if (parser.currentToken() == JsonReader.Token.VALUE_NULL || parser.currentToken() == JsonReader.Token.VALUE_STRING && parser.currentString().equals("NaN")) {
            return NumberUtils.NaN();
        }
        return parser.currentDoubleValue();
    }

    private static Geometry importFromJsonMultiPoint(JsonReader parser, AttributeStreamOfDbl as, AttributeStreamOfDbl bs) {
        if (parser.currentToken() != JsonReader.Token.START_ARRAY) {
            throw new GeometryException("failed to parse multipoint: array of vertices is expected");
        }
        int point_count = 0;
        MultiPoint multipoint = new MultiPoint();
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(2, 0.0);
        double[] buf = new double[4];
        while (parser.nextToken() != JsonReader.Token.END_ARRAY) {
            int c;
            if (parser.currentToken() != JsonReader.Token.START_ARRAY) {
                throw new GeometryException("failed to parse multipoint: array is expected, multipoint vertices consist of arrays of cooridinates");
            }
            int sz = 0;
            while (parser.nextToken() != JsonReader.Token.END_ARRAY) {
                buf[sz++] = OperatorImportFromJsonCursor.readDouble(parser);
            }
            if (sz < 2) {
                throw new GeometryException("failed to parse multipoint: each vertex array has to have at least 2 elements");
            }
            if (position.size() == 2 * point_count) {
                c = point_count * 3;
                if (c % 2 != 0) {
                    ++c;
                }
                position.resize(c);
            }
            position.write(2 * point_count, buf[0]);
            position.write(2 * point_count + 1, buf[1]);
            if (as.size() == point_count) {
                c = point_count * 3 / 2;
                if (c < 4) {
                    c = 4;
                } else if (c < 16) {
                    c = 16;
                }
                as.resize(c);
            }
            if (sz > 2) {
                as.write(point_count, buf[2]);
            } else {
                as.write(point_count, NumberUtils.NaN());
            }
            if (bs.size() == point_count) {
                c = point_count * 3 / 2;
                if (c < 4) {
                    c = 4;
                } else if (c < 16) {
                    c = 16;
                }
                bs.resize(c);
            }
            if (sz > 3) {
                bs.write(point_count, buf[3]);
            } else {
                bs.write(point_count, NumberUtils.NaN());
            }
            ++point_count;
        }
        if (point_count != 0) {
            MultiPointImpl mp_impl = (MultiPointImpl)multipoint._getImpl();
            mp_impl.resizeNoInit(point_count);
            mp_impl.setAttributeStreamRef(0, position);
        }
        return multipoint;
    }

    private static int get_resize_size_for_one_component_(int point_count) {
        int c = (point_count + 1) * 3 / 2;
        if (c < 4) {
            c = 4;
        } else if (c < 16) {
            c = 16;
        }
        assert (c >= point_count + 1);
        return c;
    }

    private static int get_resize_size_for_two_components_(int point_count) {
        int c = (point_count + 1) * 3 / 2 * 2;
        if (c < 8) {
            c = 8;
        } else if (c < 32) {
            c = 32;
        }
        assert (c >= (point_count + 1) * 2);
        return c;
    }

    private static Geometry importFromJsonMultiPath(boolean b_polygon, int importFlags, JsonReader parser, PairAsBs asbs) throws Exception {
        byte pathFlag;
        if (parser.currentToken() != JsonReader.Token.START_ARRAY) {
            throw new GeometryException("failed to parse multipath: array of array of vertices is expected");
        }
        boolean deltaEncoded104 = false;
        MultiPath multipath = b_polygon ? new Polygon() : new Polyline();
        AttributeStreamOfInt32 parts = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0);
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(2, 0.0);
        AttributeStreamOfInt8 pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(0);
        double[] buf = new double[4];
        double[] start_vertex = new double[4];
        int point_count = 0;
        int path_count = 0;
        byte by = pathFlag = b_polygon ? (byte)1 : 0;
        while (parser.nextToken() != JsonReader.Token.END_ARRAY) {
            if (parser.currentToken() != JsonReader.Token.START_ARRAY) {
                throw new GeometryException("failed to parse multipath: ring/path array is expected");
            }
            int minimumRequiredPathSize = 2;
            int pathPointCount = 0;
            boolean b_first = true;
            int vertex_size = 0;
            int vertex_size_start = 0;
            long deltaX = 0L;
            long deltaY = 0L;
            parser.nextToken();
            while (parser.currentToken() != JsonReader.Token.END_ARRAY) {
                if (parser.currentToken() != JsonReader.Token.START_ARRAY) {
                    throw new GeometryException("failed to parse multipath: array is expected, rings/paths vertices consist of arrays of cooridinates");
                }
                vertex_size = 0;
                while (parser.nextToken() != JsonReader.Token.END_ARRAY) {
                    if (vertex_size == buf.length) {
                        throw new GeometryException("failed to parse multipath: each vertex array has to have at most 4 elements");
                    }
                    buf[vertex_size++] = OperatorImportFromJsonCursor.readDouble(parser);
                }
                if (vertex_size < 2) {
                    throw new GeometryException("failed to parse multipath: each vertex array has to have at least 2 elements");
                }
                if (deltaEncoded104) {
                    buf[0] = deltaX += (long)buf[0];
                    buf[1] = deltaY += (long)buf[1];
                }
                parser.nextToken();
                do {
                    if (position.size() == point_count * 2) {
                        position.resize(OperatorImportFromJsonCursor.get_resize_size_for_two_components_(point_count));
                    }
                    position.write(2 * point_count, buf[0]);
                    position.write(2 * point_count + 1, buf[1]);
                    if (asbs.as != null && asbs.as.size() == point_count) {
                        asbs.as.resize(OperatorImportFromJsonCursor.get_resize_size_for_one_component_(point_count));
                    }
                    if (vertex_size > 2) {
                        if (asbs.as == null) {
                            asbs.as = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(point_count + 1, Double.NaN);
                        }
                        asbs.as.write(point_count, buf[2]);
                    } else if (asbs.as != null) {
                        asbs.as.write(point_count, Double.NaN);
                    }
                    if (asbs.bs != null && asbs.bs.size() == point_count) {
                        asbs.bs.resize(OperatorImportFromJsonCursor.get_resize_size_for_one_component_(point_count));
                    }
                    if (vertex_size > 3) {
                        if (asbs.bs == null) {
                            asbs.bs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(point_count + 1, Double.NaN);
                        }
                        asbs.bs.write(point_count, buf[3]);
                    } else if (asbs.bs != null) {
                        asbs.bs.write(point_count, Double.NaN);
                    }
                    if (b_first) {
                        ++path_count;
                        parts.add(point_count);
                        pathFlags.add(pathFlag);
                        b_first = false;
                        vertex_size_start = vertex_size;
                        start_vertex[0] = buf[0];
                        start_vertex[1] = buf[1];
                        start_vertex[2] = buf[2];
                        start_vertex[3] = buf[3];
                    }
                    ++point_count;
                } while (++pathPointCount < minimumRequiredPathSize && parser.currentToken() == JsonReader.Token.END_ARRAY);
            }
            if (pathPointCount == 0 || !b_polygon) continue;
            boolean vertEq = true;
            for (int i = 0; i < vertex_size; ++i) {
                vertEq &= NumberUtils.isEqualNonIEEE(buf[i], start_vertex[i]);
            }
            if (pathPointCount > minimumRequiredPathSize && vertex_size == vertex_size_start && vertEq) assert (--pathPointCount != 0 && --point_count != 0);
        }
        if (point_count != 0) {
            parts.resize(path_count);
            pathFlags.resize(path_count);
            if (point_count > 0) {
                parts.add(point_count);
                pathFlags.add((byte)0);
            }
            MultiPathImpl mp_impl = (MultiPathImpl)multipath._getImpl();
            mp_impl.setAttributeStreamRef(0, position);
            mp_impl.setPathFlagsStreamRef(pathFlags);
            mp_impl.setPathStreamRef(parts);
            mp_impl.notifyModified(0xFFFFFF);
        }
        return multipath;
    }

    private static class PairAsBs {
        AttributeStreamOfDbl as = null;
        AttributeStreamOfDbl bs = null;

        private PairAsBs() {
        }
    }
}

