/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.GeodeticDensify;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;

@HadoopSDKExcluded
class OperatorGeodeticDensifyCursor
extends GeometryCursor {
    private GeometryCursor m_input_geoms;
    private SpatialReference m_spatial_reference;
    private int m_curve_type;
    private double m_max_length_meters;
    private double m_max_deviation_meters;
    private ProgressTracker m_progress_tracker;
    private int m_index;

    public OperatorGeodeticDensifyCursor(GeometryCursor geoms, SpatialReference sr, int curve_type, double max_length_meters, double max_deviation_meters, double max_angle, ProgressTracker progress_tracker) {
        this.m_progress_tracker = progress_tracker;
        if (max_angle > 0.0) {
            throw new GeometryException("not implemented");
        }
        if (curve_type != 4 && max_deviation_meters > 0.0) {
            throw new GeometryException("not implemented");
        }
        if (sr == null) {
            throw new IllegalArgumentException("invalid argument");
        }
        SpatialReference.Type cstype = sr.getCoordinateSystemType();
        if (cstype == SpatialReference.Type.Local) {
            throw new IllegalArgumentException("invalid argument");
        }
        if (!(max_length_meters > 0.0) && !(max_deviation_meters > 0.0)) {
            throw new IllegalArgumentException("invalid argument");
        }
        this.m_index = -1;
        this.m_input_geoms = geoms;
        this.m_spatial_reference = sr;
        this.m_curve_type = curve_type;
        this.m_max_length_meters = max_length_meters;
        this.m_max_deviation_meters = max_deviation_meters;
    }

    @Override
    public Geometry next() {
        Geometry geom = this.m_input_geoms.next();
        if (geom != null) {
            this.m_index = this.m_input_geoms.getGeometryID();
            return this.geodeticDensify_(geom);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    private Geometry geodeticDensify_(Geometry geom) {
        return GeodeticDensify.densify(geom, this.m_spatial_reference, this.m_curve_type, this.m_max_length_meters, this.m_max_deviation_meters, this.m_progress_tracker);
    }
}

