/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.GeodesicBufferer;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;

@HadoopSDKExcluded
public class OperatorGeodesicBufferCursor
extends GeometryCursor {
    private GeometryCursor m_input_geoms;
    private SpatialReference m_spatial_reference;
    private int m_curve_type;
    private double[] m_distances;
    private double m_convergence_offset;
    private Envelope2D m_current_union_envelope2D;
    private int m_index;
    private int m_dindex;
    private ProgressTracker m_progress_tracker;

    public OperatorGeodesicBufferCursor(GeometryCursor input_geoms, SpatialReference sr, int curve_type, double[] distances, double convergence_offset, boolean b_outline_only, boolean b_union, ProgressTracker progress_tracker) {
        if (b_outline_only) {
            throw new GeometryException("not_implemented");
        }
        if (sr == null) {
            throw new IllegalArgumentException("invalid_argument");
        }
        SpatialReference.Type cstype = sr.getCoordinateSystemType();
        if (cstype == SpatialReference.Type.Local) {
            throw new IllegalArgumentException("invalid_argument");
        }
        this.m_index = -1;
        this.m_input_geoms = input_geoms;
        this.m_spatial_reference = sr;
        this.m_curve_type = curve_type;
        this.m_distances = distances;
        this.m_convergence_offset = convergence_offset;
        this.m_dindex = -1;
        this.m_progress_tracker = progress_tracker;
        this.m_current_union_envelope2D = new Envelope2D();
        this.m_current_union_envelope2D.setEmpty();
    }

    @Override
    public Geometry next() {
        Geometry geom = this.m_input_geoms.next();
        if (geom != null) {
            this.m_index = this.m_input_geoms.getGeometryID();
            if (this.m_dindex + 1 < this.m_distances.length) {
                ++this.m_dindex;
            }
            return this.geodesic_buffer(geom, this.m_distances[this.m_dindex]);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    private Geometry geodesic_buffer(Geometry geom, double distance) {
        return GeodesicBufferer.buffer(geom, this.m_spatial_reference, this.m_curve_type, distance, this.m_convergence_offset, this.m_progress_tracker);
    }
}

