/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.ProgressTracker;

final class OperatorGeneralizeCursor
extends GeometryCursor {
    ProgressTracker m_progressTracker;
    GeometryCursor m_geoms;
    double m_maxDeviation;
    boolean m_bRemoveDegenerateParts;
    AttributeStreamOfInt32 m_stack = null;
    AttributeStreamOfInt32 m_resultStack = null;
    Point m_point = null;
    Line m_line = null;
    AttributeStreamOfDbl m_xy = null;
    Dbl m_maxd = null;
    int m_callCount = 0;

    public OperatorGeneralizeCursor(GeometryCursor geoms, double maxDeviation, boolean bRemoveDegenerateParts, ProgressTracker progressTracker) {
        this.m_geoms = geoms;
        this.m_maxDeviation = maxDeviation;
        this.m_progressTracker = progressTracker;
        this.m_bRemoveDegenerateParts = bRemoveDegenerateParts;
    }

    @Override
    public Geometry next() {
        Geometry geom = this.m_geoms.next();
        if (geom == null) {
            return null;
        }
        return this.generalize(geom);
    }

    @Override
    public int getGeometryID() {
        return this.m_geoms.getGeometryID();
    }

    public static Geometry generalize(Geometry geom, double maxDeviation, boolean bRemoveDegenerateParts, ProgressTracker progressTracker) {
        Geometry.Type gt = geom.getType();
        if (Geometry.isPoint(gt.value())) {
            return geom;
        }
        return new OperatorGeneralizeCursor(null, maxDeviation, bRemoveDegenerateParts, progressTracker).generalize(geom);
    }

    Geometry generalize(Geometry geom) {
        Geometry.Type gt = geom.getType();
        if (Geometry.isPoint(gt.value())) {
            return geom;
        }
        if (gt == Geometry.Type.Envelope) {
            Polygon poly = new Polygon(geom.getDescription());
            poly.addEnvelope((Envelope)geom, false);
            return this.generalize(poly);
        }
        if (!Geometry.isMultiPath(gt.value())) {
            throw new GeometryException("not implemented");
        }
        if (geom.isEmpty() || this.m_maxDeviation <= 0.0) {
            return geom;
        }
        MultiPath mp = (MultiPath)geom;
        MultiPath dstmp = (MultiPath)geom.createInstance();
        this.m_xy = (AttributeStreamOfDbl)((MultiPathImpl)mp._getImpl()).getAttributeStreamRef(0);
        this.m_point = new Point();
        this.m_line = new Line();
        int npath = mp.getPathCount();
        for (int ipath = 0; ipath < npath; ++ipath) {
            this.generalizePath((MultiPathImpl)mp._getImpl(), ipath, (MultiPathImpl)dstmp._getImpl());
        }
        if (this.m_stack != null) {
            this.m_stack.clear(false);
            this.m_resultStack.clear(false);
        }
        return dstmp;
    }

    private void generalizePath(MultiPathImpl mpsrc, int ipath, MultiPathImpl mpdst) {
        int path_size;
        int rs_size;
        if (mpsrc.getPathSize(ipath) < 2) {
            return;
        }
        if (this.m_stack == null) {
            this.m_stack = new AttributeStreamOfInt32(0);
        }
        if (this.m_resultStack == null) {
            this.m_resultStack = new AttributeStreamOfInt32(0);
        }
        this.m_stack.clear(false);
        this.m_resultStack.clear(false);
        int start = mpsrc.getPathStart(ipath);
        int end = mpsrc.getPathEnd(ipath) - 1;
        boolean bClosed = mpsrc.isClosedPath(ipath);
        boolean bClosedOnXY = mpsrc.isClosedPathInXYPlane(ipath);
        if (this.m_maxd == null) {
            this.m_maxd = new Dbl();
        }
        this.m_stack.reserve(mpsrc.getPathSize(ipath) + 1);
        this.m_resultStack.reserve(mpsrc.getPathSize(ipath) + 1);
        double second_max_distance = 0.0;
        int second_max_index = -1;
        this.m_stack.add(bClosed ? start : end);
        this.m_stack.add(start);
        boolean force_first = false;
        boolean track_second_point = false;
        if (!this.m_bRemoveDegenerateParts && bClosedOnXY) {
            force_first = true;
            track_second_point = true;
        }
        Point2D pt = new Point2D();
        while (this.m_stack.size() > 1) {
            int i1 = this.m_stack.getLast();
            this.m_stack.removeLast();
            int i2 = this.m_stack.getLast();
            this.m_xy.read(i1 * 2, pt);
            this.m_line.setStartXY(pt);
            this.m_xy.read(i2 * 2, pt);
            this.m_line.setEndXY(pt);
            int mid = this.findGreatestDistance(i1, i2, end, pt);
            if (mid >= 0) {
                assert (this.m_maxd.value > 0.0);
                if (!force_first) {
                    if (track_second_point && this.m_maxd.value > second_max_distance) {
                        second_max_distance = this.m_maxd.value;
                        second_max_index = mid;
                    }
                    if (this.m_maxd.value <= this.m_maxDeviation) {
                        mid = -1;
                    }
                } else {
                    force_first = false;
                }
            }
            if (mid >= 0) {
                this.m_stack.add(mid);
                this.m_stack.add(i1);
                continue;
            }
            this.m_resultStack.add(i1);
        }
        if (!bClosed) {
            this.m_resultStack.add(this.m_stack.get(0));
        }
        if ((rs_size = this.m_resultStack.size()) == (path_size = mpsrc.getPathSize(ipath)) && rs_size == this.m_stack.size()) {
            mpdst.addPath(mpsrc, ipath, true);
        } else if (this.m_resultStack.size() > 0) {
            int i;
            if (this.m_bRemoveDegenerateParts && this.m_resultStack.size() <= 2) {
                if (bClosed || this.m_resultStack.size() == 1) {
                    return;
                }
                double d = Point2D.distance(mpsrc.getXY(this.m_resultStack.get(0)), mpsrc.getXY(this.m_resultStack.get(1)));
                if (d <= this.m_maxDeviation) {
                    return;
                }
            }
            if (track_second_point) {
                assert (bClosedOnXY);
                assert (!this.m_bRemoveDegenerateParts);
                if (second_max_index >= 0 && second_max_distance <= this.m_maxDeviation) {
                    assert (second_max_distance > 0.0);
                    assert (this.m_resultStack.getLast() != second_max_index);
                    boolean swaplast = this.m_resultStack.getLast() > second_max_index;
                    this.m_resultStack.add(second_max_index);
                    if (swaplast) {
                        this.m_resultStack.swap(this.m_resultStack.size() - 1, this.m_resultStack.size() - 2);
                    }
                }
            }
            if (this.m_point == null) {
                this.m_point = new Point();
            }
            int n = this.m_resultStack.size();
            for (i = 0; i < n; ++i) {
                mpsrc.getPointByVal(this.m_resultStack.get(i), this.m_point);
                if (i == 0) {
                    mpdst.startPath(this.m_point);
                    continue;
                }
                mpdst.lineTo(this.m_point);
            }
            if (bClosed) {
                for (i = this.m_resultStack.size(); i < 3; ++i) {
                    mpdst.lineTo(this.m_point);
                }
                mpdst.closePathWithLine();
            }
        }
    }

    private int findGreatestDistance(int start, int end, int pathEnd, Point2D ptHelper) {
        int to = end - 1;
        if (end <= start) {
            to = pathEnd;
        }
        int mid = -1;
        double maxd = 0.0;
        for (int i = start + 1; i <= to; ++i) {
            this.m_xy.read(2 * i, ptHelper);
            double x1 = ptHelper.x;
            double y1 = ptHelper.y;
            double t = this.m_line.getClosestCoordinate(ptHelper, false);
            this.m_line.getCoord2D(t, ptHelper);
            ptHelper.x -= x1;
            ptHelper.y -= y1;
            double dist = ptHelper.length();
            if (dist > maxd) {
                mid = i;
                maxd = dist;
            }
            if (this.m_callCount >= 4095) {
                ProgressTracker.checkAndThrow(this.m_progressTracker);
                this.m_callCount = 0;
            }
            ++this.m_callCount;
        }
        this.m_maxd.value = maxd;
        return mid;
    }

    private static final class Dbl {
        double value = 0.0;

        private Dbl() {
        }
    }
}

