/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.JsonCursor;
import com.esri.core.geometry.JsonStringWriter;
import com.esri.core.geometry.JsonWriter;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.Transformation2D;
import java.util.Map;

class OperatorExportToJsonCursor
extends JsonCursor {
    GeometryCursor m_inputGeometryCursor;
    SpatialReference m_spatialReference;
    int m_index = -1;
    static final String c_numberOfDecimalsXY = "numberOfDecimalsXY";
    static final String c_quantTransXY = "quantTransXY";

    public OperatorExportToJsonCursor(SpatialReference spatialReference, GeometryCursor geometryCursor) {
        if (geometryCursor == null) {
            throw new IllegalArgumentException();
        }
        this.m_inputGeometryCursor = geometryCursor;
        this.m_spatialReference = spatialReference;
    }

    @Override
    public int getID() {
        return this.m_index;
    }

    @Override
    public String next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            return OperatorExportToJsonCursor.exportToString(geometry, this.m_spatialReference, null);
        }
        return null;
    }

    static String exportToString(Geometry geometry, SpatialReference spatialReference, Map<String, Object> exportProperties) {
        JsonStringWriter jsonWriter = new JsonStringWriter();
        OperatorExportToJsonCursor.exportToJson_(geometry, spatialReference, jsonWriter, exportProperties);
        return (String)((JsonWriter)jsonWriter).getJson();
    }

    private static void exportToJson_(Geometry geometry, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        try {
            int type = geometry.getType().value();
            switch (type) {
                case 33: {
                    OperatorExportToJsonCursor.exportPointToJson((Point)geometry, spatialReference, jsonWriter, exportProperties);
                    break;
                }
                case 550: {
                    OperatorExportToJsonCursor.exportMultiPointToJson((MultiPoint)geometry, spatialReference, jsonWriter, exportProperties);
                    break;
                }
                case 1607: {
                    OperatorExportToJsonCursor.exportPolylineToJson((Polyline)geometry, spatialReference, jsonWriter, exportProperties);
                    break;
                }
                case 1736: {
                    OperatorExportToJsonCursor.exportPolygonToJson((Polygon)geometry, spatialReference, jsonWriter, exportProperties);
                    break;
                }
                case 197: {
                    OperatorExportToJsonCursor.exportEnvelopeToJson((Envelope)geometry, spatialReference, jsonWriter, exportProperties);
                    break;
                }
                default: {
                    throw new RuntimeException("not implemented for this geometry type");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void exportPolygonToJson(Polygon pp, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        OperatorExportToJsonCursor.exportPolypathToJson(pp, "rings", spatialReference, jsonWriter, exportProperties);
    }

    private static void exportPolylineToJson(Polyline pp, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        OperatorExportToJsonCursor.exportPolypathToJson(pp, "paths", spatialReference, jsonWriter, exportProperties);
    }

    private static void deltaCompress(Transformation2D trans, Point2D ptInOut, Point2D trackingInOut, boolean first) {
        if (trans != null) {
            trans.transform(ptInOut, ptInOut);
            ptInOut.x = MathUtils.truncate(ptInOut.x + 0.5);
            ptInOut.y = MathUtils.truncate(ptInOut.y + 0.5);
            if (first) {
                if (trackingInOut != null) {
                    trackingInOut.setCoords(ptInOut);
                }
            } else {
                double x = ptInOut.x;
                double y = ptInOut.y;
                ptInOut.sub(trackingInOut);
                trackingInOut.setCoords(x, y);
            }
        }
    }

    private static void exportPolypathToJson(MultiPath pp, String name, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        boolean bExportZs = pp.hasAttribute(1);
        boolean bExportMs = pp.hasAttribute(2);
        boolean bPositionAsF = false;
        int decimals = 17;
        Transformation2D quantTransXY = null;
        if (exportProperties != null) {
            Object numberOfDecimalsXY = exportProperties.get(c_numberOfDecimalsXY);
            if (numberOfDecimalsXY != null && numberOfDecimalsXY instanceof Number) {
                bPositionAsF = true;
                decimals = ((Number)numberOfDecimalsXY).intValue();
            }
            quantTransXY = (Transformation2D)exportProperties.get(c_quantTransXY);
        }
        jsonWriter.startObject();
        if (bExportZs) {
            jsonWriter.addPairBoolean("hasZ", true);
        }
        if (bExportMs) {
            jsonWriter.addPairBoolean("hasM", true);
        }
        jsonWriter.addPairArray(name);
        if (!pp.isEmpty()) {
            int npaths = pp.getPathCount();
            MultiPathImpl mpImpl = (MultiPathImpl)pp._getImpl();
            AttributeStreamOfDbl zs = null;
            AttributeStreamOfDbl ms = null;
            if (bExportZs) {
                zs = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(1);
            }
            if (bExportMs) {
                ms = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(2);
            }
            Point2D ptWritten = new Point2D();
            Point2D pt = new Point2D();
            Point2D deltaTracking = new Point2D();
            for (int ipath = 0; ipath < npaths; ++ipath) {
                double m;
                double z;
                double startm;
                double startz;
                double starty;
                double startx;
                boolean bClosed = pp.isClosedPath(ipath);
                int startindex = pp.getPathStart(ipath);
                int numVertices = pp.getPathSize(ipath);
                if (quantTransXY != null) {
                    if (numVertices == 0) continue;
                    int written = 0;
                    startx = 0.0;
                    starty = 0.0;
                    startz = 0.0;
                    startm = 0.0;
                    z = NumberUtils.NaN();
                    m = NumberUtils.NaN();
                    boolean first = true;
                    int n = startindex + numVertices;
                    for (int j = startindex; j < n; ++j) {
                        pp.getXY(j, pt);
                        ptWritten.setCoords(pt);
                        OperatorExportToJsonCursor.deltaCompress(quantTransXY, ptWritten, deltaTracking, first);
                        double zprev = z;
                        double mprev = m;
                        if (bExportZs) {
                            z = zs.get(j);
                        }
                        if (bExportMs) {
                            m = ms.get(j);
                        }
                        if (!first && ptWritten.isEqual(0.0, 0.0) && NumberUtils.isEqualNonIEEE(z, zprev) && NumberUtils.isEqualNonIEEE(m, mprev)) continue;
                        zprev = z;
                        mprev = m;
                        if (first && bClosed) {
                            startx = pt.x;
                            starty = pt.y;
                            startz = z;
                            startm = m;
                        }
                        first = false;
                        ++written;
                    }
                    if (bClosed) {
                        boolean battrib_dif;
                        boolean bxy_dif = startx != pt.x || starty != pt.y;
                        boolean bl = battrib_dif = !NumberUtils.isEqualNonIEEE(startz, z) || !NumberUtils.isEqualNonIEEE(startm, m);
                        if (bxy_dif || battrib_dif) {
                            pp.getXY(startindex, pt);
                            ptWritten.setCoords(pt);
                            OperatorExportToJsonCursor.deltaCompress(quantTransXY, ptWritten, deltaTracking, first);
                            if (!ptWritten.isEqual(0.0, 0.0)) {
                                ++written;
                            }
                        }
                    }
                    if (bClosed && written < 3 || !bClosed && written < 2) continue;
                }
                boolean first = true;
                jsonWriter.addValueArray();
                startx = 0.0;
                starty = 0.0;
                startz = NumberUtils.NaN();
                startm = NumberUtils.NaN();
                z = 0.0;
                m = 0.0;
                int n = startindex + numVertices;
                for (int j = startindex; j < n; ++j) {
                    pp.getXY(j, pt);
                    ptWritten.setCoords(pt);
                    OperatorExportToJsonCursor.deltaCompress(quantTransXY, ptWritten, deltaTracking, first);
                    double zprev = z;
                    double mprev = m;
                    if (bExportZs) {
                        z = zs.get(j);
                    }
                    if (bExportMs) {
                        m = ms.get(j);
                    }
                    if (quantTransXY != null && !first && ptWritten.isEqual(0.0, 0.0) && NumberUtils.isEqualNonIEEE(z, zprev) && NumberUtils.isEqualNonIEEE(m, mprev)) continue;
                    zprev = z;
                    mprev = m;
                    jsonWriter.addValueArray();
                    if (bPositionAsF) {
                        jsonWriter.addValueDouble(ptWritten.x, decimals, true);
                        jsonWriter.addValueDouble(ptWritten.y, decimals, true);
                    } else {
                        jsonWriter.addValueDouble(ptWritten.x);
                        jsonWriter.addValueDouble(ptWritten.y);
                    }
                    if (bExportZs) {
                        jsonWriter.addValueDouble(z);
                    }
                    if (bExportMs) {
                        jsonWriter.addValueDouble(m);
                    }
                    if (first && bClosed) {
                        startx = pt.x;
                        starty = pt.y;
                        startz = z;
                        startm = m;
                    }
                    first = false;
                    jsonWriter.endArray();
                }
                if (bClosed) {
                    boolean battrib_dif;
                    boolean bxy_dif = startx != pt.x || starty != pt.y;
                    boolean bl = battrib_dif = !NumberUtils.isEqualNonIEEE(startz, z) || !NumberUtils.isEqualNonIEEE(startm, m);
                    if (bxy_dif || battrib_dif) {
                        ptWritten.setCoords(startx, starty);
                        OperatorExportToJsonCursor.deltaCompress(quantTransXY, ptWritten, deltaTracking, first);
                        if (quantTransXY == null || !ptWritten.isEqual(0.0, 0.0) || battrib_dif) {
                            jsonWriter.addValueArray();
                            if (bPositionAsF) {
                                jsonWriter.addValueDouble(ptWritten.x, decimals, true);
                                jsonWriter.addValueDouble(ptWritten.y, decimals, true);
                            } else {
                                jsonWriter.addValueDouble(ptWritten.x);
                                jsonWriter.addValueDouble(ptWritten.y);
                            }
                            if (bExportZs) {
                                jsonWriter.addValueDouble(startz);
                            }
                            if (bExportMs) {
                                jsonWriter.addValueDouble(startm);
                            }
                            jsonWriter.endArray();
                        }
                    }
                }
                jsonWriter.endArray();
            }
        }
        jsonWriter.endArray();
        if (spatialReference != null) {
            OperatorExportToJsonCursor.writeSR(spatialReference, jsonWriter);
        }
        jsonWriter.endObject();
    }

    private static void exportMultiPointToJson(MultiPoint mpt, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        boolean bExportZs = mpt.hasAttribute(1);
        boolean bExportMs = mpt.hasAttribute(2);
        boolean bPositionAsF = false;
        int decimals = 17;
        Transformation2D quantTransXY = null;
        if (exportProperties != null) {
            Object numberOfDecimalsXY = exportProperties.get(c_numberOfDecimalsXY);
            if (numberOfDecimalsXY != null && numberOfDecimalsXY instanceof Number) {
                bPositionAsF = true;
                decimals = ((Number)numberOfDecimalsXY).intValue();
            }
            quantTransXY = (Transformation2D)exportProperties.get(c_quantTransXY);
        }
        jsonWriter.startObject();
        if (bExportZs) {
            jsonWriter.addPairBoolean("hasZ", true);
        }
        if (bExportMs) {
            jsonWriter.addPairBoolean("hasM", true);
        }
        jsonWriter.addPairArray("points");
        if (!mpt.isEmpty()) {
            MultiPointImpl mpImpl = (MultiPointImpl)mpt._getImpl();
            AttributeStreamOfDbl zs = null;
            AttributeStreamOfDbl ms = null;
            if (bExportZs) {
                zs = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(1);
            }
            if (bExportMs) {
                ms = (AttributeStreamOfDbl)mpImpl.getAttributeStreamRef(2);
            }
            Point2D pt = new Point2D();
            Point2D ptWritten = new Point2D();
            Point2D deltaTracking = quantTransXY != null ? new Point2D() : null;
            boolean first = true;
            int n = mpt.getPointCount();
            for (int i = 0; i < n; ++i) {
                mpt.getXY(i, pt);
                ptWritten.setCoords(pt);
                OperatorExportToJsonCursor.deltaCompress(quantTransXY, ptWritten, deltaTracking, first);
                first = false;
                jsonWriter.addValueArray();
                if (bPositionAsF) {
                    jsonWriter.addValueDouble(ptWritten.x, decimals, true);
                    jsonWriter.addValueDouble(ptWritten.y, decimals, true);
                } else {
                    jsonWriter.addValueDouble(ptWritten.x);
                    jsonWriter.addValueDouble(ptWritten.y);
                }
                if (bExportZs) {
                    double z = zs.get(i);
                    jsonWriter.addValueDouble(z);
                }
                if (bExportMs) {
                    double m = ms.get(i);
                    jsonWriter.addValueDouble(m);
                }
                jsonWriter.endArray();
            }
        }
        jsonWriter.endArray();
        if (spatialReference != null) {
            OperatorExportToJsonCursor.writeSR(spatialReference, jsonWriter);
        }
        jsonWriter.endObject();
    }

    private static void exportPointToJson(Point pt, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        boolean bExportZs = pt.hasAttribute(1);
        boolean bExportMs = pt.hasAttribute(2);
        boolean bPositionAsF = false;
        int decimals = 17;
        Transformation2D quantTransXY = null;
        if (exportProperties != null) {
            Object numberOfDecimalsXY = exportProperties.get(c_numberOfDecimalsXY);
            if (numberOfDecimalsXY != null && numberOfDecimalsXY instanceof Number) {
                bPositionAsF = true;
                decimals = ((Number)numberOfDecimalsXY).intValue();
            }
            quantTransXY = (Transformation2D)exportProperties.get(c_quantTransXY);
        }
        jsonWriter.startObject();
        if (pt.isEmpty()) {
            jsonWriter.addPairNull("x");
            jsonWriter.addPairNull("y");
            if (bExportZs) {
                jsonWriter.addPairNull("z");
            }
            if (bExportMs) {
                jsonWriter.addPairNull("m");
            }
        } else {
            double y;
            double x;
            if (quantTransXY != null) {
                x = quantTransXY.transformX(pt.getX(), pt.getY());
                y = quantTransXY.transformY(pt.getX(), pt.getY());
            } else {
                x = pt.getX();
                y = pt.getY();
            }
            if (bPositionAsF) {
                jsonWriter.addPairDouble("x", x, decimals, true);
                jsonWriter.addPairDouble("y", y, decimals, true);
            } else {
                jsonWriter.addPairDouble("x", x);
                jsonWriter.addPairDouble("y", y);
            }
            if (bExportZs) {
                jsonWriter.addPairDouble("z", pt.getZ());
            }
            if (bExportMs) {
                jsonWriter.addPairDouble("m", pt.getM());
            }
        }
        if (spatialReference != null) {
            OperatorExportToJsonCursor.writeSR(spatialReference, jsonWriter);
        }
        jsonWriter.endObject();
    }

    private static void exportEnvelopeToJson(Envelope env, SpatialReference spatialReference, JsonWriter jsonWriter, Map<String, Object> exportProperties) {
        Object numberOfDecimalsXY;
        boolean bExportZs = env.hasAttribute(1);
        boolean bExportMs = env.hasAttribute(2);
        boolean bPositionAsF = false;
        int decimals = 17;
        if (exportProperties != null && (numberOfDecimalsXY = exportProperties.get(c_numberOfDecimalsXY)) != null && numberOfDecimalsXY instanceof Number) {
            bPositionAsF = true;
            decimals = ((Number)numberOfDecimalsXY).intValue();
        }
        jsonWriter.startObject();
        if (env.isEmpty()) {
            jsonWriter.addPairNull("xmin");
            jsonWriter.addPairNull("ymin");
            jsonWriter.addPairNull("xmax");
            jsonWriter.addPairNull("ymax");
            if (bExportZs) {
                jsonWriter.addPairNull("zmin");
                jsonWriter.addPairNull("zmax");
            }
            if (bExportMs) {
                jsonWriter.addPairNull("mmin");
                jsonWriter.addPairNull("mmax");
            }
        } else {
            if (bPositionAsF) {
                jsonWriter.addPairDouble("xmin", env.getXMin(), decimals, true);
                jsonWriter.addPairDouble("ymin", env.getYMin(), decimals, true);
                jsonWriter.addPairDouble("xmax", env.getXMax(), decimals, true);
                jsonWriter.addPairDouble("ymax", env.getYMax(), decimals, true);
            } else {
                jsonWriter.addPairDouble("xmin", env.getXMin());
                jsonWriter.addPairDouble("ymin", env.getYMin());
                jsonWriter.addPairDouble("xmax", env.getXMax());
                jsonWriter.addPairDouble("ymax", env.getYMax());
            }
            if (bExportZs) {
                Envelope1D z = env.queryInterval(1, 0);
                jsonWriter.addPairDouble("zmin", z.vmin);
                jsonWriter.addPairDouble("zmax", z.vmax);
            }
            if (bExportMs) {
                Envelope1D m = env.queryInterval(2, 0);
                jsonWriter.addPairDouble("mmin", m.vmin);
                jsonWriter.addPairDouble("mmax", m.vmax);
            }
        }
        if (spatialReference != null) {
            OperatorExportToJsonCursor.writeSR(spatialReference, jsonWriter);
        }
        jsonWriter.endObject();
    }

    private static void writeSR(SpatialReference spatialReference, JsonWriter jsonWriter) {
        String wkt;
        if (spatialReference.getCoordinateSystemType() == SpatialReference.Type.Local) {
            jsonWriter.addPairObject("spatialReference");
            jsonWriter.addPairNull("wkid");
            jsonWriter.endObject();
            return;
        }
        int wkid = spatialReference.getOldID();
        if (wkid > 0) {
            int vcs_wkid;
            jsonWriter.addPairObject("spatialReference");
            jsonWriter.addPairInt("wkid", wkid);
            int latest_wkid = spatialReference.getLatestID();
            if (latest_wkid > 0 && latest_wkid != wkid) {
                jsonWriter.addPairInt("latestWkid", latest_wkid);
            }
            if ((vcs_wkid = spatialReference.getOldVerticalID()) > 0) {
                jsonWriter.addPairInt("vcsWkid", vcs_wkid);
                int latestVcsWkid = spatialReference.getLatestVerticalID();
                if (latestVcsWkid != vcs_wkid) {
                    jsonWriter.addPairInt("latestVcsWkid", latestVcsWkid);
                }
            }
            jsonWriter.endObject();
        }
        if (wkid <= 0 && (wkt = spatialReference.getText()) != null) {
            jsonWriter.addPairObject("spatialReference");
            jsonWriter.addPairString("wkt", wkt);
            jsonWriter.endObject();
        }
    }
}

