/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorDistance;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.PolygonUtils;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;

class OperatorDistanceLocal
extends OperatorDistance {
    OperatorDistanceLocal() {
    }

    @Override
    public double execute(Geometry geom1, Geometry geom2, ProgressTracker progressTracker) {
        if (progressTracker != null && !progressTracker.progress(-1, -1)) {
            throw new RuntimeException("user_canceled");
        }
        if (null == geom1 || null == geom2) {
            throw new IllegalArgumentException();
        }
        if (geom1.isEmpty() || geom2.isEmpty()) {
            return Double.NaN;
        }
        switch (geom1.getType()) {
            case Point: {
                switch (geom2.getType()) {
                    case Point: {
                        return this.distancePointToPoint_((Point)geom1, (Point)geom2);
                    }
                    case MultiPoint: {
                        return OperatorDistanceLocal.bruteForceMultiPointPoint_((MultiPoint)geom2, (Point)geom1);
                    }
                    case Polyline: 
                    case Polygon: {
                        return OperatorDistanceLocal.bruteForceMultiPathPoint_((MultiPath)geom2, (Point)geom1);
                    }
                    case Envelope: {
                        return this.distanceEnvelopeToPoint_((Envelope)geom2, (Point)geom1);
                    }
                }
                return 0.0;
            }
            case MultiPoint: {
                switch (geom2.getType()) {
                    case Point: {
                        return OperatorDistanceLocal.bruteForceMultiPointPoint_((MultiPoint)geom1, (Point)geom2);
                    }
                    case MultiPoint: {
                        return OperatorDistanceLocal.bruteForceMultiPointMultiPoint_((MultiPoint)geom1, (MultiPoint)geom2);
                    }
                    case Polyline: 
                    case Polygon: {
                        return OperatorDistanceLocal.bruteForceMultiPathMultiPoint_((MultiPath)geom2, (MultiPoint)geom1);
                    }
                    case Envelope: {
                        return OperatorDistanceLocal.bruteForceMultiPathMultiPoint_(this.envelopeToPolygon_(geom2), (MultiPoint)geom1);
                    }
                }
                return 0.0;
            }
            case Envelope: {
                switch (geom2.getType()) {
                    case Point: {
                        return this.distanceEnvelopeToPoint_((Envelope)geom1, (Point)geom2);
                    }
                    case MultiPoint: {
                        return OperatorDistanceLocal.bruteForceMultiPathMultiPoint_(this.envelopeToPolygon_(geom1), (MultiPoint)geom2);
                    }
                    case Polyline: 
                    case Polygon: {
                        return OperatorDistanceLocal.bruteForceMultiPathMultiPath_(this.envelopeToPolygon_(geom1), (MultiPath)geom2);
                    }
                    case Envelope: {
                        return this.distanceEnvelopeToEnvelope_((Envelope)geom1, (Envelope)geom2);
                    }
                }
                return 0.0;
            }
            case Polyline: 
            case Polygon: {
                switch (geom2.getType()) {
                    case Point: {
                        return OperatorDistanceLocal.bruteForceMultiPathPoint_((MultiPath)geom1, (Point)geom2);
                    }
                    case MultiPoint: {
                        return OperatorDistanceLocal.bruteForceMultiPathMultiPoint_((MultiPath)geom1, (MultiPoint)geom2);
                    }
                    case Polyline: 
                    case Polygon: {
                        return OperatorDistanceLocal.bruteForceMultiPathMultiPath_((MultiPath)geom1, (MultiPath)geom2);
                    }
                    case Envelope: {
                        return OperatorDistanceLocal.bruteForceMultiPathMultiPath_((MultiPath)geom1, this.envelopeToPolygon_(geom2));
                    }
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    private Polygon envelopeToPolygon_(Geometry envelope) {
        Polygon polygon = new Polygon();
        polygon.addEnvelope((Envelope)envelope, false);
        return polygon;
    }

    private double distancePointToPoint_(Point pt1, Point pt2) {
        return Math.sqrt(Point.sqrDistance2D(pt1, pt2));
    }

    private double distanceEnvelopeToPoint_(Envelope env, Point pt) {
        double dx = 0.0;
        double dy = 0.0;
        double nn = env.getXMin() - pt.getX();
        if (nn > dx) {
            dx = nn;
        }
        if ((nn = env.getYMin() - pt.getY()) > dy) {
            dy = nn;
        }
        if ((nn = pt.getX() - env.getXMax()) > dx) {
            dx = nn;
        }
        if ((nn = pt.getY() - env.getYMax()) > dy) {
            dy = nn;
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    private double distanceEnvelopeToEnvelope_(Envelope env1, Envelope env2) {
        double dx = 0.0;
        double dy = 0.0;
        double nn = env1.getXMin() - env2.getXMax();
        if (nn > dx) {
            dx = nn;
        }
        if ((nn = env1.getYMin() - env2.getYMax()) > dy) {
            dy = nn;
        }
        if ((nn = env2.getXMin() - env1.getXMax()) > dx) {
            dx = nn;
        }
        if ((nn = env2.getYMin() - env1.getYMax()) > dy) {
            dy = nn;
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static double bruteForceMultiPathMultiPath_(MultiPath candidate1, MultiPath candidate2) {
        MultiPath geometryB;
        MultiPath geometryA;
        if (candidate1.getPointCount() > candidate2.getPointCount()) {
            geometryA = candidate1;
            geometryB = candidate2;
        } else {
            geometryA = candidate2;
            geometryB = candidate1;
        }
        Envelope2D envA = new Envelope2D();
        geometryA.queryEnvelope2D(envA);
        Envelope2D envB = new Envelope2D();
        geometryB.queryEnvelope2D(envB);
        boolean geometriesAreDisjoint = !envA.isIntersecting(envB);
        SegmentIterator segIterA = geometryA.querySegmentIterator();
        segIterA.stripAttributes();
        SegmentIterator segIterB = geometryB.querySegmentIterator();
        segIterB.stripAttributes();
        Envelope2D env2DSegmentA = new Envelope2D();
        Envelope2D env2DSegmentB = new Envelope2D();
        double minSqrDistance = NumberUtils.doubleMax();
        if (!geometriesAreDisjoint && OperatorDistanceLocal.weakIntersectionTest_(geometryA, geometryB, segIterA, segIterB)) {
            return 0.0;
        }
        int numSegmentPartsCached = 0;
        double[] cachedSegCoordsB = null;
        double[] cachedEnvCoordsB = null;
        Line cachedSegmentB = new Line();
        while (segIterA.nextPath()) {
            while (segIterA.hasNextSegment()) {
                double sqrDistance;
                Segment segmentA = segIterA.nextSegment();
                segmentA.queryEnvelope2D(env2DSegmentA);
                if (env2DSegmentA.sqrDistance(envB) > minSqrDistance) continue;
                if (cachedSegCoordsB == null) {
                    cachedSegCoordsB = new double[geometryB.getPointCount() * 4];
                    cachedEnvCoordsB = new double[geometryB.getPointCount() * 4];
                    while (segIterB.nextPath()) {
                        while (segIterB.hasNextSegment()) {
                            Segment segmentB = segIterB.nextSegment();
                            segmentB.queryEnvelope2D(env2DSegmentB);
                            if (env2DSegmentA.sqrDistance(env2DSegmentB) < minSqrDistance) {
                                sqrDistance = segmentA.distance(segmentB, geometriesAreDisjoint);
                                if ((sqrDistance *= sqrDistance) < minSqrDistance) {
                                    if (sqrDistance == 0.0) {
                                        return 0.0;
                                    }
                                    minSqrDistance = sqrDistance;
                                }
                            }
                            cachedSegCoordsB[numSegmentPartsCached] = segmentB.getStartX();
                            cachedSegCoordsB[numSegmentPartsCached + 1] = segmentB.getStartY();
                            cachedSegCoordsB[numSegmentPartsCached + 2] = segmentB.getEndX();
                            cachedSegCoordsB[numSegmentPartsCached + 3] = segmentB.getEndY();
                            cachedEnvCoordsB[numSegmentPartsCached] = env2DSegmentB.xmin;
                            cachedEnvCoordsB[numSegmentPartsCached + 1] = env2DSegmentB.ymin;
                            cachedEnvCoordsB[numSegmentPartsCached + 2] = env2DSegmentB.xmax;
                            cachedEnvCoordsB[numSegmentPartsCached + 3] = env2DSegmentB.ymax;
                            numSegmentPartsCached += 4;
                        }
                    }
                    segIterB.resetToFirstPath();
                    continue;
                }
                for (int i = 0; i < numSegmentPartsCached; i += 4) {
                    cachedSegmentB.setStartXY(cachedSegCoordsB[i], cachedSegCoordsB[i + 1]);
                    cachedSegmentB.setEndXY(cachedSegCoordsB[i + 2], cachedSegCoordsB[i + 3]);
                    env2DSegmentB.xmin = cachedEnvCoordsB[i];
                    env2DSegmentB.ymin = cachedEnvCoordsB[i + 1];
                    env2DSegmentB.xmax = cachedEnvCoordsB[i + 2];
                    env2DSegmentB.ymax = cachedEnvCoordsB[i + 3];
                    if (!(env2DSegmentA.sqrDistance(env2DSegmentB) < minSqrDistance)) continue;
                    sqrDistance = segmentA.distance(cachedSegmentB, geometriesAreDisjoint);
                    if (!((sqrDistance *= sqrDistance) < minSqrDistance)) continue;
                    if (sqrDistance == 0.0) {
                        return 0.0;
                    }
                    minSqrDistance = sqrDistance;
                }
            }
        }
        return Math.sqrt(minSqrDistance);
    }

    private static double bruteForceMultiPathPoint_(MultiPath geometryA, Point geometryB) {
        Point2D inputPoint = geometryB.getXY();
        if (geometryA.getType() == Geometry.Type.Polygon && PolygonUtils.isPointInPolygon2D((Polygon)geometryA, inputPoint, 0.0) != PolygonUtils.PiPResult.PiPOutside) {
            return 0.0;
        }
        SegmentIterator segIterA = geometryA.querySegmentIterator();
        segIterA.stripAttributes();
        Point2D tempPoint = new Point2D();
        Point2D subPoint = new Point2D();
        double minSqrDistance = NumberUtils.doubleMax();
        while (segIterA.nextPath()) {
            while (segIterA.hasNextSegment()) {
                Segment segmentA = segIterA.nextSegment();
                tempPoint.setCoords(inputPoint);
                double t = segmentA.getClosestCoordinate(tempPoint, false);
                segmentA.getCoord2D(t, subPoint);
                tempPoint.sub(subPoint);
                double sqrDistance = tempPoint.sqrLength();
                if (!(sqrDistance < minSqrDistance)) continue;
                if (sqrDistance == 0.0) {
                    return 0.0;
                }
                minSqrDistance = sqrDistance;
            }
        }
        return Math.sqrt(minSqrDistance);
    }

    private static double bruteForceMultiPathMultiPoint_(MultiPath geometryA, MultiPoint geometryB) {
        boolean bDoPiPTest;
        Envelope2D envA = new Envelope2D();
        geometryA.queryEnvelope2D(envA);
        Envelope2D envB = new Envelope2D();
        geometryB.queryEnvelope2D(envB);
        boolean geometriesAreDisjoint = !envA.isIntersecting(envB);
        SegmentIterator segIterA = geometryA.querySegmentIterator();
        segIterA.stripAttributes();
        Envelope2D env2DSegmentA = new Envelope2D();
        double minSqrDistance = NumberUtils.doubleMax();
        Point2D inputPoint = new Point2D();
        double t = -1.0;
        double sqrDistance = minSqrDistance;
        MultiPointImpl multiPointImplB = (MultiPointImpl)geometryB._getImpl();
        int pointCountB = multiPointImplB.getPointCount();
        boolean bl = bDoPiPTest = !geometriesAreDisjoint && geometryA.getType() == Geometry.Type.Polygon;
        while (segIterA.nextPath()) {
            while (segIterA.hasNextSegment()) {
                Segment segmentA = segIterA.nextSegment();
                segmentA.queryEnvelope2D(env2DSegmentA);
                if (pointCountB > 1 && env2DSegmentA.sqrDistance(envB) > minSqrDistance) continue;
                for (int i = 0; i < pointCountB; ++i) {
                    multiPointImplB.getXY(i, inputPoint);
                    if (bDoPiPTest && PolygonUtils.isPointInPolygon2D((Polygon)geometryA, inputPoint, 0.0) != PolygonUtils.PiPResult.PiPOutside) {
                        return 0.0;
                    }
                    t = segmentA.getClosestCoordinate(inputPoint, false);
                    inputPoint.sub(segmentA.getCoord2D(t));
                    sqrDistance = inputPoint.sqrLength();
                    if (!(sqrDistance < minSqrDistance)) continue;
                    if (sqrDistance == 0.0) {
                        return 0.0;
                    }
                    minSqrDistance = sqrDistance;
                }
                bDoPiPTest = false;
            }
        }
        return Math.sqrt(minSqrDistance);
    }

    private static double bruteForceMultiPointPoint_(MultiPoint geometryA, Point geometryB) {
        double minSqrDistance = NumberUtils.doubleMax();
        Point2D pointA = new Point2D();
        Point2D pointB = geometryB.getXY();
        double sqrDistance = minSqrDistance;
        MultiPointImpl multiPointImplA = (MultiPointImpl)geometryA._getImpl();
        int pointCountA = multiPointImplA.getPointCount();
        for (int i = 0; i < pointCountA; ++i) {
            multiPointImplA.getXY(i, pointA);
            sqrDistance = Point2D.sqrDistance(pointA, pointB);
            if (!(sqrDistance < minSqrDistance)) continue;
            if (sqrDistance == 0.0) {
                return 0.0;
            }
            minSqrDistance = sqrDistance;
        }
        return Math.sqrt(minSqrDistance);
    }

    private static double bruteForceMultiPointMultiPoint_(MultiPoint candidate1, MultiPoint candidate2) {
        MultiPoint geometryB;
        MultiPoint geometryA;
        if (candidate1.getPointCount() > candidate2.getPointCount()) {
            geometryA = candidate1;
            geometryB = candidate2;
        } else {
            geometryA = candidate2;
            geometryB = candidate1;
        }
        Envelope2D envB = new Envelope2D();
        geometryB.queryEnvelope2D(envB);
        double minSqrDistance = NumberUtils.doubleMax();
        Point2D pointA = new Point2D();
        Point2D pointB = new Point2D();
        double sqrDistance = minSqrDistance;
        MultiPointImpl multiPointImplA = (MultiPointImpl)geometryA._getImpl();
        MultiPointImpl multiPointImplB = (MultiPointImpl)geometryB._getImpl();
        int pointCountA = multiPointImplA.getPointCount();
        int pointCountB = multiPointImplB.getPointCount();
        for (int i = 0; i < pointCountA; ++i) {
            multiPointImplA.getXY(i, pointA);
            if (pointCountB > 1 && envB.sqrDistance(pointA) > minSqrDistance) continue;
            for (int j = 0; j < pointCountB; ++j) {
                multiPointImplB.getXY(j, pointB);
                sqrDistance = Point2D.sqrDistance(pointA, pointB);
                if (!(sqrDistance < minSqrDistance)) continue;
                if (sqrDistance == 0.0) {
                    return 0.0;
                }
                minSqrDistance = sqrDistance;
            }
        }
        return Math.sqrt(minSqrDistance);
    }

    private static boolean weakIntersectionTest_(Geometry geometryA, Geometry geometryB, SegmentIterator segIterA, SegmentIterator segIterB) {
        if (geometryA.getType() == Geometry.Type.Polygon) {
            while (segIterB.nextPath()) {
                Segment segmentB;
                if (!segIterB.hasNextSegment() || PolygonUtils.isPointInPolygon2D((Polygon)geometryA, (segmentB = segIterB.nextSegment()).getEndXY(), 0.0) == PolygonUtils.PiPResult.PiPOutside) continue;
                return true;
            }
            segIterB.resetToFirstPath();
        }
        if (geometryB.getType() == Geometry.Type.Polygon) {
            while (segIterA.nextPath()) {
                Segment segmentA;
                if (!segIterA.hasNextSegment() || PolygonUtils.isPointInPolygon2D((Polygon)geometryB, (segmentA = segIterA.nextSegment()).getEndXY(), 0.0) == PolygonUtils.PiPResult.PiPOutside) continue;
                return true;
            }
            segIterA.resetToFirstPath();
        }
        return false;
    }
}

