/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Clipper;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;

class OperatorClipCursor
extends GeometryCursor {
    GeometryCursor m_inputGeometryCursor;
    SpatialReferenceImpl m_spatialRefImpl;
    Envelope2D m_envelope;
    double m_tolerance;
    int m_index = -1;
    ProgressTracker m_progressTracker;

    OperatorClipCursor(GeometryCursor geoms, Envelope2D envelope, SpatialReference spatial_ref, ProgressTracker progress_tracker) {
        if (geoms == null) {
            throw new IllegalArgumentException();
        }
        this.m_envelope = envelope;
        this.m_inputGeometryCursor = geoms;
        this.m_spatialRefImpl = (SpatialReferenceImpl)spatial_ref;
        this.m_tolerance = InternalUtils.calculateToleranceFromGeometryForOp(spatial_ref, envelope, false);
        this.m_progressTracker = progress_tracker;
    }

    static Geometry clip(Geometry geom, Envelope2D envelope, SpatialReference spatial_ref, ProgressTracker progressTracker) {
        return Clipper.clip(geom, envelope, spatial_ref, Double.NaN, 0.0, progressTracker);
    }

    @Override
    public Geometry next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            return Clipper.clip(geometry, this.m_envelope, this.m_tolerance, 0.0, this.m_progressTracker);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }
}

