/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryAccelerators;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.SpatialReference;

@HadoopSDKPublic
public abstract class Operator {
    @HadoopSDKPublic
    public abstract Type getType();

    @HadoopSDKPublic
    public boolean accelerateGeometry(Geometry geometry, SpatialReference spatialReference, Geometry.GeometryAccelerationDegree accelDegree) {
        return false;
    }

    @HadoopSDKPublic
    public boolean canAccelerateGeometry(Geometry geometry) {
        return false;
    }

    @HadoopSDKPublic
    public static void deaccelerateGeometry(Geometry geometry) {
        GeometryAccelerators accel;
        Geometry.Type gt = geometry.getType();
        if (Geometry.isMultiVertex(gt.value()) && (accel = ((MultiVertexGeometryImpl)geometry._getImpl())._getAccelerators()) != null) {
            accel._setRasterizedGeometry(null);
            accel._setQuadTree(null);
        }
    }

    @HadoopSDKPublic
    public static enum Type {
        Project,
        ExportToJson,
        ImportFromJson,
        ExportToESRIShape,
        ImportFromESRIShape,
        Union,
        Difference,
        Proximity2D,
        Relate,
        Equals,
        Disjoint,
        Intersects,
        Within,
        Contains,
        Crosses,
        Touches,
        Overlaps,
        Buffer,
        GraphicBuffer,
        Distance,
        Intersection,
        Clip,
        Cut,
        DensifyByLength,
        DensifyByAngle,
        LabelPoint,
        GeodesicBuffer,
        GeodeticDensifyByLength,
        ShapePreservingDensify,
        GeodeticLength,
        GeodeticArea,
        Simplify,
        SimplifyOGC,
        Offset,
        Generalize,
        LocateAlong,
        LocateBetween,
        ExportToWkb,
        ImportFromWkb,
        ExportToWkt,
        ImportFromWkt,
        ImportFromGeoJson,
        ExportToGeoJson,
        SymmetricDifference,
        ConvexHull,
        Boundary,
        Centroid,
        Subcurve;

    }
}

