/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.OctTreeImpl;

@HadoopSDKExcluded
public class OctTree {
    private OctTreeImpl m_impl;

    public OctTree(Envelope3D extent, int height) {
        this.m_impl = new OctTreeImpl(extent, height);
    }

    public OctTree(Envelope3D extent, int height, boolean bStoreDuplicates) {
        this.m_impl = new OctTreeImpl(extent, height, bStoreDuplicates);
    }

    public int insert(int element, Envelope3D boundingBox) {
        return this.m_impl.insert(element, boundingBox);
    }

    public int insert(int element, Envelope3D boundingBox, int hintIndex) {
        return this.m_impl.insert(element, boundingBox, hintIndex);
    }

    public void removeElement(int elementHandle) {
        this.m_impl.removeElement(elementHandle);
    }

    public int getElement(int elementHandle) {
        return this.m_impl.getElement(elementHandle);
    }

    public Envelope3D getElementExtent(int elementHandle) {
        return this.m_impl.getElementExtent(elementHandle);
    }

    public Envelope3D getDataExtent() {
        return this.m_impl.getDataExtent();
    }

    public Envelope3D getOctTreeExtent() {
        return this.m_impl.getOctTreeExtent();
    }

    public int getSubTreeElementCount(int octHandle) {
        return this.m_impl.getSubTreeElementCount(octHandle);
    }

    public int getContainedSubTreeElementCount(int octHandle) {
        return this.m_impl.getContainedSubTreeElementCount(octHandle);
    }

    public int getIntersectionCount(Envelope3D query, double tolerance, int maxCount) {
        return this.m_impl.getIntersectionCount(query, tolerance, maxCount);
    }

    public boolean hasData(Envelope3D query, double tolerance) {
        return this.m_impl.hasData(query, tolerance);
    }

    public int getHeight(int octHandle) {
        return this.m_impl.getHeight(octHandle);
    }

    public int getMaxHeight() {
        return this.m_impl.getMaxHeight();
    }

    public Envelope3D getExtent(int octHandle) {
        return this.m_impl.getExtent(octHandle);
    }

    public int getOctant(int elementHandle) {
        return this.m_impl.getOctant(elementHandle);
    }

    public int getElementCount() {
        return this.m_impl.getElementCount();
    }

    public OctTreeIterator getIterator(Geometry query, double tolerance) {
        OctTreeImpl.OctTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
        return new OctTreeIterator(iterator, false);
    }

    public OctTreeIterator getIterator(Envelope3D query, double tolerance) {
        OctTreeImpl.OctTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
        return new OctTreeIterator(iterator, false);
    }

    public OctTreeIterator getIterator() {
        OctTreeImpl.OctTreeIteratorImpl iterator = this.m_impl.getIterator();
        return new OctTreeIterator(iterator, false);
    }

    public OctTreeIterator getIterator(Geometry query, double tolerance, boolean bSorted) {
        if (!bSorted) {
            OctTreeImpl.OctTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
            return new OctTreeIterator(iterator, false);
        }
        OctTreeImpl.OctTreeSortedIteratorImpl iterator = this.m_impl.getSortedIterator(query, tolerance);
        return new OctTreeIterator(iterator, true);
    }

    public OctTreeIterator getIterator(Envelope3D query, double tolerance, boolean bSorted) {
        if (!bSorted) {
            OctTreeImpl.OctTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
            return new OctTreeIterator(iterator, false);
        }
        OctTreeImpl.OctTreeSortedIteratorImpl iterator = this.m_impl.getSortedIterator(query, tolerance);
        return new OctTreeIterator(iterator, true);
    }

    public OctTreeIterator getIterator(boolean bSorted) {
        if (!bSorted) {
            OctTreeImpl.OctTreeIteratorImpl iterator = this.m_impl.getIterator();
            return new OctTreeIterator(iterator, false);
        }
        OctTreeImpl.OctTreeSortedIteratorImpl iterator = this.m_impl.getSortedIterator();
        return new OctTreeIterator(iterator, true);
    }

    Object getImpl_() {
        return this.m_impl;
    }

    public static final class OctTreeIterator {
        private Object m_impl;
        private boolean m_b_sorted;

        public void resetIterator(Geometry query, double tolerance) {
            if (!this.m_b_sorted) {
                ((OctTreeImpl.OctTreeIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            } else {
                ((OctTreeImpl.OctTreeSortedIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            }
        }

        public void resetIterator(Envelope3D query, double tolerance) {
            if (!this.m_b_sorted) {
                ((OctTreeImpl.OctTreeIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            } else {
                ((OctTreeImpl.OctTreeSortedIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            }
        }

        public int next() {
            if (!this.m_b_sorted) {
                return ((OctTreeImpl.OctTreeIteratorImpl)this.m_impl).next();
            }
            return ((OctTreeImpl.OctTreeSortedIteratorImpl)this.m_impl).next();
        }

        Object getImpl_() {
            return this.m_impl;
        }

        private OctTreeIterator(Object obj, boolean bSorted) {
            this.m_impl = obj;
            this.m_b_sorted = bSorted;
        }
    }
}

