/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryAccelerators;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MutableDouble;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class MultiVertexGeometryImpl
extends Geometry {
    private static final long serialVersionUID = 1L;
    VertexDescription m_description;
    AttributeStreamBase[] m_vertexAttributes;
    GeometryAccelerators m_accelerators;
    private double[] m_envelopeData;
    protected int m_pointCount = 0;
    protected int m_reservedPointCount = -1;
    private double m_simpleTolerance = 0.0;
    final Lock st_lock = new ReentrantLock();
    private AtomicInteger m_flagsMask = new AtomicInteger(65503);

    abstract void _copyToImpl(MultiVertexGeometryImpl var1);

    protected abstract void _notifyModifiedAllImpl();

    protected abstract void _verifyStreamsAfterSizeChangeExtraImpl();

    public int getPointCount() {
        return this.m_pointCount;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmptyImpl();
    }

    public VertexDescription getDescriptionImpl() {
        return this.m_description;
    }

    final boolean isEmptyImpl() {
        return this.m_pointCount == 0;
    }

    protected final boolean _hasDirtyFlag(int flag) {
        int n = this.m_flagsMask.get();
        return (n & flag) != 0;
    }

    protected final void _setDirtyFlag(int flag) {
        int n;
        int oldn;
        do {
            if (((oldn = this.m_flagsMask.get()) & flag) != flag) continue;
            return;
        } while (!this.m_flagsMask.weakCompareAndSet(oldn, n = oldn | flag));
    }

    protected final void _clearDirtyFlag(int flag) {
        int n;
        do {
            if (((n = this.m_flagsMask.get()) & flag) != 0) continue;
            return;
        } while (!this.m_flagsMask.weakCompareAndSet(n, n & ~flag));
    }

    protected final void _clearAndSetDirtyFlag(int flagToClear, int flagToSet) {
        int n;
        do {
            n = this.m_flagsMask.get();
            int m = n & ~flagToClear;
        } while (!this.m_flagsMask.weakCompareAndSet(n, m |= flagToSet));
    }

    protected final void _verifyAllStreamsAfterSizeChange() {
        if (this._hasDirtyFlag(32)) {
            this._verifyAllStreamsAfterSizeChangeImpl();
        }
    }

    protected final void throwIfEmpty() {
        if (this.isEmptyImpl()) {
            throw new GeometryException("This operation was performed on an Empty Geometry.");
        }
    }

    public void getPointByVal(int index, Point dst) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new IllegalArgumentException();
        }
        Point outPoint = dst;
        outPoint.assignVertexDescription(this.m_description);
        for (int attributeIndex = 0; attributeIndex < this.m_description.getAttributeCount(); ++attributeIndex) {
            int semantics = this.m_description.getSemantics(attributeIndex);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = this.m_vertexAttributes[attributeIndex].readAsDbl(ncomp * index + icomp);
                outPoint.setAttribute(semantics, icomp, v);
            }
        }
    }

    public void setPointByVal(int index, Point src) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new GeometryException("index out of bounds");
        }
        Point point = src;
        if (src.isEmpty()) {
            throw new IllegalArgumentException();
        }
        VertexDescription vdin = point.getDescription();
        if (vdin != this.m_description) {
            this.mergeVertexDescription(vdin);
        }
        double x = point.getX();
        double y = point.getY();
        AttributeStreamOfDbl dblStream = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        dblStream.write(index * 2, x, y);
        int nattrib = this.m_description.getAttributeCount();
        for (int attribute_index = 1; attribute_index < nattrib; ++attribute_index) {
            int semantics = this.m_description.getSemantics(attribute_index);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = point.getAttributeAsDbl(semantics, icomp);
                this.m_vertexAttributes[attribute_index].writeAsDbl(index * ncomp + icomp, v);
            }
        }
        this.notifyModified(2001);
    }

    protected void setPointByValWithDefaults_(int index, Point src) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new GeometryException("index out of bounds");
        }
        if (src.isEmpty()) {
            throw new IllegalArgumentException();
        }
        double x = src.getX();
        double y = src.getY();
        AttributeStreamOfDbl dblStream = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        dblStream.write(index * 2, x, y);
        VertexDescription vdSrc = src.getDescription();
        int nattrib = this.m_description.getAttributeCount();
        for (int attribute_index = 1; attribute_index < nattrib; ++attribute_index) {
            int semantics = this.m_description.getSemantics(attribute_index);
            int ncomp = VertexDescription.getComponentCount(semantics);
            boolean hasAttr = vdSrc.hasAttribute(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = hasAttr ? src.getAttributeAsDbl(semantics, icomp) : VertexDescription.getDefaultValue(semantics);
                this.m_vertexAttributes[attribute_index].writeAsDbl(index * ncomp + icomp, v);
            }
        }
        this.notifyModified(2001);
    }

    protected void setPointByValWithDefaults_(int index, double x, double y, double z) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new GeometryException("index out of bounds");
        }
        if (Double.isNaN(x) || Double.isNaN(y)) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfDbl dblStream = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        dblStream.write(index * 2, x, y);
        int attribute_index = 1;
        if (this.m_description.hasAttribute(1)) {
            this.m_vertexAttributes[1].writeAsDbl(index, z);
            attribute_index = 2;
        }
        int nattrib = this.m_description.getAttributeCount();
        while (attribute_index < nattrib) {
            int semantics = this.m_description.getSemantics(attribute_index);
            double v = VertexDescription.getDefaultValue(semantics);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                this.m_vertexAttributes[attribute_index].writeAsDbl(index * ncomp + icomp, v);
            }
            ++attribute_index;
        }
        this.notifyModified(2001);
    }

    public Point2D getXY(int index) {
        Point2D pt = new Point2D();
        this.getXY(index, pt);
        return pt;
    }

    public void getXY(int index, Point2D pt) {
        if (index < 0 || index >= this.getPointCount()) {
            throw new IndexOutOfBoundsException();
        }
        AttributeStreamOfDbl v = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        v.read(index * 2, pt);
    }

    public void setXY(int index, Point2D pt) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new IndexOutOfBoundsException();
        }
        AttributeStreamOfDbl v = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        v.write(index * 2, pt);
        this.notifyModified(2001);
    }

    public void setXY(int index, double x, double y) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new IndexOutOfBoundsException();
        }
        AttributeStreamOfDbl v = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        v.write(index * 2, x, y);
        this.notifyModified(2001);
    }

    public Point3D getXYZ(int index) {
        if (index < 0 || index >= this.getPointCount()) {
            throw new IndexOutOfBoundsException();
        }
        AttributeStreamOfDbl v = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        Point3D pt = new Point3D();
        pt.x = v.read(index * 2);
        pt.y = v.read(index * 2 + 1);
        pt.z = this.hasAttribute(1) ? this.m_vertexAttributes[1].readAsDbl(index) : VertexDescription.getDefaultValue(1);
        return pt;
    }

    public void setXYZ(int index, Point3D pt) {
        if (index < 0 || index >= this.getPointCount()) {
            throw new IndexOutOfBoundsException();
        }
        this.addAttribute(1);
        AttributeStreamOfDbl v = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        v.write(index * 2, pt.x, pt.y);
        this.m_vertexAttributes[1].writeAsDbl(index, pt.z);
        this.notifyModified(2001);
    }

    public double getAttributeAsDbl(int semantics, int offset, int ordinate) {
        if (offset < 0 || offset >= this.m_pointCount) {
            throw new IndexOutOfBoundsException();
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (attributeIndex >= 0) {
            return this.m_vertexAttributes[attributeIndex].readAsDbl(offset * ncomps + ordinate);
        }
        return VertexDescription.getDefaultValue(semantics);
    }

    public int getAttributeAsInt(int semantics, int offset, int ordinate) {
        return (int)this.getAttributeAsDbl(semantics, offset, ordinate);
    }

    public void setAttribute(int semantics, int offset, int ordinate, double value) {
        if (offset < 0 || offset >= this.m_pointCount) {
            throw new IndexOutOfBoundsException();
        }
        int ncomps = VertexDescription.getComponentCount(semantics);
        if (ordinate >= ncomps) {
            throw new IndexOutOfBoundsException();
        }
        this.addAttribute(semantics);
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        this.notifyModified(2001);
        this.m_vertexAttributes[attributeIndex].writeAsDbl(offset * ncomps + ordinate, value);
    }

    public void setAttribute(int semantics, int offset, int ordinate, int value) {
        this.setAttribute(semantics, offset, ordinate, (double)value);
    }

    public AttributeStreamBase getAttributeStreamRef(int semantics) {
        this.throwIfEmpty();
        this.addAttribute(semantics);
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        return this.m_vertexAttributes[attributeIndex];
    }

    public void setAttributeStreamRef(int semantics, AttributeStreamBase stream) {
        if (stream != null && VertexDescription.getPersistence(semantics) != stream.getPersistence()) {
            throw new IllegalArgumentException();
        }
        this.addAttribute(semantics);
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        if (this.m_vertexAttributes == null) {
            this.m_vertexAttributes = new AttributeStreamBase[this.m_description.getAttributeCount()];
        }
        this.m_vertexAttributes[attributeIndex] = stream;
        this.notifyModified(0xFFFFFF);
    }

    protected final void _assignVertexDescriptionImpl(VertexDescription newDescription) {
        if (this.m_vertexAttributes != null) {
            int[] mapping = VertexDescriptionDesignerImpl.mapAttributes(newDescription, this.m_description);
            AttributeStreamBase[] newAttributes = new AttributeStreamBase[newDescription.getAttributeCount()];
            int n = newDescription.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                int m = mapping[i];
                if (m != -1) {
                    newAttributes[i] = this.m_vertexAttributes[m];
                    continue;
                }
                this.m_reservedPointCount = -1;
            }
            this.m_vertexAttributes = newAttributes;
        }
        this.m_description = newDescription;
        this.notifyModified(65535);
        this._verifyAllStreamsAfterSizeChange();
    }

    protected void _updateEnvelope(Envelope2D env) {
        this._updateAllDirtyIntervals(true);
        env.setCoords(this.m_envelopeData[0], this.m_envelopeData[1], this.m_envelopeData[2], this.m_envelopeData[3]);
    }

    protected void _updateEnvelope(Envelope3D env) {
        this._updateAllDirtyIntervals(true);
        if (this.hasAttribute(1)) {
            int n = this.m_description.getTotalComponentCount() - 2;
            env.setCoords(this.m_envelopeData[0], this.m_envelopeData[1], this.m_envelopeData[4], this.m_envelopeData[2], this.m_envelopeData[3], this.m_envelopeData[4 + n]);
        } else {
            env.setCoords(this.m_envelopeData[0], this.m_envelopeData[1], 0.0, this.m_envelopeData[2], this.m_envelopeData[3], 0.0);
        }
    }

    protected void _updateLooseEnvelope(Envelope2D env) {
        this._updateAllDirtyIntervals(false);
        env.setCoords(this.m_envelopeData[0], this.m_envelopeData[1], this.m_envelopeData[2], this.m_envelopeData[3]);
    }

    protected void _updateLooseEnvelope(Envelope3D env) {
        this._updateAllDirtyIntervals(false);
        if (this.hasAttribute(1)) {
            int n = this.m_description.getTotalComponentCount() - 2;
            env.setCoords(this.m_envelopeData[0], this.m_envelopeData[1], this.m_envelopeData[4], this.m_envelopeData[2], this.m_envelopeData[3], this.m_envelopeData[4 + n]);
        } else {
            env.setCoords(this.m_envelopeData[0], this.m_envelopeData[1], 0.0, this.m_envelopeData[2], this.m_envelopeData[3], 0.0);
        }
    }

    @Override
    public void queryEnvelope(Envelope env) {
        this._updateAllDirtyIntervals(true);
        env.setFromData_(this.m_description, this.m_envelopeData);
    }

    @Override
    public void queryEnvelope2D(Envelope2D env) {
        this._updateEnvelope(env);
    }

    @Override
    public void queryEnvelope3D(Envelope3D env) {
        this._updateEnvelope(env);
    }

    @Override
    public void queryLooseEnvelope2D(Envelope2D env) {
        this._updateLooseEnvelope(env);
    }

    @Override
    public void queryLooseEnvelope3D(Envelope3D env) {
        this._updateLooseEnvelope(env);
    }

    @Override
    public void queryInterval(int semantics, int ordinate, Envelope1D dst) {
        if (this.isEmptyImpl()) {
            dst.setEmpty();
            return;
        }
        this._updateAllDirtyIntervals(true);
        Envelope.queryIntervalFromData_(this.m_description, this.m_envelopeData, semantics, ordinate, dst);
    }

    public int hashCode() {
        int hashCode = this.m_description.hashCode();
        if (!this.isEmptyImpl()) {
            int pointCount = this.getPointCount();
            int n = this.m_description.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                int components = VertexDescription.getComponentCount(this.m_description.getSemantics(i));
                AttributeStreamBase stream = this.m_vertexAttributes[i];
                hashCode = stream.calculateHashImpl(hashCode, 0, pointCount * components);
            }
        }
        return hashCode;
    }

    public boolean equals(Object other) {
        int pointCountOther;
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiVertexGeometryImpl)) {
            return false;
        }
        MultiVertexGeometryImpl otherMulti = (MultiVertexGeometryImpl)other;
        if (!this.m_description.equals(otherMulti.m_description)) {
            return false;
        }
        if (this.isEmptyImpl() != otherMulti.isEmptyImpl()) {
            return false;
        }
        if (this.isEmptyImpl()) {
            return true;
        }
        int pointCount = this.getPointCount();
        if (pointCount != (pointCountOther = otherMulti.getPointCount())) {
            return false;
        }
        for (int i = 0; i < this.m_description.getAttributeCount(); ++i) {
            int components;
            AttributeStreamBase streamOther;
            int semantics = this.m_description.getSemantics(i);
            AttributeStreamBase stream = this.getAttributeStreamRef(semantics);
            if (stream.equals(streamOther = otherMulti.getAttributeStreamRef(semantics), 0, pointCount * (components = VertexDescription.getComponentCount(semantics)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Geometry other, double tol) {
        int pointCountOther;
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiVertexGeometryImpl)) {
            return false;
        }
        MultiVertexGeometryImpl otherMulti = (MultiVertexGeometryImpl)other;
        if (!this.m_description.equals(otherMulti.m_description)) {
            return false;
        }
        if (this.isEmptyImpl() != otherMulti.isEmptyImpl()) {
            return false;
        }
        if (this.isEmptyImpl()) {
            return true;
        }
        int pointCount = this.getPointCount();
        if (pointCount != (pointCountOther = otherMulti.getPointCount())) {
            return false;
        }
        for (int i = 0; i < this.m_description.getAttributeCount(); ++i) {
            int components;
            AttributeStreamBase streamOther;
            int semantics = this.m_description.getSemantics(i);
            AttributeStreamBase stream = this.getAttributeStreamRef(semantics);
            if (stream.equals(streamOther = otherMulti.getAttributeStreamRef(semantics), 0, pointCount * (components = VertexDescription.getComponentCount(semantics)), tol)) continue;
            return false;
        }
        return true;
    }

    void setEnvelopeForImport(Envelope env) {
        if (!this.m_description.equals(env.getDescription())) {
            throw new IllegalArgumentException();
        }
        int n = this.m_description.getTotalComponentCount() * 2;
        this.m_envelopeData = new double[n];
        env.copyToData_(this.m_envelopeData);
        this._clearDirtyFlag(192);
    }

    @Override
    public void copyTo(Geometry dstGeom) {
        if (dstGeom.getType() != this.getType()) {
            throw new IllegalArgumentException();
        }
        this._copyToUnsafe(dstGeom);
    }

    void _copyToUnsafe(Geometry dst_geom) {
        int gt_dst;
        MultiVertexGeometryImpl dst = (MultiVertexGeometryImpl)dst_geom;
        int gt_src = this.getType().value();
        GeometryException.releaseAssert(gt_src == (gt_dst = dst.getType().value()) || gt_src == 1736 && gt_dst == 1607);
        dst._clearAccelerators();
        dst.m_description = this.m_description;
        dst.m_vertexAttributes = null;
        int nattrib = this.m_description.getAttributeCount();
        AttributeStreamBase[] cloneAttributes = null;
        if (this.m_vertexAttributes != null) {
            cloneAttributes = new AttributeStreamBase[nattrib];
            for (int i = 0; i < nattrib; ++i) {
                if (this.m_vertexAttributes[i] == null) continue;
                int ncomps = VertexDescription.getComponentCount(this.m_description.getSemantics(i));
                cloneAttributes[i] = this.m_vertexAttributes[i].restrictedClone(this.getPointCount() * ncomps);
            }
        }
        dst.m_pointCount = this.m_pointCount;
        dst.m_reservedPointCount = !this._hasDirtyFlag(32) ? this.m_pointCount : -1;
        MutableDouble geomTol = new MutableDouble();
        int knownSimple = this.getIsSimple(0.0, geomTol);
        this.st_lock.lock();
        dst.m_envelopeData = null;
        if (this.m_envelopeData != null) {
            dst.m_envelopeData = (double[])this.m_envelopeData.clone();
        }
        dst.m_flagsMask.set(this.m_flagsMask.get());
        this.st_lock.unlock();
        if (gt_src == gt_dst) {
            dst.setIsSimple(knownSimple, geomTol.get());
        } else {
            assert (gt_src == 1736 && gt_dst == 1607);
            if (knownSimple >= 3) {
                dst.setIsSimple(1, geomTol.get());
            } else {
                dst.setIsSimple(-1, 0.0);
            }
        }
        dst.m_vertexAttributes = cloneAttributes;
        dst.m_reservedPointCount = dst._hasDirtyFlag(32) ? -1 : dst.m_pointCount;
        dst.m_accelerators = this.m_accelerators;
        try {
            this._copyToImpl(dst);
        }
        catch (Exception ex) {
            dst.setEmpty();
            throw new RuntimeException(ex);
        }
        dst._verifyAllStreamsAfterSizeChange();
    }

    public boolean _attributeStreamIsAllocated(int semantics) {
        this.throwIfEmpty();
        int attributeIndex = this.m_description.getAttributeIndex(semantics);
        return attributeIndex >= 0 && this.m_vertexAttributes[attributeIndex] != null;
    }

    void _setEmptyImpl() {
        this.m_pointCount = 0;
        this.m_reservedPointCount = -1;
        this.m_vertexAttributes = null;
        this.notifyModified(0xFFFFFF);
    }

    public void notifyModified(int flags) {
        if (flags == 0xFFFFFF) {
            this.m_reservedPointCount = -1;
            this._notifyModifiedAllImpl();
        }
        this._setDirtyFlag(flags);
        this._clearAccelerators();
        if ((flags & 0x20) != 0) {
            this._verifyAllStreamsAfterSizeChange();
        }
    }

    public void notifyModified() {
        this.notifyModified(2001);
    }

    protected void _updateXYImpl(Envelope env, boolean bExact) {
        assert (env.isEmpty());
        AttributeStreamOfDbl stream = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        Point2D pt = new Point2D();
        for (int i = 0; i < this.m_pointCount; ++i) {
            stream.read(2 * i, pt);
            env.merge(pt);
        }
    }

    protected void _updateAllDirtyIntervals(boolean bExact) {
        if (this._hasDirtyFlag(192)) {
            if (this.isEmpty()) {
                Envelope env = new Envelope(this.m_description);
                this.st_lock.lock();
                if (this._hasDirtyFlag(192)) {
                    this.m_envelopeData = env.copyToData_();
                    this._clearDirtyFlag(192);
                }
                this.st_lock.unlock();
                return;
            }
            Envelope env = new Envelope(this.m_description);
            this._updateXYImpl(env, bExact);
            Envelope1D interval = new Envelope1D();
            for (int attributeIndex = 1; attributeIndex < this.m_description.getAttributeCount(); ++attributeIndex) {
                int semantics = this.m_description.getSemantics(attributeIndex);
                int ncomps = VertexDescription.getComponentCount(semantics);
                AttributeStreamBase stream = this.m_vertexAttributes[attributeIndex];
                for (int iord = 0; iord < ncomps; ++iord) {
                    if (interval == null) {
                        interval = new Envelope1D();
                    }
                    interval.setEmpty();
                    for (int i = 0; i < this.m_pointCount; ++i) {
                        double value = stream.readAsDbl(i * ncomps + iord);
                        interval.merge(value);
                    }
                    env.setInterval(semantics, iord, interval);
                }
            }
            this.st_lock.lock();
            if (this._hasDirtyFlag(192)) {
                this.m_envelopeData = env.copyToData_();
                this._clearDirtyFlag(192);
            }
            this.st_lock.unlock();
        }
    }

    void calculateEnvelope2D(Envelope2D env, boolean bExact) {
        env.setEmpty();
        AttributeStreamOfDbl stream = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        Point2D pt = new Point2D();
        for (int i = 0; i < this.m_pointCount; ++i) {
            stream.read(2 * i, pt);
            env.merge(pt);
        }
    }

    protected void _verifyAllStreamsAfterSizeChangeImpl() {
        if (!this._hasDirtyFlag(32)) {
            return;
        }
        if (this.m_reservedPointCount < this.m_pointCount) {
            if (this.m_vertexAttributes == null) {
                this.m_vertexAttributes = new AttributeStreamBase[this.m_description.getAttributeCount()];
            }
            this.m_reservedPointCount = NumberUtils.intMax();
            int reserveSize = 0;
            reserveSize = this.m_pointCount < 4 ? 3 : (this.m_pointCount <= 128 ? this.m_pointCount * 2 : (this.m_pointCount * 4 + 2) / 3);
            int n = this.m_description.getAttributeCount();
            for (int attributeIndex = 0; attributeIndex < n; ++attributeIndex) {
                int semantics = this.m_description.getSemantics(attributeIndex);
                int size = 0;
                if (this.m_vertexAttributes[attributeIndex] != null) {
                    int ncomp = VertexDescription.getComponentCount(semantics);
                    size = this.m_vertexAttributes[attributeIndex].virtualSize() / ncomp;
                    if (size < this.m_pointCount) {
                        this.m_vertexAttributes[attributeIndex].resize(reserveSize * ncomp, VertexDescription.getDefaultValue(semantics));
                        size = reserveSize;
                    }
                } else {
                    this.m_vertexAttributes[attributeIndex] = AttributeStreamBase.createAttributeStreamWithSemantics(semantics, reserveSize);
                    size = reserveSize;
                }
                if (size >= this.m_reservedPointCount) continue;
                this.m_reservedPointCount = size;
            }
        }
        this._verifyStreamsAfterSizeChangeExtraImpl();
        this._clearDirtyFlag(32);
    }

    protected final void reserveImpl_(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("");
        }
        if (capacity == 0) {
            return;
        }
        if (this.m_reservedPointCount < capacity) {
            if (this.m_vertexAttributes == null) {
                this.m_vertexAttributes = new AttributeStreamBase[this.m_description.getAttributeCount()];
            }
            if (this.m_vertexAttributes[0] == null) {
                this.m_vertexAttributes[0] = AttributeStreamBase.createAttributeStreamWithSemanticsUninitialized(0, capacity);
            } else {
                this.m_vertexAttributes[0].resize(capacity * 2);
            }
            int n = this.m_description.getAttributeCount();
            for (int attribute_index = 1; attribute_index < n; ++attribute_index) {
                int semantics = this.m_description.getSemantics(attribute_index);
                int ncomp = VertexDescription.getComponentCount(semantics);
                if (this.m_vertexAttributes[attribute_index] != null) {
                    this.m_vertexAttributes[attribute_index].resize(capacity * ncomp);
                    continue;
                }
                this.m_vertexAttributes[attribute_index] = AttributeStreamBase.createAttributeStreamWithSemanticsUninitialized(semantics, capacity);
            }
            this.m_reservedPointCount = capacity;
        }
    }

    void _resizeImpl(int point_count) {
        if (point_count == this.m_pointCount) {
            return;
        }
        assert (point_count >= 0);
        this.m_pointCount = point_count;
        int dirtyFlags = this.m_pointCount <= this.m_reservedPointCount ? 2001 : 65535;
        this.notifyModified(dirtyFlags);
    }

    int queryCoordinates(Point2D[] dst, int dstSize, int beginIndex, int endIndex) {
        int endIndexC = endIndex < 0 ? this.m_pointCount : endIndex;
        endIndexC = Math.min(endIndexC, beginIndex + dstSize);
        if (beginIndex < 0 || beginIndex >= this.m_pointCount || endIndexC < beginIndex) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfDbl xy = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        int j = 0;
        double[] dstArray = new double[dst.length * 2];
        xy.readRange(2 * beginIndex, (endIndexC - beginIndex) * 2, dstArray, j, true);
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = new Point2D(dstArray[i * 2], dstArray[i * 2 + 1]);
        }
        return endIndexC;
    }

    int QueryCoordinates(Point3D[] dst, int dstSize, int beginIndex, int endIndex) {
        int endIndexC = endIndex < 0 ? this.m_pointCount : endIndex;
        endIndexC = Math.min(endIndexC, beginIndex + dstSize);
        if (beginIndex < 0 || beginIndex >= this.m_pointCount || endIndexC < beginIndex) {
            throw new IllegalArgumentException();
        }
        AttributeStreamOfDbl xy = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        AttributeStreamOfDbl z = null;
        double v = VertexDescription.getDefaultValue(1);
        boolean bHasZ = this.hasAttribute(1);
        if (bHasZ) {
            z = (AttributeStreamOfDbl)this.getAttributeStreamRef(1);
        }
        int j = 0;
        int i = beginIndex;
        while (i < endIndexC) {
            dst[j].x = xy.read(2 * i);
            dst[j].y = xy.read(2 * i + 1);
            dst[j].z = bHasZ ? z.read(i) : v;
            dst[j] = this.getXYZ(i);
            ++i;
            ++j;
        }
        return endIndexC;
    }

    public int getIsSimple(double tolerance, MutableDouble geom_tolerance_out) {
        int res = -1;
        if (geom_tolerance_out != null) {
            geom_tolerance_out.put(0.0);
        }
        this.st_lock.lock();
        int flags = this.m_flagsMask.get();
        double tol = this.m_simpleTolerance;
        this.st_lock.unlock();
        if ((flags & 1) == 0) {
            int v = (flags & 0xE) >> 1;
            assert (v >= 0 && v <= 5);
            res = v;
            if (geom_tolerance_out != null) {
                geom_tolerance_out.put(tol);
            }
            if (tol < tolerance) {
                res = -1;
            }
        }
        return res;
    }

    final void setIsSimple(int isSimpleRes, double tolerance) {
        this.setIsSimple(isSimpleRes, tolerance, false);
    }

    final void setIsSimple(int isSimpleRes, double tolerance, boolean ogc_known) {
        if (isSimpleRes == 2 ? this.getType() != Geometry.Type.Polyline : (isSimpleRes == 1 ? this.getType() != Geometry.Type.MultiPoint && this.getType() != Geometry.Type.Polyline : isSimpleRes == 3 && this.getType() != Geometry.Type.Polygon)) {
            throw GeometryException.GeometryInternalError();
        }
        if (isSimpleRes == -1) {
            this._setDirtyFlag(17);
        } else {
            int set_mask = isSimpleRes << 1;
            int n = ogc_known ? 0 : 16;
            int clear_mask = 31;
            this.st_lock.lock();
            this.m_simpleTolerance = tolerance;
            this._clearAndSetDirtyFlag(clear_mask, set_mask |= n);
            this.st_lock.unlock();
        }
    }

    double _getSimpleTolerance() {
        return this.m_simpleTolerance;
    }

    public GeometryAccelerators _getAccelerators() {
        return this.m_accelerators;
    }

    void _clearAccelerators() {
        if (this.m_accelerators != null) {
            this.m_accelerators = null;
        }
    }

    void _interpolateTwoVertices(int vertex1, int vertex2, double f, Point outPoint) {
        if (vertex1 < 0 || vertex1 >= this.m_pointCount) {
            throw new GeometryException("index out of bounds.");
        }
        if (vertex2 < 0 || vertex2 >= this.m_pointCount) {
            throw new GeometryException("index out of bounds.");
        }
        outPoint.assignVertexDescription(this.m_description);
        double[] v1 = VertexDescription.createComponentArray();
        double[] v2 = VertexDescription.createComponentArray();
        for (int attributeIndex = 0; attributeIndex < this.m_description.getAttributeCount(); ++attributeIndex) {
            int semantics = this.m_description.getSemantics(attributeIndex);
            this.queryAttributeAsDbl(semantics, vertex1, v1);
            this.queryAttributeAsDbl(semantics, vertex2, v2);
            int interp = VertexDescription.getInterpolation(semantics);
            int ncomps = VertexDescription.getComponentCount(semantics);
            MathUtils.interpolate(semantics, interp, v1, v2, f, v1, ncomps);
            outPoint.setAttributes(semantics, v1);
        }
    }

    void queryAttributeAsDbl(int semantics, int vertex, double[] v1) {
        assert (this.hasAttribute(semantics));
        assert (vertex >= 0 && vertex < this.m_pointCount);
        int attr = this.m_description.getAttributeIndex(semantics);
        int ncomps = VertexDescription.getComponentCount(semantics);
        AttributeStreamBase stream = this.m_vertexAttributes[attr];
        int index = vertex * ncomps;
        v1[0] = stream.readAsDbl(index);
        for (int i = 1; i < ncomps; ++i) {
            v1[i] = stream.readAsDbl(index + i);
        }
    }

    double _getShortestDistance(int vertex1, int vertex2) {
        Point2D pt = this.getXY(vertex1);
        pt.sub(this.getXY(vertex2));
        return pt.length();
    }

    public Point getPoint(int index) {
        if (index < 0 || index >= this.m_pointCount) {
            throw new IndexOutOfBoundsException();
        }
        Point outPoint = new Point(this.m_description);
        for (int attributeIndex = 0; attributeIndex < this.m_description.getAttributeCount(); ++attributeIndex) {
            int semantics = this.m_description.getSemantics(attributeIndex);
            int ncomp = VertexDescription.getComponentCount(semantics);
            for (int icomp = 0; icomp < ncomp; ++icomp) {
                double v = this.m_vertexAttributes[attributeIndex].readAsDbl(ncomp * index + icomp);
                outPoint.setAttribute(semantics, icomp, v);
            }
        }
        return outPoint;
    }

    public void setPoint(int index, Point src) {
        this.setPointByVal(index, src);
    }

    public void queryCoordinates(Point[] dst) {
        int sz = this.m_pointCount;
        if (dst.length < sz) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sz; ++i) {
            dst[i] = this.getPoint(i);
        }
    }

    public void queryCoordinates(Point2D[] dst) {
        int sz = this.m_pointCount;
        if (dst.length < sz) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sz; ++i) {
            dst[i] = this.getXY(i);
        }
    }

    public void queryCoordinates(Point3D[] dst) {
        int sz = this.m_pointCount;
        if (dst.length < sz) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sz; ++i) {
            dst[i] = this.getXYZ(i);
        }
    }

    @Override
    public void replaceNaNs(int semantics, double value) {
        this.addAttribute(semantics);
        if (this.isEmpty()) {
            return;
        }
        boolean modified = false;
        int ncomps = VertexDescription.getComponentCount(semantics);
        for (int i = 0; i < ncomps; ++i) {
            AttributeStreamBase streamBase = this.getAttributeStreamRef(semantics);
            if (streamBase instanceof AttributeStreamOfDbl) {
                AttributeStreamOfDbl dblStream = (AttributeStreamOfDbl)streamBase;
                int n = this.m_pointCount * ncomps;
                for (int ivert = 0; ivert < n; ++ivert) {
                    double v = dblStream.read(ivert);
                    if (!Double.isNaN(v)) continue;
                    dblStream.write(ivert, value);
                    modified = true;
                }
                continue;
            }
            int n = this.m_pointCount * ncomps;
            for (int ivert = 0; ivert < n; ++ivert) {
                double v = streamBase.readAsDbl(ivert);
                if (!Double.isNaN(v)) continue;
                streamBase.writeAsDbl(ivert, value);
                modified = true;
            }
        }
        if (modified) {
            this.notifyModified(2001);
        }
    }

    public abstract boolean _buildRasterizedGeometryAccelerator(double var1, Geometry.GeometryAccelerationDegree var3);

    public abstract boolean _buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree var1);

    void ensureUniqueAccelerators_() {
        if (this.m_accelerators != null) {
            GeometryAccelerators new_accelerators;
            this.m_accelerators = new_accelerators = (GeometryAccelerators)this.m_accelerators.clone();
        }
    }

    @Override
    public String toString() {
        return "MultiVertexGeometryImpl";
    }

    @Override
    public VertexDescription getDescription() {
        return this.m_description;
    }

    @Override
    public void assignVertexDescription(VertexDescription src) {
        if (this.m_description == src) {
            return;
        }
        this._assignVertexDescriptionImpl(src);
    }

    @Override
    public void mergeVertexDescription(VertexDescription src) {
        if (this.m_description == src) {
            return;
        }
        if (this.m_description.hasAttributesFrom(src)) {
            return;
        }
        this._mergeVertexDescriptionImpl(src);
    }

    @Override
    public boolean hasAttribute(int semantics) {
        return this.m_description.hasAttribute(semantics);
    }

    @Override
    public void addAttribute(int semantics) {
        if (this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription descr = VertexDescriptionDesignerImpl.getMergedVertexDescription(this.m_description, semantics);
        this.assignVertexDescription(descr);
    }

    @Override
    public void dropAttribute(int semantics) {
        if (!this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription descr = VertexDescriptionDesignerImpl.removeSemanticsFromVertexDescription(this.m_description, semantics);
        this.assignVertexDescription(descr);
    }

    @Override
    public void dropAllAttributes() {
        VertexDescription newvd = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        if (newvd == this.m_description) {
            return;
        }
        this.assignVertexDescription(newvd);
    }

    public static interface DirtyFlags {
        public static final int DirtyIsKnownSimple = 1;
        public static final int SimpleBits = 14;
        public static final int DirtyOGCFlags = 16;
        public static final int DirtyVerifiedStreams = 32;
        public static final int DirtyExactIntervals = 64;
        public static final int DirtyLooseIntervals = 128;
        public static final int DirtyIntervals = 192;
        public static final int DirtyIsEnvelope = 256;
        public static final int DirtyLength2D = 512;
        public static final int DirtyRingAreas2D = 1024;
        public static final int DirtyCoordinates = 2001;
        public static final int DirtyAllInternal = 65535;
        public static final int DirtyAll = 0xFFFFFF;
    }
}

