/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIterator;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import java.io.Serializable;

@AndroidSDKPublic
@HadoopSDKPublic
public abstract class MultiPath
extends MultiVertexGeometry
implements Serializable {
    MultiPathImpl m_impl;

    @Override
    @HadoopSDKPublic
    public VertexDescription getDescription() {
        return this.m_impl.getDescription();
    }

    @Override
    @HadoopSDKPublic
    public void assignVertexDescription(VertexDescription src) {
        this.m_impl.assignVertexDescription(src);
    }

    @Override
    @HadoopSDKPublic
    public void mergeVertexDescription(VertexDescription src) {
        this.m_impl.mergeVertexDescription(src);
    }

    @Override
    @HadoopSDKPublic
    public boolean hasAttribute(int semantics) {
        return this.m_impl.hasAttribute(semantics);
    }

    @Override
    @HadoopSDKPublic
    public void addAttribute(int semantics) {
        this.m_impl.addAttribute(semantics);
    }

    @Override
    @HadoopSDKPublic
    public void dropAttribute(int semantics) {
        this.m_impl.dropAttribute(semantics);
    }

    @Override
    @HadoopSDKPublic
    public void dropAllAttributes() {
        this.m_impl.dropAllAttributes();
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getPointCount() {
        return this.m_impl.getPointCount();
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point getPoint(int index) {
        return this.m_impl.getPoint(index);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setPoint(int index, Point point) {
        this.m_impl.setPoint(index, point);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isEmpty() {
        return this.m_impl.isEmptyImpl();
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double calculateArea2D() {
        return this.m_impl.calculateArea2D();
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double calculateLength2D() {
        return this.m_impl.calculateLength2D();
    }

    @HadoopSDKPublic
    public double calculatePathLength2D(int pathIndex) {
        return this.m_impl.calculatePathLength2D(pathIndex);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public double getAttributeAsDbl(int semantics, int index, int ordinate) {
        return this.m_impl.getAttributeAsDbl(semantics, index, ordinate);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getAttributeAsInt(int semantics, int index, int ordinate) {
        return this.m_impl.getAttributeAsInt(semantics, index, ordinate);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setAttribute(int semantics, int index, int ordinate, double value) {
        this.m_impl.setAttribute(semantics, index, ordinate, value);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setAttribute(int semantics, int index, int ordinate, int value) {
        this.m_impl.setAttribute(semantics, index, ordinate, value);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Point2D getXY(int index) {
        return this.m_impl.getXY(index);
    }

    @Override
    @HadoopSDKPublic
    public void getXY(int index, Point2D pt) {
        this.m_impl.getXY(index, pt);
    }

    @Override
    @HadoopSDKPublic
    public void setXY(int index, Point2D pt) {
        this.m_impl.setXY(index, pt);
    }

    @Override
    @HadoopSDKPublic
    public Point3D getXYZ(int index) {
        return this.m_impl.getXYZ(index);
    }

    @Override
    @HadoopSDKPublic
    public void setXYZ(int index, Point3D pt) {
        this.m_impl.setXYZ(index, pt);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void queryEnvelope(Envelope env) {
        this.m_impl.queryEnvelope(env);
    }

    @Override
    @HadoopSDKPublic
    public void queryEnvelope2D(Envelope2D env) {
        this.m_impl.queryEnvelope2D(env);
    }

    @HadoopSDKPublic
    public void queryPathEnvelope2D(int pathIndex, Envelope2D env) {
        this.m_impl.queryPathEnvelope2D(pathIndex, env);
    }

    @Override
    @HadoopSDKPublic
    public void queryEnvelope3D(Envelope3D env) {
        this.m_impl.queryEnvelope3D(env);
    }

    @HadoopSDKPublic
    public void queryLooseEnvelope(Envelope2D env) {
        this.m_impl.queryLooseEnvelope2D(env);
    }

    @HadoopSDKPublic
    public void queryLooseEnvelope(Envelope3D env) {
        this.m_impl.queryLooseEnvelope3D(env);
    }

    @Override
    @HadoopSDKPublic
    public void queryInterval(int semantics, int ordinate, Envelope1D dst) {
        this.m_impl.queryInterval(semantics, ordinate, dst);
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void copyTo(Geometry dst) {
        if (this.getType() != dst.getType()) {
            throw new IllegalArgumentException();
        }
        this.m_impl.copyTo((Geometry)dst._getImpl());
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public Geometry getBoundary() {
        return this.m_impl.getBoundary();
    }

    @Override
    @HadoopSDKPublic
    public void queryCoordinates(Point2D[] dst) {
        this.m_impl.queryCoordinates(dst);
    }

    @HadoopSDKPublic
    public void queryCoordinates(Point2D[] dst, int dstSize, int beginIndex, int endIndex) {
        this.m_impl.queryCoordinates(dst, dstSize, beginIndex, endIndex);
    }

    @Override
    @HadoopSDKPublic
    public void queryCoordinates(Point3D[] dst) {
        this.m_impl.queryCoordinates(dst);
    }

    @Override
    @HadoopSDKPublic
    public void queryCoordinates(Point[] dst) {
        this.m_impl.queryCoordinates(dst);
    }

    @HadoopSDKPublic
    public boolean hasNonLinearSegments() {
        return this.m_impl.hasNonLinearSegments();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getSegmentCount() {
        return this.m_impl.getSegmentCount();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getSegmentCount(int pathIndex) {
        int segCount = this.getPathSize(pathIndex);
        if (!this.isClosedPath(pathIndex)) {
            --segCount;
        }
        return segCount;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void add(MultiPath src, boolean bReversePaths) {
        this.m_impl.add((MultiPathImpl)src._getImpl(), bReversePaths);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void addPath(MultiPath src, int srcPathIndex, boolean bForward) {
        this.m_impl.addPath((MultiPathImpl)src._getImpl(), srcPathIndex, bForward);
    }

    @HadoopSDKPublic
    public void addPath(Point2D[] points, int count, boolean bForward) {
        this.m_impl.addPath(points, count, bForward);
    }

    @HadoopSDKPublic
    public void addSegmentsFromPath(MultiPath src, int srcPathIndex, int srcSegmentFrom, int srcSegmentCount, boolean bStartNewPath) {
        this.m_impl.addSegmentsFromPath((MultiPathImpl)src._getImpl(), srcPathIndex, srcSegmentFrom, srcSegmentCount, bStartNewPath);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void addSegment(Segment segment, boolean bStartNewPath) {
        this.m_impl.addSegment(segment, bStartNewPath);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void reverseAllPaths() {
        this.m_impl.reverseAllPaths();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void reversePath(int pathIndex) {
        this.m_impl.reversePath(pathIndex);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void removePath(int pathIndex) {
        this.m_impl.removePath(pathIndex);
    }

    @HadoopSDKPublic
    public void insertPath(int pathIndex, MultiPath src, int srcPathIndex, boolean bForward) {
        this.m_impl.insertPath(pathIndex, (MultiPathImpl)src._getImpl(), srcPathIndex, bForward);
    }

    @HadoopSDKPublic
    public void insertPath(int pathIndex, Point2D[] points, int pointsOffset, int count, boolean bForward) {
        this.m_impl.insertPath(pathIndex, points, pointsOffset, count, bForward);
    }

    @HadoopSDKPublic
    public void insertPathFromMultiPoint(int path_index, MultiPoint pointSource, int points_offset, int count, boolean b_forward) {
        this.m_impl.insertPathFromMultiPoint(path_index, pointSource, points_offset, count, b_forward);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void insertPoints(int pathIndex, int beforePointIndex, MultiPath src, int srcPathIndex, int srcPointIndexFrom, int srcPointCount, boolean bForward) {
        this.m_impl.insertPoints(pathIndex, beforePointIndex, (MultiPathImpl)src._getImpl(), srcPathIndex, srcPointIndexFrom, srcPointCount, bForward);
    }

    @HadoopSDKPublic
    public void insertPoints(int pathIndex, int beforePointIndex, Point2D[] src, int srcPointIndexFrom, int srcPointCount, boolean bForward) {
        this.m_impl.insertPoints(pathIndex, beforePointIndex, src, srcPointIndexFrom, srcPointCount, bForward);
    }

    @HadoopSDKPublic
    public void insertPoint(int pathIndex, int beforePointIndex, Point2D pt) {
        this.m_impl.insertPoint(pathIndex, beforePointIndex, pt);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void insertPoint(int pathIndex, int beforePointIndex, Point pt) {
        this.m_impl.insertPoint(pathIndex, beforePointIndex, pt);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void removePoint(int pathIndex, int pointIndex) {
        this.m_impl.removePoint(pathIndex, pointIndex);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getPathCount() {
        return this.m_impl.getPathCount();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getPathSize(int pathIndex) {
        return this.m_impl.getPathSize(pathIndex);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getPathStart(int pathIndex) {
        return this.m_impl.getPathStart(pathIndex);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getPathEnd(int pathIndex) {
        return this.m_impl.getPathEnd(pathIndex);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int getPathIndexFromPointIndex(int pointIndex) {
        return this.m_impl.getPathIndexFromPointIndex(pointIndex);
    }

    @HadoopSDKPublic
    public void startPath(double x, double y) {
        this.m_impl.startPath(x, y);
    }

    @HadoopSDKPublic
    public void startPath(double x, double y, double z) {
        this.m_impl.startPath(x, y, z);
    }

    @HadoopSDKPublic
    public void startPath(Point2D point) {
        this.m_impl.startPath(point);
    }

    @HadoopSDKPublic
    public void startPath(Point3D point) {
        this.m_impl.startPath(point);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void startPath(Point point) {
        this.m_impl.startPath(point);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void lineTo(double x, double y) {
        this.m_impl.lineTo(x, y);
    }

    @HadoopSDKPublic
    public void lineTo(double x, double y, double z) {
        this.m_impl.lineTo(x, y, z);
    }

    @HadoopSDKPublic
    public void lineTo(Point2D endPoint) {
        this.m_impl.lineTo(endPoint);
    }

    @HadoopSDKPublic
    public void lineTo(Point3D endPoint) {
        this.m_impl.lineTo(endPoint);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void lineTo(Point endPoint) {
        this.m_impl.lineTo(endPoint);
    }

    void bezierTo(Point2D controlPoint1, Point2D controlPoint2, Point2D endPoint) {
        this.m_impl.bezierTo(controlPoint1, controlPoint2, endPoint);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void closePathWithLine() {
        this.m_impl.closePathWithLine();
    }

    void closePathWithBezier(Point2D controlPoint1, Point2D controlPoint2) {
        this.m_impl.closePathWithBezier(controlPoint1, controlPoint2);
    }

    void closePathWithArc() {
        throw new RuntimeException("not implemented");
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void closeAllPaths() {
        this.m_impl.closeAllPaths();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public boolean isClosedPath(int pathIndex) {
        return this.m_impl.isClosedPath(pathIndex);
    }

    @HadoopSDKPublic
    public boolean isClosedPathInXYPlane(int pathIndex) {
        return this.m_impl.isClosedPathInXYPlane(pathIndex);
    }

    @HadoopSDKPublic
    public boolean hasNonLinearSegments(int pathIndex) {
        return this.m_impl.hasNonLinearSegments(pathIndex);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void addEnvelope(Envelope2D envSrc, boolean bReverse) {
        this.m_impl.addEnvelope(envSrc, bReverse);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public void addEnvelope(Envelope envSrc, boolean bReverse) {
        this.m_impl.addEnvelope(envSrc, bReverse);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public SegmentIterator querySegmentIterator() {
        return new SegmentIterator(this.m_impl.querySegmentIterator());
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public SegmentIterator querySegmentIteratorAtVertex(int startVertexIndex) {
        return new SegmentIterator(this.m_impl.querySegmentIteratorAtVertex(startVertexIndex));
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void setEmpty() {
        this.m_impl.setEmpty();
    }

    @Override
    @AndroidSDKPublic
    @HadoopSDKPublic
    public void applyTransformation(Transformation2D transform) {
        this.m_impl.applyTransformation(transform);
    }

    @Override
    @HadoopSDKPublic
    public void applyTransformation(Transformation3D transform) {
        this.m_impl.applyTransformation(transform);
    }

    @Override
    protected Object _getImpl() {
        return this.m_impl;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public int hashCode() {
        return this.m_impl.hashCode();
    }

    @Override
    @HadoopSDKPublic
    public void getPointByVal(int index, Point outPoint) {
        this.m_impl.getPointByVal(index, outPoint);
    }

    @Override
    @HadoopSDKPublic
    public void setPointByVal(int index, Point point) {
        this.m_impl.setPointByVal(index, point);
    }

    @Override
    @HadoopSDKPublic
    public void replaceNaNs(int semantics, double value) {
        this.m_impl.replaceNaNs(semantics, value);
    }

    @Override
    @HadoopSDKPublic
    public void reserve(int capacity) {
        this.m_impl.reserve(capacity);
    }

    @HadoopSDKPublic
    public void reserve(int vertices, int paths) {
        this.m_impl.reserve(vertices, paths);
    }

    @Override
    @HadoopSDKPublic
    public AttributeStreamBase getAttributeStreamRef(int semantics) {
        return this.m_impl.getAttributeStreamRef(semantics);
    }

    @HadoopSDKPublic
    public int queryPointAlongPath(int ipath, double distance, Point ptOut) {
        return this.m_impl.queryPointAlongPath(ipath, distance, ptOut);
    }

    @Override
    public void notifyModified() {
        this.m_impl.notifyModified();
    }
}

