/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.VertexDescription;

final class MathUtils {
    MathUtils() {
    }

    static double copySign(double x, double y) {
        return y >= 0.0 ? Math.abs(x) : -Math.abs(x);
    }

    static int sign(double value) {
        return value < 0.0 ? -1 : (value > 0.0 ? 1 : 0);
    }

    static double truncate(double v) {
        if (v >= 0.0) {
            return Math.floor(v);
        }
        return -Math.floor(-v);
    }

    static double FMod(double x, double y) {
        return x - MathUtils.truncate(x / y) * y;
    }

    @HadoopSDKExcluded
    static double dilogarithm(double z) {
        double rtnval;
        double PISQ6 = 1.6449340668482264;
        if (z == 1.0) {
            rtnval = PISQ6;
        } else if (z > 1.0) {
            assert (false);
            rtnval = PISQ6;
        } else if (z == 0.0) {
            rtnval = z;
        } else if (z < 0.0) {
            z = Math.abs(z);
            double t = 1.0 + z;
            double lnT = Math.log(t);
            rtnval = lnT * lnT / -2.0 - MathUtils.dilogarithm(z / t);
        } else if (z > 0.5) {
            double t = 1.0 - z;
            double lnzLnT = Math.log(z) * Math.log(t);
            rtnval = PISQ6 - MathUtils.dilogarithm(t) - lnzLnT;
        } else {
            rtnval = 0.0;
            int numTerms = 1 + (int)(-16.0 * Math.log(10.0) / Math.log(z) + 1.5);
            double d = numTerms;
            int i = numTerms;
            while (i > 0) {
                rtnval *= z;
                rtnval += 1.0 / (d * d);
                --i;
                d -= 1.0;
            }
            rtnval *= z;
        }
        return rtnval;
    }

    @HadoopSDKExcluded
    static double dilogarithmEzOverE(double z, double e) {
        double answer = 0.0;
        int upperLimit = 60;
        if (Math.abs(e) < 0.1) {
            for (int i = upperLimit; i >= 1; --i) {
                answer *= e * z;
                answer += 1.0 / (double)i / (double)i;
            }
            return answer *= z;
        }
        return MathUtils.dilogarithm(e * z) / e;
    }

    @HadoopSDKExcluded
    static double atanhUOverU(double u) {
        double rtnval;
        if (u == 0.0) {
            rtnval = 1.0;
        } else if (Math.abs(u) > 0.25) {
            rtnval = 0.5 * Math.log((1.0 + u) / (1.0 - u)) / u;
        } else {
            double baseNumber = -36.841361487904734;
            rtnval = 0.0;
            double u2 = u * u;
            int numTerms = (int)(baseNumber / Math.log(u2) + 2.5);
            for (int i = numTerms - 1; i > 0; --i) {
                double frac = 1.0 / (double)(2 * i + 1);
                rtnval = (rtnval + frac) * u2;
            }
            rtnval += 1.0;
        }
        return rtnval;
    }

    static double round(double v) {
        return Math.floor(v + 0.5);
    }

    static double sqr(double v) {
        return v * v;
    }

    static double lerp(double start_, double end_, double t) {
        double v = t <= 0.5 ? start_ + (end_ - start_) * t : end_ - (end_ - start_) * (1.0 - t);
        assert (t < 0.0 || t > 1.0 || v >= start_ && v <= end_ || v <= start_ && v >= end_ || NumberUtils.isNaN(start_) || NumberUtils.isNaN(end_));
        return v;
    }

    static void lerp(Point2D start_, Point2D end_, double t, Point2D result) {
        double ry;
        double rx;
        assert (start_ != result);
        if (t <= 0.5) {
            rx = start_.x + (end_.x - start_.x) * t;
            ry = start_.y + (end_.y - start_.y) * t;
        } else {
            rx = end_.x - (end_.x - start_.x) * (1.0 - t);
            ry = end_.y - (end_.y - start_.y) * (1.0 - t);
        }
        assert (t < 0.0 || t > 1.0 || rx >= start_.x && rx <= end_.x || rx <= start_.x && rx >= end_.x);
        assert (t < 0.0 || t > 1.0 || ry >= start_.y && ry <= end_.y || ry <= start_.y && ry >= end_.y);
        result.x = rx;
        result.y = ry;
    }

    static void lerp(double start_x, double start_y, double end_x, double end_y, double t, Point2D result) {
        if (t <= 0.5) {
            result.x = start_x + (end_x - start_x) * t;
            result.y = start_y + (end_y - start_y) * t;
        } else {
            result.x = end_x - (end_x - start_x) * (1.0 - t);
            result.y = end_y - (end_y - start_y) * (1.0 - t);
        }
        assert (t < 0.0 || t > 1.0 || result.x >= start_x && result.x <= end_x || result.x <= start_x && result.x >= end_x);
        assert (t < 0.0 || t > 1.0 || result.y >= start_y && result.y <= end_y || result.y <= start_y && result.y >= end_y);
    }

    private static void _cpy(double[] src, double[] dst, int c) {
        dst[0] = src[0];
        for (int i = 1; i < c; ++i) {
            dst[i] = src[i];
        }
    }

    static double interpolate(int semantics, int interpolation, double from, double to, double t) {
        if (interpolation == 0) {
            return t == 0.0 ? from : (t == 1.0 ? to : VertexDescription.getDefaultValue(semantics));
        }
        if (interpolation == 1) {
            if (t == 0.0) {
                return from;
            }
            if (t == 1.0) {
                return to;
            }
            return MathUtils.lerp(from, to, t);
        }
        if (interpolation == 2) {
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    static void interpolate(int semantics, int interpolation, double[] from, double[] to, double t, double[] result, int ncomps) {
        if (interpolation == 0) {
            for (int i = 0; i < ncomps; ++i) {
                result[i] = t == 0.0 ? from[i] : (t == 1.0 ? to[i] : VertexDescription.getDefaultValue(semantics));
            }
        } else if (interpolation == 1) {
            if (t == 0.0) {
                MathUtils._cpy(result, from, ncomps);
            } else if (t == 1.0) {
                MathUtils._cpy(result, to, ncomps);
            } else {
                for (int i = 0; i < ncomps; ++i) {
                    result[i] = MathUtils.lerp(from[i], to[i], t);
                }
            }
        } else if (interpolation == 2) {
            if (t == 0.0) {
                MathUtils._cpy(result, from, ncomps);
            } else if (t == 1.0) {
                MathUtils._cpy(result, to, ncomps);
            } else {
                int i;
                double len = 0.0;
                for (i = 0; i < ncomps; ++i) {
                    result[i] = MathUtils.lerp(from[i], to[i], t);
                    len += result[i] * result[i];
                }
                if (len > 0.0) {
                    len = Math.sqrt(len);
                    i = 0;
                    while (i < ncomps) {
                        int n = i++;
                        result[n] = result[n] / len;
                    }
                } else {
                    for (i = 0; i < ncomps; ++i) {
                        result[i] = 0.0;
                    }
                    result[0] = 1.0;
                }
            }
        } else {
            throw new GeometryException("not implemented");
        }
    }

    static final class KahanSummator {
        private double sum;
        private double compensation;
        private double startValue;

        KahanSummator(double startValue_) {
            this.startValue = startValue_;
            this.reset();
        }

        void reset() {
            this.sum = 0.0;
            this.compensation = 0.0;
        }

        void add(double v) {
            double y = v - this.compensation;
            double t = this.sum + y;
            double h = t - this.sum;
            this.compensation = h - y;
            this.sum = t;
        }

        void sub(double v) {
            this.add(-v);
        }

        void add(KahanSummator v) {
            double y = v.getResult() + v.compensation - this.compensation;
            double t = this.sum + y;
            double h = t - this.sum;
            this.compensation = h - y;
            this.sum = t;
        }

        void sub(KahanSummator v) {
            double y = -(v.getResult() - v.compensation) - this.compensation;
            double t = this.sum + y;
            double h = t - this.sum;
            this.compensation = h - y;
            this.sum = t;
        }

        double getResult() {
            return this.startValue + this.sum;
        }

        KahanSummator plusEquals(double v) {
            this.add(v);
            return this;
        }

        KahanSummator minusEquals(double v) {
            this.add(-v);
            return this;
        }

        KahanSummator plusEquals(KahanSummator v) {
            this.add(v);
            return this;
        }

        KahanSummator minusEquals(KahanSummator v) {
            this.sub(v);
            return this;
        }
    }
}

