/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCollection;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.SegmentIterator;
import com.esri.core.geometry.VertexDescription;

@HadoopSDKExcluded
final class LocateBetween {
    private Envelope1D m_interval;
    private ProgressTracker m_progress_tracker;
    private int m_semantics;
    private int m_ord;

    public static Geometry execute(Geometry input_geom, int semantics, int ord, Envelope1D interval, ProgressTracker progress_tracker) {
        LocateBetween locate = new LocateBetween(semantics, ord, interval, progress_tracker);
        return locate.processGeometry(input_geom);
    }

    private Geometry processGeometry(Geometry geom) {
        ProgressTracker.checkAndThrow(this.m_progress_tracker);
        int gt = geom.getGeometryType();
        if (gt == 3594) {
            return this.processGeometryCollection((GeometryCollection)geom);
        }
        InternalUtils.require(!Geometry.isArea(gt), "LocateBetween does not support Polygons and Envelopes.");
        if (geom.isEmpty() || !geom.hasAttribute(this.m_semantics)) {
            return new Point(geom.getDescription());
        }
        if (Geometry.isSegment(gt)) {
            return this.process_segment((Segment)geom);
        }
        switch (gt) {
            case 33: {
                return this.process_point((Point)geom);
            }
            case 550: {
                return this.process_multi_point((MultiPoint)geom);
            }
            case 1607: {
                return this.process_polyline((Polyline)geom);
            }
        }
        throw GeometryException.GeometryInternalError();
    }

    private Geometry process_polyline(Polyline geom) {
        assert (!geom.isEmpty() && geom.hasAttribute(this.m_semantics));
        Envelope1D geom_int = geom.queryInterval(this.m_semantics, this.m_ord);
        if (this.m_interval.contains(geom_int)) {
            return geom;
        }
        if (!this.m_interval.isIntersecting(geom_int)) {
            return new Point(geom.getDescription());
        }
        MultiPoint res_mp = null;
        MultiPath res_polyline = null;
        SegmentIterator seg_iter = geom.querySegmentIterator();
        SegmentBuffer seg_buf = new SegmentBuffer();
        Point pt_out = new Point();
        Point pt_dummy = new Point();
        Point pt_dummy1 = new Point();
        HelperResult seg_res = new HelperResult();
        boolean start_new_path = true;
        boolean prev_equals_end = false;
        while (seg_iter.nextPath()) {
            start_new_path = true;
            prev_equals_end = false;
            while (seg_iter.hasNextSegment()) {
                Segment seg = seg_iter.nextSegment();
                seg_res.seg_out = null;
                int gt = this.process_segment_helper(seg, seg_buf, seg_res, pt_out);
                Segment res_seg_ptr = seg_res.seg_out;
                if (gt == 0) {
                    start_new_path = true;
                    prev_equals_end = false;
                    continue;
                }
                if (gt == 33) {
                    if (!start_new_path) {
                        assert (res_polyline != null);
                        res_polyline.getPointByVal(res_polyline.getPointCount() - 1, pt_dummy);
                        if (pt_dummy.equals(pt_out)) continue;
                    }
                    start_new_path = true;
                    if (prev_equals_end) {
                        seg.queryStart(pt_dummy);
                        if (pt_out.equals(pt_dummy)) continue;
                    }
                    seg.queryEnd(pt_dummy);
                    prev_equals_end = pt_out.equals(pt_dummy);
                    if (res_mp == null) {
                        res_mp = new MultiPoint(pt_out);
                        continue;
                    }
                    res_mp.add(pt_out);
                    continue;
                }
                if (gt != 322) continue;
                prev_equals_end = false;
                if (res_polyline == null) {
                    res_polyline = new Polyline();
                }
                if (start_new_path && res_mp != null && !res_mp.isEmpty()) {
                    res_mp.getPointByVal(res_mp.getPointCount() - 1, pt_dummy);
                    res_seg_ptr.queryStart(pt_out);
                    if (pt_dummy.equals(pt_out)) {
                        res_mp.removePoint(res_mp.getPointCount() - 1);
                    }
                }
                ((Polyline)res_polyline).addSegment(res_seg_ptr, start_new_path);
                seg.queryEnd(pt_dummy);
                res_seg_ptr.queryEnd(pt_dummy1);
                if (pt_dummy.equals(pt_dummy1)) {
                    start_new_path = false;
                    continue;
                }
                start_new_path = true;
            }
        }
        if (res_mp != null && res_mp.isEmpty()) {
            res_mp = null;
        }
        if (res_mp != null && res_polyline != null) {
            GeometryCollection gc = new GeometryCollection();
            gc.addGeometry(res_polyline);
            gc.addGeometry(res_mp);
            return gc;
        }
        if (res_mp != null) {
            return res_mp;
        }
        if (res_polyline != null) {
            return res_polyline;
        }
        return new Point(geom.getDescription());
    }

    int process_segment_helper(Segment seg_in, SegmentBuffer buffer_out, HelperResult segment_out, Point pt_out) {
        double start_m = seg_in.getAttributeAsDbl(0.0, this.m_semantics, this.m_ord);
        double end_m = seg_in.getAttributeAsDbl(1.0, this.m_semantics, this.m_ord);
        double seg_start_m = NumberUtils.isNaN(start_m) ? end_m : start_m;
        double seg_end_m = NumberUtils.isNaN(end_m) ? start_m : end_m;
        Envelope1D seg_e = new Envelope1D();
        seg_e.setCoords(seg_start_m, seg_end_m);
        Envelope1D e = new Envelope1D(seg_e);
        e.intersect(this.m_interval);
        if (e.isEmpty()) {
            return 0;
        }
        if (seg_e.equals(e)) {
            segment_out.seg_out = seg_in;
            return 322;
        }
        double w = seg_end_m - seg_start_m;
        assert (w != 0.0);
        double len = seg_in.calculateLength2D();
        if (e.getWidth() == 0.0) {
            double t1 = (e.vmin - seg_start_m) / w;
            double t = t1 == 1.0 ? 1.0 : seg_in.lengthToT(t1 * len);
            seg_in.queryCoord(t, pt_out);
            return 33;
        }
        double t1 = (e.vmin - seg_start_m) / w;
        double t2 = (e.vmax - seg_start_m) / w;
        if (t1 > t2) {
            double tmp = t1;
            t1 = t2;
            t2 = tmp;
        }
        t1 = t1 == 1.0 ? 1.0 : seg_in.lengthToT(t1 * len);
        t2 = t2 == 1.0 ? 1.0 : seg_in.lengthToT(t2 * len);
        seg_in.cut(t1, t2, buffer_out);
        segment_out.seg_out = buffer_out.get();
        return 322;
    }

    private Geometry process_multi_point(MultiPoint geom) {
        assert (!geom.isEmpty() && geom.hasAttribute(this.m_semantics));
        MultiPoint res = null;
        int i0 = -1;
        AttributeStreamBase ms = geom.getAttributeStreamRef(this.m_semantics);
        int comp = VertexDescription.getComponentCount(this.m_semantics);
        int i = 0;
        int index = 0;
        int n = geom.getPointCount();
        while (i < n) {
            double m = ms.readAsDbl(index);
            if (!this.m_interval.contains(m)) {
                if (i0 >= 0) {
                    if (res == null) {
                        res = new MultiPoint(geom.getDescription());
                    }
                    res.add(geom, i0, i);
                    i0 = -1;
                }
            } else if (i0 == -1) {
                i0 = i;
            }
            ++i;
            index += comp;
        }
        if (i0 >= 0) {
            if (res == null) {
                res = new MultiPoint(geom.getDescription());
            }
            res.add(geom, i0, -1);
        }
        if (res == null) {
            return new Point(geom.getDescription());
        }
        return res;
    }

    private Geometry process_point(Point geom) {
        assert (!geom.isEmpty() && geom.hasAttribute(this.m_semantics));
        double m = geom.getAttributeAsDbl(this.m_semantics, this.m_ord);
        if (!this.m_interval.contains(m)) {
            return new Point(geom.getDescription());
        }
        return new MultiPoint(geom);
    }

    private Geometry process_segment(Segment geom) {
        assert (!geom.isEmpty() && geom.hasAttribute(this.m_semantics));
        double start_m = geom.getAttributeAsDbl(0.0, this.m_semantics, this.m_ord);
        double end_m = geom.getAttributeAsDbl(1.0, this.m_semantics, this.m_ord);
        double seg_start_m = NumberUtils.isNaN(start_m) ? end_m : start_m;
        double seg_end_m = NumberUtils.isNaN(end_m) ? start_m : end_m;
        Envelope1D seg_e = new Envelope1D();
        seg_e.setCoords(seg_start_m, seg_end_m);
        Envelope1D e = new Envelope1D(seg_e);
        e.intersect(this.m_interval);
        if (e.isEmpty()) {
            return new Point(geom.getDescription());
        }
        if (seg_e.equals(e)) {
            return geom;
        }
        double w = seg_end_m - seg_start_m;
        assert (w != 0.0);
        double len = geom.calculateLength2D();
        if (e.getWidth() == 0.0) {
            Point pt = new Point(geom.getDescription());
            double t1 = (e.vmin - seg_start_m) / w;
            double t = geom.lengthToT(t1 * len);
            geom.queryCoord(t, pt);
            return pt;
        }
        double t1 = (e.vmin - seg_start_m) / w;
        double t2 = (e.vmax - seg_start_m) / w;
        if (t1 > t2) {
            double tmp = t1;
            t1 = t2;
            t2 = tmp;
        }
        t1 = geom.lengthToT(t1 * len);
        t2 = geom.lengthToT(t2 * len);
        return geom.cut(t1, t2);
    }

    private Geometry processGeometryCollection(GeometryCollection geom) {
        if (geom.isEmpty() || !geom.hasAttribute(this.m_semantics)) {
            return new Point(geom.getDescription());
        }
        GeometryCursor cursor = GeometryCollection.generateGeometryCursor(geom, -1);
        GeometryCollection result_gc = new GeometryCollection();
        Geometry g = cursor.next();
        while (g != null) {
            Geometry res = this.processGeometry(g);
            assert (res != null);
            if (!res.isEmpty()) {
                result_gc.addGeometry(res);
            }
            g = cursor.next();
        }
        if (result_gc.isEmpty()) {
            return new Point(geom.getDescription());
        }
        return result_gc;
    }

    private LocateBetween(int semantics, int ord, Envelope1D interval, ProgressTracker progress_tracker) {
        this.m_interval = interval;
        this.m_progress_tracker = progress_tracker;
        this.m_semantics = semantics;
        this.m_ord = ord;
        InternalUtils.require(VertexDescription.getComponentCount(semantics) > ord && ord >= 0, "LocateBetween: ordinate");
        InternalUtils.require(VertexDescription.getInterpolation(semantics) != 2, "LocateBetween: angular interpolation");
    }

    private static class HelperResult {
        Segment seg_out = null;

        private HelperResult() {
        }
    }
}

