/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.LinearUnit;
import com.esri.core.geometry.PeInitializer;
import com.esri.core.geometry.Unit;
import com.esri.sde.sdk.pe.engine.PeLinunit;
import com.esri.sde.sdk.pe.engine.PeObject;
import com.esri.sde.sdk.pe.engine.PeUnit;
import com.esri.sde.sdk.pe.factory.PeFactory;

@HadoopSDKExcluded
class LinearUnitImpl
extends LinearUnit {
    private PeLinunit m_peUnit;
    private int m_wkid;

    LinearUnitImpl(PeLinunit peUnit) {
        if (peUnit != null) {
            this.m_peUnit = (PeLinunit)peUnit.clone();
            this.m_factor = this.getPEUnit().getUnitFactor();
            this.m_wkid = PeFactory.getCode((PeObject)this.getPEUnit());
            if (this.m_wkid < 0) {
                this.m_wkid = 0;
            }
        } else {
            this.m_peUnit = null;
            this.m_factor = 1.0;
            this.m_wkid = 9001;
        }
    }

    @Override
    public String getName() {
        return this.getPEUnit().getName();
    }

    @Override
    public String getDisplayName() {
        return this.getPEUnit().getDisplay();
    }

    @Override
    public String getPluralDisplayName() {
        return this.getPEUnit().getPlural();
    }

    @Override
    public String getAbbreviation() {
        return this.getPEUnit().getAbbr();
    }

    @Override
    public int getID() {
        return this.m_wkid;
    }

    public PeUnit getPEUnit() {
        return this.m_peUnit != null ? this.m_peUnit : this._getMeters();
    }

    @Override
    public double getConversionFactor(Unit dstUnit) {
        if (dstUnit.getUnitType() != Unit.UnitType.Linear) {
            throw new GeometryException("invalid_call");
        }
        return this.getUnitToBaseFactor() / dstUnit.getUnitToBaseFactor();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LinearUnitImpl)) {
            return false;
        }
        LinearUnitImpl impl = (LinearUnitImpl)other;
        return impl.getPEUnit().isEqual(this.getPEUnit());
    }

    public String toString() {
        String snippet = this.getPEUnit().toString();
        if (snippet.length() > 200) {
            return snippet.substring(0, 197) + "... (" + snippet.length() + " characters)";
        }
        return snippet;
    }

    private PeUnit _getMeters() {
        return PeInitializer.meter;
    }
}

