/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.ExternalTransform;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorClip;
import com.esri.core.geometry.OperatorDensifyByLength;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.ProjectionTransformationImpl;
import com.esri.core.geometry.ProjectionUtils;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.SpatialReferencePrecisionDescriptor;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.sde.sdk.pe.engine.PePCSInfo;

@HadoopSDKExcluded
class LegacyProject {
    private final ProjectionTransformationImpl m_projTransform;
    private final ProjectionUtils.HorizonClipOption m_inputPCSHorizonClipOption;
    private final ProjectionUtils.HorizonClipOption m_outputPCSHorizonClipOption;
    private final boolean m_b_dont_hack_poles_in_geog_to_geog;
    private final double m_centralMeridianOfOutputGCS;
    private final double m_densificationStepInput;
    private final boolean m_b_dontGeonormalizePolygon;

    public LegacyProject(ProjectionTransformation projTransform) {
        if (projTransform == null) {
            throw new GeometryException("Invalid arguement");
        }
        this.m_projTransform = (ProjectionTransformationImpl)projTransform;
        ProjectionTransformation.ExtendedParams exParam = projTransform.getExtendedParams();
        this.m_inputPCSHorizonClipOption = !exParam.hasClipWithInputHorizon() ? ProjectionUtils.HorizonClipOption.DontClip : (((SpatialReferenceImpl)projTransform.getInputSR()).isPannableBase() ? ProjectionUtils.HorizonClipOption.PannableFold : ProjectionUtils.HorizonClipOption.Clip);
        this.m_outputPCSHorizonClipOption = !exParam.hasClipWithOutputHorizon() ? ProjectionUtils.HorizonClipOption.DontClip : (((SpatialReferenceImpl)projTransform.getOutputSR()).isPannableBase() ? ProjectionUtils.HorizonClipOption.PannableFold : ProjectionUtils.HorizonClipOption.Clip);
        this.m_centralMeridianOfOutputGCS = exParam.centralMeridianOfOutputGCS;
        this.m_densificationStepInput = exParam.densificationStep;
        ProjectionTransformationImpl.ExtendedParamsInternal exParamInternal = this.m_projTransform.getExtendedParamsInternal();
        this.m_b_dontGeonormalizePolygon = exParamInternal.hasFlag(ProjectionTransformationImpl.ExtendedParamsInternal.FlagsInternal.Dont_Geonomalize_Polygon.getValue());
        this.m_b_dont_hack_poles_in_geog_to_geog = exParamInternal.hasFlag(ProjectionTransformationImpl.ExtendedParamsInternal.FlagsInternal.Dont_Adjust_At_Poles.getValue());
    }

    public static Geometry project(Geometry geom, ProjectionTransformation projTransform, ProgressTracker progressTracker) {
        return ((ProjectionTransformationImpl)projTransform).getProjector().project(geom, progressTracker);
    }

    public static int transformInPlace(ProjectionTransformation projTransform, Point2D[] input_points, int count, Point2D[] output_points) {
        return ((ProjectionTransformationImpl)projTransform).getProjector().transformInPlace(input_points, count, output_points);
    }

    public static int transform(ProjectionTransformation projTransform, Point2D[] input_points, int count_, Point2D[] output_points) {
        int count = count_ < 0 ? input_points.length : count_;
        int res = ((ProjectionTransformationImpl)projTransform).getProjector().transformInPlace(input_points, count, output_points);
        if (res == count) {
            return res;
        }
        int j = 0;
        int n = count;
        for (int i = 0; i < n; ++i) {
            Point2D pt = output_points[i];
            if (pt.isNaN()) continue;
            if (j < i) {
                output_points[j].setCoords(pt);
            }
            ++j;
        }
        while (j < count) {
            output_points[j].setNaN();
            ++j;
        }
        return res;
    }

    public static int transformInPlace(ProjectionTransformation projTransform, Point3D[] input_points, int count, Point3D[] output_points) {
        return ((ProjectionTransformationImpl)projTransform).getProjector().transformInPlace(input_points, count, output_points);
    }

    public static int transform(ProjectionTransformation projTransform, Point3D[] input_points, int count_, Point3D[] output_points) {
        int count = count_ < 0 ? input_points.length : count_;
        int res = ((ProjectionTransformationImpl)projTransform).getProjector().transformInPlace(input_points, count, output_points);
        if (res == count) {
            return res;
        }
        int j = 0;
        int n = count;
        for (int i = 0; i < n; ++i) {
            Point3D pt = output_points[i];
            if (Double.isNaN(pt.x)) continue;
            if (j < i) {
                output_points[j].setCoords(pt);
            }
            ++j;
        }
        while (j < count) {
            output_points[j].setNaN();
            ++j;
        }
        return res;
    }

    public static int transform(ProjectionTransformation transform, Point[] pointsIn, int count, Point[] pointsOut, boolean removeClippedOut) {
        if (transform.isIdentity()) {
            InternalUtils.copyPointArray(pointsOut, pointsIn, count);
            return count;
        }
        Point2D[] points2D = new Point2D[Math.min(count, 64)];
        int resultCount = 0;
        int i = 0;
        int n = count;
        int dstIndex = 0;
        while (i < n) {
            int batch = Math.min(points2D.length, count - i);
            int j = i;
            int r = 0;
            while (j < batch) {
                if (points2D[r] == null) {
                    points2D[r] = pointsIn[j].getXY();
                } else {
                    pointsIn[j].getXY(points2D[r]);
                }
                ++j;
                ++r;
            }
            int res = 0;
            res = removeClippedOut ? LegacyProject.transform(transform, points2D, batch, points2D) : LegacyProject.transformInPlace(transform, points2D, batch, points2D);
            int j2 = dstIndex;
            int r2 = 0;
            while (j2 < res) {
                if (pointsOut[i] == null) {
                    pointsOut[i] = new Point(pointsIn[i]);
                }
                pointsOut[i].setXY(points2D[r2]);
                ++j2;
                ++r2;
            }
            i += batch;
            resultCount += res;
        }
        return resultCount;
    }

    public static double[] transform(ProjectionTransformation transform, double[] coordsSrc, int pointCount) {
        if (pointCount == 0) {
            return new double[0];
        }
        MultiPoint mp = new MultiPoint();
        mp.addPoints(coordsSrc, 0, 2 * pointCount);
        MultiPoint mpResult = (MultiPoint)LegacyProject.project(mp, transform, null);
        MultiPointImpl mpimplResult = (MultiPointImpl)mpResult._getImpl();
        AttributeStreamOfDbl xyResult = (AttributeStreamOfDbl)mpimplResult.getAttributeStreamRef(0);
        int resLen = mpResult.getPointCount() * 2;
        double[] result = new double[resLen];
        xyResult.readRange(0, resLen, result, 0, true);
        return result;
    }

    protected int transformInPlace(Point2D[] points_in, int count, Point2D[] points_out) {
        boolean outIsPCS;
        Envelope2D env;
        if (this.m_projTransform.isIdentity()) {
            if (points_in != points_out) {
                InternalUtils.copyPoint2DArray(points_out, points_in, count);
            }
            return count;
        }
        SpatialReferenceImpl inSR = (SpatialReferenceImpl)this.m_projTransform.getInputSR();
        SpatialReferenceImpl outSR = (SpatialReferenceImpl)this.m_projTransform.getOutputSR();
        SpatialReference.Type srTypeIn = inSR.getCoordinateSystemType();
        SpatialReference.Type srTypeOut = outSR.getCoordinateSystemType();
        if (srTypeIn == SpatialReference.Type.Local && srTypeIn == srTypeOut) {
            double factorIn = inSR.getHorzUnitFactor();
            double factorOut = outSR.getHorzUnitFactor();
            double coef = factorIn / factorOut;
            Transformation2D trans = new Transformation2D();
            trans.setScale(coef, coef);
            trans.transform(points_in, count, points_out);
            return count;
        }
        double[][] bufferOfPeCoord = new double[Math.min(count, 64)][2];
        if (srTypeIn == SpatialReference.Type.Image) {
            ExternalTransform in_external_xform = inSR.m_external_xform;
            inSR = (SpatialReferenceImpl)in_external_xform.getBaseSpatialReference();
            srTypeIn = inSR.getCoordinateSystemType();
            if (points_out != points_in) {
                InternalUtils.copyPoint2DArray(points_out, points_in, count);
            }
            ProjectionUtils.clipImage(in_external_xform, points_out, count, true);
            in_external_xform.transform(ExternalTransform.TransformDirection.forward, points_out, count);
            ProjectionUtils.clipBase(in_external_xform, points_out, count, true);
        }
        if (srTypeIn == SpatialReference.Type.Image || srTypeOut == SpatialReference.Type.Image) {
            throw new GeometryException("image: transform_in_place_");
        }
        if (srTypeIn == SpatialReference.Type.Projected) {
            if (this.m_inputPCSHorizonClipOption == ProjectionUtils.HorizonClipOption.Clip) {
                if (points_out != points_in) {
                    InternalUtils.copyPoint2DArray(points_out, points_in, count);
                }
                Geometry pcsHorz = inSR.getPCSHorizon();
                ProjectionUtils.intersectArrayWithPolygonOrEnv(pcsHorz, inSR, points_out, count);
            } else {
                if (points_out != points_in) {
                    InternalUtils.copyPoint2DArray(points_out, points_in, count);
                }
                if (inSR.isPannable()) {
                    double tol = inSR.getTolerance(0);
                    env = inSR.getPannableExtentByReferenceInternal();
                    ProjectionUtils.snapToHorizonEnvelopeAndClip(points_out, count, env, tol);
                    ProjectionUtils.foldInto360DegreeRange(points_out, count, inSR, 0.0);
                }
            }
            ProjectionUtils.PEprojToGeogCenter(inSR, 0.0, points_out, count, bufferOfPeCoord);
        } else {
            double tol = inSR.getTolerance(0);
            env = inSR.getPannableExtentByReferenceInternal();
            for (int i = 0; i < count; ++i) {
                ProjectionUtils.snapToHorizonEnvelope(points_in[i], env, tol, points_out[i]);
            }
        }
        ProjectionUtils.PEgeogToGeog(this.m_projTransform, points_out, count, false, bufferOfPeCoord);
        boolean applyOutExternalTransform = false;
        ExternalTransform out_external_xform = null;
        if (srTypeOut == SpatialReference.Type.Image) {
            applyOutExternalTransform = true;
            out_external_xform = outSR.m_external_xform;
            outSR = (SpatialReferenceImpl)out_external_xform.getBaseSpatialReference();
            srTypeOut = outSR.getCoordinateSystemType();
        }
        double centralLong2InGCS2Units = 0.0;
        boolean bl = outIsPCS = srTypeOut == SpatialReference.Type.Projected;
        if (outIsPCS) {
            centralLong2InGCS2Units = outSR.getAdjustedCentralMeridian();
        } else if (!NumberUtils.isNaN(this.m_centralMeridianOfOutputGCS)) {
            centralLong2InGCS2Units = this.m_centralMeridianOfOutputGCS;
        }
        if (!outIsPCS || this.m_outputPCSHorizonClipOption == ProjectionUtils.HorizonClipOption.Clip) {
            ProjectionUtils.foldInto360DegreeRange(points_out, count, (SpatialReferenceImpl)outSR.getGCS(), centralLong2InGCS2Units);
        }
        if (outIsPCS) {
            ProjectionUtils.intersectWithGCSHorizon(points_out, count, outSR, this.m_outputPCSHorizonClipOption);
            ProjectionUtils.PEgeogToProj(outSR, points_out, count, bufferOfPeCoord);
        }
        if (applyOutExternalTransform) {
            ProjectionUtils.clipBase(out_external_xform, points_out, count, false);
            out_external_xform.transform(ExternalTransform.TransformDirection.reverse, points_out, count);
            ProjectionUtils.clipImage(out_external_xform, points_out, count, false);
        }
        int result_count = count;
        for (int i = 0; i < count; ++i) {
            if (!points_out[i].isNaN()) continue;
            --result_count;
        }
        return result_count;
    }

    protected int transformInPlace(Point3D[] pointsIn, int count_, Point3D[] pointsOut) {
        int count;
        int n = count = count_ < 0 ? pointsIn.length : count_;
        if (this.m_projTransform.isIdentity()) {
            for (int i = 0; i < count; ++i) {
                if (pointsOut[i] == null) {
                    pointsOut[i] = new Point3D(pointsIn[i]);
                    continue;
                }
                pointsOut[i].setCoords(pointsIn[i]);
            }
            return count;
        }
        SpatialReferenceImpl inSR = (SpatialReferenceImpl)this.m_projTransform.getInputSR();
        SpatialReferenceImpl outSR = (SpatialReferenceImpl)this.m_projTransform.getOutputSR();
        SpatialReference.Type srTypeIn = inSR.getCoordinateSystemType();
        SpatialReference.Type srTypeOut = outSR.getCoordinateSystemType();
        if (srTypeIn == SpatialReference.Type.Local && srTypeIn == srTypeOut) {
            double factorIn = inSR.getHorzUnitFactor();
            double factorOut = outSR.getHorzUnitFactor();
            double coef = factorIn / factorOut;
            Transformation3D trans = new Transformation3D();
            trans.setScale(coef, coef, coef);
            trans.transform(pointsIn, count, pointsOut);
            return count;
        }
        MultiPoint mp = new MultiPoint();
        mp.addAttribute(1);
        mp.addAttribute(3);
        mp.addPoints(pointsIn, count, 0, -1);
        AttributeStreamOfInt32 ids = (AttributeStreamOfInt32)mp.getAttributeStreamRef(3);
        int n2 = count;
        for (int i = 0; i < n2; ++i) {
            ids.write(i, i);
        }
        MultiPoint mpResult = (MultiPoint)this.project(mp, null);
        for (int i = 0; i < count; ++i) {
            if (pointsOut[i] == null) {
                pointsOut[i] = Point3D.construct(Double.NaN, Double.NaN, Double.NaN);
                continue;
            }
            pointsOut[i].setNaN();
        }
        if (mpResult == null) {
            return 0;
        }
        ids = (AttributeStreamOfInt32)mpResult.getAttributeStreamRef(3);
        AttributeStreamOfDbl xy = (AttributeStreamOfDbl)mpResult.getAttributeStreamRef(0);
        AttributeStreamOfDbl z = (AttributeStreamOfDbl)mpResult.getAttributeStreamRef(1);
        mpResult.queryCoordinates(pointsOut, count, 0, -1);
        int n3 = mpResult.getPointCount();
        for (int i = 0; i < n3; ++i) {
            int pos = ids.read(i);
            xy.read2D(2 * i, pointsOut[pos]);
            pointsOut[pos].z = z.read(i);
        }
        return mpResult.getPointCount();
    }

    protected Geometry project(Geometry geom, ProgressTracker progressTracker) {
        if (this.m_projTransform.isIdentity() || geom.isEmpty()) {
            return geom;
        }
        int geomType = geom.getType().value();
        if (geomType == 33) {
            return this.projectPoint((Point)geom, progressTracker);
        }
        SpatialReferenceImpl inSR = (SpatialReferenceImpl)this.m_projTransform.getInputSR();
        SpatialReferenceImpl outSR = (SpatialReferenceImpl)this.m_projTransform.getOutputSR();
        SpatialReference.Type srTypeIn = inSR.getCoordinateSystemType();
        SpatialReference.Type srTypeOut = outSR.getCoordinateSystemType();
        if (srTypeIn == SpatialReference.Type.Local && srTypeIn == srTypeOut) {
            double factorIn = inSR.getHorzUnitFactor();
            double factorOut = outSR.getHorzUnitFactor();
            double coef = factorIn / factorOut;
            Transformation2D trans = new Transformation2D();
            trans.setScale(coef, coef);
            Geometry fg = Geometry._clone(geom);
            fg.applyTransformation(trans);
            return fg;
        }
        Geometry dst = null;
        switch (geom.getType().value()) {
            case 1607: 
            case 1736: {
                dst = this.projectMultiPath((MultiPath)geom, progressTracker);
                break;
            }
            case 550: {
                dst = this.projectMultiPoint((MultiPoint)geom, progressTracker);
                break;
            }
            case 197: {
                dst = this.projectEnvelope((Envelope)geom, progressTracker);
                break;
            }
            default: {
                throw new GeometryException("");
            }
        }
        return dst;
    }

    private Geometry projectPoint(Point inputPoint, ProgressTracker progressTracker) {
        Point2D pt = inputPoint.getXY();
        Point2D[] pts = new Point2D[]{pt};
        this.transformInPlace(pts, 1, pts);
        Point result = new Point(inputPoint);
        result.setXY(pts[0]);
        return result;
    }

    private Geometry projectMultiPath(MultiPath inputMultiPath, ProgressTracker progressTracker) {
        if (inputMultiPath.hasNonLinearSegments()) {
            throw new GeometryException("curves not supported");
        }
        Geometry.Type geomType = inputMultiPath.getType();
        if (geomType == Geometry.Type.Polygon) {
            return this.projectPolygon((Polygon)inputMultiPath, progressTracker);
        }
        if (geomType == Geometry.Type.Polyline) {
            return this.projectPolyline((Polyline)inputMultiPath, progressTracker);
        }
        throw new GeometryException("projectMultiPath");
    }

    private Geometry projectPolygon(Polygon inputPolygon, ProgressTracker progressTracker) {
        Polygon geonormalized_polygon;
        boolean has_split_lines;
        double densification_step_in_current_units;
        boolean force_densify;
        assert (inputPolygon.getType() == Geometry.Type.Polygon);
        assert (!this.m_projTransform.isIdentity());
        assert (!inputPolygon.isEmpty());
        SpatialReferenceImpl inSR = (SpatialReferenceImpl)this.m_projTransform.getInputSR();
        SpatialReferenceImpl outSR = (SpatialReferenceImpl)this.m_projTransform.getOutputSR();
        SpatialReference.Type srTypeIn = inSR.getCoordinateSystemType();
        SpatialReference.Type srTypeOut = outSR.getCoordinateSystemType();
        double[][] bufferOfPeCoord = new double[Math.min(inputPolygon.getPointCount(), 64)][2];
        Polygon inputPolygonCloned = (Polygon)Polygon._clone(inputPolygon);
        if (srTypeIn == SpatialReference.Type.Image) {
            ExternalTransform in_external_xform = inSR.m_external_xform;
            assert (in_external_xform != null);
            inSR = (SpatialReferenceImpl)in_external_xform.getBaseSpatialReference();
            assert (inSR != null);
            srTypeIn = inSR.getCoordinateSystemType();
            inputPolygonCloned = (Polygon)in_external_xform.clipImage(inputPolygonCloned, true);
            this.applyExternalTransform(in_external_xform, ExternalTransform.TransformDirection.forward, inputPolygonCloned);
            inputPolygonCloned = (Polygon)in_external_xform.clipBase(inputPolygonCloned, true);
        }
        ExternalTransform out_external_xform = null;
        if (srTypeOut == SpatialReference.Type.Image) {
            out_external_xform = outSR.m_external_xform;
            assert (out_external_xform != null);
            outSR = (SpatialReferenceImpl)out_external_xform.getBaseSpatialReference();
            assert (outSR != null);
            srTypeOut = outSR.getCoordinateSystemType();
        }
        boolean inIsPCS = srTypeIn == SpatialReference.Type.Projected;
        boolean outIsPCS = srTypeOut == SpatialReference.Type.Projected;
        SpatialReferenceImpl outGCS = outIsPCS ? (SpatialReferenceImpl)outSR.getGCS() : outSR;
        boolean hack_poles = !outIsPCS && !this.m_b_dont_hack_poles_in_geog_to_geog;
        boolean simplify_output = false;
        MultiPath inputPolygonClipped = inputPolygonCloned;
        if (inIsPCS) {
            if ((inputPolygonClipped = ProjectionUtils.processWithPCSHorizon(inputPolygonClipped, inSR, this.m_inputPCSHorizonClipOption, progressTracker)).isEmpty()) {
                return inputPolygonClipped;
            }
        } else {
            Envelope2D thisEnv2D = new Envelope2D();
            inputPolygonClipped.queryLooseEnvelope(thisEnv2D);
            Envelope2D pannable_extent = inSR.getPannableExtentByReferenceInternal();
            if (thisEnv2D.ymin < pannable_extent.ymin || thisEnv2D.ymax > pannable_extent.ymax) {
                Envelope2D horizonEnv2D = new Envelope2D(thisEnv2D.xmin - 1.0, pannable_extent.ymin, thisEnv2D.xmax + 1.0, pannable_extent.ymax);
                inputPolygonClipped = (MultiPath)OperatorClip.local().execute(inputPolygonClipped, horizonEnv2D, (SpatialReference)inSR, progressTracker);
                if (inputPolygonClipped.isEmpty()) {
                    return inputPolygonClipped;
                }
            }
            if (thisEnv2D.getWidth() > pannable_extent.getWidth() * 2.0) {
                inputPolygonClipped = (MultiPath)ProjectionUtils.foldGeometry(inputPolygonClipped, -2.0 * pannable_extent.getWidth(), 2.0 * pannable_extent.getWidth(), inSR, true, 0.0, true, progressTracker);
            }
        }
        boolean bl = force_densify = !NumberUtils.isNaN(densification_step_in_current_units = this.m_densificationStepInput);
        if (force_densify) {
            inputPolygonClipped = (MultiPath)OperatorDensifyByLength.local().execute(inputPolygonClipped, densification_step_in_current_units, progressTracker);
        }
        PePCSInfo pcsInfoOut = outIsPCS ? outSR.getPCSInfo() : null;
        double centralLong1InGCS1Units = NumberUtils.NaN();
        if (inIsPCS) {
            centralLong1InGCS1Units = inSR.getAdjustedCentralMeridian();
        }
        boolean bl2 = has_split_lines = outSR.getGCSSplitLines() != null;
        if (!this.m_b_dontGeonormalizePolygon) {
            double f2;
            double f1;
            Polyline polyline = new Polyline(inputPolygonClipped.getDescription());
            polyline.addAndExplicitlyOpenAllPaths(inputPolygonClipped, false);
            if (inIsPCS) {
                ProjectionUtils.PEprojToGeogCenter(inSR, centralLong1InGCS1Units, polyline, bufferOfPeCoord);
                if (force_densify) {
                    f1 = inSR.getUnitsPerMillimeter();
                    f2 = ((SpatialReferenceImpl)inSR.getGCS()).getUnitsPerMillimeter();
                    densification_step_in_current_units *= f2 / f1;
                }
            }
            ProjectionUtils.PEgeogToGeog(this.m_projTransform, polyline, hack_poles, bufferOfPeCoord);
            if (force_densify) {
                f1 = ((SpatialReferenceImpl)inSR.getGCS()).getOneMeterPCSUnit();
                f2 = ((SpatialReferenceImpl)outSR.getGCS()).getOneMeterPCSUnit();
                densification_step_in_current_units *= f2 / f1;
            }
            double centralLong2InGCS2Units = NumberUtils.NaN();
            if (outIsPCS) {
                pcsInfoOut = outSR.getPCSInfo();
                centralLong2InGCS2Units = outSR.getAdjustedCentralMeridian();
            } else if (!NumberUtils.isNaN(this.m_centralMeridianOfOutputGCS)) {
                centralLong2InGCS2Units = this.m_centralMeridianOfOutputGCS;
            }
            int pole_flags = LegacyProject.getSRPoleFlags(inSR) | LegacyProject.getSRPoleFlags(outSR);
            double poleSnappingTolerance = outGCS.getTolerance(0) * 10.0;
            if (this.m_b_dont_hack_poles_in_geog_to_geog) {
                pole_flags = 3;
                poleSnappingTolerance = 0.0;
            }
            geonormalized_polygon = ProjectionUtils.geoNormalizePolygonGeometry((Polygon)inputPolygonClipped, inSR, polyline, outGCS, centralLong2InGCS2Units, progressTracker, pole_flags, poleSnappingTolerance);
            assert (geonormalized_polygon.getType() == Geometry.Type.Polygon);
            pole_flags = 0;
        } else {
            double f2;
            double f1;
            Polygon p = (Polygon)inputPolygonClipped;
            if (inIsPCS) {
                ProjectionUtils.PEprojToGeogCenter(inSR, centralLong1InGCS1Units, p, bufferOfPeCoord);
                if (force_densify) {
                    f1 = inSR.getUnitsPerMillimeter();
                    f2 = ((SpatialReferenceImpl)inSR.getGCS()).getUnitsPerMillimeter();
                    densification_step_in_current_units *= f2 / f1;
                }
            }
            ProjectionUtils.PEgeogToGeog(this.m_projTransform, p, hack_poles, bufferOfPeCoord);
            if (force_densify) {
                f1 = ((SpatialReferenceImpl)inSR.getGCS()).getUnitsPerMillimeter();
                f2 = ((SpatialReferenceImpl)outSR.getGCS()).getUnitsPerMillimeter();
                densification_step_in_current_units *= f2 / f1;
            }
            geonormalized_polygon = p;
        }
        if (has_split_lines) {
            assert (!outSR.isPannable());
            geonormalized_polygon = (Polygon)ProjectionUtils.applySplitLines(geonormalized_polygon, outSR, progressTracker);
        }
        if (outIsPCS) {
            if (!simplify_output) {
                boolean wideGeom;
                double width360 = outGCS.getPannableExtentByReferenceInternal().getWidth();
                Envelope1D envX = geonormalized_polygon.queryInterval(0, 0);
                boolean bl3 = wideGeom = envX.getWidth() >= width360 - outGCS.getTolerance(0);
                if (wideGeom) {
                    int outNorthPoleLocation = pcsInfoOut.getNorthPoleLocation();
                    int outSouthPoleLocation = pcsInfoOut.getSouthPoleLocation();
                    int outNorthPoleGeom = pcsInfoOut.getNorthPoleGeometry();
                    int outSouthPoleGeom = pcsInfoOut.getSouthPoleGeometry();
                    int outPoleFlags = 0;
                    if (outNorthPoleGeom == 1 && outNorthPoleLocation != 0) {
                        outPoleFlags = 1;
                    }
                    if (outSouthPoleGeom == 1 && outSouthPoleLocation != 0) {
                        outPoleFlags |= 2;
                    }
                    simplify_output |= outPoleFlags != 0;
                }
            }
            geonormalized_polygon = (Polygon)ProjectionUtils.intersectWithGCSHorizon(geonormalized_polygon, outSR, this.m_outputPCSHorizonClipOption, progressTracker);
            if (force_densify) {
                geonormalized_polygon = (Polygon)OperatorDensifyByLength.local().execute(geonormalized_polygon, densification_step_in_current_units, progressTracker);
            }
            ProjectionUtils.PEgeogToProj(outSR, geonormalized_polygon, bufferOfPeCoord);
        }
        if (geonormalized_polygon.isEmpty()) {
            return geonormalized_polygon;
        }
        if (simplify_output) {
            geonormalized_polygon = (Polygon)OperatorSimplify.local().execute(geonormalized_polygon, (SpatialReference)outSR, false, progressTracker);
        }
        if (out_external_xform != null) {
            geonormalized_polygon = (Polygon)out_external_xform.clipBase(geonormalized_polygon, false);
            this.applyExternalTransform(out_external_xform, ExternalTransform.TransformDirection.reverse, geonormalized_polygon);
            geonormalized_polygon = (Polygon)out_external_xform.clipImage(geonormalized_polygon, false);
        }
        return geonormalized_polygon;
    }

    private static int getSRPoleFlags(SpatialReferenceImpl pcs) {
        if (pcs.getCoordinateSystemType() != SpatialReference.Type.Projected) {
            return 0;
        }
        int poleFlags = 0;
        PePCSInfo pcsInfoIn = pcs.getPCSInfo();
        int inNorthPoleLocation = pcsInfoIn.getNorthPoleLocation();
        int inSouthPoleLocation = pcsInfoIn.getSouthPoleLocation();
        int inNorthPoleGeom = pcsInfoIn.getNorthPoleGeometry();
        int inSouthPoleGeom = pcsInfoIn.getSouthPoleGeometry();
        if (inNorthPoleGeom == 1 && inNorthPoleLocation != 0) {
            poleFlags = 1;
        }
        if (inSouthPoleGeom == 1 && inSouthPoleLocation != 0) {
            poleFlags |= 2;
        }
        return poleFlags;
    }

    private Geometry projectPolyline(MultiPath inputPolyline, ProgressTracker progressTracker) {
        Polyline geonormalizedPolyline;
        boolean forceDensify;
        assert (inputPolyline.getType() == Geometry.Type.Polyline);
        assert (!this.m_projTransform.isIdentity());
        assert (!inputPolyline.isEmpty());
        SpatialReferenceImpl inSR = (SpatialReferenceImpl)this.m_projTransform.getInputSR();
        SpatialReferenceImpl outSR = (SpatialReferenceImpl)this.m_projTransform.getOutputSR();
        SpatialReference.Type srTypeIn = inSR.getCoordinateSystemType();
        SpatialReference.Type srTypeOut = outSR.getCoordinateSystemType();
        double[][] bufferOfPeCoord = new double[Math.min(inputPolyline.getPointCount(), 64)][2];
        Polyline inputPolylineCloned = (Polyline)Polyline._clone(inputPolyline);
        inputPolyline = null;
        if (srTypeIn == SpatialReference.Type.Image) {
            ExternalTransform inExternalXform = inSR.m_external_xform;
            assert (inExternalXform != null);
            inSR = (SpatialReferenceImpl)inExternalXform.getBaseSpatialReference();
            assert (inSR != null);
            srTypeIn = inSR.getCoordinateSystemType();
            inputPolylineCloned = (Polyline)inExternalXform.clipImage(inputPolylineCloned, true);
            this.applyExternalTransform(inExternalXform, ExternalTransform.TransformDirection.forward, inputPolylineCloned);
            inputPolylineCloned = (Polyline)inExternalXform.clipBase(inputPolylineCloned, true);
        }
        ExternalTransform outExternalTransform = null;
        if (srTypeOut == SpatialReference.Type.Image) {
            outExternalTransform = outSR.m_external_xform;
            assert (outExternalTransform != null);
            outSR = (SpatialReferenceImpl)outExternalTransform.getBaseSpatialReference();
            assert (outSR != null);
            srTypeOut = outSR.getCoordinateSystemType();
        }
        boolean inIsPCS = srTypeIn == SpatialReference.Type.Projected;
        boolean outIsPCS = srTypeOut == SpatialReference.Type.Projected;
        SpatialReferenceImpl outGCS = outIsPCS ? (SpatialReferenceImpl)outSR.getGCS() : outSR;
        boolean hackPoles = !outIsPCS && !this.m_b_dont_hack_poles_in_geog_to_geog;
        Polyline inputPolylineClipped = inputPolylineCloned;
        inputPolylineCloned = null;
        if (inIsPCS) {
            if ((inputPolylineClipped = (Polyline)ProjectionUtils.processWithPCSHorizon(inputPolylineClipped, inSR, this.m_inputPCSHorizonClipOption, progressTracker)).isEmpty()) {
                return inputPolylineClipped;
            }
        } else {
            Envelope2D thisEnv2D = new Envelope2D();
            inputPolylineClipped.queryLooseEnvelope(thisEnv2D);
            Envelope2D pannableExtent = inSR.getPannableExtentByReferenceInternal();
            if (thisEnv2D.ymin < pannableExtent.ymin || thisEnv2D.ymax > pannableExtent.ymax) {
                Envelope2D horizonEnv2d = new Envelope2D(thisEnv2D.xmin - 1.0, pannableExtent.ymin, thisEnv2D.xmax + 1.0, pannableExtent.ymax);
                inputPolylineClipped = (Polyline)OperatorClip.local().execute(inputPolylineClipped, horizonEnv2d, (SpatialReference)inSR, progressTracker);
                if (inputPolylineClipped.isEmpty()) {
                    return inputPolylineClipped;
                }
            }
        }
        double centralLong1InGCS1Units = NumberUtils.NaN();
        if (inIsPCS) {
            centralLong1InGCS1Units = inSR.getAdjustedCentralMeridian();
        }
        boolean hasSplitLines = outSR.getGCSSplitLines() != null;
        double densificationStepInCurrentUnit = this.m_densificationStepInput;
        boolean bl = forceDensify = !NumberUtils.isNaN(densificationStepInCurrentUnit);
        if (forceDensify) {
            inputPolylineClipped = (Polyline)OperatorDensifyByLength.local().execute(inputPolylineClipped, densificationStepInCurrentUnit, progressTracker);
        }
        if (!this.m_b_dontGeonormalizePolygon) {
            double f2;
            double f1;
            Polyline polyline = new Polyline(inputPolylineClipped.getDescription());
            polyline.addAndExplicitlyOpenAllPaths(inputPolylineClipped, false);
            if (inIsPCS) {
                ProjectionUtils.PEprojToGeogCenter(inSR, centralLong1InGCS1Units, polyline, bufferOfPeCoord);
                if (forceDensify) {
                    f1 = inSR.getUnitsPerMillimeter();
                    f2 = ((SpatialReferenceImpl)inSR.getGCS()).getUnitsPerMillimeter();
                    densificationStepInCurrentUnit *= f2 / f1;
                }
            }
            ProjectionUtils.PEgeogToGeog(this.m_projTransform, polyline, hackPoles, bufferOfPeCoord);
            if (forceDensify) {
                f1 = ((SpatialReferenceImpl)inSR.getGCS()).getUnitsPerMillimeter();
                f2 = ((SpatialReferenceImpl)outSR.getGCS()).getUnitsPerMillimeter();
                densificationStepInCurrentUnit *= f2 / f1;
            }
            double centralLong2InGCS2Units = NumberUtils.NaN();
            if (outIsPCS) {
                centralLong2InGCS2Units = outSR.getAdjustedCentralMeridian();
            } else if (!NumberUtils.isNaN(this.m_centralMeridianOfOutputGCS)) {
                centralLong2InGCS2Units = this.m_centralMeridianOfOutputGCS;
            }
            int poleFlags = LegacyProject.getSRPoleFlags(inSR) | LegacyProject.getSRPoleFlags(outSR);
            double poleSnappingTolerance = outGCS.getTolerance(0) * 10.0;
            if (this.m_b_dont_hack_poles_in_geog_to_geog) {
                poleFlags = 3;
                poleSnappingTolerance = 0.0;
            }
            geonormalizedPolyline = ProjectionUtils.geoNormalizePolylineGeometry(inputPolylineClipped, inSR, polyline, outGCS, centralLong2InGCS2Units, progressTracker, poleFlags, poleSnappingTolerance);
            assert (geonormalizedPolyline.getType() == Geometry.Type.Polyline);
            poleFlags = 0;
        } else {
            double f2;
            double f1;
            if (inIsPCS) {
                ProjectionUtils.PEprojToGeogCenter(inSR, centralLong1InGCS1Units, inputPolylineClipped, bufferOfPeCoord);
            }
            if (forceDensify) {
                f1 = inSR.getUnitsPerMillimeter();
                f2 = ((SpatialReferenceImpl)inSR.getGCS()).getUnitsPerMillimeter();
                densificationStepInCurrentUnit *= f2 / f1;
            }
            ProjectionUtils.PEgeogToGeog(this.m_projTransform, inputPolylineClipped, hackPoles, bufferOfPeCoord);
            if (forceDensify) {
                f1 = ((SpatialReferenceImpl)inSR.getGCS()).getUnitsPerMillimeter();
                f2 = ((SpatialReferenceImpl)outSR.getGCS()).getUnitsPerMillimeter();
                densificationStepInCurrentUnit *= f2 / f1;
            }
            geonormalizedPolyline = inputPolylineClipped;
        }
        if (hasSplitLines) {
            assert (!outSR.isPannable());
            geonormalizedPolyline = (Polyline)ProjectionUtils.applySplitLines(geonormalizedPolyline, outSR, progressTracker);
        }
        if (outIsPCS) {
            geonormalizedPolyline = (Polyline)ProjectionUtils.intersectWithGCSHorizon(geonormalizedPolyline, outSR, this.m_outputPCSHorizonClipOption, progressTracker);
            if (forceDensify) {
                geonormalizedPolyline = (Polyline)OperatorDensifyByLength.local().execute(geonormalizedPolyline, densificationStepInCurrentUnit, progressTracker);
            }
            ProjectionUtils.PEgeogToProj(outSR, geonormalizedPolyline, bufferOfPeCoord);
        }
        if (geonormalizedPolyline.isEmpty()) {
            return geonormalizedPolyline;
        }
        if (outExternalTransform != null) {
            geonormalizedPolyline = (Polyline)outExternalTransform.clipBase(geonormalizedPolyline, false);
            this.applyExternalTransform(outExternalTransform, ExternalTransform.TransformDirection.reverse, geonormalizedPolyline);
            geonormalizedPolyline = (Polyline)outExternalTransform.clipImage(geonormalizedPolyline, false);
        }
        return geonormalizedPolyline;
    }

    private Geometry projectEnvelope(Envelope inputEnvelope, ProgressTracker progressTracker) {
        double distance = (inputEnvelope.getHeight() + inputEnvelope.getWidth()) / 400.0;
        if (distance != 0.0) {
            Geometry envelopePolygon = OperatorDensifyByLength.local().execute(inputEnvelope, distance, progressTracker);
            envelopePolygon = this.projectMultiPath((MultiPath)envelopePolygon, progressTracker);
            Geometry outputEnvelope = inputEnvelope.createInstance();
            envelopePolygon.queryEnvelope((Envelope)outputEnvelope);
            return outputEnvelope;
        }
        Point pt = new Point(inputEnvelope.getCenterXY());
        Point ptGeom = (Point)this.projectPoint(pt, progressTracker);
        Envelope outputEnvelope = (Envelope)inputEnvelope.createInstance();
        if (!ptGeom.isEmpty()) {
            inputEnvelope.copyTo(outputEnvelope);
            Point2D outputPt = ptGeom.getXY();
            outputEnvelope.setCoords(outputPt.x, outputPt.y, outputPt.x, outputPt.y);
        } else {
            outputEnvelope.setEmpty();
        }
        return outputEnvelope;
    }

    private Geometry projectMultiPoint(MultiPoint inputMultiPoint, ProgressTracker progressTracker) {
        boolean outIsPCS;
        MultiPoint multiPoint = (MultiPoint)Geometry._clone(inputMultiPoint);
        SpatialReferenceImpl inSR = (SpatialReferenceImpl)this.m_projTransform.getInputSR();
        SpatialReferenceImpl outSR = (SpatialReferenceImpl)this.m_projTransform.getOutputSR();
        SpatialReference.Type srTypeIn = inSR.getCoordinateSystemType();
        SpatialReference.Type srTypeOut = outSR.getCoordinateSystemType();
        double[][] bufferOfPeCoord = new double[Math.min(multiPoint.getPointCount(), 64)][2];
        if (srTypeIn == SpatialReference.Type.Image) {
            ExternalTransform inExternalTransform = inSR.m_external_xform;
            inSR = (SpatialReferenceImpl)inExternalTransform.getBaseSpatialReference();
            srTypeIn = inSR.getCoordinateSystemType();
            multiPoint = (MultiPoint)inExternalTransform.clipBase(multiPoint, true);
            this.applyExternalTransform(inExternalTransform, ExternalTransform.TransformDirection.forward, multiPoint);
            multiPoint = (MultiPoint)inExternalTransform.clipImage(multiPoint, true);
        }
        if (srTypeIn == SpatialReference.Type.Projected) {
            if (this.m_inputPCSHorizonClipOption == ProjectionUtils.HorizonClipOption.Clip) {
                multiPoint = (MultiPoint)OperatorIntersection.local().execute(multiPoint, inSR.getPCSHorizon(), (SpatialReference)inSR, progressTracker);
            } else if (inSR.isPannable()) {
                Envelope2D ge = new Envelope2D();
                multiPoint.queryLooseEnvelope2D(ge);
                if (!inSR.getPannableExtentByReferenceInternal().contains(ge)) {
                    if (this.m_inputPCSHorizonClipOption == ProjectionUtils.HorizonClipOption.PannableFold) {
                        multiPoint = (MultiPoint)ProjectionUtils.clipGeometryFromTopAndBottom(multiPoint, inSR);
                    }
                    ProjectionUtils.snapToHorizonEnvelope(multiPoint, inSR.getPannableExtentByReferenceInternal(), inSR.getTolerance(0), true);
                    multiPoint = (MultiPoint)ProjectionUtils.foldInto360DegreeRange(multiPoint, inSR, 0.0, true, 0.0, progressTracker);
                }
            }
            if (multiPoint.isEmpty()) {
                return multiPoint;
            }
            ProjectionUtils.PEprojToGeogCenter(inSR, 0.0, multiPoint, bufferOfPeCoord);
        } else {
            ProjectionUtils.snapToHorizonEnvelope(multiPoint, inSR.getPannableExtentByReferenceInternal(), inSR.getTolerance(0), true);
        }
        ProjectionUtils.PEgeogToGeog(this.m_projTransform, multiPoint, false, bufferOfPeCoord);
        double centralLong2InGCS2Units = 0.0;
        boolean applyExternalTransform = false;
        ExternalTransform outExternalTransform = null;
        if (srTypeOut == SpatialReference.Type.Image) {
            applyExternalTransform = true;
            outExternalTransform = outSR.m_external_xform;
            outSR = (SpatialReferenceImpl)outExternalTransform.getBaseSpatialReference();
            srTypeOut = outSR.getCoordinateSystemType();
        }
        boolean bl = outIsPCS = srTypeOut == SpatialReference.Type.Projected;
        if (outIsPCS) {
            centralLong2InGCS2Units = outSR.getAdjustedCentralMeridian();
        } else if (!NumberUtils.isNaN(this.m_centralMeridianOfOutputGCS)) {
            centralLong2InGCS2Units = this.m_centralMeridianOfOutputGCS;
        }
        if (!outIsPCS || this.m_outputPCSHorizonClipOption == ProjectionUtils.HorizonClipOption.Clip) {
            multiPoint = (MultiPoint)ProjectionUtils.foldInto360DegreeRange(multiPoint, (SpatialReferenceImpl)outSR.getGCS(), centralLong2InGCS2Units, false, 0.0, progressTracker);
        }
        if (outIsPCS) {
            multiPoint = (MultiPoint)ProjectionUtils.intersectWithGCSHorizon(multiPoint, outSR, this.m_outputPCSHorizonClipOption, progressTracker);
            ProjectionUtils.PEgeogToProj(outSR, multiPoint, bufferOfPeCoord);
            if (multiPoint.isEmpty()) {
                return multiPoint;
            }
        }
        if (applyExternalTransform) {
            multiPoint = (MultiPoint)outExternalTransform.clipBase(multiPoint, true);
            this.applyExternalTransform(outExternalTransform, ExternalTransform.TransformDirection.reverse, multiPoint);
            multiPoint = (MultiPoint)outExternalTransform.clipImage(multiPoint, true);
        }
        return multiPoint;
    }

    private void applyExternalTransform(ExternalTransform xf, ExternalTransform.TransformDirection direction, MultiVertexGeometry multiVertexGeometry) {
        int readCount;
        int numPoint = multiVertexGeometry.getPointCount();
        if (numPoint == 0) {
            return;
        }
        MultiVertexGeometryImpl mImpl = (MultiVertexGeometryImpl)multiVertexGeometry._getImpl();
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)mImpl.getAttributeStreamRef(0);
        double[] buffer = new double[200];
        Point2D[] dst = new Point2D[100];
        for (int i = 0; i < numPoint; i += readCount) {
            readCount = Math.min(100, numPoint - i);
            position.readRange(i * 2, 2 * readCount, buffer, 2, true);
            for (int j = 0; j < readCount; ++j) {
                dst[j] = new Point2D(buffer[i * 2], buffer[i * 2 + 1]);
            }
            xf.transform(direction, dst, readCount);
        }
        mImpl.notifyModified(2001);
    }

    static Geometry foldInto360Range(Geometry geom, SpatialReference pannableSR, ProgressTracker progressTracker) {
        MultiPath tempGeom;
        if (geom == null || pannableSR == null || !pannableSR.isPannable()) {
            throw new GeometryException("Invalid Arguement");
        }
        if (geom.isEmpty()) {
            return geom;
        }
        Geometry copiedGeom = null;
        Geometry.Type gt = geom.getType();
        if (gt == Geometry.Type.Envelope) {
            tempGeom = new Polygon(geom.getDescription());
            tempGeom.addEnvelope((Envelope)geom, false);
            copiedGeom = tempGeom;
        } else if (Geometry.isSegment(gt.value())) {
            tempGeom = new Polyline(geom.getDescription());
            ((Polyline)tempGeom).addSegment((Segment)geom, true);
            copiedGeom = tempGeom;
        } else {
            copiedGeom = geom;
        }
        Geometry clippedGeom = ProjectionUtils.clipGeometryFromTopAndBottom(copiedGeom, pannableSR);
        if (clippedGeom.isEmpty()) {
            return clippedGeom;
        }
        return ProjectionUtils.foldInto360DegreeRange(clippedGeom, (SpatialReferenceImpl)pannableSR, 0.0, clippedGeom != geom, 0.0, progressTracker);
    }

    static Geometry foldInto360RangeGeodetic(Geometry geom_, SpatialReference pannableSR, int curveType, ProgressTracker progressTracker) {
        Geometry geom = geom_;
        if (geom == null || pannableSR == null || !pannableSR.isPannable()) {
            throw new GeometryException("Invalid Arguement");
        }
        if (geom.isEmpty()) {
            return geom;
        }
        int gt = geom.getType().value();
        if (!Geometry.isMultiPath(gt)) {
            if (gt == 197) {
                Polygon tempGeom = new Polygon(geom.getDescription());
                tempGeom.addEnvelope((Envelope)geom, false);
                return LegacyProject.foldInto360RangeGeodetic(tempGeom, pannableSR, curveType, progressTracker);
            }
            if (Geometry.isSegment(gt)) {
                Polyline tempGeom = new Polyline(geom.getDescription());
                tempGeom.addSegment((Segment)geom, true);
                return LegacyProject.foldInto360RangeGeodetic(tempGeom, pannableSR, curveType, progressTracker);
            }
        } else {
            geom = ProjectionUtils.clipGeometryFromTopAndBottom(geom, pannableSR);
            Envelope2D geomExtent = new Envelope2D();
            geom.queryEnvelope2D(geomExtent);
            double tolerance = InternalUtils.calculateToleranceFromGeometryForOp(pannableSR, geomExtent, false);
            Envelope2D pannableExtent = pannableSR.getPannableExtent();
            MultiPath mp = (MultiPath)geom;
            for (double v = Math.floor((geomExtent.xmin - pannableExtent.xmin) / pannableExtent.getWidth()) * pannableExtent.getWidth() + pannableExtent.xmin; v < geomExtent.xmax; v += pannableExtent.getWidth()) {
                if (!(v > geomExtent.xmin + tolerance) || !(v < geomExtent.xmax - tolerance)) continue;
                mp = ProjectionUtils.insertGeodeticPoints(mp, (SpatialReferenceImpl)pannableSR, curveType, true, v);
            }
            geom = mp;
        }
        return LegacyProject.foldInto360Range(geom, pannableSR, progressTracker);
    }

    static Geometry clipToSpatialReference(Geometry geometry, SpatialReference sr, ProgressTracker progressTracker, OperatorProject.DomainClipOptions options) {
        SpatialReference.Type csType = sr.getCoordinateSystemType();
        SpatialReferencePrecisionDescriptor descr = new SpatialReferencePrecisionDescriptor();
        sr.queryPrecisionDescriptor(descr);
        if (csType == SpatialReference.Type.Local) {
            return LegacyProject.clipToSpatialReferenceDomain(geometry, descr, sr, progressTracker);
        }
        Geometry domainClippedGeom = geometry;
        if (options == OperatorProject.DomainClipOptions.foldAndClipWithHorizon && sr.isPannable()) {
            domainClippedGeom = LegacyProject.foldInto360Range(domainClippedGeom, sr, progressTracker);
        }
        domainClippedGeom = LegacyProject.clipToSpatialReferenceDomain(domainClippedGeom, descr, sr, progressTracker);
        if (options == OperatorProject.DomainClipOptions.clipToDomainOnly || domainClippedGeom.isEmpty()) {
            return domainClippedGeom;
        }
        if (csType == SpatialReference.Type.Geographic) {
            if (options == OperatorProject.DomainClipOptions.clipWithHorizon) {
                Envelope2D geomEnv = new Envelope2D();
                domainClippedGeom.queryLooseEnvelope2D(geomEnv);
                Envelope2D pannableExtent = ((SpatialReferenceImpl)sr).getPannableExtentByReferenceInternal();
                double dw = 0.01 * pannableExtent.getWidth();
                geomEnv.ymin = pannableExtent.ymin;
                geomEnv.ymax = pannableExtent.ymax;
                geomEnv.xmin -= dw;
                geomEnv.xmax += dw;
                return OperatorClip.local().execute(domainClippedGeom, geomEnv, sr, progressTracker);
            }
            return domainClippedGeom;
        }
        if (csType == SpatialReference.Type.Projected) {
            Geometry horizon = ((SpatialReferenceImpl)sr).getPCSHorizon();
            if (options == OperatorProject.DomainClipOptions.clipWithHorizon || options == OperatorProject.DomainClipOptions.foldAndClipWithHorizon) {
                Geometry g = OperatorIntersection.local().execute(domainClippedGeom, horizon, sr, progressTracker);
                if (g == horizon) {
                    return Geometry._clone(g);
                }
                return g;
            }
            return domainClippedGeom;
        }
        if (csType == SpatialReference.Type.Image) {
            return domainClippedGeom;
        }
        throw new GeometryException("missing implementation");
    }

    static Geometry clipToSpatialReferenceDomain(Geometry geometry, SpatialReferencePrecisionDescriptor descr, SpatialReference sr, ProgressTracker progressTracker) {
        Envelope1D eg;
        Envelope2D xyGrid = descr.getXYGridRange();
        boolean hasZs = geometry.hasAttribute(1);
        boolean hasMs = geometry.hasAttribute(2);
        Envelope1D zGrid = new Envelope1D();
        zGrid.setEmpty();
        Envelope1D mGrid = new Envelope1D();
        mGrid.setEmpty();
        if (hasZs) {
            zGrid = descr.getZGridRange();
        }
        if (hasMs) {
            mGrid = descr.getMGridRange();
        }
        Geometry resGeom = OperatorClip.local().execute(geometry, xyGrid, sr, progressTracker);
        if (hasZs && !zGrid.contains(eg = resGeom.queryInterval(1, 0))) {
            if (geometry == resGeom) {
                resGeom = Geometry._clone(resGeom);
            }
            InternalUtils.snapCoordinate(resGeom, zGrid, 1, 0);
        }
        if (hasMs && !mGrid.contains(eg = resGeom.queryInterval(2, 0))) {
            if (geometry == resGeom) {
                resGeom = Geometry._clone(resGeom);
            }
            InternalUtils.snapCoordinate(resGeom, mGrid, 2, 0);
        }
        return resGeom;
    }
}

