/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.JsonGeometryException;
import com.esri.core.geometry.JsonReader;
import com.esri.core.geometry.NumberUtils;
import java.io.IOException;

final class JSONUtils {
    JSONUtils() {
    }

    static boolean isObjectStart(JsonReader parser) throws Exception {
        JsonReader.Token token = parser.currentToken();
        return token == null ? parser.nextToken() == JsonReader.Token.START_OBJECT : token == JsonReader.Token.START_OBJECT;
    }

    static double readDouble(JsonReader parser) throws JsonGeometryException, IOException, Exception {
        JsonReader.Token token = parser.currentToken();
        if (token == JsonReader.Token.VALUE_NUMBER_FLOAT) {
            return parser.currentDoubleValue();
        }
        if (token == JsonReader.Token.VALUE_NUMBER_INT) {
            return parser.currentIntValue();
        }
        if (token == JsonReader.Token.VALUE_NULL) {
            return NumberUtils.NaN();
        }
        if (token == JsonReader.Token.VALUE_STRING && parser.currentString().equals("NaN")) {
            return NumberUtils.NaN();
        }
        throw new GeometryException("invalid parameter");
    }
}

