/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentIteratorImpl;
import com.esri.core.geometry.SimpleRasterizer;
import com.esri.core.geometry.Transformation2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class HitMap2D {
    private Point2D m_pt_start_dummy = new Point2D();
    private Point2D m_pt_end_dummy = new Point2D();
    private Envelope2D m_env_dummy = new Envelope2D();
    private double[] m_helper_xy_10_elm = new double[10];
    private SimpleRasterizer m_rasterizer;
    private ScanCallbackImpl m_callback;
    private long[] m_bitmap;
    private int m_scanline_width;
    private int m_width;
    private int m_max_geom_ids;
    private int m_shift_bit;
    private long m_bit_mask;
    private int m_unique_id_count;
    private HashMap<Long, Long> m_id_to_bit = new HashMap();
    private long m_last_id = -1L;
    private long m_last_bit = 0L;
    private Transformation2D m_transform = new Transformation2D();
    private double m_stroke_half_width;
    private double m_stroke_half_width_pix;
    private double m_tolerance_xy;
    private double m_stroke_half_widthX_pix;
    private double m_stroke_half_widthY_pix;
    private Envelope2D m_geom_env = new Envelope2D();

    public HitMap2D(Envelope2D extent, double tolerance_xy, int grid_size, int max_geom_ids) {
        this.init(extent, tolerance_xy, grid_size, max_geom_ids);
    }

    public void reset(Envelope2D extent) {
        Arrays.fill(this.m_bitmap, 0L);
        this.resetImpl_(extent);
    }

    public void addGeometry(Geometry geom, long id, boolean only_area_boundaries) {
        this.m_callback.setId(id);
        this.do_action(geom, only_area_boundaries);
    }

    void addGeometry(EditShape shape, int geometry, boolean only_area_boundaries) {
        this.m_callback.setId(geometry);
        int gt = shape.getGeometryType(geometry);
        switch (gt) {
            case 550: {
                this.fillPoints(shape, geometry);
                break;
            }
            case 1607: {
                this.strokeDrawPolyPath(this.m_rasterizer, shape, geometry);
                break;
            }
            case 1736: {
                if (!only_area_boundaries) {
                    this.fillMultiPath(shape, geometry, shape.getFillRule(geometry) == 1);
                }
                this.strokeDrawPolyPath(this.m_rasterizer, shape, geometry);
                break;
            }
        }
    }

    public void add_xy(Point2D point, long id) {
        this.m_callback.setId(id);
        this.m_pt_start_dummy.setCoords(point);
        this.addXYImpl_(this.m_pt_start_dummy);
    }

    public long hitTest(Geometry geom, long[] ids_out, int ids_count, boolean only_area_boundaries) {
        this.m_callback.setTesting();
        this.do_action(geom, only_area_boundaries);
        this.m_rasterizer.flush();
        long m = this.m_callback.m_test_mask;
        int i = 0;
        for (Map.Entry<Long, Long> entry : this.m_id_to_bit.entrySet()) {
            long v = entry.getValue();
            if ((v & m) == 0L) continue;
            long id = entry.getKey();
            ids_out[i++] = id;
        }
        return i;
    }

    public boolean hitTest(Geometry geom, long id, boolean only_area_boundaries) {
        this.m_callback.setTesting();
        long mask = this.m_last_bit;
        if (this.m_last_id != id) {
            Long v = this.m_id_to_bit.get(id);
            if (v == null) {
                return false;
            }
            mask = v;
            this.m_last_id = id;
            this.m_last_bit = mask;
        }
        this.do_action(geom, only_area_boundaries);
        this.m_rasterizer.flush();
        long m = this.m_callback.m_test_mask;
        long s = mask ^ 0xFFFFFFFFFFFFFFFFL;
        return (m & s) != 0L;
    }

    public void dbgSaveToBitmap(String fileName) {
        try {
            FileOutputStream outfile = new FileOutputStream(fileName);
            int height = this.m_width;
            int width = this.m_width;
            int sz = 54 + 4 * this.m_width * height;
            ByteBuffer byteBuffer = ByteBuffer.allocate(sz);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put((byte)66);
            byteBuffer.put((byte)77);
            byteBuffer.putInt(sz);
            short zero16 = 0;
            byteBuffer.putShort(zero16);
            byteBuffer.putShort(zero16);
            int offset = 54;
            byteBuffer.putInt(offset);
            int biSize = 40;
            int biWidth = width;
            int biHeight = -height;
            short biPlanes = 1;
            short biBitCount = 32;
            int biCompression = 0;
            int biSizeImage = 4 * width * height;
            int biXPelsPerMeter = 0;
            int biYPelsPerMeter = 0;
            int biClrUsed = 0;
            int biClrImportant = 0;
            byteBuffer.putInt(biSize);
            byteBuffer.putInt(biWidth);
            byteBuffer.putInt(biHeight);
            byteBuffer.putShort(biPlanes);
            byteBuffer.putShort(biBitCount);
            byteBuffer.putInt(biCompression);
            byteBuffer.putInt(biSizeImage);
            byteBuffer.putInt(biXPelsPerMeter);
            byteBuffer.putInt(biYPelsPerMeter);
            byteBuffer.putInt(biClrUsed);
            byteBuffer.putInt(biClrImportant);
            long c = this.m_max_geom_ids == 64 ? -1L : (1L << this.m_max_geom_ids) - 1L;
            int shift_bit = this.m_shift_bit;
            long bit_mask = this.m_bit_mask;
            int bpp = this.m_max_geom_ids;
            int nh = height;
            for (int y = 0; y < nh; ++y) {
                int scanline_start = y * this.m_scanline_width;
                for (int x = 0; x < this.m_width; ++x) {
                    long v = this.m_bitmap[scanline_start + (x >>> shift_bit)];
                    v >>>= (int)(((long)x & bit_mask) * (long)bpp);
                    int color = 0;
                    if ((v &= c) != 0L) {
                        for (int i = 0; i < this.m_max_geom_ids; ++i) {
                            long m = 1L << i;
                            if ((v & m) == 0L) continue;
                            int n = 0xFF00FF - i * (0xFF00FF / this.m_max_geom_ids);
                            if (color != 0) {
                                color = 0xFFFFFF;
                                break;
                            }
                            color = n;
                        }
                    }
                    byteBuffer.putInt(0xFFFFFF - color | 0xFF000000);
                }
            }
            byte[] b = byteBuffer.array();
            outfile.write(b);
            outfile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void init(Envelope2D extent, double tolerance_xy, int grid_size, int max_geom_ids) {
        if (max_geom_ids > 64 || max_geom_ids < 1) {
            throw new IllegalArgumentException("max_geom_ids has to be between 1 and 64");
        }
        this.assignMaxGeomIds(max_geom_ids);
        this.m_width = 0;
        if (grid_size > 0) {
            this.m_width = (int)Math.sqrt(grid_size);
        }
        if (this.m_width < 64) {
            this.m_width = 64;
        }
        this.m_tolerance_xy = tolerance_xy;
        this.m_scanline_width = (this.m_width * this.m_max_geom_ids + 63) / 64;
        int size = this.m_width * this.m_scanline_width;
        this.m_bitmap = new long[size];
        this.m_rasterizer = new SimpleRasterizer();
        this.m_callback = new ScanCallbackImpl(this);
        this.m_rasterizer.setup(this.m_width, this.m_width, this.m_callback);
        this.resetImpl_(extent);
    }

    private void resetImpl_(Envelope2D extent) {
        this.m_callback.reset();
        this.m_unique_id_count = 0;
        this.m_id_to_bit.clear();
        this.m_last_id = -1L;
        this.m_last_bit = 0L;
        this.m_geom_env = extent;
        if (this.m_geom_env.getWidth() > (double)this.m_width * this.m_geom_env.getHeight() || this.m_geom_env.getHeight() > this.m_geom_env.getWidth() * (double)this.m_width) {
            // empty if block
        }
        this.m_geom_env.inflate(this.m_tolerance_xy, this.m_tolerance_xy);
        Envelope2D world_env = new Envelope2D();
        Envelope2D pix_env = new Envelope2D(1.0, 1.0, this.m_width - 2, this.m_width - 2);
        double min_width = 2.0 * this.m_tolerance_xy * pix_env.getWidth();
        double min_height = 2.0 * this.m_tolerance_xy * pix_env.getHeight();
        world_env.setCoords(this.m_geom_env.getCenter(), Math.max(min_width, this.m_geom_env.getWidth()), Math.max(min_height, this.m_geom_env.getHeight()));
        this.m_stroke_half_width = this.m_tolerance_xy;
        this.m_transform.initializeFromRect(world_env, pix_env);
        this.m_stroke_half_widthX_pix = Math.max(1.0, this.m_stroke_half_width * this.m_transform.xx);
        this.m_stroke_half_widthY_pix = Math.max(1.0, this.m_stroke_half_width * this.m_transform.yy);
        this.m_stroke_half_width_pix = this.m_transform.transform(this.m_stroke_half_width) + 1.1;
    }

    private long getBitMask(long id) {
        if (this.m_last_id == id) {
            return this.m_last_bit;
        }
        Long v = this.m_id_to_bit.get(id);
        if (v != null) {
            this.m_last_id = id;
            this.m_last_bit = v;
            return this.m_last_bit;
        }
        if (this.m_unique_id_count == this.m_max_geom_ids) {
            throw new IllegalArgumentException("too many geometry ids");
        }
        ++this.m_unique_id_count;
        long mask = 1L << this.m_unique_id_count - 1;
        this.m_id_to_bit.put(id, mask);
        this.m_last_id = id;
        this.m_last_bit = mask;
        return mask;
    }

    private void do_action(Geometry geom, boolean only_area_boundaries) {
        Envelope2D env = new Envelope2D();
        geom.queryEnvelope2D(env);
        if (!env.isIntersecting(this.m_geom_env)) {
            return;
        }
        int gt = geom.getType().value();
        switch (gt) {
            case 322: {
                this.strokeDrawSegment(this.m_rasterizer, (Segment)geom);
                break;
            }
            case 33: {
                ((Point)geom).getXY(this.m_pt_start_dummy);
                this.addXYImpl_(this.m_pt_start_dummy);
                break;
            }
            case 550: {
                this.fillPoints((MultiPointImpl)geom._getImpl());
                break;
            }
            case 1607: {
                this.strokeDrawPolyPath(this.m_rasterizer, (MultiPathImpl)geom._getImpl());
                break;
            }
            case 1736: {
                boolean isWinding;
                boolean bl = isWinding = ((MultiPathImpl)geom._getImpl()).getFillRule() == 1;
                if (!only_area_boundaries) {
                    this.fillMultiPath((MultiPathImpl)geom._getImpl(), isWinding);
                }
                this.strokeDrawPolyPath(this.m_rasterizer, (MultiPathImpl)geom._getImpl());
                break;
            }
            default: {
                throw GeometryException.GeometryInternalError();
            }
        }
    }

    private void fillMultiPath(MultiPathImpl polygon, boolean b_winding) {
        this.m_rasterizer.startAddingEdges();
        Point2D prev_pt = new Point2D();
        Point2D skipped_pt1 = new Point2D();
        Point2D skipped_pt2 = new Point2D();
        SegmentIteratorImpl seg_iter = polygon.querySegmentIterator();
        while (seg_iter.nextPath()) {
            boolean has_prev = false;
            boolean skipped = false;
            while (seg_iter.hasNextSegment()) {
                Segment seg = seg_iter.nextSegment();
                if (seg.getType().value() != 322) {
                    throw GeometryException.GeometryInternalError();
                }
                Point2D pt2 = this.m_pt_end_dummy;
                seg.getEndXY(pt2);
                if (!has_prev) {
                    seg.getStartXY(prev_pt);
                    this.m_transform.transform(prev_pt, prev_pt);
                    has_prev = true;
                }
                this.m_transform.transform(pt2, pt2);
                if (Point2D.sqrDistance(prev_pt, pt2) > 0.25) {
                    this.m_rasterizer.addEdge(prev_pt.x, prev_pt.y, pt2.x, pt2.y);
                    prev_pt.setCoords(pt2);
                    skipped = false;
                    continue;
                }
                skipped_pt1.setCoords(prev_pt);
                skipped_pt2.setCoords(pt2);
                skipped = true;
            }
            if (!skipped) continue;
            this.m_rasterizer.addEdge(skipped_pt1.x, skipped_pt1.y, skipped_pt2.x, skipped_pt2.y);
        }
        this.m_rasterizer.renderEdges(b_winding ? 1 : 0);
    }

    private void fillMultiPath(EditShape shape, int geometry, boolean b_winding) {
        this.m_rasterizer.startAddingEdges();
        Point2D prev_pt = new Point2D();
        Point2D skipped_pt1 = new Point2D();
        Point2D skipped_pt2 = new Point2D();
        Line seg = new Line();
        int path = shape.getFirstPath(geometry);
        while (path != -1) {
            int vertex = shape.getFirstVertex(path);
            boolean skipped = false;
            boolean has_prev = false;
            int n = shape.getPathSize(path);
            for (int i = 0; i < n; ++i) {
                if (seg.getType() != Geometry.Type.Line) {
                    throw GeometryException.GeometryInternalError();
                }
                Point2D pt2 = this.m_pt_end_dummy;
                seg.getEndXY(pt2);
                if (!has_prev) {
                    seg.getStartXY(prev_pt);
                    this.m_transform.transform(prev_pt, prev_pt);
                    has_prev = true;
                }
                this.m_transform.transform(pt2, pt2);
                if (Point2D.sqrDistance(prev_pt, pt2) > 0.25) {
                    this.m_rasterizer.addEdge(prev_pt.x, prev_pt.y, pt2.x, pt2.y);
                    prev_pt.setCoords(pt2);
                    skipped = false;
                } else {
                    skipped_pt1.setCoords(prev_pt);
                    skipped_pt2.setCoords(pt2);
                    skipped = true;
                }
                vertex = shape.getNextVertex(vertex);
            }
            if (skipped) {
                this.m_rasterizer.addEdge(skipped_pt1.x, skipped_pt1.y, skipped_pt2.x, skipped_pt2.y);
            }
            path = shape.getNextPath(path);
        }
        this.m_rasterizer.renderEdges(b_winding ? 1 : 0);
    }

    private void strokeDrawPolyPath(SimpleRasterizer rasterizer, EditShape shape, int geometry) {
        assert (!this.m_geom_env.isEmpty());
        double stroke_half_width = this.m_stroke_half_width_pix;
        Line seg = new Line();
        Point2D ptOld = new Point2D();
        Point2D prev_start = new Point2D();
        Point2D prev_end = new Point2D();
        int path = shape.getFirstPath(geometry);
        while (path != -1) {
            int vertex = shape.getFirstVertex(path);
            boolean first = true;
            boolean has_fan = false;
            ptOld.setCoords(0.0, 0.0);
            int n = shape.getPathSize(path);
            for (int i = 0; i < n; ++i) {
                if (shape.queryLineConnector(vertex, seg, true)) {
                    Point2D pt_start = this.m_pt_start_dummy;
                    Point2D pt_end = this.m_pt_end_dummy;
                    seg.getStartXY(pt_start);
                    seg.getEndXY(pt_end);
                    Envelope2D env = this.m_env_dummy;
                    env.setCoords(pt_start);
                    env.mergeNE(pt_end.x, pt_end.y);
                    if (!this.m_geom_env.isIntersectingNE(env)) {
                        if (has_fan) {
                            rasterizer.startAddingEdges();
                            rasterizer.addSegmentStroke(prev_start.x, prev_start.y, prev_end.x, prev_end.y, stroke_half_width, false, this.m_helper_xy_10_elm);
                            rasterizer.renderEdges(0);
                            has_fan = false;
                        }
                        first = true;
                    } else {
                        this.m_transform.transform(pt_end, pt_end);
                        if (first) {
                            this.m_transform.transform(pt_start, pt_start);
                            ptOld.setCoords(pt_start);
                            first = false;
                        } else {
                            pt_start.setCoords(ptOld);
                        }
                        prev_start.setCoords(pt_start);
                        prev_end.setCoords(pt_end);
                        rasterizer.startAddingEdges();
                        has_fan = !rasterizer.addSegmentStroke(prev_start.x, prev_start.y, prev_end.x, prev_end.y, stroke_half_width, true, this.m_helper_xy_10_elm);
                        rasterizer.renderEdges(0);
                        if (!has_fan) {
                            ptOld.setCoords(prev_end);
                        }
                    }
                }
                vertex = shape.getNextVertex(vertex);
            }
            if (has_fan) {
                rasterizer.startAddingEdges();
                rasterizer.addSegmentStroke(prev_start.x, prev_start.y, prev_end.x, prev_end.y, stroke_half_width, false, this.m_helper_xy_10_elm);
                rasterizer.renderEdges(0);
            }
            path = shape.getNextPath(path);
        }
    }

    private void strokeDrawPolyPath(SimpleRasterizer rasterizer, MultiPathImpl poly_path) {
        assert (!this.m_geom_env.isEmpty());
        assert (this.m_transform.isScaleAndShift(0.0));
        SegmentIteratorImpl seg_iter = poly_path.querySegmentIterator();
        double stroke_half_width = this.m_stroke_half_width_pix;
        Point2D prev_start = new Point2D();
        Point2D prev_end = new Point2D();
        Point2D ptOld = new Point2D();
        while (seg_iter.nextPath()) {
            boolean first = true;
            boolean has_fan = false;
            ptOld.setCoords(0.0, 0.0);
            while (seg_iter.hasNextSegment()) {
                Segment seg = seg_iter.nextSegment();
                Point2D pt_start = this.m_pt_start_dummy;
                seg.getStartXY(pt_start);
                Point2D pt_end = this.m_pt_end_dummy;
                seg.getEndXY(pt_end);
                Envelope2D env = this.m_env_dummy;
                env.setCoords(pt_start);
                env.mergeNE(pt_end.x, pt_end.y);
                if (!this.m_geom_env.isIntersectingNE(env)) {
                    if (has_fan) {
                        rasterizer.startAddingEdges();
                        rasterizer.addSegmentStroke(prev_start.x, prev_start.y, prev_end.x, prev_end.y, stroke_half_width, false, this.m_helper_xy_10_elm);
                        rasterizer.renderEdges(0);
                        has_fan = false;
                    }
                    first = true;
                    continue;
                }
                pt_end.x = this.m_transform.xx * pt_end.x + this.m_transform.xd;
                pt_end.y = this.m_transform.yy * pt_end.y + this.m_transform.yd;
                if (first) {
                    pt_start.x = this.m_transform.xx * pt_start.x + this.m_transform.xd;
                    pt_start.y = this.m_transform.yy * pt_start.y + this.m_transform.yd;
                    ptOld.setCoords(pt_start);
                    first = false;
                } else {
                    pt_start.setCoords(ptOld);
                }
                prev_start.setCoords(pt_start);
                prev_end.setCoords(pt_end);
                rasterizer.startAddingEdges();
                has_fan = !rasterizer.addSegmentStroke(prev_start.x, prev_start.y, prev_end.x, prev_end.y, stroke_half_width, true, this.m_helper_xy_10_elm);
                rasterizer.renderEdges(0);
                if (has_fan) continue;
                ptOld.setCoords(prev_end);
            }
            if (!has_fan) continue;
            rasterizer.startAddingEdges();
            has_fan = !rasterizer.addSegmentStroke(prev_start.x, prev_start.y, prev_end.x, prev_end.y, stroke_half_width, false, this.m_helper_xy_10_elm);
            rasterizer.renderEdges(0);
        }
    }

    private void fillPoints(MultiPointImpl mp) {
        assert (!this.m_geom_env.isEmpty());
        assert (this.m_transform.isScaleAndShift(0.0));
        int n = mp.getPointCount();
        for (int ipoint = 0; ipoint < n; ++ipoint) {
            Point2D pt = this.m_pt_start_dummy;
            mp.getXY(ipoint, pt);
            pt.x = this.m_transform.xx * pt.x + this.m_transform.xd;
            pt.y = this.m_transform.yy * pt.y + this.m_transform.yd;
            this.m_env_dummy.setCoords(pt.x - this.m_stroke_half_width_pix, pt.y - this.m_stroke_half_width_pix, pt.x + this.m_stroke_half_width_pix, pt.y + this.m_stroke_half_width_pix);
            this.m_rasterizer.fillEnvelope(this.m_env_dummy);
        }
    }

    private void fillPoints(EditShape shape, int geometry) {
        assert (!this.m_geom_env.isEmpty());
        assert (this.m_transform.isScaleAndShift(0.0));
        int vertex = shape.getFirstVertex(shape.getFirstPath(geometry));
        while (vertex != -1) {
            Point2D pt = this.m_pt_start_dummy;
            shape.getXY(vertex, pt);
            pt.x = this.m_transform.xx * pt.x + this.m_transform.xd;
            pt.y = this.m_transform.yy * pt.y + this.m_transform.yd;
            this.m_env_dummy.setCoords(pt.x - this.m_stroke_half_width_pix, pt.y - this.m_stroke_half_width_pix, pt.x + this.m_stroke_half_width_pix, pt.y + this.m_stroke_half_width_pix);
            this.m_rasterizer.fillEnvelope(this.m_env_dummy);
            vertex = shape.getNextVertex(vertex);
        }
    }

    private void addXYImpl_(Point2D point) {
        Point2D pt = point;
        pt.x = this.m_transform.xx * point.x + this.m_transform.xd;
        pt.y = this.m_transform.yy * point.y + this.m_transform.yd;
        this.m_env_dummy.setCoords(pt.x - this.m_stroke_half_widthX_pix, pt.y - this.m_stroke_half_widthY_pix, pt.x + this.m_stroke_half_widthX_pix, pt.y + this.m_stroke_half_widthY_pix);
        this.m_rasterizer.fillEnvelope(this.m_env_dummy);
    }

    private void strokeDrawSegment(SimpleRasterizer rasterizer, Segment seg) {
        assert (!this.m_geom_env.isEmpty());
        double stroke_half_width = this.m_stroke_half_width_pix;
        Point2D pt_start = this.m_pt_start_dummy;
        seg.getStartXY(pt_start);
        Point2D pt_end = this.m_pt_end_dummy;
        seg.getStartXY(pt_end);
        pt_start.x = this.m_transform.xx * pt_start.x + this.m_transform.xd;
        pt_start.y = this.m_transform.yy * pt_start.y + this.m_transform.yd;
        pt_end.x = this.m_transform.xx * pt_end.x + this.m_transform.xd;
        pt_end.y = this.m_transform.yy * pt_end.y + this.m_transform.yd;
        if (Point2D.sqrDistance(pt_start, pt_end) < stroke_half_width * stroke_half_width) {
            this.m_env_dummy.setCoords(pt_start);
            this.m_env_dummy.mergeNE(pt_end.x, pt_end.y);
            this.m_env_dummy.inflate(stroke_half_width, stroke_half_width);
            rasterizer.fillEnvelope(this.m_env_dummy);
            return;
        }
        rasterizer.startAddingEdges();
        rasterizer.addSegmentStroke(pt_start.x, pt_start.y, pt_end.x, pt_end.y, stroke_half_width, false, this.m_helper_xy_10_elm);
        rasterizer.renderEdges(0);
    }

    private void assignMaxGeomIds(int max_geom_ids) {
        int i = 0;
        int bits = 1;
        while (bits < max_geom_ids) {
            bits *= 2;
            ++i;
        }
        this.m_max_geom_ids = bits;
        this.m_shift_bit = 6 - i;
        this.m_bit_mask = this.m_shift_bit == 64 ? -1L : (1L << this.m_shift_bit) - 1L;
    }

    private static final class ScanCallbackImpl
    implements SimpleRasterizer.ScanCallback {
        long[] m_bitmap;
        private int m_bpp;
        private int m_bit_mask;
        private int m_shift_bit;
        private int m_scanline_width;
        private long m_id;
        private long m_mask;
        private boolean m_adding;
        private HitMap2D m_parent;
        private SimpleRasterizer m_rasterizer;
        public long m_test_mask;

        private long flush1(int[] scans, int scanCount3) {
            int bpp = this.m_bpp;
            int shift = this.m_shift_bit;
            int bit_mask = this.m_bit_mask;
            long c = this.m_mask;
            long[] bitmap = this.m_bitmap;
            int i = 0;
            int n = scanCount3;
            while (i < n) {
                int x_0 = scans[i];
                int x_1 = scans[++i];
                int y = scans[++i];
                int pos = y * this.m_scanline_width;
                for (int x = x_0; x < x_1; ++x) {
                    int n2 = pos + (x >>> shift);
                    bitmap[n2] = bitmap[n2] | c << (x & bit_mask) * bpp;
                }
            }
            return 0L;
        }

        private long flush2(int[] scans, int scanCount3) {
            int bpp = this.m_bpp;
            int shift = this.m_shift_bit;
            int bit_mask = this.m_bit_mask;
            long c = this.m_mask;
            long[] bitmap = this.m_bitmap;
            long result = 0L;
            int i = 0;
            int n = scanCount3;
            while (i < n) {
                int x_0 = scans[i];
                int x_1 = scans[++i];
                int y = scans[++i];
                int pos = y * this.m_scanline_width;
                for (int x = x_0; x < x_1; ++x) {
                    long v = bitmap[pos + (x >>> shift)];
                    result |= v >>> (x & bit_mask) * bpp & c;
                }
            }
            return result;
        }

        public ScanCallbackImpl(HitMap2D parent) {
            this.m_scanline_width = parent.m_scanline_width;
            this.m_adding = true;
            this.m_id = -1L;
            this.m_test_mask = 0L;
            this.m_rasterizer = parent.m_rasterizer;
            this.m_parent = parent;
            this.m_mask = 0L;
            this.reset();
        }

        public void setId(long id) {
            if (this.m_id != id) {
                this.m_rasterizer.flush();
                this.m_id = id;
                this.m_mask = this.m_parent.getBitMask(id);
            }
        }

        public void setTesting() {
            this.m_test_mask = 0L;
            if (this.m_adding) {
                this.m_rasterizer.flush();
                this.m_adding = false;
                this.m_mask = this.m_parent.m_max_geom_ids == 64 ? -1L : (1L << this.m_parent.m_max_geom_ids) - 1L;
                this.prepShifts_();
            }
        }

        private void prepShifts_() {
            switch (this.m_parent.m_max_geom_ids) {
                case 1: {
                    this.m_shift_bit = 6;
                    this.m_bit_mask = 63;
                    this.m_bpp = 1;
                    break;
                }
                case 2: {
                    this.m_shift_bit = 5;
                    this.m_bit_mask = 31;
                    this.m_bpp = 2;
                    break;
                }
                case 4: {
                    this.m_shift_bit = 4;
                    this.m_bit_mask = 15;
                    this.m_bpp = 4;
                    break;
                }
                case 8: {
                    this.m_shift_bit = 3;
                    this.m_bit_mask = 7;
                    this.m_bpp = 8;
                    break;
                }
                case 16: {
                    this.m_shift_bit = 2;
                    this.m_bit_mask = 3;
                    this.m_bpp = 16;
                    break;
                }
                case 32: {
                    this.m_shift_bit = 1;
                    this.m_bit_mask = 1;
                    this.m_bpp = 32;
                    break;
                }
                case 64: {
                    this.m_shift_bit = 0;
                    this.m_bpp = 0;
                    this.m_bit_mask = 0;
                    break;
                }
                default: {
                    throw GeometryException.GeometryInternalError();
                }
            }
        }

        @Override
        public void drawScan(int[] scans, int scanCount3) {
            this.m_test_mask = this.m_adding ? (this.m_test_mask |= this.flush1(scans, scanCount3)) : (this.m_test_mask |= this.flush2(scans, scanCount3));
        }

        public void reset() {
            this.m_adding = true;
            this.m_id = -1L;
            this.prepShifts_();
        }
    }
}

