/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AndroidSDKExcluded;
import com.esri.core.geometry.AndroidSDKPublic;
import com.esri.core.geometry.Clusterer;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.HadoopSDKPublic;
import com.esri.core.geometry.JsonGeometryException;
import com.esri.core.geometry.JsonReader;
import com.esri.core.geometry.LinearUnit;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.OperatorBuffer;
import com.esri.core.geometry.OperatorClip;
import com.esri.core.geometry.OperatorContains;
import com.esri.core.geometry.OperatorConvexHull;
import com.esri.core.geometry.OperatorCrosses;
import com.esri.core.geometry.OperatorCut;
import com.esri.core.geometry.OperatorDifference;
import com.esri.core.geometry.OperatorDisjoint;
import com.esri.core.geometry.OperatorDistance;
import com.esri.core.geometry.OperatorEquals;
import com.esri.core.geometry.OperatorExportToESRIShape;
import com.esri.core.geometry.OperatorExportToGeoJson;
import com.esri.core.geometry.OperatorExportToJson;
import com.esri.core.geometry.OperatorExportToWkt;
import com.esri.core.geometry.OperatorGeodeticLength;
import com.esri.core.geometry.OperatorImportFromESRIShape;
import com.esri.core.geometry.OperatorImportFromGeoJson;
import com.esri.core.geometry.OperatorImportFromJson;
import com.esri.core.geometry.OperatorImportFromWkt;
import com.esri.core.geometry.OperatorIntersection;
import com.esri.core.geometry.OperatorOverlaps;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.OperatorProximity2D;
import com.esri.core.geometry.OperatorRelate;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.OperatorSymmetricDifference;
import com.esri.core.geometry.OperatorTouches;
import com.esri.core.geometry.OperatorUnion;
import com.esri.core.geometry.OperatorWithin;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.Proximity2DResult;
import com.esri.core.geometry.SimpleGeometryCursor;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.Unit;
import com.fasterxml.jackson.core.JsonParser;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

@AndroidSDKPublic
@HadoopSDKPublic
public class GeometryEngine {
    @HadoopSDKExcluded
    @AndroidSDKPublic
    public static Geometry project(Geometry geometry, SpatialReference inputSR, SpatialReference outputSR) {
        ProjectionTransformation transform = ProjectionTransformation.create(inputSR, outputSR, null);
        Geometry geom = OperatorProject.local().execute(geometry, transform, null);
        return geom;
    }

    @HadoopSDKExcluded
    @AndroidSDKPublic
    public static Geometry project(Geometry geometry, ProjectionTransformation projectionTransformation) {
        Geometry geom = OperatorProject.local().execute(geometry, projectionTransformation, null);
        return geom;
    }

    @Deprecated
    @HadoopSDKPublic
    public static MapGeometry jsonToGeometry(JsonParser json) {
        MapGeometry geom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, json);
        return geom;
    }

    @HadoopSDKPublic
    public static MapGeometry jsonToGeometry(JsonReader json) {
        MapGeometry geom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, json);
        return geom;
    }

    @HadoopSDKPublic
    public static MapGeometry jsonToGeometry(String json) throws JsonGeometryException {
        MapGeometry geom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, json);
        return geom;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static String geometryToJson(int wkid, Geometry geometry) {
        return GeometryEngine.geometryToJson(wkid > 0 ? SpatialReference.create(wkid) : null, geometry);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static String geometryToJson(SpatialReference spatialReference, Geometry geometry) {
        return OperatorExportToJson.local().execute(spatialReference, geometry);
    }

    @HadoopSDKPublic
    public static String geometryToGeoJson(Geometry geometry) {
        return OperatorExportToGeoJson.local().execute(geometry);
    }

    @HadoopSDKPublic
    public static String geometryToGeoJson(int wkid, Geometry geometry) {
        return GeometryEngine.geometryToGeoJson(wkid > 0 ? SpatialReference.create(wkid) : null, geometry);
    }

    @HadoopSDKPublic
    public static String geometryToGeoJson(SpatialReference spatialReference, Geometry geometry) {
        return OperatorExportToGeoJson.local().execute(spatialReference, geometry);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static Geometry geometryFromEsriShape(byte[] esriShapeBuffer, Geometry.Type geometryType) {
        return OperatorImportFromESRIShape.local().execute(2, geometryType, ByteBuffer.wrap(esriShapeBuffer).order(ByteOrder.LITTLE_ENDIAN));
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static byte[] geometryToEsriShape(Geometry geometry) {
        if (geometry == null) {
            throw new IllegalArgumentException();
        }
        return OperatorExportToESRIShape.local().execute(0, geometry).array();
    }

    @AndroidSDKExcluded
    @HadoopSDKPublic
    public static Geometry geometryFromWkt(String wkt, int importFlags, Geometry.Type geometryType) {
        return OperatorImportFromWkt.local().execute(importFlags, geometryType, wkt, null);
    }

    @Deprecated
    @AndroidSDKExcluded
    @HadoopSDKPublic
    public static MapGeometry geometryFromGeoJson(String geoJson, int importFlags, Geometry.Type geometryType) throws JsonGeometryException {
        return OperatorImportFromGeoJson.local().execute(importFlags, geometryType, geoJson, null);
    }

    @AndroidSDKExcluded
    @HadoopSDKPublic
    public static String geometryToWkt(Geometry geometry, int exportFlags) {
        return OperatorExportToWkt.local().execute(exportFlags, geometry, null);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static Geometry union(Geometry[] geometries, SpatialReference spatialReference) {
        SimpleGeometryCursor inputGeometries = new SimpleGeometryCursor(geometries);
        GeometryCursor result = OperatorUnion.local().execute(inputGeometries, spatialReference, null);
        return result.next();
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static Geometry difference(Geometry geometry1, Geometry substractor, SpatialReference spatialReference) {
        Geometry result = OperatorDifference.local().execute(geometry1, substractor, spatialReference, null);
        return result;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static Geometry symmetricDifference(Geometry leftGeometry, Geometry rightGeometry, SpatialReference spatialReference) {
        Geometry result = OperatorSymmetricDifference.local().execute(leftGeometry, rightGeometry, spatialReference, null);
        return result;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static boolean equals(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        boolean result = OperatorEquals.local().execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    @HadoopSDKPublic
    public static boolean disjoint(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        boolean result = OperatorDisjoint.local().execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    static Geometry[] intersect(Geometry[] inputGeometries, Geometry geometry, SpatialReference spatialReference) {
        Geometry g;
        SimpleGeometryCursor inputGeometriesCursor = new SimpleGeometryCursor(inputGeometries);
        SimpleGeometryCursor intersectorCursor = new SimpleGeometryCursor(geometry);
        GeometryCursor result = OperatorIntersection.local().execute(inputGeometriesCursor, intersectorCursor, spatialReference, null);
        ArrayList<Geometry> resultGeoms = new ArrayList<Geometry>();
        while ((g = result.next()) != null) {
            resultGeoms.add(g);
        }
        Geometry[] resultarr = resultGeoms.toArray(new Geometry[0]);
        return resultarr;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static Geometry intersect(Geometry geometry1, Geometry intersector, SpatialReference spatialReference) {
        Geometry result = OperatorIntersection.local().execute(geometry1, intersector, spatialReference, null);
        return result;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static boolean within(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        boolean result = OperatorWithin.local().execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static boolean contains(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        boolean result = OperatorContains.local().execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static boolean crosses(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        boolean result = OperatorCrosses.local().execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static boolean touches(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        boolean result = OperatorTouches.local().execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    @HadoopSDKPublic
    public static boolean overlaps(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        boolean result = OperatorOverlaps.local().execute(geometry1, geometry2, spatialReference, null);
        return result;
    }

    @HadoopSDKPublic
    public static boolean relate(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference, String relation) {
        boolean result = OperatorRelate.local().execute(geometry1, geometry2, spatialReference, relation, null);
        return result;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static double distance(Geometry geometry1, Geometry geometry2, SpatialReference spatialReference) {
        return OperatorDistance.local().execute(geometry1, geometry2, null);
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static Geometry clip(Geometry geometry, Envelope envelope, SpatialReference spatialReference) {
        Geometry result = OperatorClip.local().execute(geometry, Envelope2D.construct(envelope.getXMin(), envelope.getYMin(), envelope.getXMax(), envelope.getYMax()), spatialReference, null);
        return result;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static Geometry[] cut(Geometry cuttee, Polyline cutter, SpatialReference spatialReference) {
        Geometry geometry;
        if (cuttee == null || cutter == null) {
            return null;
        }
        GeometryCursor cursor = OperatorCut.local().execute(true, cuttee, cutter, spatialReference, null);
        ArrayList<Geometry> cutsList = new ArrayList<Geometry>();
        while ((geometry = cursor.next()) != null) {
            if (geometry.isEmpty()) continue;
            cutsList.add(geometry);
        }
        return cutsList.toArray(new Geometry[0]);
    }

    @HadoopSDKExcluded
    @AndroidSDKPublic
    public static Polygon[] buffer(Geometry[] geometries, SpatialReference spatialReference, double[] distances, Unit unit, boolean toUnionResults) {
        double[] bufferDistances = distances;
        if (spatialReference != null) {
            Unit unitSR = spatialReference.getUnit();
            if (unit != null && unitSR.getID() != unit.getID()) {
                if (unitSR.getUnitType() != unit.getUnitType()) {
                    throw new IllegalArgumentException();
                }
                bufferDistances = new double[distances.length];
                Unit.convertUnits(distances, distances.length, unit, unitSR, bufferDistances);
            }
        } else if (unit != null) {
            throw new IllegalArgumentException();
        }
        if (toUnionResults) {
            Geometry g;
            SimpleGeometryCursor inputGeometriesCursor = new SimpleGeometryCursor(geometries);
            GeometryCursor result = OperatorBuffer.local().execute(inputGeometriesCursor, spatialReference, bufferDistances, toUnionResults, null);
            ArrayList<Polygon> resultGeoms = new ArrayList<Polygon>();
            while ((g = result.next()) != null) {
                resultGeoms.add((Polygon)g);
            }
            Polygon[] buffers = resultGeoms.toArray(new Polygon[0]);
            return buffers;
        }
        Polygon[] buffers = new Polygon[geometries.length];
        for (int i = 0; i < geometries.length; ++i) {
            buffers[i] = (Polygon)OperatorBuffer.local().execute(geometries[i], spatialReference, bufferDistances[i], null);
        }
        return buffers;
    }

    @AndroidSDKExcluded
    @HadoopSDKPublic
    public static Polygon[] buffer(Geometry[] geometries, SpatialReference spatialReference, double[] distances, boolean toUnionResults) {
        double[] bufferDistances = distances;
        if (toUnionResults) {
            Geometry g;
            SimpleGeometryCursor inputGeometriesCursor = new SimpleGeometryCursor(geometries);
            GeometryCursor result = OperatorBuffer.local().execute(inputGeometriesCursor, spatialReference, bufferDistances, toUnionResults, null);
            ArrayList<Polygon> resultGeoms = new ArrayList<Polygon>();
            while ((g = result.next()) != null) {
                resultGeoms.add((Polygon)g);
            }
            Polygon[] buffers = resultGeoms.toArray(new Polygon[0]);
            return buffers;
        }
        Polygon[] buffers = new Polygon[geometries.length];
        for (int i = 0; i < geometries.length; ++i) {
            buffers[i] = (Polygon)OperatorBuffer.local().execute(geometries[i], spatialReference, bufferDistances[i], null);
        }
        return buffers;
    }

    @HadoopSDKExcluded
    @AndroidSDKPublic
    public static Polygon buffer(Geometry geometry, SpatialReference spatialReference, double distance, Unit unit) {
        double bufferDistance = distance;
        if (spatialReference != null) {
            Unit unitSR = spatialReference.getUnit();
            if (unit != null && unitSR.getID() != unit.getID()) {
                if (unitSR.getUnitType() != unit.getUnitType()) {
                    throw new GeometryException("The input unit and the spatial reference unit are not of the same unit type. ie Linear vs. Angular");
                }
                bufferDistance = Unit.convertUnits(distance, unit, unitSR);
            }
        } else if (unit != null) {
            throw new IllegalArgumentException();
        }
        Geometry result = OperatorBuffer.local().execute(geometry, spatialReference, bufferDistance, null);
        return (Polygon)result;
    }

    @AndroidSDKExcluded
    @HadoopSDKPublic
    public static Polygon buffer(Geometry geometry, SpatialReference spatialReference, double distance) {
        double bufferDistance = distance;
        Geometry result = OperatorBuffer.local().execute(geometry, spatialReference, bufferDistance, null);
        return (Polygon)result;
    }

    @HadoopSDKPublic
    public static Geometry convexHull(Geometry geometry) {
        return OperatorConvexHull.local().execute(geometry, null);
    }

    @HadoopSDKPublic
    public static Geometry[] convexHull(Geometry[] geometries, boolean b_merge) {
        Geometry g;
        SimpleGeometryCursor simple_cursor = new SimpleGeometryCursor(geometries);
        GeometryCursor cursor = OperatorConvexHull.local().execute(simple_cursor, b_merge, null);
        ArrayList<Geometry> resultGeoms = new ArrayList<Geometry>();
        while ((g = cursor.next()) != null) {
            resultGeoms.add(g);
        }
        Geometry[] output = new Geometry[resultGeoms.size()];
        for (int i = 0; i < resultGeoms.size(); ++i) {
            output[i] = (Geometry)resultGeoms.get(i);
        }
        return output;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static Proximity2DResult getNearestCoordinate(Geometry geometry, Point inputPoint, boolean bTestPolygonInterior) {
        Proximity2DResult result = OperatorProximity2D.local().getNearestCoordinate(geometry, inputPoint, bTestPolygonInterior);
        return result;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static Proximity2DResult getNearestVertex(Geometry geometry, Point inputPoint) {
        Proximity2DResult result = OperatorProximity2D.local().getNearestVertex(geometry, inputPoint);
        return result;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static Proximity2DResult[] getNearestVertices(Geometry geometry, Point inputPoint, double searchRadius, int maxVertexCountToReturn) {
        Proximity2DResult[] results = OperatorProximity2D.local().getNearestVertices(geometry, inputPoint, searchRadius, maxVertexCountToReturn);
        return results;
    }

    @AndroidSDKPublic
    @HadoopSDKPublic
    public static Geometry simplify(Geometry geometry, SpatialReference spatialReference) {
        Geometry result = OperatorSimplify.local().execute(geometry, spatialReference, false, null);
        return result;
    }

    static boolean isSimple(Geometry geometry, SpatialReference spatialReference) {
        boolean result = OperatorSimplify.local().isSimpleAsFeature(geometry, spatialReference, null);
        return result;
    }

    @HadoopSDKExcluded
    @AndroidSDKPublic
    public static double geodesicLength(Geometry geometry, SpatialReference spatialReference, LinearUnit lengthUnit) {
        double resultInMeters = OperatorGeodeticLength.local().execute(geometry, spatialReference, 0, null);
        if (lengthUnit != null) {
            return lengthUnit.convertFromMeters(resultInMeters);
        }
        return resultInMeters;
    }

    @AndroidSDKExcluded
    @HadoopSDKPublic
    public static double geodesicDistanceOnWGS84(Point ptFrom, Point ptTo) {
        return SpatialReferenceImpl.geodesicDistanceOnWGS84Impl(ptFrom, ptTo);
    }

    @HadoopSDKPublic
    public static MultiPoint clusterPoints2D(MultiPoint multiPoint, boolean useMAsWeight, double tolerance, boolean reserved) {
        return Clusterer.clusterPoints2D(multiPoint, useMAsWeight, tolerance, reserved);
    }
}

