/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.CompositeGeographicTransformation;
import com.esri.core.geometry.GeographicTransformation;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.JsonGeometryException;
import com.esri.core.geometry.JsonParserReader;
import com.esri.core.geometry.JsonReader;
import com.esri.sde.sdk.pe.resources.PeResources;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

@HadoopSDKExcluded
public class GeogTranDefaults {
    private static GeogTranDefaults st_instance;
    private boolean m_bFallbackEnabled = false;
    private boolean m_b_has_gt_defaults = false;
    private boolean m_bHasGtDefaultsOverrides = false;
    ArrayList<GeogTranRecord> m_gt_defaults_list = new ArrayList();
    ArrayList<GeogTranRecord> m_gt_defaults_overrides_list = new ArrayList();

    private static synchronized GeogTranDefaults getInstance() {
        if (st_instance == null) {
            st_instance = new GeogTranDefaults();
        }
        return st_instance;
    }

    static boolean hasGTDefaults() {
        return GeogTranDefaults.getInstance().m_b_has_gt_defaults;
    }

    static boolean hasGTDefaultsOverrides() {
        return GeogTranDefaults.getInstance().m_bHasGtDefaultsOverrides;
    }

    static CompositeGeographicTransformation Lookup(int gcs1, int gcs2) {
        if (gcs1 == gcs2) {
            return null;
        }
        GeogTranDefaults This = GeogTranDefaults.getInstance();
        if (This.m_bFallbackEnabled) {
            CompositeGeographicTransformation overrideTrans = GeogTranDefaults._lookUpImpl(This.m_gt_defaults_overrides_list, gcs1, gcs2, true);
            if (overrideTrans != null) {
                return overrideTrans;
            }
            return GeogTranDefaults._lookUpUsingPEimpl(gcs1, gcs2);
        }
        CompositeGeographicTransformation overrideTrans = GeogTranDefaults._lookUpImpl(This.m_gt_defaults_overrides_list, gcs1, gcs2, false);
        if (overrideTrans != null) {
            return overrideTrans;
        }
        return GeogTranDefaults._lookUpImpl(This.m_gt_defaults_list, gcs1, gcs2, false);
    }

    static CompositeGeographicTransformation createCompositeGeoTransform(int geog_tran_ID_1, boolean b_inverted_1, int geog_tran_ID_2, boolean b_inverted_2, boolean b_inverse_result) {
        assert (geog_tran_ID_1 >= 0 && geog_tran_ID_2 >= 0);
        assert (geog_tran_ID_1 != 0 || geog_tran_ID_2 == 0);
        CompositeGeographicTransformation cgt = CompositeGeographicTransformation.create();
        if (geog_tran_ID_1 > 0) {
            try {
                GeographicTransformation GT_1 = GeographicTransformation.create(geog_tran_ID_1, b_inverted_1);
                if (GT_1.getID() == 0) {
                    return null;
                }
                cgt.add(GT_1);
                if (geog_tran_ID_2 > 0) {
                    GeographicTransformation GT_2 = GeographicTransformation.create(geog_tran_ID_2, b_inverted_2);
                    if (GT_2.getID() == 0) {
                        return null;
                    }
                    cgt.add(GT_2);
                }
                if (b_inverse_result) {
                    cgt = cgt.getInverse();
                }
            }
            catch (Exception e) {
                assert (false);
                cgt = null;
            }
        }
        return cgt;
    }

    private GeogTranDefaults() {
        this._init();
    }

    static CompositeGeographicTransformation _lookUpImpl(ArrayList<GeogTranRecord> gt_defaults_list, int gcs1, int gcs2, boolean usable) {
        if (gcs1 == gcs2 || gt_defaults_list.isEmpty()) {
            return null;
        }
        GeogTranRecord query = GeogTranRecord.construct(gcs1, gcs2, 0, 0);
        boolean b_inverse_result = false;
        boolean b_found = false;
        int geog_tran_ID_1 = 0;
        int geog_tran_ID_2 = 0;
        GeogTranRecordComparator comparator = new GeogTranRecordComparator();
        int index = Collections.binarySearch(gt_defaults_list, query, comparator);
        if (index < 0 || gt_defaults_list.get((int)index).m_gcs1 != query.m_gcs1 || gt_defaults_list.get((int)index).m_gcs2 != query.m_gcs2) {
            query = GeogTranRecord.construct(gcs2, gcs1, 0, 0);
            index = Collections.binarySearch(gt_defaults_list, query, comparator);
            if (index >= 0 && gt_defaults_list.get((int)index).m_gcs1 == query.m_gcs1 && gt_defaults_list.get((int)index).m_gcs2 == query.m_gcs2) {
                geog_tran_ID_1 = gt_defaults_list.get((int)index).m_gt1;
                geog_tran_ID_2 = gt_defaults_list.get((int)index).m_gt2;
                b_inverse_result = true;
                b_found = true;
            }
        } else {
            geog_tran_ID_1 = gt_defaults_list.get((int)index).m_gt1;
            geog_tran_ID_2 = gt_defaults_list.get((int)index).m_gt2;
            b_inverse_result = false;
            b_found = true;
        }
        if (!b_found) {
            return null;
        }
        if (geog_tran_ID_1 == 0) {
            geog_tran_ID_1 = geog_tran_ID_2;
            geog_tran_ID_2 = 0;
        }
        boolean b_inverted_1 = false;
        boolean b_inverted_2 = false;
        if (geog_tran_ID_1 < 0) {
            geog_tran_ID_1 = -geog_tran_ID_1;
            b_inverted_1 = true;
        }
        if (geog_tran_ID_2 < 0) {
            geog_tran_ID_2 = -geog_tran_ID_2;
            b_inverted_2 = true;
        }
        return GeogTranDefaults.createCompositeGeoTransform(geog_tran_ID_1, b_inverted_1, geog_tran_ID_2, b_inverted_2, b_inverse_result);
    }

    void _init() {
        if (this._initImpl(true, this.m_gt_defaults_list)) {
            this.m_b_has_gt_defaults = true;
        }
        if (this._initImpl(false, this.m_gt_defaults_overrides_list)) {
            this.m_bHasGtDefaultsOverrides = true;
        }
        this.m_bFallbackEnabled = !this.m_b_has_gt_defaults;
    }

    private boolean _initImpl(boolean b, ArrayList<GeogTranRecord> m_gt_defaults_list2) {
        try {
            InputStream inputStream = PeResources.class.getResourceAsStream(b ? "gtdefaults.json" : "gtdefaults_overrides.json");
            if (inputStream == null) {
                return false;
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean bError = false;
            try {
                int len = 1024;
                byte[] buffer = new byte[len];
                int cBytes = 0;
                while ((cBytes = inputStream.read(buffer, 0, len)) > 0) {
                    for (int i = 0; i < cBytes; ++i) {
                        stringBuilder.append((char)buffer[i]);
                    }
                }
            }
            catch (IOException e) {
                bError = true;
            }
            if (bError) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return false;
            }
            ArrayList<GeogTranRecord> records = new ArrayList<GeogTranRecord>(0);
            int reserved = 5200;
            records.ensureCapacity(reserved);
            try {
                JsonReader jsonParser = JsonParserReader.createFromStringNNT(stringBuilder.toString());
                JsonReader.Token current_token = jsonParser.nextToken();
                if (current_token != JsonReader.Token.START_OBJECT) {
                    throw new GeometryException("Error parsing gtdefaults");
                }
                current_token = jsonParser.nextToken();
                if (current_token != JsonReader.Token.FIELD_NAME) {
                    throw new GeometryException("Error parsing gtdefaults");
                }
                String field_name = jsonParser.currentString();
                if (!field_name.equals("geogtran")) {
                    throw new GeometryException("Error parsing gtdefaults");
                }
                current_token = jsonParser.nextToken();
                if (current_token != JsonReader.Token.START_ARRAY) {
                    throw new GeometryException("Error parsing gtdefaults");
                }
                int[] buf = new int[6];
                while ((current_token = jsonParser.nextToken()) != JsonReader.Token.END_ARRAY) {
                    if (current_token != JsonReader.Token.START_ARRAY) {
                        throw new GeometryException("Error parsing gtdefaults");
                    }
                    for (int i = 0; i < 6; ++i) {
                        current_token = jsonParser.nextToken();
                        if (current_token != JsonReader.Token.VALUE_NUMBER_INT) {
                            throw new GeometryException("Error parsing gtdefaults");
                        }
                        buf[i] = jsonParser.currentIntValue();
                    }
                    current_token = jsonParser.nextToken();
                    if (current_token != JsonReader.Token.END_ARRAY) {
                        throw new GeometryException("Error parsing gtdefaults");
                    }
                    records.add(GeogTranRecord.construct(buf[0], buf[1], buf[3] != 0 ? -buf[2] : buf[2], buf[5] != 0 ? -buf[4] : buf[4]));
                }
            }
            catch (JsonGeometryException e) {
                return false;
            }
            assert (reserved >= records.size());
            Collections.sort(records, new GeogTranRecordComparator());
            records.trimToSize();
            m_gt_defaults_list2.ensureCapacity(records.size());
            m_gt_defaults_list2.addAll(records);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    static CompositeGeographicTransformation _lookUpUsingPEimpl(int gcs1, int gcs2) {
        return null;
    }

    static final class GeogTranRecordComparator
    implements Comparator<GeogTranRecord> {
        GeogTranRecordComparator() {
        }

        @Override
        public int compare(GeogTranRecord gtr1, GeogTranRecord gtr2) {
            if (gtr1.m_gcs1 == gtr2.m_gcs1) {
                if (gtr1.m_gcs2 == gtr2.m_gcs2) {
                    return 0;
                }
                if (gtr1.m_gcs2 < gtr2.m_gcs2) {
                    return -1;
                }
                return 1;
            }
            if (gtr1.m_gcs1 < gtr2.m_gcs1) {
                return -1;
            }
            return 1;
        }
    }

    private static final class GeogTranRecord {
        int m_gcs1;
        int m_gcs2;
        int m_gt1;
        int m_gt2;

        private GeogTranRecord() {
        }

        static GeogTranRecord construct(int gcs1, int gcs2, int gt1, int gt2) {
            GeogTranRecord gt_record = new GeogTranRecord();
            gt_record.m_gcs1 = gcs1;
            gt_record.m_gcs2 = gcs2;
            gt_record.m_gt1 = gt1;
            gt_record.m_gt2 = gt2;
            return gt_record;
        }
    }
}

