/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.HadoopSDKExcluded;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorProject;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.ProjectionTransformation;
import com.esri.core.geometry.ProjectionUtils;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.SpatialReferencePrecisionDescriptor;
import com.esri.sde.sdk.pe.engine.PeCoordsys;
import com.esri.sde.sdk.pe.engine.PeDouble;
import com.esri.sde.sdk.pe.engine.PeGeogcs;
import com.esri.sde.sdk.pe.engine.PeLineType;
import com.esri.sde.sdk.pe.engine.PeLinunit;
import com.esri.sde.sdk.pe.engine.PeParameter;
import com.esri.sde.sdk.pe.engine.PeProjcs;
import com.esri.sde.sdk.pe.engine.PeProjection;
import com.esri.sde.sdk.pe.engine.PeSpheroid;
import com.esri.sde.sdk.pe.factory.PeFactory;

@HadoopSDKExcluded
public final class GeodeticUtils {
    public static int movePointsByDistance(SpatialReference SR_in_out, Point2D[] points_in_out, int count, double distance, double azimuth, int curve_type) {
        if (curve_type == 4) {
            throw new GeometryException("not implemented");
        }
        SpatialReferenceImpl sr = (SpatialReferenceImpl)SR_in_out;
        SpatialReferenceImpl gcs = (SpatialReferenceImpl)sr.getGCS();
        PeGeogcs pegeogcs = (PeGeogcs)gcs.getPECoordSys();
        PeSpheroid spheroid = pegeogcs.getDatum().getSpheroid();
        double flattening = spheroid.getFlattening();
        double e_squared = flattening * (2.0 - flattening);
        double a = spheroid.getAxis();
        double rpu = gcs.getUnit().getUnitToBaseFactor();
        PeDouble param_1_ptr = new PeDouble();
        PeDouble param_2_ptr = new PeDouble();
        ProjectionTransformation transform_to_GCS = sr.getSRToGCSTransform();
        ProjectionTransformation transform_to_SR = sr.getGCSToSRTransform();
        int maxSize = Math.min(200, count * 2);
        double[] input_points = new double[maxSize];
        double[] output_points = new double[maxSize];
        int res_count = 0;
        int i = 0;
        int i_1 = 0;
        while (i < count) {
            int n = count - i;
            if (n * 2 > input_points.length) {
                n = input_points.length / 2;
            }
            for (int j = 0; j < n; ++j) {
                Point2D pt = points_in_out[i + j];
                input_points[2 * j] = pt.x;
                input_points[2 * j + 1] = pt.y;
            }
            int nn = ProjectionUtils.transformPointsInPlace(transform_to_GCS, input_points, 0, n, output_points, 0);
            if (nn > 0) {
                for (int j = 0; j < n; ++j) {
                    double x = output_points[2 * j];
                    double y = output_points[2 * j + 1];
                    if (NumberUtils.isNaN(x) || NumberUtils.isNaN(y)) {
                        input_points[2 * j] = Double.NaN;
                        continue;
                    }
                    PeLineType.geodetic_coordinate((double)a, (double)e_squared, (double)(x *= rpu), (double)(y *= rpu), (double)distance, (double)azimuth, (PeDouble)param_1_ptr, (PeDouble)param_2_ptr, (int)curve_type);
                    x = param_1_ptr.val;
                    y = param_2_ptr.val;
                    input_points[2 * j] = x /= rpu;
                    input_points[2 * j + 1] = y /= rpu;
                }
                int nn1 = ProjectionUtils.transformPointsInPlace(transform_to_SR, input_points, 0, n, output_points, 0);
                res_count += nn1;
            }
            for (int j = 0; j < n; ++j) {
                points_in_out[i_1 + j].setCoords(output_points[2 * j], output_points[2 * j + 1]);
            }
            i += n;
            i_1 += n;
        }
        return res_count;
    }

    public static void calculateDistanceAndAzimuth(SpatialReference srIn, Point2D point1, Point2D point2, int curveType, DistanceAndAzimuth resultOut) {
        if (curveType == 4) {
            throw new GeometryException("not implemented");
        }
        resultOut.distanceMeters = Double.NaN;
        resultOut.azimuth12_Radians = Double.NaN;
        resultOut.azimuth21_Radians = Double.NaN;
        SpatialReferenceImpl sr = (SpatialReferenceImpl)srIn;
        SpatialReferenceImpl gcs = (SpatialReferenceImpl)srIn.getGCS();
        PeGeogcs pegeogcs = (PeGeogcs)gcs.getPECoordSys();
        PeSpheroid spheroid = pegeogcs.getDatum().getSpheroid();
        double flattening = spheroid.getFlattening();
        double eSquared = flattening * (2.0 - flattening);
        double a = spheroid.getAxis();
        double rpu = gcs.getUnit().getUnitToBaseFactor();
        PeDouble param_1_ptr = new PeDouble();
        PeDouble param_2_ptr = new PeDouble();
        PeDouble param_3_ptr = new PeDouble();
        ProjectionTransformation transform_to_GCS = sr.getSRToGCSTransform();
        double[] pts_in = new double[]{point1.x, point1.y, point2.x, point2.y};
        int res = ProjectionUtils.transformPointsInPlace(transform_to_GCS, pts_in, 0, 2, pts_in, 0);
        if (res != 2) {
            return;
        }
        pts_in[0] = pts_in[0] * rpu;
        pts_in[1] = pts_in[1] * rpu;
        pts_in[2] = pts_in[2] * rpu;
        pts_in[3] = pts_in[3] * rpu;
        PeLineType.geodetic_distance((double)a, (double)eSquared, (double)pts_in[0], (double)pts_in[1], (double)pts_in[2], (double)pts_in[3], (PeDouble)param_1_ptr, (PeDouble)param_2_ptr, (PeDouble)param_3_ptr, (int)curveType);
        resultOut.distanceMeters = param_1_ptr.val;
        resultOut.azimuth12_Radians = param_2_ptr.val;
        resultOut.azimuth21_Radians = param_3_ptr.val;
    }

    private static double distance_to_antipode_(double a, double e2, Point2D p) {
        double antipode_x = p.x + Math.PI;
        if (antipode_x > Math.PI * 2) {
            antipode_x -= Math.PI * 2;
        } else if (antipode_x < Math.PI * -2) {
            antipode_x += Math.PI * 2;
        }
        double antipode_y = -p.y;
        PeDouble max_distance = new PeDouble();
        PeLineType.geodesic_distance((double)a, (double)e2, (double)p.x, (double)p.y, (double)antipode_x, (double)antipode_y, (PeDouble)max_distance, null, null);
        return max_distance.val;
    }

    public static Geometry constructGeodesicEllipse2(Geometry.Type output_type, SpatialReference sr, Point2D center, double semi_axis_1, double semi_axis_2, double major_axis_direction_radians, double max_segment_length_meters, int max_point_count, ProgressTracker progress_tracker) {
        double b;
        assert (max_point_count > 0);
        if (max_point_count == 0) {
            throw new IllegalArgumentException("constructGeodesicEllipse2");
        }
        assert (!center.isNaN());
        if (center.isNaN()) {
            throw new IllegalArgumentException("constructGeodesicEllipse2");
        }
        double a = Math.abs(semi_axis_1);
        if (a < (b = Math.abs(semi_axis_2))) {
            double temp = a;
            a = b;
            b = temp;
        }
        int count = max_point_count;
        if (b != 0.0) {
            double n = Math.floor(a * a / b * Math.PI * 2.0 / max_segment_length_meters + 0.5);
            count = (int)Math.min((double)count, n);
        }
        return GeodeticUtils.constructGeodesicEllipse(output_type, sr, center, semi_axis_1, semi_axis_2, major_axis_direction_radians, count, progress_tracker);
    }

    public static Geometry constructGeodesicEllipse(Geometry.Type output_type, SpatialReference sr, Point2D center, double semi_axis_1, double semi_axis_2, double major_axis_direction_radians, int point_count, ProgressTracker progress_tracker) {
        assert (!center.isNaN());
        if (center.isNaN()) {
            throw new IllegalArgumentException("constructGeodesicEllipse");
        }
        if (sr.getCoordinateSystemType() == SpatialReference.Type.Local) {
            throw new IllegalArgumentException("constructGeodesicEllipse: local sr");
        }
        SpatialReferenceImpl gcs = (SpatialReferenceImpl)sr.getGCS();
        Point center_GCS = new Point(center);
        if (sr.getCoordinateSystemType() == SpatialReference.Type.Projected) {
            ProjectionTransformation sr_to_GCS = ((SpatialReferenceImpl)sr).getSRToGCSTransform();
            center_GCS = (Point)OperatorProject.local().execute(new Point(center), sr_to_GCS, null);
            if (center_GCS.isEmpty()) {
                throw new IllegalArgumentException("constructGeodesicEllipse: center point is outside the horizon");
            }
        }
        double a = Math.max(Math.abs(semi_axis_1), Math.abs(semi_axis_2));
        double b = Math.min(Math.abs(semi_axis_1), Math.abs(semi_axis_2));
        boolean clipWithHorizon = false;
        PeGeogcs pegeogcs = (PeGeogcs)gcs.getPECoordSys();
        PeSpheroid spheroid = pegeogcs.getDatum().getSpheroid();
        double flattening = spheroid.getFlattening();
        double e_squared = flattening * (2.0 - flattening);
        double earthA = spheroid.getAxis();
        double distance_to_antipode = GeodeticUtils.distance_to_antipode_(earthA, e_squared, center_GCS.getXY());
        boolean bl = clipWithHorizon = a > distance_to_antipode - 10.0;
        if (point_count < 10) {
            point_count = 10;
        }
        MultiPoint multipoint = null;
        MultiPath multipath = null;
        if (output_type == Geometry.Type.Polygon) {
            multipath = new Polygon();
            multipath.reserve(point_count);
        } else if (output_type == Geometry.Type.Polyline) {
            multipath = new Polyline();
            multipath.reserve(point_count + 1);
        } else if (output_type == Geometry.Type.MultiPoint) {
            multipoint = new MultiPoint();
            multipoint.reserve(point_count);
        } else {
            throw new IllegalArgumentException("constructGeodesicEllipse: output_type");
        }
        double parametric_start = 0.0;
        double parametric_sweep = Math.PI * -2;
        double da = parametric_sweep / (double)point_count;
        double a0 = parametric_start;
        double cosR = Math.cos(major_axis_direction_radians);
        double sinR = Math.sin(major_axis_direction_radians);
        Point2D pt0 = new Point2D(0.0, 0.0);
        Point2D pt = new Point2D(0.0, 0.0);
        int n = point_count;
        if (output_type == Geometry.Type.Polyline) {
            ++n;
        }
        for (int i = 0; i < n; ++i) {
            double angle = i != point_count ? (double)i * da + a0 : a0;
            double cosA = Math.cos(angle);
            double sinA = Math.sin(angle);
            pt.setCoords(a * cosA, b * sinA);
            pt.rotateDirect(cosR, sinR);
            if (i == 0) {
                pt0.setCoords(pt);
                if (output_type != Geometry.Type.MultiPoint) {
                    multipath.startPath(pt);
                    continue;
                }
                multipoint.add(pt);
                continue;
            }
            if (output_type != Geometry.Type.MultiPoint) {
                multipath.lineTo(pt);
                continue;
            }
            multipoint.add(pt);
        }
        MultiVertexGeometry res_geom = output_type == Geometry.Type.MultiPoint ? multipoint : multipath;
        SpatialReferenceImpl equidistantSR = (SpatialReferenceImpl)GeodeticUtilsHelper.getEquidistantPCSInstance_(gcs, center_GCS.getXY());
        ProjectionTransformation.ExtendedParams ex_params = new ProjectionTransformation.ExtendedParams();
        ex_params.setFlag(1, clipWithHorizon);
        ProjectionTransformation equidistant_to_sr = ProjectionTransformation.createEx(equidistantSR, sr, null, ex_params);
        return OperatorProject.local().execute(res_geom, equidistant_to_sr, progress_tracker);
    }

    public static Geometry constructGeodesicSector2(Geometry.Type output_type, SpatialReference sr, Point2D center, double semi_axis_1, double semi_axis_2, double major_axis_direction_radians, double start_direction_radians, double sweep_angle_radians, double max_segment_length_meters, int max_point_count, ProgressTracker progress_tracker) {
        double n;
        double b;
        assert (max_point_count > 0);
        if (max_point_count == 0) {
            throw new IllegalArgumentException("constructGeodesicSector2");
        }
        assert (!center.isNaN());
        if (center.isNaN()) {
            throw new IllegalArgumentException("constructGeodesicSector2");
        }
        double sweep_angle = NumberUtils.snap(Math.abs(sweep_angle_radians), 0.0, Math.PI * 2);
        double a = Math.abs(semi_axis_1);
        if (a < (b = Math.abs(semi_axis_2))) {
            double temp = a;
            a = b;
            b = temp;
        }
        int radius_point_count = max_point_count / 2;
        int arc_point_count = max_point_count / 2;
        int count = max_point_count;
        if (b != 0.0 && max_segment_length_meters > 0.0 && (double)(arc_point_count = (int)Math.min((double)count, n = Math.floor(a * a / b * Math.abs(sweep_angle) / max_segment_length_meters + 0.5))) + (double)(radius_point_count = (int)Math.min((double)count, a / max_segment_length_meters)) > (double)count) {
            double n1 = (double)arc_point_count + (double)radius_point_count;
            radius_point_count = (int)((double)count * (double)radius_point_count / n1);
            arc_point_count = count - radius_point_count;
        }
        return GeodeticUtils.constructGeodesicSector(output_type, sr, center, a, b, major_axis_direction_radians, start_direction_radians, sweep_angle, arc_point_count, radius_point_count, progress_tracker);
    }

    public static Geometry constructGeodesicSector(Geometry.Type output_type, SpatialReference sr, Point2D center, double semi_axis_1, double semi_axis_2, double major_axis_direction, double start_direction, double sweep_angle_, int arc_point_count, int radius_point_count, ProgressTracker progress_tracker) {
        double t;
        int i;
        assert (!center.isNaN());
        if (center.isNaN()) {
            throw new IllegalArgumentException("constructGeodesicSector2");
        }
        long sz = (long)arc_point_count + 2L * (long)radius_point_count;
        if (sz >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("constructGeodesicSector2: arc_point_count or radius_point_count is too big");
        }
        if (sr.getCoordinateSystemType() == SpatialReference.Type.Local) {
            throw new IllegalArgumentException("constructGeodesicSector2: local sr");
        }
        double sweep_angle = NumberUtils.snap(Math.abs(sweep_angle_), 0.0, Math.PI * 2);
        sweep_angle = -sweep_angle;
        double a = Math.max(Math.abs(semi_axis_1), Math.abs(semi_axis_2));
        double b = Math.min(Math.abs(semi_axis_1), Math.abs(semi_axis_2));
        double start_angle = start_direction - major_axis_direction;
        double end_angle = start_direction + sweep_angle;
        end_angle -= major_axis_direction;
        if (arc_point_count < 10) {
            arc_point_count = 10;
        }
        if (radius_point_count < 10) {
            radius_point_count = 10;
        }
        MultiPoint multipoint = null;
        MultiPath multipath = null;
        if (output_type == Geometry.Type.Polygon) {
            multipath = new Polygon();
        } else if (output_type == Geometry.Type.Polyline) {
            multipath = new Polyline();
        } else if (output_type == Geometry.Type.MultiPoint) {
            multipoint = new MultiPoint();
        } else {
            throw new IllegalArgumentException("constructGeodesicSector: output_type");
        }
        double ab = a * b;
        double cosA = Math.cos(start_angle);
        double sinA = Math.sin(start_angle);
        double d = Math.sqrt(MathUtils.sqr(b * cosA) + MathUtils.sqr(a * sinA));
        Point2D pt = new Point2D(ab * cosA / d, ab * sinA / d);
        double parametric_start = Math.atan2(pt.y / b, pt.x / a);
        cosA = Math.cos(end_angle);
        sinA = Math.sin(end_angle);
        d = Math.sqrt(MathUtils.sqr(b * cosA) + MathUtils.sqr(a * sinA));
        pt = new Point2D(ab * cosA / d, ab * sinA / d);
        double parametric_end = Math.atan2(pt.y / b, pt.x / a);
        double parametric_sweep = parametric_end - parametric_start;
        if (parametric_sweep > 0.0 || Math.abs(sweep_angle) - Math.abs(parametric_sweep) > Math.PI) {
            parametric_sweep = (parametric_end -= Math.PI * 2) - parametric_start;
        }
        assert (parametric_sweep <= 0.0 && sweep_angle <= 0.0);
        boolean polar = false;
        double da = (polar ? sweep_angle : parametric_sweep) / (double)(arc_point_count - 1);
        double a0 = polar ? start_angle : parametric_start;
        double a1 = polar ? end_angle : parametric_end;
        double cosR = Math.cos(major_axis_direction);
        double sinR = Math.sin(major_axis_direction);
        Point2D pt0 = new Point2D(0.0, 0.0);
        Point2D pt2 = new Point2D(0.0, 0.0);
        for (i = 0; i < arc_point_count; ++i) {
            double angle = i != arc_point_count - 1 ? (double)i * da + a0 : a1;
            double cosA2 = Math.cos(angle);
            double sinA2 = Math.sin(angle);
            if (polar) {
                double d2 = Math.sqrt(MathUtils.sqr(b * cosA2) + MathUtils.sqr(a * sinA2));
                pt2.setCoords(ab * cosA2 / d2, ab * sinA2 / d2);
            } else {
                pt2.setCoords(a * cosA2, b * sinA2);
            }
            pt2.rotateDirect(cosR, sinR);
            if (i == 0) {
                pt0.setCoords(pt2);
                if (output_type != Geometry.Type.MultiPoint) {
                    multipath.startPath(pt2);
                    continue;
                }
                multipoint.add(pt2);
                continue;
            }
            if (output_type != Geometry.Type.MultiPoint) {
                multipath.lineTo(pt2);
                continue;
            }
            multipoint.add(pt2);
        }
        for (i = radius_point_count - 2; i >= 0; --i) {
            t = (double)i / (double)(radius_point_count - 1);
            Point2D p = new Point2D();
            pt2.scale(t);
            if (output_type != Geometry.Type.MultiPoint) {
                multipath.lineTo(p);
                continue;
            }
            multipoint.add(p);
        }
        for (i = 1; i < radius_point_count; ++i) {
            t = (double)i / (double)(radius_point_count - 1);
            Point2D p = new Point2D();
            pt0.scale(t);
            if (output_type != Geometry.Type.Polyline && i == radius_point_count - 1) break;
            if (output_type != Geometry.Type.MultiPoint) {
                multipath.lineTo(p);
                continue;
            }
            multipoint.add(p);
        }
        MultiVertexGeometry res_geom = output_type == Geometry.Type.MultiPoint ? multipoint : multipath;
        SpatialReferenceImpl gcs = (SpatialReferenceImpl)sr.getGCS();
        Point center_GCS = new Point(center);
        if (sr.getCoordinateSystemType() == SpatialReference.Type.Projected) {
            ProjectionTransformation sr_to_GCS = ((SpatialReferenceImpl)sr).getSRToGCSTransform();
            center_GCS = (Point)OperatorProject.local().execute(new Point(center), sr_to_GCS, null);
            if (center_GCS.isEmpty()) {
                throw new IllegalArgumentException("constructGeodesicSector: center point is outside the horizon");
            }
        }
        SpatialReferenceImpl equidistantSR = (SpatialReferenceImpl)GeodeticUtilsHelper.getEquidistantPCSInstance_(gcs, center_GCS.getXY());
        ProjectionTransformation.ExtendedParams ex_params = new ProjectionTransformation.ExtendedParams();
        ex_params.setFlag(1, false);
        ProjectionTransformation equidistant_to_sr = ProjectionTransformation.createEx(equidistantSR, sr, null, ex_params);
        return OperatorProject.local().execute(res_geom, equidistant_to_sr, progress_tracker);
    }

    private static class GeodeticUtilsHelper {
        private GeodeticUtilsHelper() {
        }

        static SpatialReference getEquidistantPCSInstance_(SpatialReference gcs, Point2D center_point_in_GCS) {
            PeParameter[] PE_param_arr = new PeParameter[16];
            for (int i = 0; i < PE_param_arr.length; ++i) {
                PE_param_arr[i] = null;
            }
            PE_param_arr[2] = PeParameter.fromArgs((String)"Central_Meridian", (double)center_point_in_GCS.x);
            PE_param_arr[6] = PeParameter.fromArgs((String)"Latitude_of_Origin", (double)center_point_in_GCS.y);
            PE_param_arr[0] = PeParameter.fromArgs((String)"False_Easting", (double)0.0);
            PE_param_arr[1] = PeParameter.fromArgs((String)"False_Northing", (double)0.0);
            PeProjection PE_proj_ptr = PeFactory.projection((int)43032);
            PeLinunit PE_linunit_ptr = PeFactory.linunit((int)9001);
            PeGeogcs PE_geogcs_ptr = (PeGeogcs)((SpatialReferenceImpl)gcs).getPECoordSys().clone();
            PeProjcs PE_coord_sys = PeProjcs.fromArgs((String)"INTERNALAzimutalEquidistant", (PeGeogcs)PE_geogcs_ptr, (PeProjection)PE_proj_ptr, (PeParameter[])PE_param_arr, (PeLinunit)PE_linunit_ptr);
            SpatialReferenceImpl equidistant_PCS = SpatialReferenceImpl.createImpl((PeCoordsys)PE_coord_sys, null, SpatialReferencePrecisionDescriptor.Precision.FloatingPoint, false);
            return equidistant_PCS;
        }
    }

    public static class DistanceAndAzimuth {
        public double distanceMeters;
        public double azimuth12_Radians;
        public double azimuth21_Radians;
    }
}

